/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.setupservice.beans.MysqlCmdBean;
import at.letto.setupservice.dto.MysqlCmdDto;
import at.letto.setupservice.service.DatabaseService;
import at.letto.setupservice.service.DockerService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class MySQLCmdController {
    @Autowired
    private DatabaseService databaseService;
    @Autowired
    private DockerService dockerService;
    @Resource(name="mysqlCmdBean")
    MysqlCmdBean mysqlCmdBean;

    @RequestMapping(value={"/config/session/admin/mysqlcmd"})
    public String mysqlcmdDocker(@ModelAttribute MysqlCmdDto cmdDto, HttpServletRequest request, Model model) {
        return this.mysqlcmd(cmdDto, request, model);
    }

    @RequestMapping(value={"/setup/session/admin/mysqlcmd"})
    public String mysqlcmdLocal(@ModelAttribute MysqlCmdDto cmdDto, HttpServletRequest request, Model model) {
        return this.mysqlcmd(cmdDto, request, model);
    }

    public String mysqlcmd(@ModelAttribute MysqlCmdDto cmdDto, HttpServletRequest request, Model model) {
        model.addAttribute("cmdControl", (Object)this);
        model.addAttribute("dockerService", (Object)this.dockerService);
        String button = cmdDto.getUserAction();
        Object msg = "";
        if (button != null) {
            if (button.equals("back")) {
                return "redirect:" + this.dockerService.welcomeEP();
            }
            if (button.equals("enter")) {
                String cmd = cmdDto.getCmdline();
                if (cmd == null) {
                    cmd = "";
                }
                msg = this.callcmd(cmd);
            }
            if (button.equals("ok")) {
                String cL = cmdDto.getCmdline();
                Object cmd = cmdDto.getCmd();
                if (cmd == null) {
                    cmd = "";
                }
                if (cL == null) {
                    cL = "";
                }
                cmd = ((String)cmd).trim();
                cL = cL.trim();
                if (((String)cmd).length() > 0) {
                    if (cL.length() > 0) {
                        cmd = cL + "\n" + (String)cmd;
                    }
                } else {
                    cmd = cL;
                }
                msg = this.callcmd((String)cmd);
            }
            if (button.startsWith("conn")) {
                try {
                    int id = Integer.parseInt(button.substring(4));
                    MysqlCmdBean.MySQLConnection conn = (MysqlCmdBean.MySQLConnection)this.mysqlCmdBean.getMySQLConnections().get(id);
                    this.mysqlCmdBean.setConnection(conn);
                    msg = "connection set to " + conn.getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (button.endsWith("con")) {
                msg = this.connectTo(cmdDto);
            }
            this.mysqlCmdBean.setCmdLine(cmdDto.getCmdline());
            this.mysqlCmdBean.setCmd(cmdDto.getCmd());
        } else {
            cmdDto.setCmd(this.mysqlCmdBean.getCmd());
            cmdDto.setCmdline(this.mysqlCmdBean.getCmdLine());
        }
        model.addAttribute("cmdDto", (Object)cmdDto);
        model.addAttribute("mysqlCmdBean", (Object)this.mysqlCmdBean);
        model.addAttribute("msg", msg);
        return "mysqlcmd";
    }

    public void loadConnections() {
        this.mysqlCmdBean.setMySQLConnections(this.databaseService.loadConnections());
        if (this.mysqlCmdBean.getConnection() == null && this.mysqlCmdBean.getMySQLConnections().size() > 0) {
            this.mysqlCmdBean.setConnection((MysqlCmdBean.MySQLConnection)this.mysqlCmdBean.getMySQLConnections().get(0));
        }
    }

    public String callcmd(String cmd) {
        this.mysqlCmdBean.setResults(new ArrayList());
        MysqlCmdBean.MySQLConnection mySQLConnection = this.mysqlCmdBean.getConnection();
        if (mySQLConnection == null) {
            return "ERROR: no connection defined!";
        }
        Connection conn = null;
        try {
            String[] cmds;
            conn = mySQLConnection.getDatabase().trim().length() == 0 ? this.databaseService.getConnection(mySQLConnection.getHost(), mySQLConnection.getUser(), mySQLConnection.getPassword()) : this.databaseService.getConnection(mySQLConnection.getHost(), mySQLConnection.getDatabase(), mySQLConnection.getUser(), mySQLConnection.getPassword());
            if (conn == null) {
                return "ERROR: cannot connect to Database!";
            }
            for (String c : cmds = cmd.split(";")) {
                MysqlCmdBean.MyCmdResult result = new MysqlCmdBean.MyCmdResult();
                Vector output = new Vector();
                c = c.trim();
                result.setCmd(c);
                String m = null;
                if (c.startsWith("select ") || c.startsWith("show ") || c.startsWith("describe ")) {
                    try {
                        output = this.databaseService.executeExceptedQuery(conn, c);
                    }
                    catch (SQLException e) {
                        result.setSqlmessage("<span style='color:red;'>error: " + e.getMessage() + "</span>");
                        this.mysqlCmdBean.getResults().add(result);
                        return "ERROR: executation stopped!";
                    }
                }
                try {
                    output = this.databaseService.executeWithExeption(conn, c);
                }
                catch (SQLException e) {
                    result.setSqlmessage("<span style='color:red;'>error: " + e.getMessage() + "</span>");
                    this.mysqlCmdBean.getResults().add(result);
                    return "ERROR: executation stopped!";
                }
                if (m != null) {
                    result.setSqlmessage(m);
                }
                if (output != null) {
                    result.setOutput(output);
                }
                this.mysqlCmdBean.getResults().add(result);
            }
        }
        catch (Exception ex) {
            return "ERROR: cannot execute command!";
        }
        return "";
    }

    public String connectTo(MysqlCmdDto cmdDto) {
        String db = cmdDto.getConnect();
        String user = "";
        String password = "";
        String host = "";
        String database = "";
        Matcher m = Pattern.compile("^([^:@]+):([^@]+)@([^/@]+)$").matcher(db);
        if (m.find()) {
            user = m.group(1);
            password = m.group(2);
            host = m.group(3);
        } else {
            m = Pattern.compile("^([^:@]+):([^@]+)@([^/@]+)/([^/@]+)$").matcher(db);
            if (m.find()) {
                user = m.group(1);
                password = m.group(2);
                host = m.group(3);
                database = m.group(4);
            } else {
                return "database-connection inconsistent!";
            }
        }
        MysqlCmdBean.MySQLConnection c = new MysqlCmdBean.MySQLConnection();
        c.setId(-1);
        c.setUser(user);
        c.setDatabase(database);
        c.setPassword(password);
        c.setHost(host);
        Connection conn = null;
        try {
            conn = database != null && database.trim().length() > 0 ? this.databaseService.getConnection(c.getHost(), c.getDatabase(), c.getUser(), c.getPassword()) : this.databaseService.getConnection(c.getHost(), c.getUser(), c.getPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (conn != null) {
            this.mysqlCmdBean.setConnection(c);
            cmdDto.setConnect("");
            return "<span style='color:green;'>database connected to " + c.getName() + "</span>";
        }
        return "cannot connect to database " + c.getName();
    }
}

