/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.setup.dto.ServiceStatusDto;
import at.letto.setupservice.model.docker.DockerComposeDto;
import at.letto.setupservice.model.docker.DockerComposeServiceDto;
import at.letto.setupservice.service.DockerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceInfoService {
    @Autowired
    DockerService dockerService;

    public boolean isSetupLocalRunning() {
        if (this.dockerService.isDockerRunning()) {
            ServiceStatusDto serviceStatusDto = this.dockerService.getServiceStatusDto();
            return serviceStatusDto != null && serviceStatusDto.isSetup();
        }
        return true;
    }

    public boolean isSetupDockerRunning() {
        if (this.dockerService.isDockerRunning()) {
            return true;
        }
        ServiceStatusDto serviceStatusDto = this.dockerService.getServiceStatusDto();
        return serviceStatusDto != null && serviceStatusDto.isSetupHost();
    }

    public boolean isLoginRunning() {
        ServiceStatusDto serviceStatusDto = this.dockerService.getServiceStatusDto();
        return serviceStatusDto != null && serviceStatusDto.isLogin();
    }

    public boolean isQuestionRunning() {
        try {
            return ((DockerComposeServiceDto)((DockerComposeDto)this.dockerService.getInstalledServicesYmls().get("question")).getServices().get(0)).isRunning();
        }
        catch (Exception exception) {
            ServiceStatusDto serviceStatusDto = this.dockerService.getServiceStatusDto();
            return serviceStatusDto != null && serviceStatusDto.isQuestion();
        }
    }

    public boolean isExportRunning() {
        try {
            return ((DockerComposeServiceDto)((DockerComposeDto)this.dockerService.getInstalledServicesYmls().get("export")).getServices().get(0)).isRunning();
        }
        catch (Exception exception) {
            ServiceStatusDto serviceStatusDto = this.dockerService.getServiceStatusDto();
            return serviceStatusDto != null && serviceStatusDto.isExport();
        }
    }

    public boolean isPluginRunning() {
        try {
            return ((DockerComposeServiceDto)((DockerComposeDto)this.dockerService.getInstalledServicesYmls().get("plugin")).getServices().get(0)).isRunning();
        }
        catch (Exception exception) {
            ServiceStatusDto serviceStatusDto = this.dockerService.getServiceStatusDto();
            return serviceStatusDto != null && serviceStatusDto.isPlugin();
        }
    }

    public boolean isPluginSourcecodeRunning() {
        try {
            return ((DockerComposeServiceDto)((DockerComposeDto)this.dockerService.getInstalledServicesYmls().get("pluginsourcecode")).getServices().get(0)).isRunning();
        }
        catch (Exception exception) {
            ServiceStatusDto serviceStatusDto = this.dockerService.getServiceStatusDto();
            return serviceStatusDto != null && serviceStatusDto.isPluginsourcecode();
        }
    }

    public boolean isLtiRunning() {
        ServiceStatusDto serviceStatusDto = this.dockerService.getServiceStatusDto();
        return serviceStatusDto != null && serviceStatusDto.isLti();
    }
}

