/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.plugins.dto.PluginGeneralInfo;
import at.letto.plugins.restclient.RestPluginConnectionService;
import at.letto.setup.dto.config.ConfigServiceDto;
import at.letto.setupservice.beans.PluginEditBean;
import at.letto.setupservice.dto.pluginconfig.PluginConfigPluginGeneralInfo;
import at.letto.setupservice.dto.pluginconfig.PluginConfigServiceDto;
import at.letto.setupservice.model.PluginsModel;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LettoService;
import at.letto.setupservice.service.setupStorage.SetupStorageService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class PluginManageController {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private LettoService lettoService;
    @Autowired
    private SetupStorageService setupStorageService;
    @Resource(name="pluginEditBean")
    PluginEditBean pluginEditBean;

    public void loadPluginInformation() {
        ArrayList<PluginConfigServiceDto> plugins = new ArrayList<PluginConfigServiceDto>();
        int i = 0;
        for (ConfigServiceDto c : this.setupStorageService.getPlugins()) {
            ArrayList<PluginConfigPluginGeneralInfo> pCpGI = new ArrayList<PluginConfigPluginGeneralInfo>();
            try {
                RestPluginConnectionService con = new RestPluginConnectionService(c.getUriIntern(), c.getUsername(), c.getPassword());
                for (PluginGeneralInfo pgi : con.getPluginGeneralInfoList()) {
                    PluginConfigPluginGeneralInfo p = new PluginConfigPluginGeneralInfo(pgi);
                    pCpGI.add(p);
                }
            }
            catch (Exception con) {
                // empty catch block
            }
            PluginConfigServiceDto pluginConfigServiceDto = new PluginConfigServiceDto(i, c, pCpGI);
            plugins.add(pluginConfigServiceDto);
            ++i;
        }
        this.pluginEditBean.setPlugins(plugins);
    }

    public void checkAndLoadPluginInformation() {
        if (this.pluginEditBean == null) {
            this.loadPluginInformation();
            return;
        }
        if (this.pluginEditBean.getPlugins() == null || this.pluginEditBean.getPlugins().size() == 0) {
            this.loadPluginInformation();
        }
    }

    @RequestMapping(value={"/config/session/admin/plugins"})
    public String pluginsDocker(@ModelAttribute PluginsModel pluginsModel, Model model) {
        return this.plugins(pluginsModel, model);
    }

    @RequestMapping(value={"/setup/session/admin/plugins"})
    public String pluginsLocal(@ModelAttribute PluginsModel pluginsModel, Model model) {
        return this.plugins(pluginsModel, model);
    }

    private String plugins(@ModelAttribute PluginsModel pluginsModel, Model model) {
        Object msg = "";
        this.checkAndLoadPluginInformation();
        model.addAttribute("dockerService", (Object)this.dockerService);
        String button = pluginsModel.getUserAction();
        if (button != null) {
            switch (button) {
                case "cancel": {
                    return "redirect:" + this.dockerService.welcomeEP();
                }
            }
            if (button.startsWith("edit-")) {
                try {
                    int id = Integer.parseInt(button.substring(5));
                    if (id < this.pluginEditBean.getPlugins().size()) {
                        this.pluginEditBean.setSelectedPluginIndex(id);
                        return this.loadPluginEdit(model, pluginsModel, (String)msg);
                    }
                }
                catch (Exception e) {
                    msg = "Fehler beim Laden der Plugin Informationen: " + e.getMessage();
                }
            }
        }
        return this.loadPlugin(model, pluginsModel, (String)msg);
    }

    @RequestMapping(value={"/config/session/admin/pluginedit"})
    public String pluginEdit(@ModelAttribute PluginsModel pluginsModel, Model model) {
        String msg = "";
        this.checkAndLoadPluginInformation();
        model.addAttribute("dockerService", (Object)this.dockerService);
        String button = pluginsModel.getUserAction();
        if (button != null) {
            switch (button) {
                case "cancel": {
                    return this.loadPlugin(model, pluginsModel, msg);
                }
            }
        }
        return this.loadPluginEdit(model, pluginsModel, msg);
    }

    private String loadPluginEdit(Model model, PluginsModel pluginsModel, String msg) {
        PluginConfigServiceDto pIcSDto = (PluginConfigServiceDto)this.pluginEditBean.getPlugins().get(this.pluginEditBean.getSelectedPluginIndex());
        model.addAttribute("msg", (Object)msg);
        model.addAttribute("model", (Object)pluginsModel);
        model.addAttribute("dockername", (Object)pIcSDto.getConfigServiceDto().getDockerName());
        model.addAttribute("service", (Object)pIcSDto.getConfigServiceDto());
        model.addAttribute("pluginEditBean", (Object)this.pluginEditBean);
        model.addAttribute("action", (Object)"/config/session/admin/pluginedit");
        model.addAttribute("pluginInfos", (Object)pIcSDto.getPluginGeneralInfoList());
        return "pluginedit";
    }

    private String loadPlugin(Model model, PluginsModel pluginsModel, String msg) {
        model.addAttribute("msg", (Object)msg);
        model.addAttribute("model", (Object)pluginsModel);
        model.addAttribute("plugins", (Object)this.pluginEditBean.getPlugins());
        return "plugins";
    }
}

