/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.dto;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class DockerStatsDto {
    private String id = "";
    private String name = "";
    private String memoryUsage = "";
    private int memoryMB = 0;
    private String memoryLimit = "";
    private int memoryLimitMB = 0;
    private double memory = 0.0;
    private String netInput = "";
    private int netInputMB = 0;
    private String netOutput = "";
    private int netOutputMB = 0;
    private String blockInput = "";
    private int blockInputMB = 0;
    private String blockOutput = "";
    private int blockOutputMB = 0;
    private String pids = "";
    private boolean ok = false;
    private double cpu = 0.0;
    private double[] cpuTrend = new double[60];
    private int cpuTrendCounter = 0;
    private boolean cpuTrendFull = false;
    private double cpuAvg = 0.0;

    public DockerStatsDto(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public void setCpu(double cpu) {
        this.cpu = cpu;
        this.cpuTrend[this.cpuTrendCounter] = cpu;
        this.cpuTrendCounter = (this.cpuTrendCounter + 1) % 60;
        if (this.cpuTrendCounter == 59) {
            this.cpuTrendFull = true;
        }
        double sum = 0.0;
        int max = this.cpuTrendFull ? 60 : this.cpuTrendCounter;
        for (int i = 0; i < max; ++i) {
            sum += this.cpuTrend[i];
        }
        this.cpuAvg = sum / (double)max;
    }

    private Double parseMB(String s) {
        Matcher m = Pattern.compile("^([0-9\\.]+)([^0-9\\.]*)$").matcher(s.trim());
        if (m.find()) {
            try {
                double w = Double.parseDouble(m.group(1));
                String e = m.group(2);
                if (e.startsWith("k")) {
                    return w / 1024.0;
                }
                if (e.startsWith("M")) {
                    return w;
                }
                if (e.startsWith("G")) {
                    return w * 1024.0;
                }
                if (e.startsWith("T")) {
                    return w * 1024.0 * 1024.0;
                }
                if (e.startsWith("B")) {
                    return 0.0;
                }
                if (e.startsWith("iB")) {
                    return 0.0;
                }
                if (e.length() == 0) {
                    return 0.0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setMemoryUsage(String memoryUsage) {
        this.memoryUsage = memoryUsage;
        Double w = this.parseMB(memoryUsage);
        if (w != null) {
            this.memoryMB = (int)(w + 0.5);
        }
    }

    public void setMemoryLimit(String memoryLimit) {
        this.memoryLimit = memoryLimit;
        Double w = this.parseMB(memoryLimit);
        if (w != null) {
            this.memoryLimitMB = (int)(w + 0.5);
        }
    }

    public void setNetInput(String netInput) {
        this.netInput = netInput;
        Double w = this.parseMB(netInput);
        if (w != null) {
            this.netInputMB = (int)(w + 0.5);
        }
    }

    public void setNetOutput(String netOutput) {
        this.netOutput = netOutput;
        Double w = this.parseMB(netOutput);
        if (w != null) {
            this.netOutputMB = (int)(w + 0.5);
        }
    }

    public void setBlockInput(String blockInput) {
        this.blockInput = blockInput;
        Double w = this.parseMB(this.netOutput);
        if (w != null) {
            this.netOutputMB = (int)(w + 0.5);
        }
    }

    public void setBlockOutput(String blockOutput) {
        this.blockOutput = blockOutput;
        Double w = this.parseMB(this.netOutput);
        if (w != null) {
            this.netOutputMB = (int)(w + 0.5);
        }
    }

    public String toString() {
        Object ret = "DockerStatsDto{";
        ret = (String)ret + "name:" + this.name;
        ret = (String)ret + ",CPU:" + this.cpu;
        ret = (String)ret + ",mem:" + this.memoryMB + "MB";
        ret = (String)ret + ",ID:" + this.id;
        ret = (String)ret + "}";
        return ret;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMemoryUsage() {
        return this.memoryUsage;
    }

    @Generated
    public int getMemoryMB() {
        return this.memoryMB;
    }

    @Generated
    public String getMemoryLimit() {
        return this.memoryLimit;
    }

    @Generated
    public int getMemoryLimitMB() {
        return this.memoryLimitMB;
    }

    @Generated
    public double getMemory() {
        return this.memory;
    }

    @Generated
    public String getNetInput() {
        return this.netInput;
    }

    @Generated
    public int getNetInputMB() {
        return this.netInputMB;
    }

    @Generated
    public String getNetOutput() {
        return this.netOutput;
    }

    @Generated
    public int getNetOutputMB() {
        return this.netOutputMB;
    }

    @Generated
    public String getBlockInput() {
        return this.blockInput;
    }

    @Generated
    public int getBlockInputMB() {
        return this.blockInputMB;
    }

    @Generated
    public String getBlockOutput() {
        return this.blockOutput;
    }

    @Generated
    public int getBlockOutputMB() {
        return this.blockOutputMB;
    }

    @Generated
    public String getPids() {
        return this.pids;
    }

    @Generated
    public boolean isOk() {
        return this.ok;
    }

    @Generated
    public double getCpu() {
        return this.cpu;
    }

    @Generated
    public double[] getCpuTrend() {
        return this.cpuTrend;
    }

    @Generated
    public int getCpuTrendCounter() {
        return this.cpuTrendCounter;
    }

    @Generated
    public boolean isCpuTrendFull() {
        return this.cpuTrendFull;
    }

    @Generated
    public double getCpuAvg() {
        return this.cpuAvg;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMemory(double memory) {
        this.memory = memory;
    }

    @Generated
    public void setPids(String pids) {
        this.pids = pids;
    }

    @Generated
    public void setOk(boolean ok) {
        this.ok = ok;
    }
}

