/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.basespringboot.security.BaseLettoUserDetailsService;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.edit.restclient.edit.category.RestEditLehrerKlasse;
import at.letto.service.rest.BaseRestClient;
import at.letto.setup.dto.SchoolLicenseDto;
import at.letto.setup.dto.ServiceSchuleDto;
import at.letto.setup.dto.ServiceStatusDto;
import at.letto.setup.dto.ajax.AjaxWelcomeInfo;
import at.letto.setup.restclient.RestSetupService;
import at.letto.setupservice.beans.SessionBean;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.config.SetupConfiguration;
import at.letto.setupservice.config.TomcatConfiguration;
import at.letto.setupservice.configFiles.EnvFile;
import at.letto.setupservice.configFiles.LettoEnvFile;
import at.letto.setupservice.configFiles.SchuleEnv;
import at.letto.setupservice.configFiles.SetupEnvFile;
import at.letto.setupservice.dto.CpuTrendDto;
import at.letto.setupservice.dto.DockerContainerStatusDto;
import at.letto.setupservice.dto.DockerStatsDto;
import at.letto.setupservice.dto.SystemStatusDto;
import at.letto.setupservice.model.EmailConfigDto;
import at.letto.setupservice.model.FileInfoDto;
import at.letto.setupservice.model.UpdateDto;
import at.letto.setupservice.model.UpdateServiceDto;
import at.letto.setupservice.model.docker.DockerComposeDto;
import at.letto.setupservice.model.docker.DockerComposeNetworkDto;
import at.letto.setupservice.model.docker.DockerComposeServiceDto;
import at.letto.setupservice.model.docker.DockerComposeVolumeDto;
import at.letto.setupservice.model.docker.DockerContainerDto;
import at.letto.setupservice.model.docker.DockerNetworkDto;
import at.letto.setupservice.model.docker.DockerPortDto;
import at.letto.setupservice.model.docker.DockerStatusDto;
import at.letto.setupservice.model.docker.DockerVolumeDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DatabaseService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.DockerStatsService;
import at.letto.setupservice.service.LettoService;
import at.letto.setupservice.service.LizenzService;
import at.letto.setupservice.service.ResourcenService;
import at.letto.setupservice.service.SetupUserDetailsService;
import at.letto.setupservice.service.UpdateService;
import at.letto.setupservice.service.setupStorage.SetupStorageService;
import at.letto.tools.Cmd;
import at.letto.tools.Datum;
import at.letto.tools.ENCRYPT;
import at.letto.tools.LicenseKey;
import at.letto.tools.WebGet;
import at.letto.tools.rest.DtoAndMsg;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.YamlMapFactoryBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class DockerService {
    static final Logger LOGGER = LoggerFactory.getLogger(DockerService.class);
    @Autowired
    public SetupConfiguration setupConfiguration;
    @Autowired
    public MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    public DockerConfiguration dockerConfiguration;
    @Autowired
    public TomcatConfiguration tomcatConfiguration;
    @Autowired
    public AnalyzeService analyzeService;
    @Autowired
    public CmdService cmdService;
    @Autowired
    public UpdateService updateService;
    @Autowired
    public SetupUserDetailsService setupUserDetailsService;
    @Autowired
    public DatabaseService databaseService;
    @Autowired
    private LizenzService lizenzService;
    @Autowired
    private LettoService lettoService;
    @Autowired
    private BaseLettoUserDetailsService baseLettoUserDetailsService;
    @Autowired
    private ResourcenService resourcenService;
    @Autowired
    private DockerStatsService dockerStatsService;
    @Autowired
    private SetupStorageService setupStorageService;
    @Resource(name="sessionBean")
    SessionBean sessionBean;
    public static final String[] servicesV12 = new String[]{"question", "plugin", "pluginsourcecode", "export", "main", "edit", "redis", "mongo", "app", "htmlpreview"};
    private DockerComposeDto setupYml = null;
    private DockerComposeDto lettoYml = null;
    private DockerComposeDto mysqlYml = null;
    private DockerStatusDto dockerStatus = null;
    private ServiceStatusDto serviceStatusDto = new ServiceStatusDto();
    private List<FileInfoDto> proxyConfFiles = null;
    private List<FileInfoDto> proxyServerConfFiles = null;
    private List<FileInfoDto> proxyConfTemplateFiles = null;
    private List<FileInfoDto> databaseDumpFiles = null;
    private boolean proxyTemplateFilesCreated = false;
    private CpuTrendDto cpuTrendDto = new CpuTrendDto();
    private CpuTrendDto cpuTrendDtoDocker = new CpuTrendDto();
    private SystemStatusDto systemStatusDto = new SystemStatusDto();
    private AjaxWelcomeInfo welcomeInfo = new AjaxWelcomeInfo();
    private List<String> availableServices = new ArrayList();
    private List<String> installedServices = new ArrayList();
    private HashMap<String, DockerComposeDto> installedServicesYmls = new HashMap();
    private boolean mainSetupService = false;
    private boolean pingself = false;
    private Long startSetupServiceCheck = null;
    private boolean analyzeRunning = false;
    private volatile boolean analyzeFirstRunning = false;
    volatile boolean dockerStatisticsRunning = false;
    private volatile boolean calcContainerRevisionsRunning = false;

    @PostConstruct
    public void init() {
        this.updateService.dockerService = this;
        this.updateService.setupUpdateService.dockerService = this;
        this.databaseService.dockerService = this;
        this.lizenzService.dockerService = this;
        this.setupStorageService.setDockerService(this);
    }

    public String getToken() {
        String token = this.sessionBean.getLettoToken().getToken();
        return token;
    }

    public DockerComposeDto getSetupYml() {
        if (this.setupYml == null) {
            this.loadSetupYml();
        }
        return this.setupYml;
    }

    public DockerComposeDto getLettoYml() {
        if (this.lettoYml == null) {
            this.loadLettoYml();
        }
        return this.lettoYml;
    }

    public DockerComposeDto getMysqlYml() {
        if (this.mysqlYml == null) {
            this.loadMysqlYml();
        }
        return this.mysqlYml;
    }

    public DockerStatusDto getDockerStatus() {
        if (this.dockerStatus == null) {
            this.analyze(false);
        }
        return this.dockerStatus;
    }

    public String getSetupComposeDir() {
        File dir = new File(this.microServiceConfiguration.getLettoSetupHostDocker().replaceAll("\\\\", "/") + "/compose/setup");
        if (dir.exists()) {
            return dir.getAbsolutePath();
        }
        return null;
    }

    public String getMysqlComposeDir() {
        File dir = new File(this.microServiceConfiguration.getLettoSetupHostDocker().replaceAll("\\\\", "/") + "/compose/mysql");
        if (dir.exists()) {
            return dir.getAbsolutePath();
        }
        return null;
    }

    public String getLettoComposeDir() {
        File dir = new File(this.microServiceConfiguration.getLettoSetupHostDocker().replaceAll("\\\\", "/") + "/compose/letto");
        if (dir.exists()) {
            return dir.getAbsolutePath();
        }
        return null;
    }

    public List<FileInfoDto> getProxyConfFiles() {
        if (this.proxyConfFiles == null) {
            this.analyze(false);
        }
        return this.proxyConfFiles;
    }

    public List<FileInfoDto> getProxyServerConfFiles() {
        if (this.proxyServerConfFiles == null) {
            this.analyze(false);
        }
        return this.proxyServerConfFiles;
    }

    public List<FileInfoDto> getProxyConfTemplateFiles() {
        if (this.proxyConfTemplateFiles == null) {
            this.analyze(false);
        }
        return this.proxyConfTemplateFiles;
    }

    public List<FileInfoDto> getDatabaseDumpFiles() {
        if (this.databaseDumpFiles == null) {
            this.analyze(false);
        }
        return this.databaseDumpFiles;
    }

    public FileInfoDto getDumpFile(String filename) {
        try {
            if (filename != null && filename.length() > 0) {
                String fn = filename.trim();
                for (FileInfoDto f : this.getDatabaseDumpFiles()) {
                    if (!f.getFilename().equals(fn) && !f.getFilename().equals(fn + ".sql")) continue;
                    return f;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean existLocalSetupLog() {
        File f = new File("/opt/letto/setup/lettosetup.log");
        return f.exists();
    }

    public void checkMainSetupService() {
        SetupEnvFile setupEnv = this.dockerConfiguration.getSetupEnvFile();
        switch (setupEnv.getSetupMain().toUpperCase()) {
            case "LOCAL": {
                this.mainSetupService = !this.isDockerRunning();
                break;
            }
            default: {
                if (this.isDockerRunning()) {
                    try {
                        if (this.lettoService.getSetupService().pingHost()) {
                            this.mainSetupService = false;
                            this.startSetupServiceCheck = null;
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mainSetupService) break;
                    long time = System.currentTimeMillis();
                    if (this.startSetupServiceCheck == null) {
                        this.startSetupServiceCheck = time;
                        break;
                    }
                    if (this.startSetupServiceCheck + 180000L >= time) break;
                    this.mainSetupService = true;
                    break;
                }
                this.mainSetupService = true;
                try {
                    this.lettoService.getSetupService().deactivatemain();
                }
                catch (Exception exception) {}
                break;
            }
            case "DOCKER": {
                this.mainSetupService = this.isDockerRunning();
            }
        }
    }

    public String deactivateMain() {
        if (this.isDockerRunning() && this.mainSetupService) {
            this.mainSetupService = false;
            this.startSetupServiceCheck = null;
            return "main deactivated";
        }
        return "ok";
    }

    public String dockerInfo() {
        Object info = this.analyzeService.getMicroServiceConfiguration().isSetupDocker() ? "TRUE" : "FALSE";
        info = (String)info + " ";
        info = (String)info + (this.mainSetupService ? "MAIN" : "-");
        return info;
    }

    public void analyze(boolean includeAnalyzeService) {
        if (this.analyzeRunning) {
            return;
        }
        this.analyzeRunning = true;
        this.checkMainSetupService();
        try {
            if (includeAnalyzeService) {
                this.analyzeService.analyze();
            }
            this.analyzeFirst();
            this.analyzeSecond();
            this.analyzeRunning = false;
            return;
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        catch (Error e2) {
            e2.printStackTrace();
        }
        System.out.println("Error during analyze docker system! look the messages before!");
        this.analyzeRunning = false;
    }

    public void analyzeFirst() {
        if (this.analyzeFirstRunning) {
            return;
        }
        this.analyzeFirstRunning = true;
        try {
            this.pingself = this.pingSelf();
            this.calcDockerStatus();
            if (this.existsSetupEnv()) {
                if (this.existsLettoEnv()) {
                    this.databaseService.checkDatabaseDockerConfig();
                }
                this.checkDockerStatus();
            }
            this.analyzeFiles();
            this.calcSystemStatus();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        catch (Error e2) {
            e2.printStackTrace();
        }
        this.analyzeFirstRunning = false;
    }

    public void analyzeSecond() {
        try {
            this.updateService.loadUpdateDto();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        catch (Error e2) {
            e2.printStackTrace();
        }
    }

    public void loadMysqlYml() {
        this.mysqlYml = this.calcDockerComposeDto(this.getMysqlYmlFile(), (EnvFile)this.dockerConfiguration.getMysqlEnvFile());
    }

    public DockerComposeDto loadSetupYml() {
        this.setupYml = this.calcDockerComposeDto(this.getSetupYmlFile(), (EnvFile)this.dockerConfiguration.getSetupEnvFile());
        return this.setupYml;
    }

    public void loadLettoYml() {
        this.lettoYml = this.calcDockerComposeDto(this.getLettoYmlFile(), (EnvFile)this.dockerConfiguration.getLettoEnvFile());
    }

    public DockerComposeDto getSchoolYml(String school) {
        DockerComposeDto dockerComposeDto = this.calcDockerComposeDto(this.microServiceConfiguration.getSchoolYmlFile(school), (EnvFile)this.dockerConfiguration.getLettoEnvFile());
        return dockerComposeDto;
    }

    public DockerComposeDto loadServiceYml(File file) {
        DockerComposeDto yml = this.calcDockerComposeDto(file, (EnvFile)this.dockerConfiguration.getLettoEnvFile());
        return yml;
    }

    private DockerComposeDto getServiceYml(String ymlFileName) {
        DockerComposeDto dockerComposeDto = this.calcDockerComposeDto(this.microServiceConfiguration.getServiceYmlFile(ymlFileName), (EnvFile)this.dockerConfiguration.getLettoEnvFile());
        return dockerComposeDto;
    }

    public void analyzeFiles() {
        try {
            this.setupYml = this.calcDockerComposeDto(this.getSetupYmlFile(), (EnvFile)this.dockerConfiguration.getSetupEnvFile());
            this.lettoYml = this.calcDockerComposeDto(this.getLettoYmlFile(), (EnvFile)this.dockerConfiguration.getLettoEnvFile());
            this.proxyConfFiles = this.calcProxyConfFiles();
            this.proxyServerConfFiles = this.calcProxyServerFiles();
            this.proxyConfTemplateFiles = this.calcProxyConfTemplateFiles();
            this.databaseDumpFiles = this.calcDatabaseDumpFiles();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        catch (Error e2) {
            e2.printStackTrace();
        }
    }

    public void saveEmailConfig(EmailConfigDto emailConfigDto) {
        try {
            SetupEnvFile setupEnv = this.dockerConfiguration.getSetupEnvFile();
            LettoEnvFile lettoEnv = this.dockerConfiguration.getLettoEnvFile();
            setupEnv.setSpringMailHost(emailConfigDto.getEmailHost());
            if (emailConfigDto.getPort() != null) {
                setupEnv.setSpringMailPort(emailConfigDto.getPort().intValue());
            }
            setupEnv.setSpringMailUsername(emailConfigDto.getUsername());
            setupEnv.setSpringMailPassword(emailConfigDto.getPassword());
            setupEnv.setSpringMailAuth(emailConfigDto.isAuthentication());
            setupEnv.setSpringMailStartTLS(emailConfigDto.isStartTTLsEnabled());
            setupEnv.setSpringMailSSL(emailConfigDto.isSshEnabled());
            setupEnv.setSpringMailNoReply(emailConfigDto.getAddressNoReply());
            setupEnv.setSpringMailReply(emailConfigDto.getAddressReply());
            lettoEnv.setSpringMailHost(emailConfigDto.getEmailHost());
            lettoEnv.setSpringMailPort(emailConfigDto.getPort().intValue());
            lettoEnv.setSpringMailUsername(emailConfigDto.getUsername());
            lettoEnv.setSpringMailPassword(emailConfigDto.getPassword());
            lettoEnv.setSpringMailAuth(emailConfigDto.isAuthentication());
            lettoEnv.setSpringMailStartTLS(emailConfigDto.isStartTTLsEnabled());
            lettoEnv.setSpringMailSSL(emailConfigDto.isSshEnabled());
            lettoEnv.setSpringMailNoReply(emailConfigDto.getAddressNoReply());
            lettoEnv.setSpringMailReply(emailConfigDto.getAddressReply());
            this.dockerConfiguration.saveConfiguration();
            this.dockerConfiguration.loadConfiguration();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public EmailConfigDto loadEmailConfig(EmailConfigDto emailConfigDto) {
        try {
            SetupEnvFile setupEnv = this.dockerConfiguration.getSetupEnvFile();
            LettoEnvFile lettoEnv = this.dockerConfiguration.getLettoEnvFile();
            if (setupEnv.getSpringMailHost() != null && setupEnv.getSpringMailHost().trim().length() > 0) {
                emailConfigDto.setEmailHost(setupEnv.getSpringMailHost().trim());
            }
            if (setupEnv.getSpringMailPort() != null) {
                emailConfigDto.setPort(setupEnv.getSpringMailPort());
            }
            if (setupEnv.getSpringMailUsername() != null && setupEnv.getSpringMailUsername().trim().length() > 0) {
                emailConfigDto.setUsername(setupEnv.getSpringMailUsername().trim());
            }
            if (setupEnv.getSpringMailPassword() != null && setupEnv.getSpringMailPassword().trim().length() > 0) {
                emailConfigDto.setPassword(setupEnv.getSpringMailPassword().trim());
            }
            if (setupEnv.getSpringMailAuth() != null) {
                emailConfigDto.setAuthentication(setupEnv.getSpringMailAuth().booleanValue());
            }
            if (setupEnv.getSpringMailStartTLS() != null) {
                emailConfigDto.setStartTTLsEnabled(setupEnv.getSpringMailStartTLS().booleanValue());
            }
            if (setupEnv.getSpringMailSSL() != null) {
                emailConfigDto.setSshEnabled(setupEnv.getSpringMailSSL().booleanValue());
            }
            if (setupEnv.getSpringMailNoReply() != null && setupEnv.getSpringMailNoReply().trim().length() > 0) {
                emailConfigDto.setAddressNoReply(setupEnv.getSpringMailNoReply().trim());
            }
            if (setupEnv.getSpringMailReply() != null && setupEnv.getSpringMailReply().trim().length() > 0) {
                emailConfigDto.setAddressReply(setupEnv.getSpringMailNoReply().trim());
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return emailConfigDto;
    }

    public void calcSystemStatus() {
        SystemStatusDto systemStatus = new SystemStatusDto();
        systemStatus.setTime(System.currentTimeMillis());
        systemStatus.setCpuLoad(this.cpuTrendDto.getAvCpuLoadLastMinute());
        this.analyzeMemory(systemStatus);
        File f = new File(this.getDockerPath());
        systemStatus.setTotalDiskSpaceMB((int)(f.getTotalSpace() / 1024L / 1024L));
        systemStatus.setFreeDiskSpaceMB((int)(f.getFreeSpace() / 1024L / 1024L));
        systemStatus.setUseableDiskSpaceMB((int)(f.getUsableSpace() / 1024L / 1024L));
        systemStatus.setMemoryJavaUsedMB((int)(this.analyzeService.getMemoryUsed() / 1024L / 1024L));
        systemStatus.setMemoryJavaMaxMB((int)(this.analyzeService.getMemoryMax() / 1024L / 1024L));
        List containers = this.dockerStatus.getContainers();
        ArrayList<DockerContainerStatusDto> containerStatusDtoList = new ArrayList<DockerContainerStatusDto>();
        for (DockerContainerDto c : containers) {
            containerStatusDtoList.add(new DockerContainerStatusDto(c));
        }
        systemStatus.setDockerContainers(containerStatusDtoList);
        this.systemStatusDto = systemStatus;
        this.calcAvailableServices();
        this.calcInstalledServices();
        this.databaseService.calcDatabaseStatus(this.dockerStatus);
        this.checkServiceStatus();
    }

    private void analyzeMemory(SystemStatusDto systemStatus) {
        try {
            CmdThread t = null;
            t = this.analyzeService.isLinux() ? this.cmdService.cmdScriptForeground(3000L, false, new String[]{"top -b -n1"}) : this.cmdService.cmdScriptForeground(3000L, false, new String[]{"docker exec -i letto-setup top -b -n1"});
            if (t != null && t != null && t.getOut().size() > 0 && ((Vector)t.getOut().get(0)).size() > 0) {
                for (String s : (Vector)t.getOut().get(0)) {
                    Matcher m = Pattern.compile("^.*([KMG])iB ([a-zA-Z]+)\\s*:\\s*([\\d\\.\\,]+)\\s+[a-zA-Z]+,\\s+([\\d\\.\\,]+)\\s+[a-zA-Z]+,\\s+([\\d\\.\\,]+)\\s+[a-zA-Z]+[\\.\\,]\\s+([\\d\\.\\,]+)\\s+.*").matcher(s);
                    if (!m.find()) continue;
                    double fakt = 1.0;
                    if (m.group(1).equals("K")) {
                        fakt = 0.001;
                    }
                    if (m.group(1).equals("M")) {
                        fakt = 1.0;
                    }
                    if (m.group(1).equals("G")) {
                        fakt = 1000.0;
                    }
                    String memswap = m.group(2);
                    double total = 0.0;
                    double free = 0.0;
                    double used = 0.0;
                    double buffAvail = 0.0;
                    try {
                        total = Double.parseDouble(m.group(3).replaceAll("\\,", "\\.")) * fakt;
                        free = Double.parseDouble(m.group(4).replaceAll("\\,", "\\.")) * fakt;
                        used = Double.parseDouble(m.group(5).replaceAll("\\,", "\\.")) * fakt;
                        buffAvail = Double.parseDouble(m.group(6).replaceAll("\\,", "\\.")) * fakt;
                        if (memswap.toLowerCase().equals("swap")) {
                            systemStatus.setMemorySwapTotalMB((int)total);
                            systemStatus.setMemorySwapFreeMB((int)free);
                            systemStatus.setMemorySwapUsedMB((int)used);
                            systemStatus.setMemoryAvailableMB((int)buffAvail);
                            continue;
                        }
                        systemStatus.setMemoryTotalMB((int)total);
                        systemStatus.setMemoryFreeMB((int)free);
                        systemStatus.setMemoryUsedMB((int)used);
                        systemStatus.setMemoryBufferMB((int)buffAvail);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        catch (Error e2) {
            e2.printStackTrace();
        }
    }

    public CmdThread analyzeBackground(boolean includeAnalyzeService) {
        Analyze cmdThread = new Analyze(this, this, includeAnalyzeService);
        cmdThread.start();
        return cmdThread;
    }

    public boolean pingDockerProxy() {
        RestSetupService restSetupService = new RestSetupService("https://localhost");
        return restSetupService.ping();
    }

    public String head() {
        Object ret = "";
        ret = (String)ret + "<link href='" + this.getStyleCss() + "' rel='stylesheet' />";
        ret = (String)ret + "<link rel='icon' type='image/png' sizes='all' href='" + this.getIcon() + ".png'/>";
        ret = (String)ret + "<script src='" + this.jsJQueryEP() + "'></script>";
        ret = (String)ret + "<script src='" + this.jsBootstrapEP() + "'></script>";
        ret = (String)ret + "<script src='" + this.jsLettoSetupToolsEP() + "'></script>";
        return ret;
    }

    public String getBaseUrl() {
        return this.analyzeService.getLocalUrlHost();
    }

    public String getStyleCss() {
        if (this.isDockerRunning()) {
            return "/config/open/css/style.css";
        }
        return "/setup/open/css/style.css";
    }

    public String getIcon() {
        if (this.isDockerRunning()) {
            return "/config/open/images/lettoTT";
        }
        return "/setup/open/images/lettoTT";
    }

    public String logoEP10() {
        if (this.isDockerRunning()) {
            return "/config/open/images/letto2-10.png";
        }
        return "/setup/open/images/letto2-10.png";
    }

    public String logoEP20() {
        if (this.isDockerRunning()) {
            return "/config/open/images/letto2-20.png";
        }
        return "/setup/open/images/letto2-20.png";
    }

    public String logoEP50() {
        if (this.isDockerRunning()) {
            return "/config/open/images/letto2-50.png";
        }
        return "/setup/open/images/letto2-50.png";
    }

    public String logoEP100() {
        if (this.isDockerRunning()) {
            return "/config/open/images/letto2.png";
        }
        return "/setup/open/images/letto2.png";
    }

    public String loginEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/open/login" : "/setup/open/login";
    }

    public String jsJQueryEP() {
        return (this.microServiceConfiguration.isSetupDocker() ? "/config/open/js" : "/setup/open/js") + "/jquery-3.6.0.min.js";
    }

    public String jsBootstrapEP() {
        return (this.microServiceConfiguration.isSetupDocker() ? "/config/open/js" : "/setup/open/js") + "/bootstrap.min.js";
    }

    public String jsLettoSetupToolsEP() {
        return (this.microServiceConfiguration.isSetupDocker() ? "/config/open/js" : "/setup/open/js") + "/lettosetuptools.js";
    }

    public String cssBootstrapEP() {
        return (this.microServiceConfiguration.isSetupDocker() ? "/config/open/css" : "/setup/open/css") + "/bootstrap.min.css";
    }

    public String jsChartEP() {
        return (this.microServiceConfiguration.isSetupDocker() ? "/config/open/js" : "/setup/open/js") + "/chart.min.js";
    }

    public String fileviewEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/fileview" : "/setup/session/fileview";
    }

    public String fileeditEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/fileedit" : "/setup/session/fileedit";
    }

    public String logoutEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/open/logout" : "/setup/open/logout";
    }

    public String welcomeEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/welcome" : "/setup/session/welcome";
    }

    public String ldapEP() {
        return "/config/session/admin/ldap";
    }

    public String updateEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/update" : "/setup/session/admin/update";
    }

    public String serverTokenEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/servertoken" : "/setup/session/admin/servertoken";
    }

    public String pluginsEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/plugins" : "/setup/session/admin/plugins";
    }

    public String docEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/doc" : "/setup/session/admin/doc";
    }

    public String welcomeAnalyzeEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/welcomeanalyze" : "/setup/session/welcomeanalyze";
    }

    public String globalDownloadEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/global/download" : "/setup/session/global/download";
    }

    public String reloadEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/reload" : "/setup/session/reload";
    }

    public String backupEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/backup" : "/setup/session/admin/backup";
    }

    public String backupUploadEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/backupupload" : "/setup/session/admin/backupupload";
    }

    public String explorerEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/explorer" : "/setup/session/admin/explorer";
    }

    public String explorerUploadEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/explorerupload" : "/setup/session/admin/explorerupload";
    }

    public String analyzeEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/analyze" : "/setup/session/analyze";
    }

    public String systemStatusEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/systemStatus" : "/setup/session/admin/systemstatus";
    }

    public String cmdOutputEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/cmdoutput" : "/setup/session/admin/cmdoutput";
    }

    public String cmdEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/cmd" : "/setup/session/admin/cmd";
    }

    public String mysqlcmdEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/mysqlcmd" : "/setup/session/admin/mysqlcmd";
    }

    public String emailconfigEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/emailconfig" : "/setup/session/admin/emailconfig";
    }

    public String dockerLettoStatusEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/dockerlettostatus" : "/setup/session/admin/dockerlettostatus";
    }

    public String dockerLettoProxyEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/dockerlettoproxy" : "/setup/session/admin/dockerlettoproxy";
    }

    public String dockerEditSchoolEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/dockereditschool" : "/setup/session/admin/dockereditschool";
    }

    public String sicherungLocalEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/sicherunglocal" : "/setup/session/sicherunglocal";
    }

    public String schoolConfigEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/schoolconfig" : "/setup/session/admin/schoolconfig";
    }

    public String analyzeDockerEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/open/ajax/analyzedocker" : "/setup/open/ajax/analyzedocker";
    }

    public String editSchoolSetButtonsEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/ajax/editschoolsetbuttons" : "/setup/session/admin/ajax/editschoolsetbuttons";
    }

    public String editSchoolCheckDatabaseEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/ajax/editschoolcheckdatabase" : "/setup/session/admin/ajax/editschoolcheckdatabase";
    }

    public String ajaxWelcomeInfoEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/ajax/welcomeinfo" : "/setup/session/admin/ajax/welcomeinfo";
    }

    public String ajaxCmdOutputEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/ajax/cmdoutput" : "/setup/session/admin/ajax/cmdoutput";
    }

    public String configureDockerLink() {
        if (this.pingDockerProxy()) {
            return "https://" + this.analyzeService.getLocalUrlHost() + "/config/session/welcome";
        }
        return "https://" + this.analyzeService.getLocalUrlHost() + ":3096/config/session/welcome";
    }

    public void checkDockerStatus() {
        String ape;
        String ap2;
        String secret;
        boolean changed = false;
        SetupEnvFile setupEnv = this.dockerConfiguration.getSetupEnvFile();
        LettoEnvFile lettoEnv = this.dockerConfiguration.getLettoEnvFile();
        if (setupEnv.getJwtSecret() == null || setupEnv.getJwtSecret().length() == 0) {
            changed = true;
            secret = ENCRYPT.base64Encode((String)ENCRYPT.generateKeyAz09((int)80));
            setupEnv.setJwtSecret(secret);
            lettoEnv.setJwtSecret(secret);
        }
        if (setupEnv.getServerSecret() == null || setupEnv.getServerSecret().length() == 0) {
            changed = true;
            secret = ENCRYPT.base64Encode((String)ENCRYPT.generateKeyAz09((int)80));
            setupEnv.setServerSecret(secret);
            lettoEnv.setServerSecret(secret);
        }
        if (setupEnv.getLettoPrivateKey() == null || setupEnv.getLettoPrivateKey().length() == 0 || setupEnv.getLettoPublicKey() == null || setupEnv.getLettoPublicKey().length() == 0) {
            try {
                KeyPair keyPair = ENCRYPT.generateRSAkeypair();
                changed = true;
                String privateKey = ENCRYPT.privateKeyBase64FromRSAkeypair((KeyPair)keyPair);
                String publicKey = ENCRYPT.publicKeyBase64FromRSAkeypair((KeyPair)keyPair);
                setupEnv.setLettoPrivateKey(privateKey);
                lettoEnv.setLettoPrivateKey(privateKey);
                setupEnv.setLettoPublicKey(publicKey);
                lettoEnv.setLettoPublicKey(publicKey);
            }
            catch (Exception ex) {
                System.out.println("Cannot create Keypair!!");
            }
        }
        if (setupEnv.getAdminPasswordEncrypted() == null) {
            setupEnv.setAdminPasswordEncrypted("");
        }
        if (setupEnv.getAdminPassword() != null && setupEnv.getAdminPassword().length() > 0 && !new BCryptPasswordEncoder().matches((CharSequence)setupEnv.getAdminPassword(), setupEnv.getAdminPasswordEncrypted())) {
            changed = true;
            ap2 = setupEnv.getAdminPassword();
            ape = new BCryptPasswordEncoder().encode((CharSequence)ap2);
            setupEnv.setAdminPasswordEncrypted(ape);
        }
        if (setupEnv.getServiceGastPassword() == null || setupEnv.getServiceGastPassword().length() == 0) {
            changed = true;
            setupEnv.setServiceGastPassword(ENCRYPT.generateKeyAz09((int)30));
        }
        if (setupEnv.getServiceUserPassword() == null || setupEnv.getServiceUserPassword().length() == 0) {
            changed = true;
            setupEnv.setServiceUserPassword(ENCRYPT.generateKeyAz09((int)30));
        }
        if (setupEnv.getServiceAdminPassword() == null || setupEnv.getServiceAdminPassword().length() == 0) {
            changed = true;
            setupEnv.setServiceAdminPassword(ENCRYPT.generateKeyAz09((int)30));
        }
        if (setupEnv.getLettoRestkey() == null) {
            setupEnv.setLettoRestkey("");
        }
        if (setupEnv.getLettoLicenseServer() != null && setupEnv.getLettoLicenseServer().trim().length() > 0) {
            if (!setupEnv.getLettoLicenseServer().trim().equals(lettoEnv.getLettoLicenseServer().trim())) {
                changed = true;
                lettoEnv.setLettoLicenseServer(setupEnv.getLettoLicenseServer().trim());
                this.microServiceConfiguration.setLicenseServer(setupEnv.getLettoLicenseServer().trim());
            }
            if (!setupEnv.getLettoLicenseServer().trim().equals(this.microServiceConfiguration.getLicenseServer())) {
                this.microServiceConfiguration.setLicenseServer(setupEnv.getLettoLicenseServer().trim());
            }
        } else if (lettoEnv.getLettoLicenseServer() != null && setupEnv.getLettoLicenseServer().trim().length() > 0) {
            changed = true;
            lettoEnv.setLettoLicenseServer("");
            this.microServiceConfiguration.setLicenseServer("https://license.letto.at");
        }
        if (!setupEnv.getJwtSecret().equals(lettoEnv.getJwtSecret())) {
            changed = true;
            lettoEnv.setJwtSecret(setupEnv.getJwtSecret());
        }
        if (!setupEnv.getServerSecret().equals(lettoEnv.getServerSecret())) {
            changed = true;
            lettoEnv.setServerSecret(setupEnv.getServerSecret());
        }
        if (!setupEnv.getLettoPrivateKey().equals(lettoEnv.getLettoPrivateKey()) || !setupEnv.getLettoPublicKey().equals(lettoEnv.getLettoPublicKey())) {
            try {
                changed = true;
                lettoEnv.setLettoPrivateKey(setupEnv.getLettoPrivateKey());
                lettoEnv.setLettoPublicKey(setupEnv.getLettoPublicKey());
            }
            catch (Exception ap2) {
                // empty catch block
            }
        }
        if (setupEnv.getAdminPasswordEncrypted() == null || setupEnv.getAdminPasswordEncrypted().length() == 0) {
            changed = true;
            if (setupEnv.getAdminPassword() == null) {
                setupEnv.setAdminPassword("letto");
            }
            ap2 = setupEnv.getAdminPassword();
            ape = new BCryptPasswordEncoder().encode((CharSequence)ap2);
            setupEnv.setAdminPasswordEncrypted(ape);
        }
        if (setupEnv.getAdminPassword() != null && setupEnv.getAdminPassword().length() > 0 && !new BCryptPasswordEncoder().matches((CharSequence)setupEnv.getAdminPassword(), setupEnv.getAdminPasswordEncrypted())) {
            changed = true;
            ap2 = setupEnv.getAdminPassword().trim();
            ape = new BCryptPasswordEncoder().encode((CharSequence)ap2);
            setupEnv.setAdminPasswordEncrypted(ape);
        }
        if (setupEnv.getAdminPassword() != null && setupEnv.getAdminPassword().trim().length() > 0 && setupEnv.getAdminPasswordEncrypted() != null && setupEnv.getAdminPasswordEncrypted().trim().length() > 0) {
            changed = true;
            ap2 = setupEnv.getAdminPassword().trim();
            ape = new BCryptPasswordEncoder().encode((CharSequence)ap2.trim());
            setupEnv.setAdminPasswordEncrypted(ape);
            setupEnv.setAdminPassword("");
        }
        if (!setupEnv.getServiceGastPassword().equals(lettoEnv.getServiceGastPassword())) {
            changed = true;
            lettoEnv.setServiceGastPassword(setupEnv.getServiceGastPassword());
        }
        if (!setupEnv.getServiceUserPassword().equals(lettoEnv.getServiceUserPassword())) {
            changed = true;
            lettoEnv.setServiceUserPassword(setupEnv.getServiceUserPassword());
        }
        if (!setupEnv.getServiceAdminPassword().equals(lettoEnv.getServiceAdminPassword())) {
            changed = true;
            lettoEnv.setServiceAdminPassword(setupEnv.getServiceAdminPassword());
        }
        if (setupEnv.getLettoRestkey() == null) {
            setupEnv.setLettoRestkey("");
        }
        if (!setupEnv.getLettoRestkey().equals(lettoEnv.getLettoRestkey())) {
            changed = true;
            lettoEnv.setLettoRestkey(setupEnv.getLettoRestkey());
        }
        if (setupEnv.getLettoLicenseServer() != null && setupEnv.getLettoLicenseServer().trim().length() > 0) {
            if (!setupEnv.getLettoLicenseServer().trim().equals(lettoEnv.getLettoLicenseServer().trim())) {
                changed = true;
                lettoEnv.setLettoLicenseServer(setupEnv.getLettoLicenseServer().trim());
                this.microServiceConfiguration.setLicenseServer(setupEnv.getLettoLicenseServer().trim());
            }
            if (!setupEnv.getLettoLicenseServer().trim().equals(this.microServiceConfiguration.getLicenseServer())) {
                this.microServiceConfiguration.setLicenseServer(setupEnv.getLettoLicenseServer().trim());
            }
        } else if (lettoEnv.getLettoLicenseServer() != null && setupEnv.getLettoLicenseServer().trim().length() > 0) {
            changed = true;
            lettoEnv.setLettoLicenseServer("");
            this.microServiceConfiguration.setLicenseServer("https://license.letto.at");
        }
        if (changed) {
            setupEnv.writeFile();
            if (this.existsLettoEnv()) {
                lettoEnv.writeFile();
            }
        }
        if (changed || !this.microServiceConfiguration.isSetupDocker()) {
            if (setupEnv.getAdminPassword() != null && setupEnv.getAdminPassword().length() > 0) {
                this.setupUserDetailsService.setSetupAdminPassword(setupEnv.getAdminPassword());
            }
            this.setupUserDetailsService.setSetupAdminPasswordEncrypted(setupEnv.getAdminPasswordEncrypted());
            this.microServiceConfiguration.setJwtSecret(setupEnv.getJwtSecret());
            this.microServiceConfiguration.setServerSecret(setupEnv.getServerSecret());
            this.microServiceConfiguration.setRestkey(setupEnv.getLettoRestkey());
            this.microServiceConfiguration.setLocalPrivateKey(setupEnv.getLettoPrivateKey());
            this.microServiceConfiguration.setLocalPublicKey(setupEnv.getLettoPublicKey());
            this.microServiceConfiguration.setUserGastPassword(setupEnv.getServiceGastPassword());
            this.microServiceConfiguration.setUserUserPassword(setupEnv.getServiceUserPassword());
            this.microServiceConfiguration.setUserAdminPassword(setupEnv.getServiceAdminPassword());
            this.updateUserPasswords();
        }
    }

    public void updateUserPasswords() {
        try {
            if (this.microServiceConfiguration.getUserGastPassword() != null && this.microServiceConfiguration.getUserGastPassword().length() > 0) {
                this.baseLettoUserDetailsService.updateUserPassword("gast", this.microServiceConfiguration.getUserGastPassword());
            } else if (this.microServiceConfiguration.getUserGastEncryptedPassword() != null && this.microServiceConfiguration.getUserGastEncryptedPassword().length() > 0) {
                this.baseLettoUserDetailsService.updateUserEncryptedPassword("gast", this.microServiceConfiguration.getUserGastEncryptedPassword());
            }
            if (this.microServiceConfiguration.getUserUserPassword() != null && this.microServiceConfiguration.getUserUserPassword().length() > 0) {
                this.baseLettoUserDetailsService.updateUserPassword("user", this.microServiceConfiguration.getUserUserPassword());
            } else if (this.microServiceConfiguration.getUserUserEncryptedPassword() != null && this.microServiceConfiguration.getUserUserEncryptedPassword().length() > 0) {
                this.baseLettoUserDetailsService.updateUserEncryptedPassword("user", this.microServiceConfiguration.getUserUserEncryptedPassword());
            }
            if (this.microServiceConfiguration.getUserAdminPassword() != null && this.microServiceConfiguration.getUserAdminPassword().length() > 0) {
                this.baseLettoUserDetailsService.updateUserPassword("admin", this.microServiceConfiguration.getUserAdminPassword());
            } else if (this.microServiceConfiguration.getUserAdminEncryptedPassword() != null && this.microServiceConfiguration.getUserAdminEncryptedPassword().length() > 0) {
                this.baseLettoUserDetailsService.updateUserEncryptedPassword("admin", this.microServiceConfiguration.getUserAdminEncryptedPassword());
            }
        }
        catch (Exception ex) {
            System.out.println("Error - cannot update user passwords!");
        }
    }

    public void checkServiceStatus() {
        ServiceStatusDto dto = new ServiceStatusDto();
        RestSetupService setup = this.lettoService.getSetupService();
        if (setup != null) {
            dto = this.isDockerRunning() ? setup.checkServiceStatusLocal() : setup.checkServiceStatus();
        }
        this.serviceStatusDto = this.getServiceStatus(dto);
    }

    public ServiceStatusDto getServiceStatus(ServiceStatusDto serviceStatusDto) {
        if (serviceStatusDto == null) {
            serviceStatusDto = this.serviceStatusDto;
        }
        if (this.isDockerRunning()) {
            serviceStatusDto.setLettoLicense(this.lizenzService.isLicensServerAvailable());
            serviceStatusDto.setLogin(this.lettoService.initLoginService() != null);
            serviceStatusDto.setSetup(this.lettoService.initSetupService() != null);
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            LettoEnvFile envFile = this.dockerConfiguration.getLettoEnvFile();
            for (SchuleEnv schule : envFile.getSchulen()) {
                RestLettoDataService dataService = this.lettoService.initLettoDataService(schule.school);
                data.put(schule.school, dataService != null);
            }
            serviceStatusDto.setData(data);
            serviceStatusDto.setLti(this.lettoService.initLtiService() != null);
            try {
                serviceStatusDto.setQuestion(((DockerComposeServiceDto)((DockerComposeDto)this.installedServicesYmls.get("question")).getServices().get(0)).isRunning());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                serviceStatusDto.setPlugin(((DockerComposeServiceDto)((DockerComposeDto)this.installedServicesYmls.get("plugin")).getServices().get(0)).isRunning());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                serviceStatusDto.setPluginsourcecode(((DockerComposeServiceDto)((DockerComposeDto)this.installedServicesYmls.get("pluginsourcecode")).getServices().get(0)).isRunning());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                serviceStatusDto.setExport(((DockerComposeServiceDto)((DockerComposeDto)this.installedServicesYmls.get("export")).getServices().get(0)).isRunning());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                serviceStatusDto.setMain(((DockerComposeServiceDto)((DockerComposeDto)this.installedServicesYmls.get("main")).getServices().get(0)).isRunning());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                serviceStatusDto.setMath(((DockerComposeServiceDto)((DockerComposeDto)this.installedServicesYmls.get("math")).getServices().get(0)).isRunning());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                serviceStatusDto.setMail(((DockerComposeServiceDto)((DockerComposeDto)this.installedServicesYmls.get("mail")).getServices().get(0)).isRunning());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                serviceStatusDto.setImage(((DockerComposeServiceDto)((DockerComposeDto)this.installedServicesYmls.get("image")).getServices().get(0)).isRunning());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                serviceStatusDto.setPrint(((DockerComposeServiceDto)((DockerComposeDto)this.installedServicesYmls.get("print")).getServices().get(0)).isRunning());
            }
            catch (Exception exception) {}
        } else {
            serviceStatusDto.setLettoLicenseHost(this.lizenzService.isLicensServerAvailable());
            serviceStatusDto.setLoginHost(this.lettoService.initLoginService() != null);
            serviceStatusDto.setSetupHost(this.lettoService.initSetupService() != null);
        }
        boolean v12 = true;
        for (String service : servicesV12) {
            if (this.installedServicesYmls.get(service) == null) {
                v12 = false;
                serviceStatusDto.getServiceInstalled().put(service, false);
                continue;
            }
            serviceStatusDto.getServiceInstalled().put(service, true);
        }
        serviceStatusDto.setV12ymlpresent(v12);
        for (String service : servicesV12) {
            boolean ok = false;
            try {
                if (((DockerComposeServiceDto)((DockerComposeDto)this.installedServicesYmls.get(service)).getServices().get(0)).isRunning()) {
                    ok = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ok) {
                serviceStatusDto.getServiceOk().put(service, true);
                continue;
            }
            serviceStatusDto.getServiceOk().put(service, false);
            v12 = false;
        }
        serviceStatusDto.setV12servicesOk(v12);
        return serviceStatusDto;
    }

    public String htmlServiceStatus() {
        Object ret;
        block12: {
            ret = "Host-Services: ";
            try {
                ret = (String)ret + "<span style='color:" + (this.serviceStatusDto.isSetupHost() ? "green" : "red") + ";'>setup</span> ";
                if (!this.isDockerRunning() || this.serviceStatusDto.isSetupHost()) {
                    ret = (String)ret + "<span style='color:" + (this.serviceStatusDto.isLettoLicenseHost() ? "green" : "red") + ";'>license</span> ";
                    ret = (String)ret + "<span style='color:" + (this.serviceStatusDto.isLoginHost() ? "green" : "red") + ";'>login</span> ";
                }
                ret = (String)ret + " Docker-Service: ";
                if (!this.isDockerRunning() || this.serviceStatusDto.isSetupHost()) {
                    ret = (String)ret + "<span style='color:" + (this.serviceStatusDto.isSetup() ? "green" : "red") + ";'>setup</span> ";
                }
                ret = (String)ret + "<span style='color:" + (this.serviceStatusDto.isLogin() ? "green" : "red") + ";'>login</span> ";
                ret = (String)ret + "<span style='color:";
                ret = this.serviceStatusDto.isV12servicesOk() ? (String)ret + "green" : (this.serviceStatusDto.isV12ymlpresent() ? (String)ret + "red" : (String)ret + "orange");
                ret = (String)ret + ";'>services</span> ";
                if (this.serviceStatusDto.isV12servicesOk()) break block12;
                ret = (String)ret + "(";
                for (String service : servicesV12) {
                    boolean installed = false;
                    boolean ok = false;
                    try {
                        installed = (Boolean)this.serviceStatusDto.getServiceInstalled().get(service);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        ok = (Boolean)this.serviceStatusDto.getServiceOk().get(service);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ret = (String)ret + "<span style='color:" + (ok ? "green" : (installed ? "red" : "orange")) + ";'>" + service.trim().toUpperCase().substring(0, 1) + "</span>";
                }
                ret = (String)ret + ")";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ret = (String)ret + " Schulen: ";
        try {
            LettoEnvFile envFile = this.dockerConfiguration.getLettoEnvFile();
            for (SchuleEnv schule : envFile.getSchulen()) {
                ret = (String)ret + "<span style='color:" + ((Boolean)this.serviceStatusDto.getData().get(schule.school) == true ? "green" : "red") + ";'>" + schule.school + "</span> ";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean isUpdateAvailable() {
        if (!this.serviceStatusDto.isV12servicesOk()) {
            return true;
        }
        return this.updateService.isAvailableUpdate();
    }

    public void setAdminPassword(String password) {
        if (this.existsSetupEnv()) {
            SetupEnvFile setupEnv = this.dockerConfiguration.getSetupEnvFile();
            if (setupEnv.getAdminPassword() != null && setupEnv.getAdminPassword().length() > 0) {
                setupEnv.setAdminPassword(password);
            }
            String ape = new BCryptPasswordEncoder().encode((CharSequence)password);
            setupEnv.setAdminPasswordEncrypted(ape);
            if (setupEnv.getAdminPassword() != null && setupEnv.getAdminPassword().length() > 0) {
                this.setupUserDetailsService.setSetupAdminPassword(setupEnv.getAdminPassword());
            }
            this.setupUserDetailsService.setSetupAdminPasswordEncrypted(setupEnv.getAdminPasswordEncrypted());
            setupEnv.writeFile();
        }
    }

    public String createPath() {
        Object ret = "";
        try {
            Vector paths = this.getSetupPaths();
            for (String p : paths) {
                File f;
                if (p == null || (f = new File(p)).isDirectory()) continue;
                if (f.isFile()) {
                    f.delete();
                }
                f.mkdirs();
                if (!f.isDirectory()) {
                    ret = (String)ret + "cannot create " + f.getAbsolutePath() + " ! ";
                }
                if (!this.analyzeService.isLinux()) continue;
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(15000L, new String[]{"chown letto -R " + p, "chmod 755 -R " + p});
                this.cmdService.removeThread(cmdThread);
            }
        }
        catch (Exception ex) {
            ret = (String)ret + "cannot create LeTTo-Docker-directories ! ";
        }
        return ret;
    }

    private String q(String data) {
        return this.databaseService.quoteSql(data);
    }

    public void saveAndReloadConfiguration() {
        this.dockerConfiguration.saveConfiguration();
        this.dockerConfiguration.loadConfiguration();
    }

    public List<ServiceSchuleDto> getSchulen() {
        Vector schulen = this.dockerConfiguration.getLettoEnvFile().getSchulen();
        ArrayList<ServiceSchuleDto> schuleList = new ArrayList<ServiceSchuleDto>();
        for (SchuleEnv s : schulen) {
            schuleList.add(s.toServiceSchuleDto());
        }
        return schuleList;
    }

    public String getSchulenString() {
        Object ret = "";
        Vector schulen = this.dockerConfiguration.getLettoEnvFile().getSchulen();
        for (SchuleEnv s : schulen) {
            if (((String)ret).length() > 0) {
                ret = (String)ret + " ";
            }
            ret = (String)ret + s.school;
        }
        return ret;
    }

    public Vector<SchuleEnv> getSchulenEnv() {
        return this.dockerConfiguration.getLettoEnvFile().getSchulen();
    }

    public SchuleEnv getSchuleEnv(int envID) {
        Vector schulen = this.getSchulenEnv();
        for (SchuleEnv schule : schulen) {
            if (schule.envID != envID) continue;
            return schule;
        }
        return null;
    }

    public SchuleEnv getSchuleEnv(String school) {
        Vector schulen = this.getSchulenEnv();
        for (SchuleEnv schule : schulen) {
            if (!schule.school.equals(school)) continue;
            return schule;
        }
        return null;
    }

    public ServiceSchuleDto getSchule(String school) {
        for (ServiceSchuleDto s : this.getSchulen()) {
            if (!s.getShortname().equals(school)) continue;
            return s;
        }
        return null;
    }

    public boolean isDockerRunning() {
        return this.microServiceConfiguration.isSetupDocker();
    }

    public boolean existsSetupEnv() {
        return this.microServiceConfiguration.getSetupEnvFile().exists();
    }

    public boolean existsLettoEnv() {
        return this.microServiceConfiguration.getLettoEnvFile().exists();
    }

    public boolean existsMysqlEnv() {
        return this.microServiceConfiguration.getMysqlEnvFile().exists();
    }

    public boolean needDockerInit() {
        if (this.existsSetupEnv() && this.existsLettoEnv()) {
            return false;
        }
        if (this.isDockerRunning()) {
            return true;
        }
        return this.setupConfiguration.getConf().getSetupLettoDocker();
    }

    public boolean isHostLinux() {
        if (this.microServiceConfiguration.isSetupDocker()) {
            String bs = this.dockerConfiguration.getSetupEnvFile().getHostBS().toLowerCase().trim();
            return bs.startsWith("linux") || bs.startsWith("ubuntu") || bs.startsWith("deb");
        }
        return this.analyzeService.isLinux();
    }

    public boolean isHostWindows() {
        if (this.microServiceConfiguration.isSetupDocker()) {
            String bs = this.dockerConfiguration.getSetupEnvFile().getHostBS().toLowerCase().trim();
            return bs.startsWith("windows") || bs.startsWith("win");
        }
        return this.analyzeService.isWindows();
    }

    public String getDockerPath() {
        if (this.isDockerRunning()) {
            return "/opt/letto/docker";
        }
        return this.setupConfiguration.getConf().getDockerpath();
    }

    public String getLocalSetupPath() {
        String lettopfad = this.dockerConfiguration.getSetupEnvFile().getLettoPath() + this.dockerConfiguration.getSetupEnvFile().getPathSeperator() + "setup";
        return lettopfad;
    }

    public String getLocalLettoPath() {
        String lettopfad = this.dockerConfiguration.getSetupEnvFile().getLettoPath();
        return lettopfad;
    }

    public String getLocalLettoPathDocker() {
        String lettopfad = this.dockerConfiguration.getSetupEnvFile().getLettoPath().replaceAll("\\\\", "/");
        return lettopfad;
    }

    public boolean existsAllPaths() {
        Vector paths = this.getSetupPaths();
        for (String path : paths) {
            if (path == null || path.length() <= 0 || new File(path).exists()) continue;
            return false;
        }
        return true;
    }

    public boolean createAllPaths() {
        Vector paths = this.getSetupPaths();
        for (String path : paths) {
            File file = new File(path);
            try {
                if (path == null || path.length() <= 0 || file.exists()) continue;
                file.mkdirs();
            }
            catch (Exception ex) {
                System.out.println("Cannot create " + path);
            }
        }
        return true;
    }

    public Vector<String> getSetupPaths() {
        Vector<String> ret = new Vector<String>();
        boolean dr = this.isDockerRunning();
        SetupEnvFile setupEnvFile = this.dockerConfiguration.getSetupEnvFile();
        LettoEnvFile lettoEnvFile = this.dockerConfiguration.getLettoEnvFile();
        ret.add(dr ? "/opt/letto" : setupEnvFile.getLettoPath());
        ret.add(dr ? "/opt/letto/docker" : lettoEnvFile.getDockerBase());
        ret.add((dr ? "/opt/letto/docker" : lettoEnvFile.getDockerBase()) + "/compose");
        ret.add((dr ? "/opt/letto/docker" : lettoEnvFile.getDockerBase()) + "/compose/setup");
        ret.add((dr ? "/opt/letto/docker" : lettoEnvFile.getDockerBase()) + "/compose/letto");
        ret.add((dr ? "/opt/letto/docker" : lettoEnvFile.getDockerBase()) + "/compose/mysql");
        ret.add(dr ? "/opt/letto/docker/proxy" : lettoEnvFile.getProxyPath());
        ret.add(dr ? "/opt/letto/docker/public" : lettoEnvFile.getVolumePublic());
        ret.add((dr ? "/opt/letto/docker" : lettoEnvFile.getDockerBase()) + "/storage");
        ret.add(dr ? "/opt/letto/docker/storage/database" : lettoEnvFile.getVolumeDatabase());
        ret.add((dr ? "/opt/letto/docker" : lettoEnvFile.getDockerBase()) + "/storage/backup");
        ret.add(dr ? "/opt/letto/docker/storage/database-backup" : lettoEnvFile.getMysqlBackupPath());
        ret.add(dr ? "/opt/letto/docker/storage/database-dump" : lettoEnvFile.getMysqlDumpPath());
        ret.add(dr ? "/opt/letto/docker/storage/images" : lettoEnvFile.getVolumeImages());
        ret.add(dr ? "/opt/letto/docker/storage/plugins" : lettoEnvFile.getVolumePlugins());
        ret.add(dr ? "/opt/letto/docker/storage/photos" : lettoEnvFile.getVolumePhotos());
        ret.add(dr ? "/opt/letto/docker/storage/projekte" : lettoEnvFile.getVolumeProjekte());
        ret.add(dr ? "/opt/letto/docker/storage/print" : lettoEnvFile.getVolumePrint());
        ret.add(dr ? "/opt/letto/docker/storage/export" : lettoEnvFile.getVolumeExport());
        ret.add(dr ? "/opt/letto/docker/storage/log" : lettoEnvFile.getVolumeLog());
        ret.add((String)(dr ? "/opt/letto/docker/storage/log/letto" : lettoEnvFile.getVolumeLog() + "/letto"));
        ret.add((String)(dr ? "/opt/letto/docker/storage/log/data" : lettoEnvFile.getVolumeLog() + "/data"));
        for (String schule : lettoEnvFile.getLettoSchulen().split("\\s+")) {
            if (schule.trim().length() <= 0) continue;
            ret.add((dr ? "/opt/letto/docker/storage/photos" : lettoEnvFile.getVolumePhotos()) + "/" + schule);
            ret.add((dr ? "/opt/letto/docker/storage/plugins" : lettoEnvFile.getVolumePlugins()) + "/" + schule);
            ret.add((dr ? "/opt/letto/docker/storage/projekte" : lettoEnvFile.getVolumeProjekte()) + "/" + schule);
            ret.add((dr ? "/opt/letto/docker/storage/log" : lettoEnvFile.getVolumeLog()) + "/letto/" + schule);
            ret.add((dr ? "/opt/letto/docker/storage/log" : lettoEnvFile.getVolumeLog()) + "/data/" + schule);
        }
        return ret;
    }

    public String dockerPathOk() {
        if (this.existsAllPaths()) {
            return "<span style=\"color:green;\">OK</span>";
        }
        return "<span style=\"color:red;\">FAIL</span>";
    }

    public boolean existsSetupYml() {
        return this.microServiceConfiguration.getSetupYmlFile().exists();
    }

    public boolean existsLettoYml() {
        return this.microServiceConfiguration.getLettoYmlFile().exists();
    }

    public boolean existsMysqlYml() {
        return this.microServiceConfiguration.getMysqlYmlFile().exists();
    }

    public File getSetupYmlFile() {
        if (this.isDockerRunning()) {
            return new File("/opt/letto/docker/compose/setup/docker-compose.yml");
        }
        return this.microServiceConfiguration.getSetupYmlFile();
    }

    public File getLettoYmlFile() {
        if (this.isDockerRunning()) {
            return new File("/opt/letto/docker/compose/letto/docker-compose.yml");
        }
        return this.microServiceConfiguration.getLettoYmlFile();
    }

    public File getMysqlYmlFile() {
        if (this.isDockerRunning()) {
            return new File("/opt/letto/docker/compose/mysql/docker-compose.yml");
        }
        return this.microServiceConfiguration.getMysqlYmlFile();
    }

    public void calcAvailableServices() {
        Pattern pattern = Pattern.compile("^docker-service-(.*)\\.yml$");
        ArrayList<String> servicelist = new ArrayList<String>();
        for (String filepath : this.loadYmlFile("yml/services.txt")) {
            Matcher m = pattern.matcher(filepath = filepath.replaceAll("\r", "").replaceAll("\n", "").trim());
            if (m.find()) {
                servicelist.add(m.group(1));
                continue;
            }
            if (filepath.startsWith("#") || filepath == null || filepath.trim().length() <= 0 || this.loadYmlFile("yml/docker-service-" + filepath + ".yml") == null) continue;
            servicelist.add(filepath);
        }
        this.availableServices = servicelist;
    }

    public void calcInstalledServices() {
        ArrayList<String> services = new ArrayList<String>();
        for (String service : this.getAvailableServices()) {
            File file = this.microServiceConfiguration.getServiceYmlFile("docker-service-" + service + ".yml");
            if (!file.exists()) continue;
            services.add(service);
        }
        this.installedServices = services;
        HashMap<String, DockerComposeDto> serviceYmls = new HashMap<String, DockerComposeDto>();
        for (String service : this.installedServices) {
            try {
                DockerComposeDto dockerComposeDto = this.calcDockerComposeDto(this.microServiceConfiguration.getServiceYmlFile("docker-service-" + service + ".yml"), (EnvFile)this.dockerConfiguration.getLettoEnvFile());
                serviceYmls.put(service, dockerComposeDto);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.installedServicesYmls = serviceYmls;
    }

    /*
     * WARNING - void declaration
     */
    private Vector<String> preprocessYml(Vector<String> data) {
        boolean debug = false;
        boolean stable = false;
        Vector<String> result = new Vector<String>();
        boolean mode = false;
        boolean remove = false;
        boolean debugline = false;
        for (String string : data) {
            void var9_9;
            String string2 = string.replaceAll("\\r", "");
            if (remove) {
                remove = false;
                continue;
            }
            if (string2.trim().startsWith("#-Debug")) {
                if (!debug) continue;
                remove = true;
                continue;
            }
            if (string2.trim().startsWith("#+Debug")) {
                debugline = true;
                continue;
            }
            Matcher m = Pattern.compile("^(\\s+image:.*:)daily\\s*$").matcher(string2);
            if (m.find()) {
                if (debug) {
                    String string3 = m.group(1) + "latest";
                } else if (stable) {
                    String string4 = m.group(1) + "stable";
                }
            }
            if (debugline) {
                void var9_14;
                if (var9_14.trim().startsWith("#")) {
                    String string5 = var9_14.replaceFirst("#", "");
                } else {
                    debugline = false;
                }
            }
            if (debugline && !debug) continue;
            result.add((String)var9_9);
        }
        return result;
    }

    public void replaceYmlWithOldTag(Vector<String> data, File file) {
        try {
            Matcher m;
            Vector<String[]> images = new Vector<String[]>();
            Vector olddata = Cmd.readfile((File)file);
            for (String line : olddata) {
                String[] image;
                m = Pattern.compile("^([\\s\\t]*image:[\\s\\t]*)([^\\s]+):([^\\s:]+)[\\s\\t]*$").matcher(line);
                if (m.find()) {
                    image = new String[]{m.group(1), m.group(2), m.group(3)};
                    images.add(image);
                    continue;
                }
                m = Pattern.compile("^([\\s\\t]*image:[\\s\\t]*)([^\\s]+)[\\s\\t]*$").matcher(line);
                if (!m.find()) continue;
                image = new String[]{m.group(1), m.group(2), ""};
                images.add(image);
            }
            int index = 0;
            for (int ln = 0; ln < data.size(); ++ln) {
                boolean update;
                Object line;
                block10: {
                    String tag;
                    String container;
                    String image;
                    block7: {
                        block9: {
                            block8: {
                                line = data.get(ln);
                                update = false;
                                m = Pattern.compile("^([\\s\\t]*image:[\\s\\t]*)([^\\s]+):([^\\s:]+)[\\s\\t]*$").matcher((CharSequence)line);
                                if (!m.find()) break block7;
                                image = m.group(1);
                                container = m.group(2);
                                tag = m.group(3);
                                if (images.size() <= index || !((String[])images.get(index))[1].equals(container)) break block8;
                                tag = ((String[])images.get(index))[2];
                                if (tag.length() <= 0) break block9;
                                update = true;
                                line = image + container + ":" + tag;
                                break block9;
                            }
                            for (int i = 0; i < images.size(); ++i) {
                                if (!((String[])images.get(i))[1].equals(container)) continue;
                                tag = ((String[])images.get(index))[2];
                                if (tag.length() <= 0) break;
                                update = true;
                                line = image + container + ":" + tag;
                                break;
                            }
                        }
                        ++index;
                        break block10;
                    }
                    m = Pattern.compile("^([\\s\\t]*image:[\\s\\t]*)([^\\s]+)[\\s\\t]*$").matcher((CharSequence)line);
                    if (m.find()) {
                        image = m.group(1);
                        container = m.group(2);
                        tag = "";
                        ++index;
                    }
                }
                if (!update) continue;
                data.set(ln, (String)line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector<String> loadYmlFile(String filename) {
        String ymlsource = "";
        if (System.getenv("YML_SOURCE") != null && System.getenv("YML_SOURCE").trim().length() > 0) {
            ymlsource = System.getenv("YML_SOURCE").trim();
            if (ymlsource.toLowerCase().equals("setup")) {
                ymlsource = "local";
            }
            if (ymlsource.toLowerCase().equals("config")) {
                ymlsource = "local";
            }
        }
        switch (ymlsource) {
            case "local": {
                Vector data = this.resourcenService.loadTextFileFromResource(filename);
                if (data == null || data.size() <= 0) break;
                return data;
            }
            case "letto": 
            case "": {
                break;
            }
            default: {
                try {
                    Vector data;
                    Object uri = ymlsource;
                    if (!((String)uri).startsWith("https://") && !((String)uri).startsWith("http://")) {
                        uri = "https://" + (String)uri;
                        uri = ((String)uri).replaceAll("//+", "//");
                    }
                    if (!((String)uri).endsWith("/")) {
                        uri = (String)uri + "/";
                    }
                    if ((data = WebGet.readURL((String)(uri = (String)uri + filename))) != null && data.size() > 0) {
                        return data;
                    }
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            String uri = "https://build.letto.at/download/install/" + filename;
            Vector data = WebGet.readURL((String)uri);
            if (data != null && data.size() > 0) {
                return data;
            }
        }
        catch (Exception uri) {
            // empty catch block
        }
        Vector data = this.resourcenService.loadTextFileFromResource(filename);
        return data;
    }

    public String createAllYml() {
        return this.createAllYml(null);
    }

    public String createAllYml(CmdThread thread) {
        Object msg = "";
        msg = (String)msg + this.createMysqlYml(thread);
        msg = (String)msg + this.createSetupYml(thread);
        msg = (String)msg + this.createLettoYml(thread);
        for (SchuleEnv schule : this.getSchulenEnv()) {
            msg = (String)msg + this.createSchoolYml(thread, schule);
        }
        for (String serviceName : this.getInstalledServices()) {
            UpdateServiceDto service;
            if (thread != null) {
                thread.htmlOut("Service: " + serviceName);
            }
            if ((service = this.updateService.getService(serviceName)) == null) continue;
            msg = (String)msg + this.updateService.updateYml(thread, service);
        }
        if (((String)msg).trim().length() == 0) {
            msg = "OK: all yml-Files updated!";
            if (thread != null) {
                thread.htmlOut("All yml-Files updated!");
            }
        }
        return msg;
    }

    public List<UpdateServiceDto> getUpdateServiceDtoList() {
        ArrayList<UpdateServiceDto> updateServiceDtos = new ArrayList<UpdateServiceDto>();
        for (String serviceName : this.getInstalledServices()) {
            UpdateServiceDto service = this.updateService.getService(serviceName);
            if (service == null) continue;
            updateServiceDtos.add(service);
        }
        return updateServiceDtos;
    }

    public List<String> getServiceYmlFileNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (UpdateServiceDto dto : this.getUpdateServiceDtoList()) {
            list.add(dto.getYmlFilename());
        }
        return list;
    }

    public String createSetupYml() {
        return this.createSetupYml(null);
    }

    public String createSetupYml(CmdThread thread) {
        Object msg = "";
        File file = this.isDockerRunning() ? new File("/opt/letto/docker/compose/setup/docker-compose.yml") : this.microServiceConfiguration.getSetupYmlFile();
        Vector data = this.loadYmlFile("yml/docker-compose-setup.yml");
        if (data != null) {
            data = this.preprocessYml(data);
            this.replaceYmlWithOldTag(data, file);
            Cmd.writelnfile((Vector)data, (File)file);
            msg = "YML-File created: " + file.getAbsolutePath();
            if (thread != null) {
                thread.htmlOut((String)msg);
            }
        } else {
            msg = "cannot load resource file from yml/docker-compose-setup.yml";
            if (thread != null) {
                thread.htmlErr((String)msg);
            }
        }
        return msg;
    }

    public String createMysqlYml() {
        return this.createMysqlYml(null);
    }

    public String createMysqlYml(CmdThread thread) {
        Object msg = "";
        File file = this.isDockerRunning() ? new File("/opt/letto/docker/compose/mysql/docker-compose.yml") : this.microServiceConfiguration.getMysqlYmlFile();
        Vector data = this.loadYmlFile("yml/docker-compose-mysql.yml");
        if (data != null) {
            data = this.preprocessYml(data);
            this.replaceYmlWithOldTag(data, file);
            Cmd.writelnfile((Vector)data, (File)file);
            msg = "YML-File created: " + file.getAbsolutePath();
            if (thread != null) {
                thread.htmlOut((String)msg);
            }
        } else {
            msg = "cannot load resource file from yml/docker-compose-mysql.yml";
            if (thread != null) {
                thread.htmlErr((String)msg);
            }
        }
        return msg;
    }

    public String createLettoYml() {
        return this.createLettoYml(null);
    }

    public String createLettoYml(CmdThread thread) {
        Object msg = "";
        File file = this.isDockerRunning() ? new File("/opt/letto/docker/compose/letto/docker-compose.yml") : this.microServiceConfiguration.getLettoYmlFile();
        Vector data = this.loadYmlFile("yml/docker-compose-letto.yml");
        if (data != null) {
            data = this.preprocessYml(data);
            this.replaceYmlWithOldTag(data, file);
            Cmd.writelnfile((Vector)data, (File)file);
            msg = "YML-File created: " + file.getAbsolutePath();
            if (thread != null) {
                thread.htmlOut((String)msg);
            }
        } else {
            msg = "cannot load resource file from yml/docker-compose-letto.yml";
            if (thread != null) {
                thread.htmlErr((String)msg);
            }
        }
        return msg;
    }

    public String createSchoolYml(SchuleEnv schule) {
        return this.createSchoolYml(null, schule);
    }

    public String createSchoolYml(CmdThread thread, SchuleEnv schule) {
        if (schule == null) {
            return "schuleEnv ist null. Cannot update yml-File!!";
        }
        String school = schule.school;
        Object msg = "";
        File file = this.isDockerRunning() ? new File("/opt/letto/docker/compose/letto/docker-compose-" + school + ".yml") : this.microServiceConfiguration.getSchoolYmlFile(school);
        Vector<Object> data = this.loadYmlFile("yml/docker-compose-school.yml");
        if (data != null) {
            data = this.preprocessYml((Vector)data);
            Vector<Object> newdata = new Vector<Object>();
            int nr = schule.envID;
            for (Object s : data) {
                Matcher m = Pattern.compile("^(\\s*#\\s*School\\s*)1\\s*").matcher((CharSequence)s);
                s = m.find() ? m.group(1) + nr + " - " + schule.school + " : " + schule.schulname : ((m = Pattern.compile("^(\\s*data)1:\\s*").matcher((CharSequence)s)).find() ? m.group(1) + nr + ":" : ((m = Pattern.compile("^(\\s*letto)1:\\s*").matcher((CharSequence)s)).find() ? m.group(1) + nr + ":" : ((String)s).replaceAll("LETTO_1", "LETTO_" + nr).replaceAll("\\:\\-4100\\}:5080", ":-" + (4100 + nr) + "}:5080").replaceAll("\\:\\-4200\\}:5300", ":-" + (4200 + nr) + "}:5300")));
                newdata.add(s);
            }
            data = newdata;
            this.replaceYmlWithOldTag(data, file);
            Cmd.writelnfile(data, (File)file);
            msg = "YML-File created: " + file.getAbsolutePath();
            if (thread != null) {
                thread.htmlOut((String)msg);
            }
        } else {
            msg = "cannot load resource file from yml/docker-compose-school.yml";
            if (thread != null) {
                thread.htmlErr((String)msg);
            }
        }
        return msg;
    }

    public String createYml(String ymlFileName) {
        return this.createYml(null, ymlFileName);
    }

    public String createYml(CmdThread thread, String ymlFileName) {
        Object msg = "";
        File file = this.isDockerRunning() ? new File("/opt/letto/docker/compose/letto/" + ymlFileName) : this.microServiceConfiguration.getServiceYmlFile(ymlFileName);
        Vector data = this.loadYmlFile("yml/" + ymlFileName);
        if (data != null) {
            data = this.preprocessYml(data);
            this.replaceYmlWithOldTag(data, file);
            Cmd.writelnfile((Vector)data, (File)file);
            msg = "YML-File created: " + file.getAbsolutePath();
            if (thread != null) {
                thread.htmlOut((String)msg);
            }
        } else {
            msg = "cannot load resource file from yml/" + ymlFileName;
            if (thread != null) {
                thread.htmlErr((String)msg);
            }
        }
        return msg;
    }

    public void createSchoolProxyFile(SchuleEnv schule) {
        String school = schule.school;
        File file = this.isDockerRunning() ? new File("/opt/letto/docker/proxy/letto" + school + ".conf") : new File(this.getProxyPath() + "/letto" + school + ".conf");
        Vector<Object> data = new Vector<Object>();
        String v = school.replaceAll("-", "_");
        data.add("# Konfiguration einer lokalen Installation von LeTTo welche auf http-Port 8080 des Host unter Linux l\u00e4uft");
        data.add("location /letto" + school + "/ {");
        data.add("        resolver 127.0.0.11;");
        data.add("        set $letto" + v + "path     letto-server-" + school + ".nw-letto:8080;");
        data.add("        proxy_set_header  Host $host;");
        data.add("        proxy_set_header  X-Real-IP $remote_addr;");
        data.add("        proxy_set_header  X-Forwarded-For $proxy_add_x_forwarded_for;");
        data.add("        proxy_set_header  X-Forwarded-Proto $scheme;");
        data.add("        proxy_pass  http://$letto" + v + "path;");
        data.add("        proxy_read_timeout 90;");
        data.add("}");
        Cmd.writelnfile(data, (File)file);
    }

    public void rmFile(String filename) {
        try {
            File f = new File(filename);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String createAllProxyFiles() {
        LettoEnvFile lettoEnvFile = this.dockerConfiguration.getLettoEnvFile();
        Object msg = "";
        String tp = this.isDockerRunning() ? "/opt/letto/docker/proxy" : lettoEnvFile.getProxyPath();
        this.rmFile(tp + "/setup.conf");
        this.rmFile(tp + "/setup-win-mac.conf");
        msg = this.isHostLinux() ? (String)msg + this.resourcenService.copyTextFileFromResource("proxy/setup.conf", tp + "/setup.conf") : (String)msg + this.resourcenService.copyTextFileFromResource("proxy/setup-win-mac.conf", tp + "/setup-win-mac.conf");
        msg = (String)msg + this.resourcenService.copyTextFileFromResource("proxy/config.conf", tp + "/config.conf");
        msg = (String)msg + this.resourcenService.copyTextFileFromResource("proxy/phpmyadmin.conf", tp + "/phpmyadmin.conf");
        msg = (String)msg + this.resourcenService.copyTextFileFromResource("proxy/lti.conf", tp + "/lti.conf");
        msg = (String)msg + this.resourcenService.copyTextFileFromResource("proxy/login.conf", tp + "/login.conf");
        msg = (String)msg + this.resourcenService.copyTextFileFromResource("proxy/edit.conf", tp + "/edit.conf");
        return msg;
    }

    private List<FileInfoDto> calcProxyConfTemplateFiles() {
        Object tp = this.isDockerRunning() ? "/opt/letto/docker/proxy" : this.dockerConfiguration.getLettoEnvFile().getProxyPath();
        tp = (String)tp + "/templates";
        if (!this.proxyTemplateFilesCreated) {
            for (String name : this.resourcenService.getProxyFileResources()) {
                this.resourcenService.copyTextFileFromResource("proxy/" + name, (String)tp + "/" + name);
            }
            this.proxyTemplateFilesCreated = true;
        }
        ArrayList<FileInfoDto> files = new ArrayList<FileInfoDto>();
        File folder = new File((String)tp);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.getName().endsWith(".conf")) continue;
                files.add(new FileInfoDto(file));
            }
        }
        return files;
    }

    public boolean isRestKeyOk() {
        String rk = this.dockerConfiguration.getSetupEnvFile().getLettoRestkey().trim();
        if (rk.length() > 0) {
            return this.dockerConfiguration.getLettoEnvFile().getLettoRestkey().trim().equals(rk);
        }
        return false;
    }

    public boolean isRestKeyInkonsistent() {
        String rkl;
        String rks = this.dockerConfiguration.getSetupEnvFile().getLettoRestkey().trim();
        return !rks.equals(rkl = this.dockerConfiguration.getLettoEnvFile().getLettoRestkey().trim());
    }

    public String setRestkeyKonsistent() {
        String rks = this.dockerConfiguration.getSetupEnvFile().getLettoRestkey().trim();
        String rkl = this.dockerConfiguration.getLettoEnvFile().getLettoRestkey().trim();
        String rk = rks;
        if (rks.length() == 0 && rkl.length() > 0) {
            rk = rkl;
        }
        this.setRestKey(rk);
        return "setted restkey consistent";
    }

    public String getRestKey() {
        return this.dockerConfiguration.getSetupEnvFile().getLettoRestkey().trim();
    }

    public boolean getAdminLogfileWithDocker() {
        return this.dockerConfiguration.getSetupEnvFile().getAdminLogfileWithDocker();
    }

    public String setRestKey(String restkey) {
        restkey = restkey.trim();
        this.dockerConfiguration.getSetupEnvFile().setLettoRestkey(restkey);
        this.dockerConfiguration.getLettoEnvFile().setLettoRestkey(restkey);
        this.dockerConfiguration.saveConfiguration();
        this.microServiceConfiguration.setRestkey(restkey);
        return restkey;
    }

    public String getDatabaseDumpFilePath(int id) {
        try {
            String school = this.getSchuleEnv((int)id).school;
            if (this.isDockerRunning()) {
                if (new File("/opt/letto/docker/storage/database-dump/letto_" + school + ".sql").exists()) {
                    return "/opt/letto/docker/storage/database-dump/letto_" + school + ".sql";
                }
                if (new File("/opt/letto/docker/storage/database-dump/letto_" + school + ".sql.gz").exists()) {
                    return "/opt/letto/docker/storage/database-dump/letto_" + school + ".sql.gz";
                }
            } else {
                if (new File(this.microServiceConfiguration.getLettoSetupHostDocker() + "/storage/database-dump/letto_" + school + ".sql").exists()) {
                    return this.microServiceConfiguration.getLettoSetupHostDocker() + "/storage/database-dump/letto_" + school + ".sql";
                }
                if (new File(this.microServiceConfiguration.getLettoSetupHostDocker() + "/storage/database-dump/letto_" + school + ".sql.gz").exists()) {
                    return this.microServiceConfiguration.getLettoSetupHostDocker() + "/storage/database-dump/letto_" + school + ".sql.gz";
                }
                if (id == 1 && new File("/sicherung/letto.sql").exists()) {
                    return "/sicherung/letto.sql";
                }
                if (id == 1 && new File("/sicherung/letto.sql.gz").exists()) {
                    return "/sicherung/letto.sql.gz";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getDatabaseDumpDirectoryPath() {
        if (this.isDockerRunning()) {
            return "/opt/letto/docker/storage/database-dump";
        }
        return this.microServiceConfiguration.getLettoSetupHostDocker() + "/storage/database-dump";
    }

    public String getBackupDirectoryPath() {
        if (this.isDockerRunning()) {
            return "/opt/letto/docker/storage/backup";
        }
        return this.microServiceConfiguration.getLettoSetupHostDocker() + "/storage/backup";
    }

    public String getImagesDirectoryPath() {
        if (this.isDockerRunning()) {
            return "/opt/letto/docker/storage/images";
        }
        return this.microServiceConfiguration.getLettoSetupHostDocker() + "/storage/images";
    }

    public String getLogDirectoryPath() {
        if (this.isDockerRunning()) {
            return "/opt/letto/docker/storage/log";
        }
        return this.microServiceConfiguration.getLettoSetupHostDocker() + "/storage/log";
    }

    public String getPhotosDirectoryPath() {
        if (this.isDockerRunning()) {
            return "/opt/letto/docker/storage/photos";
        }
        return this.microServiceConfiguration.getLettoSetupHostDocker() + "/storage/photos";
    }

    public String getProjekteDirectoryPath() {
        if (this.isDockerRunning()) {
            return "/opt/letto/docker/storage/projekte";
        }
        return this.microServiceConfiguration.getLettoSetupHostDocker() + "/storage/projekte";
    }

    public boolean isDatabaseDumpPresent(int id) {
        return this.getDatabaseDumpFilePath(id).length() > 0;
    }

    public boolean isDumpRunning() {
        return this.databaseService.isDumpRunning();
    }

    public int schoolIsRunning(String school) {
        try {
            int ret = 0;
            for (DockerContainerDto containerDto : this.dockerStatus.getContainers()) {
                if (containerDto.getName().equals("letto-data-" + school) && containerDto.running()) {
                    ++ret;
                }
                if (!containerDto.getName().equals("letto-server-" + school) || !containerDto.running()) continue;
                ++ret;
            }
            return ret;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void calcDockerPS() {
        CmdThread t;
        if (this.dockerStatus.getContainers() == null) {
            this.dockerStatus.setContainers(new ArrayList());
        }
        if ((t = this.cmdService.cmdScriptForeground(5000L, false, new String[]{"docker ps --no-trunc --all"})).getOut().size() < 3) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            t = this.cmdService.cmdScriptForeground(5000L, false, new String[]{"docker ps --no-trunc --all"});
        }
        Vector<String> cnames = new Vector<String>();
        if (t != null && t.getOut().size() > 0 && ((Vector)t.getOut().get(0)).size() > 0) {
            String head = (String)((Vector)t.getOut().get(0)).get(0);
            int[] pos = new int[7];
            pos[1] = head.indexOf("IMAGE");
            pos[2] = head.indexOf("COMMAND");
            pos[3] = head.indexOf("CREATED");
            pos[4] = head.indexOf("STATUS");
            pos[5] = head.indexOf("PORTS");
            pos[6] = head.indexOf("NAMES");
            for (int i = 1; i < ((Vector)t.getOut().get(0)).size(); ++i) {
                String line = (String)((Vector)t.getOut().get(0)).get(i);
                String[] cols = new String[]{line.substring(pos[0], pos[1]).trim(), line.substring(pos[1], pos[2]).trim(), line.substring(pos[2], pos[3]).trim(), line.substring(pos[3], pos[4]).trim(), line.substring(pos[4], pos[5]).trim(), line.substring(pos[5], pos[6]).trim(), line.substring(pos[6]).trim()};
                ArrayList<DockerPortDto> ports = new ArrayList<DockerPortDto>();
                for (String port : cols[5].split(",\\s*")) {
                    try {
                        Pattern p = Pattern.compile("^(.+):(\\d+)\\-\\>(\\d+)\\/(.+)$");
                        DockerPortDto portDto = null;
                        Matcher m = p.matcher(port);
                        if (m.find()) {
                            portDto = new DockerPortDto(m.group(1), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), m.group(4));
                        } else {
                            p = Pattern.compile("^(\\d+)\\/(.+)$");
                            m = p.matcher(port);
                            if (m.find()) {
                                portDto = new DockerPortDto("", 0, Integer.parseInt(m.group(1)), m.group(2));
                            }
                        }
                        if (portDto == null) continue;
                        boolean found = false;
                        for (DockerPortDto dp : ports) {
                            if (dp.getHostport() != portDto.getHostport() || dp.getContainerport() != portDto.getContainerport()) continue;
                            found = true;
                            dp.setIp(dp.getIp() + (dp.getIp().length() > 0 ? "," : "") + portDto.getIp());
                        }
                        if (found) continue;
                        ports.add(portDto);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                DockerContainerDto containerDto = new DockerContainerDto(cols[0], cols[1], cols[2], cols[3], cols[4], ports, cols[6]);
                boolean found = false;
                cnames.add(containerDto.getName());
                for (int ci = 0; ci < this.dockerStatus.getContainers().size(); ++ci) {
                    DockerContainerDto c = (DockerContainerDto)this.dockerStatus.getContainers().get(ci);
                    if (!c.getName().equals(containerDto.getName())) continue;
                    c.setId(containerDto.getId());
                    c.setImage(containerDto.getImage());
                    c.setCommand(containerDto.getCommand());
                    c.setCreated(containerDto.getCreated());
                    c.setStatus(containerDto.getStatus());
                    c.setPorts(containerDto.getPorts());
                    found = true;
                }
                if (found) continue;
                this.dockerStatus.getContainers().add(containerDto);
            }
        }
        for (int ci = 0; ci < this.dockerStatus.getContainers().size(); ++ci) {
            boolean found = false;
            for (String name : cnames) {
                if (!((DockerContainerDto)this.dockerStatus.getContainers().get(ci)).getName().equals(name)) continue;
                found = true;
            }
            if (found) continue;
            this.dockerStatus.getContainers().remove(ci);
            --ci;
        }
    }

    public void calcDockerStatistics() {
        if (this.dockerStatisticsRunning) {
            return;
        }
        try {
            this.dockerStatisticsRunning = true;
            if (this.dockerStatus == null) {
                this.dockerStatus = new DockerStatusDto();
            }
            this.calcDockerPS();
            for (DockerStatsDto dockerStatsDto : this.dockerStatsService.getContainers()) {
                for (DockerContainerDto containerDto : this.dockerStatus.getContainers()) {
                    if (!containerDto.getName().equals(dockerStatsDto.getName())) continue;
                    containerDto.setStats(dockerStatsDto);
                }
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        this.dockerStatisticsRunning = false;
    }

    public void calcContainerRevisions() {
        if (this.calcContainerRevisionsRunning) {
            return;
        }
        this.calcContainerRevisionsRunning = true;
        try {
            for (int i = 0; i < this.dockerStatus.getContainers().size(); ++i) {
                DockerContainerDto containerDto = (DockerContainerDto)this.dockerStatus.getContainers().get(i);
                String version = null;
                if (!containerDto.running()) continue;
                String uri = "http://" + containerDto.getName() + ".nw-letto";
                Object port = "";
                for (DockerPortDto p : containerDto.getPorts()) {
                    if (!("" + p.getContainerport()).startsWith("8")) continue;
                    port = "" + p.getContainerport();
                }
                if (((String)port).length() > 0) {
                    uri = uri + ":" + (String)port;
                }
                if (this.isDockerRunning()) {
                    try {
                        BaseRestClient baseRestClient = new BaseRestClient(uri);
                        version = baseRestClient.version().trim();
                    }
                    catch (Exception baseRestClient) {}
                } else {
                    RestSetupService setup = this.lettoService.getSetupService();
                    if (setup != null) {
                        version = setup.getContainerVersion(uri);
                    }
                }
                if (version != null && version.length() > 0) {
                    containerDto.setRevision(version);
                    continue;
                }
                String c = containerDto.getName();
                String cmd = "docker exec -i " + containerDto.getName() + " cat /revision.txt";
                try {
                    String head;
                    CmdThread t = this.cmdService.cmdScriptForeground(5000L, false, new String[]{cmd});
                    if (t == null || t.getOut().size() <= 0 || ((Vector)t.getOut().get(0)).size() <= 0 || (head = ((String)((Vector)t.getOut().get(0)).get(0)).trim()).startsWith("cat:") || head.toLowerCase().startsWith("error")) continue;
                    containerDto.setRevision(head);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error er) {
            er.printStackTrace();
        }
        this.calcContainerRevisionsRunning = false;
    }

    public DockerStatusDto calcDockerStatus() {
        try {
            String[] cols;
            String line;
            int i;
            int[] pos;
            String head;
            if (this.dockerStatus == null) {
                this.dockerStatus = new DockerStatusDto();
            }
            this.calcDockerStatistics();
            ArrayList<DockerNetworkDto> networks = new ArrayList<DockerNetworkDto>();
            ArrayList<DockerVolumeDto> volumes = new ArrayList<DockerVolumeDto>();
            CmdThread t = this.cmdService.cmdScriptForeground(5000L, false, new String[]{"docker network list"});
            if (t != null && t.getOut().size() > 0 && ((Vector)t.getOut().get(0)).size() > 0) {
                head = (String)((Vector)t.getOut().get(0)).get(0);
                pos = new int[4];
                pos[1] = head.indexOf("NAME");
                pos[2] = head.indexOf("DRIVER");
                pos[3] = head.indexOf("SCOPE");
                for (i = 1; i < ((Vector)t.getOut().get(0)).size(); ++i) {
                    line = (String)((Vector)t.getOut().get(0)).get(i);
                    cols = new String[]{line.substring(pos[0], pos[1]).trim(), line.substring(pos[1], pos[2]).trim(), line.substring(pos[2], pos[3]).trim(), line.substring(pos[3]).trim()};
                    DockerNetworkDto networkDto = new DockerNetworkDto(cols[0], cols[1], cols[2], cols[3]);
                    networks.add(networkDto);
                }
            }
            networks.sort((Comparator<DockerNetworkDto>)new /* Unavailable Anonymous Inner Class!! */);
            this.dockerStatus.setNetworks(networks);
            t = this.cmdService.cmdScriptForeground(5000L, false, new String[]{"docker volume list"});
            if (t != null && t.getOut().size() > 0 && ((Vector)t.getOut().get(0)).size() > 0) {
                head = (String)((Vector)t.getOut().get(0)).get(0);
                pos = new int[2];
                pos[1] = head.indexOf("VOLUME");
                for (i = 1; i < ((Vector)t.getOut().get(0)).size(); ++i) {
                    line = (String)((Vector)t.getOut().get(0)).get(i);
                    cols = new String[]{line.substring(pos[0], pos[1]).trim(), line.substring(pos[1]).trim()};
                    DockerVolumeDto volumeDto = new DockerVolumeDto(cols[0], cols[1]);
                    volumes.add(volumeDto);
                }
            }
            volumes.sort((Comparator<DockerVolumeDto>)new /* Unavailable Anonymous Inner Class!! */);
            this.dockerStatus.setVolumes(volumes);
            return this.dockerStatus;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return this.dockerStatus;
        }
    }

    public Vector<String> getSetupContainers() {
        Vector<String> containers = new Vector<String>();
        DockerComposeDto dto = this.getSetupYml();
        for (DockerComposeServiceDto service : dto.getServices()) {
            if (service.getContainername().length() <= 0) continue;
            containers.add(service.getContainername());
        }
        return containers;
    }

    public Vector<String> getLettoContainers() {
        Vector<String> containers = new Vector<String>();
        DockerComposeDto dto = this.getLettoYml();
        for (DockerComposeServiceDto service : dto.getServices()) {
            if (service.getContainername().length() <= 0) continue;
            containers.add(service.getContainername());
        }
        return containers;
    }

    private String replaceEnv(String s, EnvFile env) {
        Matcher m;
        Pattern p = Pattern.compile("^(?<pre>.*)\\$(\\{(?<v1>[^\\{\\}]+)\\}|(?<v2>[a-zA-Z0-9_]+))(?<suf>.*)$");
        Object ret = s;
        while ((m = p.matcher((CharSequence)ret)).find()) {
            String pre = m.group("pre");
            String suf = m.group("suf");
            Object var = m.group("v1") != null && m.group("v1").length() > 0 ? m.group("v1") : m.group("v2");
            m = Pattern.compile("^(.*)\\:\\-(.*)").matcher((CharSequence)var);
            if (m.find()) {
                varname = m.group(1);
                String string = envvar = env != null ? env.getVar(varname) : null;
                var = envvar == null || envvar.length() == 0 ? m.group(2) : envvar;
            } else {
                m = Pattern.compile("^(.*)\\-(.*)").matcher((CharSequence)var);
                if (m.find()) {
                    varname = m.group(1);
                    String string = envvar = env != null ? env.getVar(varname) : null;
                    var = env == null || !env.containsKey(varname) ? m.group(2) : envvar;
                } else {
                    m = Pattern.compile("^(.*)\\:\\?(.*)").matcher((CharSequence)var);
                    if (m.find()) {
                        varname = m.group(1);
                        String string = envvar = env != null ? env.getVar(varname) : null;
                        var = envvar == null || envvar.length() == 0 ? "{ERROR:" + m.group(2) + "}" : envvar;
                    } else {
                        m = Pattern.compile("^(.*)\\?(.*)").matcher((CharSequence)var);
                        if (m.find()) {
                            varname = m.group(1);
                            String string = envvar = env != null ? env.getVar(varname) : null;
                            var = env == null || !env.containsKey(varname) ? "{ERROR:" + m.group(2) + "}" : envvar;
                        } else {
                            var = env == null ? "" : (env.containsKey((String)var) ? env.getVar((String)var) : "");
                        }
                    }
                }
            }
            ret = pre + (String)var + suf;
        }
        return ret;
    }

    private String StringFromMapWithEnv(Map<String, Object> map, String key, EnvFile env) {
        String ret = "";
        try {
            if (map.containsKey(key)) {
                if (map.get(key) instanceof String) {
                    ret = (String)map.get(key);
                }
                ret = map.get(key) instanceof Boolean ? ((Boolean)map.get(key)).toString() : (String)((ArrayList)map.get(key)).get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ret = this.replaceEnv(ret, env);
        return ret;
    }

    private List<String> ArrayFromMapWithEnv(Map<String, Object> map, String key, EnvFile env) {
        ArrayList ret = new ArrayList();
        try {
            if (map.containsKey(key)) {
                if (map.get(key) instanceof String) {
                    ret.add((String)map.get(key));
                } else {
                    ret = (ArrayList)map.get(key);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, this.replaceEnv((String)ret.get(i), env));
        }
        return ret;
    }

    private DockerComposeDto calcDockerComposeDto(File ymlFile, EnvFile env) {
        YamlMapFactoryBean yml = new YamlMapFactoryBean();
        yml.setResources(new org.springframework.core.io.Resource[]{new FileSystemResource(ymlFile)});
        DockerComposeDto dto = new DockerComposeDto();
        try {
            Map data = yml.getObject();
            if (data.containsKey("version") && data.get("version") instanceof String) {
                dto.setVersion(this.replaceEnv((String)data.get("version"), env));
            }
            if (data.containsKey("services")) {
                for (String key : ((Map)data.get("services")).keySet()) {
                    try {
                        Map service = (Map)((Map)data.get("services")).get(key);
                        String containername = this.StringFromMapWithEnv(service, "container_name", env);
                        dto.getServices().add(new DockerComposeServiceDto(key, this.StringFromMapWithEnv(service, "hostname", env), containername, this.StringFromMapWithEnv(service, "image", env), this.StringFromMapWithEnv(service, "restart", env), this.ArrayFromMapWithEnv(service, "networks", env), this.ArrayFromMapWithEnv(service, "ports", env), this.ArrayFromMapWithEnv(service, "environment", env), this.ArrayFromMapWithEnv(service, "volumes", env), this.ArrayFromMapWithEnv(service, "depends_on", env), this.ArrayFromMapWithEnv(service, "security_opt", env), this.isDockerContainerRunning(containername), this.isDockerContainerRunningHealthy(containername)));
                    }
                    catch (Exception service) {}
                }
            }
            if (data.containsKey("networks")) {
                for (String key : ((Map)data.get("networks")).keySet()) {
                    try {
                        Map network = (Map)((Map)data.get("networks")).get(key);
                        boolean external = false;
                        String ext = this.StringFromMapWithEnv(network, "external", env);
                        if (ext.equalsIgnoreCase("true")) {
                            external = true;
                        }
                        dto.getNetworks().add(new DockerComposeNetworkDto(key, external));
                    }
                    catch (Exception network) {}
                }
            }
            if (data.containsKey("volumes")) {
                for (String key : ((Map)data.get("volumes")).keySet()) {
                    try {
                        Map volume = (Map)((Map)data.get("volumes")).get(key);
                        String volumename = this.StringFromMapWithEnv(volume, "name", env);
                        dto.getVolumes().add(new DockerComposeVolumeDto(key, volumename));
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dto;
    }

    public boolean isDockerContainerRunningHealthyLive(String containername) {
        try {
            boolean running = false;
            boolean healthy = false;
            for (DockerContainerDto container : this.dockerStatus.getContainers()) {
                if (!container.getName().equals(containername)) continue;
                running = container.running();
                healthy = container.healthy();
            }
            return running && healthy;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDockerContainerRunningHealthy(String containername) {
        try {
            boolean running = false;
            boolean healthy = false;
            for (DockerContainerDto container : this.dockerStatus.getContainers()) {
                if (!container.getName().equals(containername)) continue;
                running = container.running();
                healthy = container.healthy();
            }
            return running && healthy;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDockerContainerRunning(String containername) {
        try {
            boolean running = false;
            for (DockerContainerDto container : this.dockerStatus.getContainers()) {
                if (!container.getName().equals(containername)) continue;
                running = true;
            }
            return running;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isSetupDockerRunning() {
        List services = this.getSetupYml().getServices();
        for (DockerComposeServiceDto service : services) {
            if (service.isHealthy()) continue;
            return false;
        }
        return services.size() != 0;
    }

    public boolean isLettoDockerRunning() {
        for (DockerComposeServiceDto service : this.getLettoYml().getServices()) {
            if (!service.isHealthy()) continue;
            return true;
        }
        return false;
    }

    public boolean isLettoDockerRunningComplete() {
        for (DockerComposeServiceDto service : this.getLettoYml().getServices()) {
            if (service.isHealthy()) continue;
            return false;
        }
        return true;
    }

    public boolean isServiceDockerRunning(String serviceName) {
        try {
            for (DockerComposeServiceDto service : ((DockerComposeDto)this.installedServicesYmls.get(serviceName)).getServices()) {
                if (!service.isHealthy()) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isLettoMysqlDockerRunning() {
        return this.isDockerContainerRunningHealthy("letto-mysql");
    }

    public boolean lettoNetworkOk() {
        for (DockerComposeNetworkDto nw : this.lettoYml.getNetworks()) {
            if (!nw.isExternal() || this.existsNetwork(nw.getName())) continue;
            return false;
        }
        return true;
    }

    public void createNetworks() {
        for (DockerComposeNetworkDto nw : this.lettoYml.getNetworks()) {
            if (!nw.isExternal() || this.existsNetwork(nw.getName())) continue;
            CmdThread cmdThread = this.cmdService.cmdScriptForeground(20000L, new String[]{"docker network create " + nw.getName()});
        }
    }

    public boolean lettoVolumesOk() {
        for (DockerComposeVolumeDto vol : this.lettoYml.getVolumes()) {
            if (this.existsVolume(vol.getName())) continue;
            return false;
        }
        return true;
    }

    public void createVolumes() {
        for (DockerComposeVolumeDto vol : this.lettoYml.getVolumes()) {
            if (this.existsVolume(vol.getName())) continue;
            CmdThread cmdThread = this.cmdService.cmdScriptForeground(20000L, new String[]{"docker volume create " + vol.getName()});
        }
    }

    public boolean existsNetwork(String networkName) {
        for (DockerNetworkDto networkDto : this.getDockerStatus().getNetworks()) {
            if (!networkDto.getName().equals(networkName)) continue;
            return true;
        }
        return false;
    }

    public boolean existsVolume(String volumeName) {
        for (DockerVolumeDto volumeDto : this.getDockerStatus().getVolumes()) {
            if (!volumeDto.getName().equals(volumeName)) continue;
            return true;
        }
        return false;
    }

    public String setupDockerStatus() {
        if (!this.existsSetupYml()) {
            return "<span style=\"color:red;\">YAML missing</span>";
        }
        int runningHealthy = 0;
        int runningNotHealthy = 0;
        int notRunning = 0;
        for (DockerComposeServiceDto service : this.getSetupYml().getServices()) {
            if (service.isHealthy()) {
                ++runningHealthy;
                continue;
            }
            if (service.isRunning()) {
                ++runningNotHealthy;
                continue;
            }
            ++notRunning;
        }
        if (notRunning == 0 && runningNotHealthy == 0) {
            if (runningHealthy > 0) {
                return "<span style=\"color:green;\">OK(" + runningHealthy + ")</span>";
            }
            return "<span style=\"color:orange;\">OFF(0)</span>";
        }
        if (runningHealthy == 0) {
            return "<span style=\"color:red;\">FAIL(" + runningNotHealthy + "/" + notRunning + ")</span>";
        }
        return "<span style=\"color:orange;\">PROBLEMS</span>(<span style=\"color:green;\">" + runningHealthy + "</span>/<span style=\"color:orange;\">" + runningNotHealthy + "</span>/<span style=\"color:red;\">" + notRunning + "</span>)";
    }

    public String mysqlDockerStatus() {
        if (this.isDockerContainerRunningHealthy("letto-mysql") && this.isDockerContainerRunningHealthy("phpmyadmin")) {
            return "<span style=\"color:green;\">OK</span>";
        }
        return "<span style=\"color:red;\">FAIL</span>";
    }

    public String serviceStatus(String serviceName) {
        int ok = 0;
        int fail = 0;
        for (DockerComposeServiceDto service : ((DockerComposeDto)this.installedServicesYmls.get(serviceName)).getServices()) {
            if (service.isHealthy()) {
                ++ok;
                continue;
            }
            ++fail;
        }
        if (fail == 0 && ok > 0) {
            return "<span style=\"color:green;\">OK</span>";
        }
        if (ok == 0) {
            return "<span style=\"color:red;\">FAIL</span>";
        }
        return "<span style=\"color:green;\">" + ok + "</span>/<span style=\"color:red;\">" + fail + "</span>";
    }

    public String lettoDockerStatus() {
        if (!this.existsLettoYml()) {
            return "<span style=\"color:red;\">YAML missing</span>";
        }
        int runningHealthy = 0;
        int runningNotHealthy = 0;
        int notRunning = 0;
        for (DockerComposeServiceDto service : this.getLettoYml().getServices()) {
            if (service.isHealthy()) {
                ++runningHealthy;
                continue;
            }
            if (service.isRunning()) {
                ++runningNotHealthy;
                continue;
            }
            ++notRunning;
        }
        int running = runningHealthy + runningNotHealthy;
        if (running == 0) {
            return "<span style=\"color:red;\">OFF(" + notRunning + ")</span>";
        }
        if (notRunning == 0 && runningNotHealthy == 0) {
            return "<span style=\"color:green;\">OK(" + runningHealthy + ")</span>";
        }
        Object ret = "";
        ret = runningHealthy == 0 ? "<span style=\"color:red;\">FAIL</span>" : "<span style=\"color:orange;\">PROBLEMS</span>";
        ret = (String)ret + "(<span style=\"color:green;\">" + runningHealthy + "</span>/<span style=\"color:orange;\">" + runningNotHealthy + "</span>/<span style=\"color:red;\">" + notRunning + "</span>)";
        return ret;
    }

    public String dockerProxyOk() {
        DockerStatusDto status = this.getDockerStatus();
        List files = this.getProxyConfFiles();
        if (files == null) {
            return "";
        }
        int fileAnz = files.size();
        for (DockerContainerDto container : status.getContainers()) {
            if (!container.getName().equalsIgnoreCase("letto-proxy")) continue;
            if (container.running() && container.healthy()) {
                return "<span style=\"color:green;\">OK(" + fileAnz + ")</span>";
            }
            if (container.running()) {
                return "<span style=\"color:orange;\">FAIL(" + fileAnz + ")</span>";
            }
            return "<span style=\"color:red;\">STOP(" + fileAnz + ")</span>";
        }
        return "<span style=\"color:red;\">MISSING(" + fileAnz + ")</span>";
    }

    public String getProxyPath() {
        return this.getDockerPath() + "/proxy";
    }

    private List<FileInfoDto> calcProxyConfFiles() {
        ArrayList<FileInfoDto> files = new ArrayList<FileInfoDto>();
        File folder = new File(this.getProxyPath());
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.getName().endsWith(".conf")) continue;
                files.add(new FileInfoDto(file));
            }
        }
        return files;
    }

    private List<FileInfoDto> calcProxyServerFiles() {
        ArrayList<FileInfoDto> files = new ArrayList<FileInfoDto>();
        File folder = new File(this.getProxyPath() + "/servers");
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.getName().endsWith(".conf")) continue;
                files.add(new FileInfoDto(file));
            }
        }
        return files;
    }

    public List<FileInfoDto> calcDatabaseDumpFiles() {
        ArrayList<FileInfoDto> files = new ArrayList<FileInfoDto>();
        File folder = new File(this.getDatabaseDumpDirectoryPath());
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.getName().endsWith(".sql") && !file.getName().endsWith(".sql.gz")) continue;
                files.add(new FileInfoDto(file));
            }
        }
        return files;
    }

    public boolean isSchoolRestkeyFromDb(String school) {
        if (this.dockerConfiguration.getLettoEnvFile().getSchule((String)school).licenceNoUpdate) {
            return false;
        }
        try {
            String schoolRestkey = ((String)this.dockerStatus.getDatabaseSchoolRestKey().get(school)).trim();
            if (schoolRestkey == null || schoolRestkey.length() == 0) {
                return false;
            }
            if (!schoolRestkey.equals(this.getRestKey())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isSchoolRestkeyInDb(String school) {
        if (this.dockerConfiguration.getLettoEnvFile().getSchule((String)school).licenceNoUpdate) {
            return false;
        }
        try {
            String restkey = this.getRestKey();
            String schoolRestkey = ((String)this.dockerStatus.getDatabaseSchoolRestKey().get(school)).trim();
            if (restkey != null && restkey.length() > 0 && !restkey.equals(schoolRestkey)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isSchoolLicenseFromDb(String school) {
        if (this.dockerConfiguration.getLettoEnvFile().getSchule((String)school).licenceNoUpdate) {
            return false;
        }
        try {
            String license = this.dockerConfiguration.getLettoEnvFile().getSchule((String)school).licence;
            String schoolLicense = ((String)this.dockerStatus.getDatabaseSchoolLicense().get(school)).trim();
            if (schoolLicense == null || schoolLicense.length() == 0) {
                return false;
            }
            if (!schoolLicense.equals(license)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isSchoolLicenseInDb(String school) {
        if (this.dockerConfiguration.getLettoEnvFile().getSchule((String)school).licenceNoUpdate) {
            return false;
        }
        try {
            String license = this.dockerConfiguration.getLettoEnvFile().getSchule((String)school).licence;
            String schoolLicense = ((String)this.dockerStatus.getDatabaseSchoolLicense().get(school)).trim();
            if (license != null && license.length() > 0 && !license.equals(license)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public File dockerLogsFile(String containername) {
        String logdir = this.getLogDirectoryPath();
        String logfile = logdir + "/" + containername + ".log";
        File f = new File(logfile);
        CmdThread t = null;
        t = !this.isDockerRunning() && this.analyzeService.isWindows() ? this.cmdService.cmdScriptForeground(20000L, new String[]{"docker logs " + containername + " >" + logfile.replaceAll("/", "\\\\") + " 2>&1"}) : this.cmdService.cmdScriptForeground(20000L, new String[]{"docker logs " + containername + " &>" + logfile});
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public File dockerComposeLogsFile(String ymlFile) {
        String logdir = this.getLogDirectoryPath();
        Object logfile = logdir + "/" + ((String)ymlFile).replaceAll(".yml", ".log");
        File f = new File((String)logfile);
        ymlFile = this.microServiceConfiguration.getComposeDirName() + "/letto/" + (String)ymlFile;
        if (this.analyzeService.isWindows()) {
            logfile = ((String)logfile).replaceAll("/", "\\\\");
            ymlFile = ((String)ymlFile).replaceAll("/", "\\\\");
        }
        CmdThread t = null;
        t = !this.isDockerRunning() && this.analyzeService.isWindows() ? this.cmdService.cmdScriptForeground(20000L, new String[]{"docker compose -f " + (String)ymlFile + " logs >" + (String)logfile + " 2>&1"}) : this.cmdService.cmdScriptForeground(20000L, new String[]{"docker compose -f " + (String)ymlFile + " logs &>" + (String)logfile});
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public String dockerLogs(String containername) {
        return this.dockerLogs(containername, 10000);
    }

    public String dockerLogs(String containername, int tail) {
        CmdThread t = tail > 0 ? this.cmdService.cmdScriptForeground(20000L, new String[]{"docker logs " + containername + " --tail " + tail}) : this.cmdService.cmdScriptForeground(20000L, new String[]{"docker logs " + containername});
        String log = "";
        Vector lines = (Vector)t.getOut().get(0);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line + "\n");
        }
        log = sb.toString();
        return log;
    }

    public String dockerLogsMysql() {
        return this.dockerLogs("letto-mysql");
    }

    public String dockerLogsSetup() {
        return this.dockerLogs("letto-setup");
    }

    public String dockerLogsLogin() {
        return this.dockerLogs("letto-login");
    }

    public String dockerLogsLTI() {
        return this.dockerLogs("letto-lti");
    }

    public String dockerLogsSchool(String school) {
        return this.dockerLogs("letto-server-" + school);
    }

    public String dockerLogsService(String servicename) {
        return this.dockerLogs("letto-" + servicename);
    }

    public String dockerLogsSchoolData(String school) {
        return this.dockerLogs("letto-data-" + school);
    }

    public File dockerLogOutSchoolFile(String school) {
        File logFile = new File(this.microServiceConfiguration.getLogDir().getAbsolutePath() + "/letto/" + school + "/tomee_out.log");
        return logFile;
    }

    public String dockerLogOutSchool(String school) {
        File logFile = this.dockerLogOutSchoolFile(school);
        StringBuilder sb = new StringBuilder();
        try {
            for (String s : Files.readAllLines(logFile.toPath())) {
                sb.append(s + "\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            return "cannot read logfile tomee_out.log";
        }
    }

    public File dockerLogErrSchoolFile(String school) {
        File logFile = new File(this.microServiceConfiguration.getLogDir().getAbsolutePath() + "/letto/" + school + "/tomee_err.log");
        return logFile;
    }

    public String dockerLogErrSchool(String school) {
        File logFile = this.dockerLogErrSchoolFile(school);
        StringBuilder sb = new StringBuilder();
        try {
            for (String s : Files.readAllLines(logFile.toPath())) {
                sb.append(s + "\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            return "cannot read logfile tomee_err.log";
        }
    }

    public void archieveLogfile(String containername, String containerID, long minsize) {
        File logdirFile = new File(this.microServiceConfiguration.getLogDir().getAbsolutePath() + "/" + containername);
        if (!logdirFile.exists()) {
            logdirFile.mkdirs();
        }
        File logFile = new File(logdirFile.getAbsolutePath() + "/" + containername + ".log");
        String logdir = logdirFile.getAbsolutePath();
        logdir = logdir.replaceAll("\\/+", "/");
        if (this.analyzeService.isWindows()) {
            logdir = logdir.replaceAll("\\/", "\\\\");
        }
        CmdThread t = this.cmdService.cmdScriptForeground(20000L, new String[]{"cd " + logdir, "docker logs " + containername + " >" + containername + ".log"});
    }

    public void archieveLogfilePerContainerName(String containername, long minsize) {
        try {
            for (DockerContainerDto containerDto : this.dockerStatus.getContainers()) {
                if (!containerDto.getName().trim().equals(containername.trim())) continue;
                this.archieveLogfile(containername.trim(), containerDto.getId(), minsize);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void archieveLogfilePerSchule(SchuleEnv schule, long minsize) {
        try {
            for (DockerContainerDto containerDto : this.dockerStatus.getContainers()) {
                if (containerDto.getName().trim().equals("letto-data-" + schule.school)) {
                    this.archieveLogfile(containerDto.getName().trim(), containerDto.getId(), minsize);
                }
                if (!containerDto.getName().trim().equals("letto-server-" + schule.school)) continue;
                this.archieveLogfile(containerDto.getName().trim(), containerDto.getId(), minsize);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void archieveAllLogFiles(long minsize) {
        try {
            for (DockerContainerDto containerDto : this.dockerStatus.getContainers()) {
                this.archieveLogfile(containerDto.getName().trim(), containerDto.getId(), minsize);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String checkDockerDatabase() {
        if (!this.isLettoMysqlDockerRunning()) {
            return "<span style=\"color:red;\">NOT RUNNING</span>";
        }
        if (this.dockerStatus.isDatabaseRootLoginOk()) {
            return "<span style=\"color:green;\">OK</span>";
        }
        return "<span style=\"color:red;\">RUNNING not Accessible</span>";
    }

    public String checkDockerLTI() {
        Object msg = "--";
        try {
            if (this.dockerStatus.isDatabaseLTILoginOk()) {
                return "<span style=\"color:green;\">OK</span>";
            }
            msg = this.dockerStatus.isDatabaseLTILoginPasswordOk() ? "USER ok, " : (!this.dockerStatus.isDatabaseLTILoginExists() ? "USER not exist, " : "USER not Accessible, ");
            msg = this.dockerStatus.isDatabaseLTIExists() ? (String)msg + "DATABASE ok" : (String)msg + "DATABASE missing";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "<span style=\"color:red;\">" + (String)msg + "</span>";
    }

    public String checkDockerLetto() {
        if (this.dockerStatus.isDatabaseLettoLoginOk()) {
            return "<span style=\"color:green;\">OK</span>";
        }
        if (!this.dockerStatus.isDatabaseLettoLoginExists()) {
            return "<span style=\"color:red;\">USER not exist</span>";
        }
        return "<span style=\"color:red;\">USER not Accessible</span>";
    }

    public String licenseInfo(SchuleEnv schule) {
        if (schule == null) {
            return "<span style=\"color:red;\">NO LICENSE</span>";
        }
        if (schule.licence == null || schule.licence.length() == 0) {
            return "<span style=\"color:red;\">NO LICENSE</span>";
        }
        LicenseKey licenseKey = this.lizenzService.toLicenseKey(schule.licence);
        Object ret = "";
        Date licenseDate = licenseKey.getLicenceEnd();
        if (licenseDate == null) {
            ret = (String)ret + " <span style='color:red;'>unknown</span>";
        } else {
            long lDays = (long)((double)licenseDate.getTime() / 1000.0 / 3600.0 / 24.0);
            long aDays = (long)((double)new Date().getTime() / 1000.0 / 3600.0 / 24.0);
            String d = Datum.formatSimple((Date)licenseKey.getLicenceEnd());
            ret = aDays >= lDays ? (String)ret + " <span style='color:red;'>" + d + "</span>" : (aDays >= lDays - 20L ? (String)ret + " <span style='color:orange;'>" + d + "</span>" : (String)ret + " <span style='color:green;'>" + d + "</span>");
        }
        ret = (String)ret + "(";
        Integer sl = this.databaseService.getSchuelerLizenzen(schule);
        if (sl != null) {
            ret = (String)ret + sl + "/";
        }
        ret = (String)ret + licenseKey.getSchuelerAnz() + ") ";
        return ret;
    }

    public DockerContainerDto getSchoolContainerLetto(String school) {
        try {
            for (DockerContainerDto c : this.dockerStatus.getContainers()) {
                if (!c.getName().equals("letto-server-" + school)) continue;
                return c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public DockerContainerDto getSchoolContainerData(String school) {
        try {
            for (DockerContainerDto c : this.dockerStatus.getContainers()) {
                if (!c.getName().equals("letto-data-" + school)) continue;
                return c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getHTMLschoolCpuLetto(String school) {
        try {
            DockerContainerDto c = this.getSchoolContainerLetto(school);
            if (c != null) {
                int x = c.getCpuProzent();
                return x > 90 ? "<span style=\"color:red;\">" + x + "%</span>" : x + "%";
            }
            return "<span style=\"color:red;\">?</span>";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "<span style=\"color:red;\">err</span>";
        }
    }

    public String getHTMLschoolMemLetto(String school) {
        try {
            DockerContainerDto c = this.getSchoolContainerLetto(school);
            if (c != null) {
                int x = c.getMemProzent();
                return x > 90 ? "<span style=\"color:red;\">" + x + "%</span>" : x + "%";
            }
            return "<span style=\"color:red;\">?</span>";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "<span style=\"color:red;\">err</span>";
        }
    }

    public String getHTMLschoolCpuData(String school) {
        try {
            DockerContainerDto c = this.getSchoolContainerData(school);
            if (c != null) {
                int x = c.getCpuProzent();
                return x > 90 ? "<span style=\"color:red;\">" + x + "%</span>" : x + "%";
            }
            return "<span style=\"color:red;\">?</span>";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "<span style=\"color:red;\">err</span>";
        }
    }

    public String getHTMLschoolMemData(String school) {
        try {
            DockerContainerDto c = this.getSchoolContainerData(school);
            if (c != null) {
                int x = c.getMemProzent();
                return x > 90 ? "<span style=\"color:red;\">" + x + "%</span>" : x + "%";
            }
            return "<span style=\"color:red;\">?</span>";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "<span style=\"color:red;\">err</span>";
        }
    }

    public boolean isSchoolRunning(String school) {
        try {
            boolean dataHealthy = false;
            boolean serverHealthy = false;
            for (DockerContainerDto c : this.dockerStatus.getContainers()) {
                if (c.getName().equals("letto-data-" + school) && c.healthy() && c.running()) {
                    dataHealthy = true;
                }
                if (!c.getName().equals("letto-server-" + school) || !c.healthy() || !c.running()) continue;
                serverHealthy = true;
            }
            return dataHealthy && serverHealthy;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String checkDockerSchool(String school) {
        try {
            boolean dataHealthy = false;
            boolean serverHealthy = false;
            for (DockerContainerDto c : this.dockerStatus.getContainers()) {
                if (c.getName().equals("letto-data-" + school) && c.healthy() && c.running()) {
                    dataHealthy = true;
                }
                if (!c.getName().equals("letto-server-" + school) || !c.healthy() || !c.running()) continue;
                serverHealthy = true;
            }
            Object ret = "";
            if (dataHealthy && !serverHealthy) {
                ret = (String)ret + " <span style=\"color:red;\">S</span><span style=\"color:green;\">D</span>";
            }
            if (!dataHealthy && serverHealthy) {
                ret = (String)ret + " <span style=\"color:green;\">S</span><span style=\"color:red;\">D</span>";
            }
            if (!dataHealthy && !serverHealthy) {
                ret = (String)ret + " <span style=\"color:red;\">STOP</span>";
            }
            Object msg = "";
            try {
                if (((Boolean)this.dockerStatus.getDatabaseSchoolLettoLoginOk().get(school)).booleanValue() && !this.dockerConfiguration.getLettoEnvFile().getSchule((String)school).licenceNoUpdate) {
                    String restkey = this.dockerConfiguration.getLettoEnvFile().getLettoRestkey().trim();
                    String schoolRestkey = ((String)this.dockerStatus.getDatabaseSchoolRestKey().get(school)).trim();
                    String license = this.dockerConfiguration.getLettoEnvFile().getSchule((String)school).licence;
                    String schoolLicense = ((String)this.dockerStatus.getDatabaseSchoolLicense().get(school)).trim();
                    LicenseKey licenseKey = this.lizenzService.toLicenseKey(license);
                    if (!licenseKey.getRestkey().equals(ENCRYPT.dec((String)restkey, (String)"enfldsgbnlsngdlksdsgm"))) {
                        ret = (String)ret + " <span style=\"color:red;\">LICrestkey</span>";
                    }
                    if (license.length() == 0 && schoolLicense.length() == 0) {
                        ret = (String)ret + " <span style=\"color:red;\">noLIC</span>";
                    } else if (!license.equals(schoolLicense)) {
                        ret = (String)ret + " <span style=\"color:orange;\">LIC</span>";
                    }
                    if (!restkey.equals(schoolRestkey)) {
                        ret = (String)ret + " <span style=\"color:orange;\">RESTKEY</span>";
                    }
                }
                if (!((Boolean)this.dockerStatus.getDatabaseSchoolLettoLoginPasswordOk().get(school)).booleanValue()) {
                    msg = (Boolean)this.dockerStatus.getDatabaseSchoolLettoLoginExists().get(school) == false ? " USER not exist, " : " USER not Accessible ";
                }
                if (!((Boolean)this.dockerStatus.getDatabaseSchoolLettoExists().get(school)).booleanValue()) {
                    msg = (String)msg + " DATABASE missing";
                }
            }
            catch (Exception ex) {
                msg = (String)msg + " DATABASE not accessible";
            }
            if (((String)msg).length() > 0) {
                ret = (String)ret + " <span style=\"color:red;\">" + (String)msg + "</span>";
            }
            if (((String)ret).length() == 0) {
                ret = (String)ret + "<span style=\"color:green;\">OK</span>";
            }
            return ret;
        }
        catch (Exception ex) {
            return "<span style=\"color:red;\">error</span>";
        }
    }

    public List<String> getDumpFiles() {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (FileInfoDto f : this.getDatabaseDumpFiles()) {
                String name = f.getFilename();
                if (name.equals("initdb.sql") || name.startsWith("change") || name.equals("utf8.sql")) continue;
                ret.add(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean isDatabaseLettoLoginAdd(String school) {
        return this.dockerStatus != null && this.dockerStatus.getDatabaseSchoolLettoLoginAdd().containsKey(school) && (Boolean)this.dockerStatus.getDatabaseSchoolLettoLoginAdd().get(school) == true;
    }

    public boolean isDatabaseLettoLoginDatabaseAdd(String school) {
        return this.dockerStatus != null && this.dockerStatus.getDatabaseSchoolLettoLoginDatabaseAdd().containsKey(school) && (Boolean)this.dockerStatus.getDatabaseSchoolLettoLoginDatabaseAdd().get(school) == true;
    }

    public boolean isDatabaseLettoDatabaseAdd(String school) {
        return this.dockerStatus != null && this.dockerStatus.getDatabaseSchoolLettoDatabaseAdd().containsKey(school) && (Boolean)this.dockerStatus.getDatabaseSchoolLettoDatabaseAdd().get(school) == true;
    }

    public boolean isDatabaseLettoLoginExists(String school) {
        return this.dockerStatus != null && this.dockerStatus.getDatabaseSchoolLettoLoginExists().containsKey(school) && (Boolean)this.dockerStatus.getDatabaseSchoolLettoLoginExists().get(school) == true;
    }

    public boolean isDatabaseLettoExists(String school) {
        return this.dockerStatus != null && this.dockerStatus.getDatabaseSchoolLettoExists().containsKey(school) && (Boolean)this.dockerStatus.getDatabaseSchoolLettoExists().get(school) == true;
    }

    public boolean isDatabaseLettoLoginPasswordOk(String school) {
        return this.dockerStatus != null && this.dockerStatus.getDatabaseSchoolLettoLoginPasswordOk().containsKey(school) && (Boolean)this.dockerStatus.getDatabaseSchoolLettoLoginPasswordOk().get(school) == true;
    }

    public boolean isLicensServerAvailable() {
        if (this.isDockerRunning()) {
            return this.serviceStatusDto.isLettoLicense();
        }
        return this.serviceStatusDto.isLettoLicenseHost();
    }

    public String setSchoolLicense(SchoolLicenseDto dto) {
        Object result = "";
        if (this.isDockerRunning()) {
            boolean ok = false;
            this.dockerConfiguration.loadConfiguration();
            Vector schulen = this.dockerConfiguration.getLettoEnvFile().getSchulen();
            for (SchuleEnv schule : schulen) {
                if (!schule.school.trim().equals(dto.getSchool().trim())) continue;
                ok = true;
                schule.licence = dto.getLicense();
            }
            if (ok) {
                this.dockerConfiguration.getLettoEnvFile().setSchulen(schulen);
            } else {
                result = "Schule " + dto.getSchool() + " kann nicht gefunden werden!";
            }
        } else {
            result = "Lizenz kann nur gesetzt werden wenn das Setup-Service als Docker-Container l\u00e4uft!";
        }
        return result;
    }

    public String restkeyFromDatabase(int envId) {
        try {
            SchuleEnv schule = this.dockerConfiguration.getLettoEnvFile().getSchule(envId);
            String school = schule.school;
            String restkey = (String)this.dockerStatus.getDatabaseSchoolRestKey().get(school);
            if (restkey != null && restkey.length() > 0) {
                this.setRestKey(restkey);
                return "Restkey is set to " + restkey;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "cannot set restkey!";
    }

    public String licenseFromDatabase(int envId) {
        try {
            Vector schulen = this.dockerConfiguration.getLettoEnvFile().getSchulen();
            SchuleEnv schule = null;
            for (SchuleEnv s : schulen) {
                if (s.envID != envId) continue;
                schule = s;
            }
            String school = schule.school;
            String license = (String)this.dockerStatus.getDatabaseSchoolLicense().get(school);
            if (license != null && license.length() > 0) {
                schule.licence = license;
                this.dockerConfiguration.getLettoEnvFile().setSchulen(schulen);
                this.dockerConfiguration.getLettoEnvFile().writeFile();
                return "License is set for school " + school;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "cannot set license!";
    }

    public String baseRedirection() {
        String r = this.dockerConfiguration.getLettoEnvFile().getRedirect();
        if (r == null || r.length() == 0) {
            return "<span style='color:red;'>REDIRECT fails</span>";
        }
        if (r.equals("public")) {
            return "<span style='color:orange;'>" + r + "</span>";
        }
        return "<span style='color:green;'>" + r + "</span>";
    }

    public String setBaseRedirection(String uri) {
        LettoEnvFile envFile = this.dockerConfiguration.getLettoEnvFile();
        envFile.setRedirect(uri);
        envFile.writeFile();
        return "base redirection changed in letto/.env - you must restart letto-Docker to take effekt";
    }

    public String getServerName() {
        LettoEnvFile lettoEnvFile = this.dockerConfiguration.getLettoEnvFile();
        if (lettoEnvFile == null) {
            return "";
        }
        String name = lettoEnvFile.getServerName();
        if (name == null) {
            return "";
        }
        return name;
    }

    public String getServerInfo() {
        LettoEnvFile lettoEnvFile = this.dockerConfiguration.getLettoEnvFile();
        if (lettoEnvFile == null) {
            return "";
        }
        String name = lettoEnvFile.getServerInfo();
        if (name == null) {
            return "";
        }
        return name;
    }

    public String certInfo() {
        LettoEnvFile lettoEnvFile = this.dockerConfiguration.getLettoEnvFile();
        if (this.getServerName().equals("localhost")) {
            return "<span style='color:orange;'>selfsigned</span>";
        }
        if (lettoEnvFile.isCertCreated()) {
            return "<span style='color:green;'>OK</span>";
        }
        return "<span style='color:red;'>NOT SET</span>";
    }

    public boolean isAbleToCreateNewCert() {
        if (this.getServerName().equals("localhost")) {
            return false;
        }
        return this.isDockerContainerRunning("letto-proxy");
    }

    public boolean isAbleToRenewCert() {
        LettoEnvFile lettoEnvFile = this.dockerConfiguration.getLettoEnvFile();
        if (this.getServerName().equals("localhost")) {
            return false;
        }
        if (!lettoEnvFile.isCertCreated()) {
            return false;
        }
        return this.isDockerContainerRunning("letto-proxy");
    }

    public String getAdminEmail() {
        LettoEnvFile lettoEnvFile = this.dockerConfiguration.getLettoEnvFile();
        String email = lettoEnvFile.getEmail();
        return email != null ? email : "";
    }

    public boolean checkDatabaseSchool6500(int id) {
        return this.databaseService.checkDatabaseSchool6500(id);
    }

    public String pingSelfUri() {
        String baseuri = "https://" + this.dockerConfiguration.getLettoEnvFile().getServerName() + "/";
        baseuri = this.isDockerRunning() ? baseuri + "config" : baseuri + "setup";
        return baseuri;
    }

    public boolean pingSelf() {
        String baseuri = this.pingSelfUri();
        String pong = "";
        try {
            BaseRestClient baseRestClient = new BaseRestClient(baseuri);
            pong = (String)baseRestClient.get("/ping", String.class);
            return pong.equals("pong");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void calcCpuUsage() {
        double cpuLoad = this.dockerStatsService.cpuUsagePercent() / 100.0;
        double cpuLoadDocker = this.dockerStatsService.cpuDockerUsagePercent() / 100.0;
        this.cpuTrendDto.addCPUload(cpuLoad);
        this.cpuTrendDtoDocker.addCPUload(cpuLoadDocker);
    }

    public String htmlRevision() {
        UpdateDto updateDto = this.updateService.getUpdateDto();
        if (updateDto != null) {
            int actualRev = 0;
            int dailyRev = 0;
            int stableRev = 0;
            try {
                actualRev = Integer.parseInt(this.analyzeService.getRevision());
                dailyRev = Integer.parseInt(updateDto.getSetupRevDaily());
                stableRev = Integer.parseInt(updateDto.getSetupRevStable());
                if (actualRev != stableRev || actualRev != dailyRev) {
                    String ret = "<span style='color:red;'>" + this.analyzeService.getRevision() + "</span>(";
                    if (dailyRev == stableRev) {
                        ret = ret + "<span style='color:lightgray;'>" + stableRev + "</span>)";
                    } else {
                        if (actualRev != dailyRev) {
                            ret = ret + "<span style='color:lightgray;'>daily-" + dailyRev + "</span>";
                            if (actualRev != stableRev) {
                                ret = ret + ",";
                            }
                        }
                        if (actualRev != stableRev) {
                            ret = ret + "<span style='color:lightgray;'>stable-" + stableRev + "</span>";
                        }
                        ret = ret + ")";
                    }
                    return ret;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.analyzeService.getRevision();
    }

    public String htmlDiskUsage() {
        int use = this.systemStatusDto.getUseableDiskSpaceMB();
        int total = this.systemStatusDto.getTotalDiskSpaceMB();
        if (use == 0 && total == 0) {
            return "";
        }
        return use + "MB / " + total + "MB";
    }

    public String htmlJavaMemoryUsage() {
        int use = this.systemStatusDto.getMemoryJavaUsedMB();
        int max = this.systemStatusDto.getMemoryJavaMaxMB();
        if (use == 0 && max == 0) {
            return "";
        }
        return use + "MB / " + max + "MB";
    }

    public String htmlMemoryUsage() {
        int free = this.systemStatusDto.getMemoryFreeMB();
        int total = this.systemStatusDto.getMemoryTotalMB();
        int used = this.systemStatusDto.getMemoryUsedMB();
        int av = this.systemStatusDto.getMemoryAvailableMB();
        if (free == 0 && total == 0 && used == 0 && av == 0) {
            return "";
        }
        return free + "MB / " + total + "MB / " + used + "MB | " + av + "MB";
    }

    public String htmlSwapMemoryUsage() {
        int free = this.systemStatusDto.getMemorySwapFreeMB();
        int total = this.systemStatusDto.getMemorySwapTotalMB();
        int use = this.systemStatusDto.getMemorySwapUsedMB();
        if (free == 0 && total == 0 && use == 0) {
            return "";
        }
        return free + "MB / " + total + "MB / " + use + "MB";
    }

    private String proz(double d) {
        if (d < 0.0) {
            return "0";
        }
        int i = (int)(d * 1000.0 + 0.01);
        if (i > 99) {
            return "" + (i + 5) / 10;
        }
        return i / 10 + "." + i % 10;
    }

    public String htmlCpuUsage() {
        double ud = 0.0;
        double u = 0.0;
        double um = 0.0;
        try {
            ud = this.cpuTrendDtoDocker.getLastCpuLoad();
            u = this.cpuTrendDto.getLastCpuLoad();
            um = this.cpuTrendDto.getAvCpuLoadLastMinute();
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        return this.proz(ud) + "% " + this.proz(u) + "% " + this.proz(um) + "% " + this.analyzeService.getCPUanzahl() + "CPUs";
    }

    public String rev(String containername) {
        String r = "";
        try {
            for (DockerContainerDto c : this.dockerStatus.getContainers()) {
                if (!c.getName().equals(containername)) continue;
                r = c.getRevision();
            }
            if (this.updateService.availableUpdate(containername)) {
                String ru = this.updateService.availableUpdateRevision(containername);
                String ret = "<span style='color:red;'>" + r + "</span>";
                if (ru.length() > 0) {
                    ret = ret + "(" + ru + ")";
                }
                return ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    public String reloadEditCaches() {
        Object msg = "";
        try {
            RestEditLehrerKlasse relk = this.lettoService.getRestEditLehrerKlasse();
            if (relk == null) {
                return "Edit-Service not running, cannot reload caches!";
            }
            String schulen = this.getSchulenString();
            if (schulen == null || schulen.trim().length() == 0) {
                return "No schools defined, cannot reload caches!";
            }
            DtoAndMsg result = relk.reloadCaches(schulen);
            msg = result.getMsg().getMeldung();
            if (msg == null || ((String)msg).trim().length() == 0) {
                msg = "All caches reloaded successfully!";
            }
        }
        catch (Exception ex) {
            msg = (String)msg + "Exception during reload of edit-service caches\n";
        }
        return msg;
    }

    @Generated
    public ServiceStatusDto getServiceStatusDto() {
        return this.serviceStatusDto;
    }

    @Generated
    public CpuTrendDto getCpuTrendDto() {
        return this.cpuTrendDto;
    }

    @Generated
    public CpuTrendDto getCpuTrendDtoDocker() {
        return this.cpuTrendDtoDocker;
    }

    @Generated
    public SystemStatusDto getSystemStatusDto() {
        return this.systemStatusDto;
    }

    @Generated
    public void setSystemStatusDto(SystemStatusDto systemStatusDto) {
        this.systemStatusDto = systemStatusDto;
    }

    @Generated
    public AjaxWelcomeInfo getWelcomeInfo() {
        return this.welcomeInfo;
    }

    @Generated
    public List<String> getAvailableServices() {
        return this.availableServices;
    }

    @Generated
    public List<String> getInstalledServices() {
        return this.installedServices;
    }

    @Generated
    public HashMap<String, DockerComposeDto> getInstalledServicesYmls() {
        return this.installedServicesYmls;
    }

    @Generated
    public boolean isMainSetupService() {
        return this.mainSetupService;
    }

    @Generated
    public boolean isPingself() {
        return this.pingself;
    }

    @Generated
    public boolean isAnalyzeRunning() {
        return this.analyzeRunning;
    }
}

