/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.basespringboot.cmd.CmdDto;
import at.letto.basespringboot.cmd.CmdThread;
import at.letto.basespringboot.service.BaseSystemInfoService;
import at.letto.databaseclient.modelMongo.login.LeTToUser;
import at.letto.databaseclient.service.LettoUserLoginService;
import at.letto.login.restclient.RestLoginService;
import at.letto.security.LettoToken;
import at.letto.setupservice.beans.SessionBean;
import at.letto.setupservice.config.LoggingConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.controller.CommandController;
import at.letto.setupservice.model.LoginModel;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LettoService;
import at.letto.setupservice.service.LoginService;
import at.letto.setupservice.service.SetupMongoDbService;
import at.letto.setupservice.service.SetupUpdateService;
import at.letto.setupservice.service.SetupUserDetailsService;
import at.letto.tools.Datum;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class LoginController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private SetupUserDetailsService setupUserDetailsService;
    @Autowired
    private LettoService lettoService;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private DockerService dockerService;
    @Autowired
    private LoggingConfiguration loggingConfiguration;
    @Autowired
    private LoginService loginService;
    @Autowired
    private LettoUserLoginService lettoUserLoginService;
    @Autowired
    private SetupMongoDbService setupMongoDbService;
    @Autowired
    private SetupUpdateService setupUpdateService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private CommandController commandController;
    @Resource(name="sessionBean")
    SessionBean sessionBean;

    @GetMapping(value={"/setup/open/tokenlogin"})
    public String tokenLoginLocal(@RequestParam(name="token", required=true) String token, HttpServletRequest request) {
        return this.tokenLogin(token, request);
    }

    @GetMapping(value={"/config/open/tokenlogin"})
    public String tokenLoginDocker(@RequestParam(name="token", required=true) String token, HttpServletRequest request) {
        return this.tokenLogin(token, request);
    }

    public String tokenLogin(String token, HttpServletRequest request) {
        try {
            String jwts = this.lettoService.getLoginService().jwtTokenFromTempToken(token, this.microServiceConfiguration.getServerSecret());
            LettoToken lettoToken = new LettoToken(jwts, this.microServiceConfiguration.getJwtSecret());
            HttpSession session = this.loginService.createSession(request, lettoToken);
            String username = lettoToken.getUsername();
            if (session == null) {
                this.loggingConfiguration.getLoginLogger().logMessage("LOGIN FAIL - cannot create session - user: " + username);
                return "redirect:" + this.dockerService.loginEP();
            }
            this.loggingConfiguration.getLoginLogger().logMessage("LOGIN OK user: " + username);
            this.dockerService.analyzeBackground(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "redirect:" + this.dockerService.welcomeEP();
    }

    @RequestMapping(value={"/config/login"})
    public String loginBase(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request) {
        this.analyzeService.analyzeRequestUrl(request);
        return "redirect:/config/open/loginletto";
    }

    @RequestMapping(value={"/setup/login"})
    public String loginLocalBase(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request) {
        this.analyzeService.analyzeRequestUrl(request);
        return "redirect:/setup/open/loginletto";
    }

    @RequestMapping(value={"/config/open/login"})
    public String login(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request) {
        this.analyzeService.analyzeRequestUrl(request);
        return "redirect:/config/open/loginletto";
    }

    @RequestMapping(value={"/setup/open/login"})
    public String loginLocal(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request) {
        this.analyzeService.analyzeRequestUrl(request);
        return "redirect:/setup/open/loginletto";
    }

    @RequestMapping(value={"/config/open/loginletto"})
    public String loginForm(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request, HttpServletResponse response) {
        return this.loginForm(loginModel, model, request, true);
    }

    @RequestMapping(value={"/setup/open/loginletto"})
    public String loginFormLocal(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request, HttpServletResponse response) {
        return this.loginForm(loginModel, model, request, false);
    }

    private String loginForm(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request, boolean docker) {
        this.analyzeService.analyzeRequestUrl(request);
        Object msg = "";
        if (loginModel != null && loginModel.getName().length() > 0 && loginModel.getPasswort().length() > 0) {
            try {
                String redirection;
                String username = loginModel.getName();
                String password = loginModel.getPasswort();
                Integer idSchule = loginModel.getIdSchule();
                String schule = loginModel.getSchule();
                String fingerprint = loginModel.getFingerprint() == null ? "setupfingerprintempty" : loginModel.getFingerprint();
                String ipaddress = BaseSystemInfoService.getIPaddress((HttpServletRequest)request);
                String service = this.dockerService.isDockerRunning() ? "config" : "setup";
                String infos = "";
                String userAgent = request.getHeader("User-Agent");
                RestLoginService restLoginService = this.lettoService.getLoginService();
                LettoToken lettoToken = null;
                String school = this.microServiceConfiguration.isSetupDocker() ? "config" : "setup";
                int idschool = this.microServiceConfiguration.isSetupDocker() ? -1 : -2;
                LeTToUser leTToUser = null;
                if (username.equals("admin")) {
                    leTToUser = this.lettoUserLoginService.getUser(school, username);
                    lettoToken = this.setupUserDetailsService.checkSetupUsernamePassword(username, password, fingerprint, ipaddress, service, infos, userAgent);
                }
                if (lettoToken == null && restLoginService != null) {
                    lettoToken = restLoginService.jwtLettoLogin(username, password, "", fingerprint, ipaddress, service, infos, userAgent).getLettoToken();
                }
                String string = redirection = docker ? "/config/session/welcome" : "/setup/session/welcome";
                if (lettoToken != null) {
                    if (lettoToken.isGlobal()) {
                        HttpSession session = this.loginService.createSession(request, lettoToken);
                        if (session != null) {
                            this.setupMongoDbService.saveTest(school, Datum.formatDateTime((Date)new Date()), lettoToken.getUsername());
                            this.dockerService.analyzeBackground(true);
                            if (this.dockerService.isDockerRunning() && this.setupUpdateService.taskAfterRestartRunning) {
                                if (this.cmdService.getThreads() != null) {
                                    for (CmdThread cmdThread : this.cmdService.getThreads()) {
                                        if (!cmdThread.getCommand().startsWith("Update all")) continue;
                                        CmdDto cmdDto = new CmdDto();
                                        cmdDto.setCmd("");
                                        cmdDto.setHomedir(this.analyzeService.getUserDir());
                                        model.addAttribute("cmdDto", (Object)cmdDto);
                                        model.addAttribute("dockerService", (Object)this.dockerService);
                                        model.addAttribute("cmdThread", (Object)cmdThread);
                                        model.addAttribute("threads", (Object)this.cmdService.getThreads());
                                        model.addAttribute("action", (Object)this.dockerService.cmdOutputEP());
                                        model.addAttribute("cmdControl", (Object)this.commandController);
                                        return "cmdoutput";
                                    }
                                }
                                return "redirect:" + this.dockerService.welcomeEP();
                            }
                            return "redirect:" + redirection;
                        }
                        this.loggingConfiguration.getLoginLogger().logMessage("LOGIN FAIL - cannot create session - user: " + username);
                        msg = "cannot create session for user " + username;
                    } else {
                        String uri = this.lettoService.getLoginService().jwtGetTempTokenUri(lettoToken.getToken(), fingerprint);
                        this.loggingConfiguration.getLoginLogger().logMessage("LOGIN FAIL - not GLOBAL - user: " + username);
                        if (uri != null && uri.length() > 0) {
                            return "redirect:" + uri;
                        }
                        msg = "Login fehlerhaft!";
                    }
                } else if (username.trim().length() > 0) {
                    this.loggingConfiguration.getLoginLogger().logMessage("LOGIN FAIL - user: " + username);
                }
                this.sessionBean.deactivate();
                loginModel.setPasswort("");
            }
            catch (Exception ex) {
                msg = ex.getMessage();
                model.addAttribute("paramerror", (Object)true);
            }
        }
        model.addAttribute("loginModel", (Object)loginModel);
        model.addAttribute("test", (Object)"ABC");
        model.addAttribute("msg", msg);
        model.addAttribute("action", (Object)(docker ? "/config/open/loginletto" : "/setup/open/loginletto"));
        model.addAttribute("dockerService", (Object)this.dockerService);
        return "loginletto";
    }

    @GetMapping(value={"/config/open/logout"})
    public String logoutPageDocker(HttpServletRequest request, HttpServletResponse response) {
        return this.logoutPage(request, response);
    }

    @GetMapping(value={"/setup/open/logout"})
    public String logoutPageLocal(HttpServletRequest request, HttpServletResponse response) {
        return this.logoutPage(request, response);
    }

    public String logoutPage(HttpServletRequest request, HttpServletResponse response) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        this.loginService.destroySession();
        if (auth != null) {
            new SecurityContextLogoutHandler().logout(request, response, auth);
        }
        return "redirect:" + this.dockerService.loginEP();
    }
}

