/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.SetupserviceApplication;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.controller.CommandController;
import at.letto.setupservice.controller.ExplorerController;
import at.letto.setupservice.controller.FileEditController;
import at.letto.setupservice.model.UpdateModel;
import at.letto.setupservice.model.UpdateServiceDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.SetupUpdateService;
import at.letto.setupservice.service.UpdateService;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class UpdateController {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private SetupUpdateService setupUpdateService;
    @Autowired
    private UpdateService updateService;
    @Autowired
    private ExplorerController explorerController;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private FileEditController fileEditController;
    @Autowired
    private CommandController commandController;
    @Autowired
    private AnalyzeService analyzeService;

    @RequestMapping(value={"/config/session/admin/update"})
    public String updateDocker(@ModelAttribute UpdateModel updateModel, @RequestParam Map<String, String> params, Model model) {
        return this.update(updateModel, params, model);
    }

    @RequestMapping(value={"/setup/session/admin/update"})
    public String update(@ModelAttribute UpdateModel updateModel, @RequestParam Map<String, String> params, Model model) {
        Object msg = "";
        model.addAttribute("dockerService", (Object)this.dockerService);
        model.addAttribute("updateService", (Object)this.updateService);
        String button = updateModel.getUserAction();
        String newplan = updateModel.getNewplan() != null ? updateModel.getNewplan() : "";
        CmdThread cmdThread = null;
        if (button != null) {
            switch (button) {
                case "refresh": {
                    this.updateService.loadUpdateDto();
                    break;
                }
                case "back": {
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "docker_update_all": {
                    cmdThread = this.setupUpdateService.dockerUpdateAll(this.dockerService.updateEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "cannot update all docker containers!";
                    break;
                }
                case "docker_restart_all": {
                    cmdThread = this.setupUpdateService.dockerRestartAll(this.dockerService.updateEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "cannot restart all docker containers!";
                    break;
                }
                case "restart_setup": {
                    SetupserviceApplication.restart();
                    msg = "restarting - please wait and reload!";
                    break;
                }
                case "UPDATE_BETA": {
                    msg = this.updateService.updateSetup("beta");
                    break;
                }
                case "UPDATE_DAILY": {
                    msg = this.updateService.updateSetup("daily");
                    break;
                }
                case "UPDATE_STABLE": {
                    msg = this.updateService.updateSetup("stable");
                    break;
                }
                case "UPDATE_REV": {
                    msg = this.updateService.updateSetup(updateModel.getNewsetuprev());
                    break;
                }
                case "create_startscripts": {
                    msg = this.updateService.createStartScripts();
                    break;
                }
                case "explore_startscripts": {
                    String filename = this.dockerService.getDockerPath() + "/scripts/" + (this.dockerService.isHostWindows() ? "windows" : "linux");
                    String template = this.explorerController.redirectExplorer(filename, model);
                    if (template == null || template.length() == 0) {
                        msg = "Cannot open directory " + filename;
                        break;
                    }
                    return template;
                }
                case "docker_update_restart_all": 
                case "docker_update_all_yaml": 
                case "update_stable_alltag": 
                case "update_stable_alltagupdate": 
                case "update_stable_alltagyml": 
                case "update_stable_alltagymlupdate": 
                case "update_daily_alltag": 
                case "update_daily_alltagupdate": 
                case "update_daily_alltagyml": 
                case "update_daily_alltagymlupdate": {
                    cmdThread = this.updateService.startUpdateThread(this.dockerService.updateEP(), button);
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "cannot start Thread " + button;
                    break;
                }
                default: {
                    try {
                        Matcher m = Pattern.compile("^([^\\-]+)\\-(.+)$").matcher(button);
                        if (!m.find()) break;
                        String cmd = m.group(1).trim();
                        String cont = m.group(2).trim();
                        UpdateServiceDto service = null;
                        for (UpdateServiceDto updateServiceDto : this.updateService.getUpdateDto().getServices()) {
                            if (!updateServiceDto.getContainername().trim().equals(cont)) continue;
                            service = updateServiceDto;
                        }
                        if (service != null) {
                            switch (cmd) {
                                case "Tag": 
                                case "Beta": 
                                case "Daily": 
                                case "Stable": 
                                case "Latest": {
                                    cmdThread = this.updateService.startUpdateThread(this.dockerService.updateEP(), cmd, service, newplan);
                                    if (cmdThread != null) {
                                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                    }
                                    msg = "cannot start Thread " + button;
                                    break;
                                }
                                case "edityml": {
                                    return this.fileEditController.editFile(service.ymlFile(), model, this.dockerService.updateEP());
                                }
                                case "updateyml": {
                                    msg = this.updateService.updateYml(service);
                                    break;
                                }
                                case "update": {
                                    cmdThread = this.updateService.serviceUpdate(service, this.dockerService.updateEP());
                                    if (cmdThread != null) {
                                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                    }
                                    msg = "cannot update service " + service.getServicename() + " in Container " + service.getContainername();
                                    break;
                                }
                                case "restart": {
                                    cmdThread = this.updateService.serviceRestart(service, this.dockerService.updateEP());
                                    if (cmdThread != null) {
                                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                    }
                                    msg = "cannot update service " + service.getServicename() + " in Container " + service.getContainername();
                                    break;
                                }
                                case "stop": {
                                    cmdThread = this.updateService.serviceStop(service, this.dockerService.updateEP());
                                    if (cmdThread != null) {
                                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                    }
                                    msg = "cannot stop service " + service.getServicename() + " in Container " + service.getContainername();
                                    break;
                                }
                                case "delete": {
                                    cmdThread = this.updateService.serviceDelete(service);
                                    if (cmdThread != null) {
                                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                    }
                                    msg = "cannot delete service " + service.getServicename() + " in Container " + service.getContainername();
                                }
                            }
                            break;
                        }
                        if (!cmd.equals("installservice")) break;
                        String ymlFileName = cont;
                        msg = this.updateService.installService(ymlFileName);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            this.updateService.getUpdateDto().setNewplan(newplan);
        }
        catch (Exception exception) {
            // empty catch block
        }
        model.addAttribute("updateDto", (Object)this.updateService.getUpdateDto());
        model.addAttribute("updateService", (Object)this.updateService);
        model.addAttribute("msg", msg);
        return "update";
    }
}

