/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.security.LettoToken;
import at.letto.setup.dto.AuthenticationRequestDto;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.SetupUserDetailsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
@Tag(name="Intern Api Controller", description="Endpoints f\u00fcr das Login-Service f\u00fcr den Login eines Setup-Admins")
public class InternApiController {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private SetupUserDetailsService setupUserDetailsService;

    @Operation(summary="Passwordcheck", hidden=true, description="Pr\u00fcft Benutzername und Passwort am Setup-Service<br>Body: [AuthenticationRequestDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/AuthenticationRequestDto.html)<br>Result: String - neuer Token", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/config/auth/user/checkpassword"})
    public ResponseEntity<String> loginBase(@RequestBody AuthenticationRequestDto dto) {
        if (!this.dockerService.isDockerRunning()) {
            ResponseEntity.ok((Object)"");
        }
        LettoToken lettoToken = this.setupUserDetailsService.checkSetupUsernamePassword(dto.getUsername(), dto.getPassword(), dto.getFingerprint(), dto.getIpaddress(), dto.getService(), dto.getInfos(), dto.getUserAgent());
        String token = lettoToken.getToken();
        return ResponseEntity.ok((Object)token);
    }
}

