/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.dto.RestStatus;
import at.letto.lettolicense.dto.LicenseState;
import at.letto.lettolicense.dto.data.PersonDTO;
import at.letto.lettolicense.dto.data.SchuleDTO;
import at.letto.lettolicense.dto.letto.MitarbeiterDTOL;
import at.letto.lettolicense.dto.letto.SchuleDTOL;
import at.letto.lettolicense.dto.licensecheck.GetServerRestKeyResponseDTO;
import at.letto.lettolicense.dto.licensecheck.LettoServerDTO;
import at.letto.lettolicense.dto.licensecheck.LicenseCheckSchuleRequestDTO;
import at.letto.lettolicense.dto.licensecheck.LicenseCheckSchuleResponseDTO;
import at.letto.lettolicense.dto.licensecheck.LizenzCheckSchuleDTO;
import at.letto.lettolicense.dto.licensecheck.SchuleLizenzDTO;
import at.letto.lettolicense.dto.licensecheck.ServerLizenzenDTO;
import at.letto.lettolicense.restclient.RestLettoLicenseService;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.configFiles.LettoEnvFile;
import at.letto.setupservice.configFiles.SchuleEnv;
import at.letto.setupservice.model.DockerEditSchoolDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.DatabaseService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LizenzService;
import at.letto.tools.ENCRYPT;
import at.letto.tools.LicenseKey;
import at.letto.tools.ServerStatus;
import java.util.List;
import java.util.Vector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LizenzService {
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private DockerConfiguration dockerConfiguration;
    @Autowired
    private DatabaseService databaseService;
    public DockerService dockerService;

    private String getLicenseServerUri() {
        String licenseServerUri = this.microServiceConfiguration.getLicenseServer();
        if (licenseServerUri == null) {
            return "";
        }
        return licenseServerUri;
    }

    private RestLettoLicenseService getRestLettoLicenseService() {
        String licenseServerUri = this.getLicenseServerUri();
        RestLettoLicenseService lettoLicenseService = new RestLettoLicenseService(licenseServerUri);
        return lettoLicenseService;
    }

    public boolean isLicensServerAvailable() {
        RestLettoLicenseService lettoLicenseService = this.getRestLettoLicenseService();
        return lettoLicenseService.ping();
    }

    public String getRestKeyDecoded() {
        String restkeyEnc = this.dockerService.getRestKey();
        String restkeyDec = ENCRYPT.dec((String)restkeyEnc, (String)"enfldsgbnlsngdlksdsgm");
        return restkeyDec;
    }

    public LicenseKey toLicenseKey(String license) {
        try {
            LicenseKey licenseKey = new LicenseKey(license, "enfldsgbnlsngdlksdsgm");
            return licenseKey;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String createNewRestKey() {
        RestLettoLicenseService lettoLicenseService = this.getRestLettoLicenseService();
        String ip1 = this.analyzeService.getLocalIP();
        String ip2 = "";
        String domain1 = this.dockerConfiguration.getLettoEnvFile().getServerName();
        String domain2 = "";
        String info = this.dockerConfiguration.getLettoEnvFile().getServerInfo();
        String schuelerLehrerAnzahl = "";
        LettoServerDTO lettoServerDTO = new LettoServerDTO("PLEASE GIVE ME A CORRECT REST-KEY FOR MY SERVER", ip1, ip2, domain1, domain2, ServerStatus.getBetriebssystem(), this.analyzeService.getJavaVersion(), ServerStatus.getServerVersion(), this.analyzeService.getRevision(), info, schuelerLehrerAnzahl, "");
        GetServerRestKeyResponseDTO ret = lettoLicenseService.getServerRestkey(lettoServerDTO);
        if (ret == null) {
            return "Cannot connect license-server " + this.getLicenseServerUri();
        }
        String restkey = ret.getRestkey();
        if (restkey != null && restkey.length() > 0) {
            this.dockerService.setRestKey(ENCRYPT.enc((String)restkey, (String)"enfldsgbnlsngdlksdsgm"));
            return "restkey set ok!";
        }
        return "error - cannot request Restkey from " + this.getLicenseServerUri();
    }

    public LizenzCheckSchuleDTO lizenzCheckSchule(SchuleEnv schule, int schuelerAnz, int lehrerAnz) {
        String restkey = this.getRestKeyDecoded();
        String licence = schule.licence;
        try {
            LicenseKey licenseKey = new LicenseKey(schule.licence, "enfldsgbnlsngdlksdsgm");
            if (!licenseKey.isOk()) {
                licenseKey.setOk();
                schule.licence = licenseKey.getKey("enfldsgbnlsngdlksdsgm");
            }
            LicenseCheckSchuleRequestDTO dto = new LicenseCheckSchuleRequestDTO(restkey, licence, ServerStatus.getBetriebssystem(), ServerStatus.getJavaVersion(), ServerStatus.getServerVersion(), this.analyzeService.getRevision(), schule.idSchuleData, schuelerAnz, lehrerAnz);
            RestLettoLicenseService lettoLicenseService = this.getRestLettoLicenseService();
            LicenseCheckSchuleResponseDTO ret = lettoLicenseService.licenseCheckSchule(dto);
            if (ret.getResult() == LicenseState.updated) {
                licence = ret.getLicenseKey();
            }
            return new LizenzCheckSchuleDTO(ret.getResult(), licence);
        }
        catch (Exception e) {
            System.out.println("LIZENCHECK-FEHLER");
            e.printStackTrace();
            return new LizenzCheckSchuleDTO(LicenseState.connectionerror, licence);
        }
    }

    public LettoServerDTO getServerInfo() {
        String restkey = this.getRestKeyDecoded();
        if (restkey == null || restkey.length() == 0) {
            return new LettoServerDTO("", "kein Restkey Definiert");
        }
        try {
            RestLettoLicenseService lettoLicenseService = this.getRestLettoLicenseService();
            LettoServerDTO ret = lettoLicenseService.getServerInfo(restkey);
            return ret;
        }
        catch (Exception exception) {
            return new LettoServerDTO("", "Verbindungsfehler zum Lizenzserver!!");
        }
    }

    public LettoServerDTO getServerInfo(String restkey) {
        if ((restkey = ENCRYPT.dec((String)restkey, (String)"enfldsgbnlsngdlksdsgm")) == null || restkey.length() == 0) {
            return new LettoServerDTO("", "kein Restkey Definiert");
        }
        try {
            RestLettoLicenseService lettoLicenseService = this.getRestLettoLicenseService();
            LettoServerDTO ret = lettoLicenseService.getServerInfo(restkey);
            return ret;
        }
        catch (Exception exception) {
            return new LettoServerDTO("", "Verbindungsfehler zum Lizenzserver!!");
        }
    }

    public boolean pingRestKey() {
        String restkey = this.getRestKeyDecoded();
        LettoServerDTO dto = this.getServerInfo();
        return dto != null && dto.getRestkey().length() > 0 && dto.getRestkey().equals(restkey);
    }

    public boolean pingRestKey(String restkey) {
        LettoServerDTO dto = this.getServerInfo();
        return dto.getRestkey().length() > 0 && dto.getRestkey().equals(restkey);
    }

    public boolean updateServerInfo() {
        LettoServerDTO dto = this.getServerInfo();
        dto.setBetriebssystem(ServerStatus.getBetriebssystem());
        dto.setJavaVersion(ServerStatus.getJavaVersion());
        dto.setJeeserver(ServerStatus.getServerVersion());
        dto.setLettoRevision(this.analyzeService.getRevision());
        if (dto == null) {
            return false;
        }
        return this.updateServerInfo(dto);
    }

    private boolean updateServerInfo(LettoServerDTO dto) {
        try {
            RestLettoLicenseService lettoLicenseService = this.getRestLettoLicenseService();
            Boolean ret = lettoLicenseService.updateserverinfo(dto);
            return ret == true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public List<SchuleLizenzDTO> getSchullizenzen() {
        String restkey = this.getRestKeyDecoded();
        try {
            RestLettoLicenseService lettoLicenseService = this.getRestLettoLicenseService();
            ServerLizenzenDTO ret = lettoLicenseService.getSchulLizenzen(restkey);
            if (ret.getReststatus().getReststatus().equals((Object)RestStatus.OK)) {
                return ret.getSchulen();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public SchuleDTOL getSchule(SchuleEnv schule) {
        return this.getSchule(schule, null);
    }

    private SchuleDTOL schuleDTOLfromSchuleEnv(SchuleEnv schule) {
        SchuleDTOL dto = new SchuleDTOL();
        DockerEditSchoolDto dockerEditSchoolDto = this.databaseService.loadEditSchoolDto(schule.envID);
        dto.setRestkey(this.getRestKeyDecoded());
        dto.getSchuleDTO().setIdschuleletto(schule.idSchuleData);
        dto.getSchuleDTO().setId(schule.idSchuleLizenz);
        dto.setCreate(dockerEditSchoolDto != null);
        if (dockerEditSchoolDto != null) {
            dto.getSchuleDTO().setSchulname(dockerEditSchoolDto.getSchulname());
            dto.getSchuleDTO().setSchulkennzahl(dockerEditSchoolDto.getSchulskz());
            dto.getSchuleDTO().setTelefon(dockerEditSchoolDto.getSchultel());
            dto.getSchuleDTO().setHomepage(dockerEditSchoolDto.getSchulweb());
            dto.getSchuleDTO().setLettourl(schule.lettoURIextern);
            dto.getSchuleDTO().setSchueleranzahl(dockerEditSchoolDto.getSchuelerLizenzAnzahl());
            dto.getSchuleDTO().setDemolizenzdatum("");
            dto.getSchuleDTO().setLizenzdatum("");
            dto.getSchuleDTO().setLehreranzahl(dockerEditSchoolDto.getLehrerAnzahl());
            dto.getSchuleDTO().setExternalusers(false);
            dto.getSchuleDTO().setPayingstudents(false);
            dto.getSchuleDTO().setEncodepossible(false);
            dto.getSchuleDTO().setIdschuleletto(schule.idSchuleData);
            dto.getSchuleDTO().setSchulname(schule.schulname);
            dto.getSchuleDTO().setBezeichnung(schule.schulname);
            dto.getSchuleDTO().setHomepage(schule.lettoURIextern);
            dto.setCurrentLicense(schule.licence);
        }
        return dto;
    }

    public SchuleDTOL getSchule(SchuleEnv schule, DockerEditSchoolDto dockerEditSchoolDto) {
        String restkey = this.getRestKeyDecoded();
        try {
            SchuleDTOL dto = new SchuleDTOL();
            dto.setRestkey(restkey);
            dto.setCreate(dockerEditSchoolDto != null);
            if (dockerEditSchoolDto != null) {
                MitarbeiterDTOL ansprechpartner = new MitarbeiterDTOL();
                ansprechpartner.setPersonDTO(new PersonDTO());
                ansprechpartner.getPersonDTO().setNachname(dockerEditSchoolDto.getSchulansprechpartner());
                ansprechpartner.getPersonDTO().setEmail(dockerEditSchoolDto.getSchulemail());
                ansprechpartner.getPersonDTO().setTelefon(dockerEditSchoolDto.getSchultel());
                if (dockerEditSchoolDto.getSchuldirektor().trim().length() > 0 && !dockerEditSchoolDto.getSchuldirektor().trim().equalsIgnoreCase(dockerEditSchoolDto.getSchulansprechpartner().trim())) {
                    MitarbeiterDTOL direktor = new MitarbeiterDTOL();
                    direktor.setPersonDTO(new PersonDTO());
                    direktor.getMitarbeiterDTO().setPosition("Direktor");
                    direktor.getPersonDTO().setNachname(dockerEditSchoolDto.getSchuldirektor().trim());
                    dto.setMitarbeiterList(new MitarbeiterDTOL[2]);
                    dto.getMitarbeiterList()[0] = ansprechpartner;
                    dto.getMitarbeiterList()[1] = direktor;
                } else {
                    if (dockerEditSchoolDto.getSchuldirektor().trim().equalsIgnoreCase(dockerEditSchoolDto.getSchulansprechpartner().trim())) {
                        ansprechpartner.getMitarbeiterDTO().setPosition("Direktor");
                    }
                    dto.setMitarbeiterList(new MitarbeiterDTOL[1]);
                    dto.getMitarbeiterList()[0] = ansprechpartner;
                }
                dto.getSchuleDTO().setSchulkennzahl(dockerEditSchoolDto.getSchulskz());
                dto.getSchuleDTO().setTelefon(dockerEditSchoolDto.getSchultel());
                dto.getSchuleDTO().setHomepage(dockerEditSchoolDto.getSchulweb());
                dto.getSchuleDTO().setLettourl(schule.lettoURIextern);
                dto.getSchuleDTO().setSchueleranzahl(10);
                dto.getSchuleDTO().setDemolizenzdatum("");
                dto.getSchuleDTO().setLizenzdatum("");
                dto.getSchuleDTO().setLehreranzahl(1);
                dto.getSchuleDTO().setExternalusers(false);
                dto.getSchuleDTO().setPayingstudents(false);
                dto.getSchuleDTO().setEncodepossible(false);
                dto.setCurrentLicense("");
            }
            dto.getSchuleDTO().setIdschuleletto(schule.idSchuleData);
            dto.getSchuleDTO().setSchulname(schule.schulname);
            dto.getSchuleDTO().setBezeichnung(schule.schulname);
            dto.getSchuleDTO().setHomepage(schule.lettoURIextern);
            dto.setCurrentLicense(schule.licence);
            RestLettoLicenseService lettoLicenseService = this.getRestLettoLicenseService();
            SchuleDTOL ret = lettoLicenseService.getSchule(dto);
            return ret;
        }
        catch (Exception dto) {
            SchuleDTOL ret = new SchuleDTOL();
            ret.setReststatus(RestStatus.NOCONNECTION, "Verbindung mit dem Lizenzserver nicht herstellbar!");
            return ret;
        }
    }

    public SchuleDTOL updateSchule(SchuleDTOL schuleDTOL) {
        String restkey = this.getRestKeyDecoded();
        try {
            schuleDTOL.setRestkey(restkey);
            RestLettoLicenseService lettoLicenseService = this.getRestLettoLicenseService();
            schuleDTOL = lettoLicenseService.updateSchule(schuleDTOL);
            return schuleDTOL;
        }
        catch (Exception exception) {
            schuleDTOL.setReststatus(RestStatus.NOCONNECTION, "Verbindung mit dem Lizenzserver nicht herstellbar!");
            return schuleDTOL;
        }
    }

    public String createDemoLicense(SchuleEnv schule, DockerEditSchoolDto dockerEditSchoolDto) {
        SchuleDTOL schuleDTOL = this.getSchule(schule, dockerEditSchoolDto);
        if (schuleDTOL == null) {
            return "error: cannot get demolicense from license-server";
        }
        if (schuleDTOL.getReststatus().getReststatus() == RestStatus.CREATED || schuleDTOL.getReststatus().getReststatus() == RestStatus.OK) {
            LicenseKey licenseKey = this.toLicenseKey(schuleDTOL.getCurrentLicense());
            if (licenseKey == null) {
                return "error in lizcense - not updated!!";
            }
            schule.idSchuleLizenz = licenseKey.getIdSchule();
            schule.licence = schuleDTOL.getCurrentLicense();
            return "";
        }
        return schuleDTOL.getReststatus().getReststatus().toString();
    }

    public String updateLicenseAll() {
        LettoEnvFile envFile = this.dockerService.dockerConfiguration.getLettoEnvFile();
        Vector schulen = envFile.getSchulen();
        Object msg = "";
        for (SchuleEnv schule : schulen) {
            msg = (String)msg + (((String)msg).length() > 0 ? "," : "") + this.updateLicenseSchool(schule, false);
        }
        envFile.setSchulen(schulen);
        envFile.writeFile();
        if (((String)msg).length() == 0) {
            return "OK: all licenses checked";
        }
        return "problems: " + (String)msg;
    }

    public String updateLicenseSchool(SchuleEnv schule) {
        return this.updateLicenseSchool(schule, true);
    }

    public String updateLicenseSchool(SchuleEnv schule, boolean saveEnv) {
        if (schule.licenceNoUpdate) {
            return "";
        }
        SchuleDTOL schuleDTOL = null;
        schuleDTOL = this.schuleDTOLfromSchuleEnv(schule);
        if (schuleDTOL != null) {
            LicenseKey oldLicenseKey = this.toLicenseKey(schuleDTOL.getCurrentLicense());
            if ((schuleDTOL = this.updateSchule(schuleDTOL)) == null) {
                return "error: cannot find school";
            }
            Object msg = "error in lizcense - not updated!!";
            switch (1.$SwitchMap$at$letto$dto$RestStatus[schuleDTOL.getReststatus().getReststatus().ordinal()]) {
                case 1: {
                    msg = "OK: license checked";
                    break;
                }
                case 2: {
                    msg = "OK: license updated";
                    break;
                }
                case 3: {
                    return "error - restkey is not available on server!";
                }
                default: {
                    return "error during license-service : " + schuleDTOL.getReststatus().getMessage();
                }
            }
            LicenseKey licenseKey = this.toLicenseKey(schuleDTOL.getCurrentLicense());
            if (licenseKey != null) {
                if (oldLicenseKey != null) {
                    msg = (String)msg + " " + this.checkLicenseUpdate(schule, schuleDTOL.getSchuleDTO(), oldLicenseKey, licenseKey);
                }
                schule.idSchuleLizenz = licenseKey.getIdSchule();
                String license = schuleDTOL.getCurrentLicense();
                if (!schule.licence.equals(license)) {
                    schule.licence = license;
                    schule.idSchuleLizenz = licenseKey.getIdSchule();
                    this.databaseService.licenseInDatabase(schule);
                }
                if (saveEnv) {
                    LettoEnvFile envFile = this.dockerService.dockerConfiguration.getLettoEnvFile();
                    Vector schulen = envFile.getSchulen();
                    for (int i = 0; i < schulen.size(); ++i) {
                        if (((SchuleEnv)schulen.get((int)i)).envID != schule.envID) continue;
                        schulen.set(i, schule);
                        envFile.setSchulen(schulen);
                        envFile.writeFile();
                        return "OK: licence checked";
                    }
                    return "error cannot save to env-File!!";
                }
                return msg;
            }
            return "error in lizcense - not updated!!";
        }
        return "not yet implemented!";
    }

    private String checkLicenseUpdate(SchuleEnv schule, SchuleDTO schuleDTO, LicenseKey oldLicense, LicenseKey newLicense) {
        if (schule == null) {
            return "schule is null";
        }
        if (oldLicense == null) {
            return "oldlicense is null";
        }
        if (newLicense == null) {
            return "newlicense is null";
        }
        if (oldLicense.getIdLicense() != newLicense.getIdLicense()) {
            String msg = this.databaseService.resetSchuelerLizenzen(schule);
            return msg;
        }
        return "";
    }
}

