/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.setupservice.dto.DockerStatsDto;
import at.letto.setupservice.model.docker.DockerContainerDto;
import at.letto.setupservice.model.docker.DockerPortDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.tools.JSON;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DockerStatsService
implements Runnable {
    static final Logger LOGGER = LoggerFactory.getLogger(DockerStatsService.class);
    private AnalyzeService analyzeService;
    private ConcurrentHashMap<String, DockerStatsDto> dockerStats = new ConcurrentHashMap();
    public long lastStatsTimeMillis = 0L;
    public Thread thread;

    public DockerStatsService(AnalyzeService analyzeService) {
        this.analyzeService = analyzeService;
        this.thread = new Thread((Runnable)this);
        this.thread.start();
    }

    public static List<DockerStatsDto> dockerStats() {
        ArrayList<DockerStatsDto> containers = new ArrayList<DockerStatsDto>();
        try {
            ProcessBuilder pb = new ProcessBuilder("docker", "stats", "--no-stream", "--all", "--no-trunc", "--format", "json");
            pb.redirectErrorStream(true);
            Process process = pb.start();
            InputStream inputStream = process.getInputStream();
            String json = new String(inputStream.readAllBytes());
            for (String line : json.split("\n")) {
                try {
                    HashMap c = (HashMap)JSON.jsonToObj((String)line, HashMap.class);
                    String id = (String)c.get("ID");
                    String container = (String)c.get("Container");
                    String blockIO = (String)c.get("BlockIO");
                    String cpuPerc = (String)c.get("CPUPerc");
                    String memPerc = (String)c.get("MemPerc");
                    String memUsage = (String)c.get("MemUsage");
                    String name = (String)c.get("Name");
                    String netIO = (String)c.get("NetIO");
                    String pids = (String)c.get("PIDs");
                    DockerStatsDto dockerStatsDto = new DockerStatsDto(id, name);
                    dockerStatsDto.setPids(pids);
                    try {
                        dockerStatsDto.setCpu(Double.parseDouble(cpuPerc.trim().substring(0, cpuPerc.trim().length() - 1)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        dockerStatsDto.setMemoryUsage(memUsage.split("\\s*\\/\\s*")[0].trim());
                        dockerStatsDto.setMemoryLimit(memUsage.split("\\s*\\/\\s*")[1].trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        dockerStatsDto.setMemory(Double.parseDouble(memPerc.trim().substring(0, memPerc.trim().length() - 1)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        dockerStatsDto.setNetInput(netIO.split("\\s*\\/\\s*")[0].trim());
                        dockerStatsDto.setNetOutput(netIO.split("\\s*\\/\\s*")[1].trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        dockerStatsDto.setBlockInput(blockIO.split("\\s*\\/\\s*")[0].trim());
                        dockerStatsDto.setBlockOutput(blockIO.split("\\s*\\/\\s*")[1].trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    containers.add(dockerStatsDto);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return containers;
    }

    public static List<DockerContainerDto> dockerPS() {
        ArrayList<DockerContainerDto> containers = new ArrayList<DockerContainerDto>();
        try {
            ProcessBuilder pb = new ProcessBuilder("docker", "ps", "--all", "--no-trunc", "--format", "json");
            pb.redirectErrorStream(true);
            Process process = pb.start();
            InputStream inputStream = process.getInputStream();
            String json = new String(inputStream.readAllBytes());
            for (String line : json.split("\n")) {
                try {
                    HashMap c = (HashMap)JSON.jsonToObj((String)line, HashMap.class);
                    String command = (String)c.get("Command");
                    String createdAt = (String)c.get("CreatedAt");
                    String id = (String)c.get("ID");
                    String image = (String)c.get("Image");
                    String labels = (String)c.get("Labels");
                    String names = (String)c.get("Names");
                    String networks = (String)c.get("Networks");
                    String ports = (String)c.get("Ports");
                    String runningfor = (String)c.get("RunningFor");
                    String size = (String)c.get("Size");
                    String state = (String)c.get("State");
                    String status = (String)c.get("Status");
                    ArrayList<DockerPortDto> dockerPorts = new ArrayList<DockerPortDto>();
                    for (String port : ports.split(",\\s*")) {
                        try {
                            Pattern p = Pattern.compile("^(.+):(\\d+)\\-\\>(\\d+)\\/(.+)$");
                            DockerPortDto portDto = null;
                            Matcher m = p.matcher(port);
                            if (m.find()) {
                                portDto = new DockerPortDto(m.group(1), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), m.group(4));
                            } else {
                                p = Pattern.compile("^(\\d+)\\/(.+)$");
                                m = p.matcher(port);
                                if (m.find()) {
                                    portDto = new DockerPortDto("", 0, Integer.parseInt(m.group(1)), m.group(2));
                                }
                            }
                            if (portDto == null) continue;
                            boolean found = false;
                            for (DockerPortDto dp : dockerPorts) {
                                if (dp.getHostport() != portDto.getHostport() || dp.getContainerport() != portDto.getContainerport()) continue;
                                found = true;
                                dp.setIp(dp.getIp() + (dp.getIp().length() > 0 ? "," : "") + portDto.getIp());
                            }
                            if (found) continue;
                            dockerPorts.add(portDto);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    DockerContainerDto containerDto = new DockerContainerDto(id, image, command, createdAt, status, dockerPorts, names);
                    containers.add(containerDto);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return containers;
    }

    private void runDockerStats() {
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("docker", "stats", "--all", "--no-trunc", "--no-stream");
            pb.redirectErrorStream(true);
            Process process = null;
            process = pb.start();
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            int[] pos = null;
            while ((line = reader.readLine()) != null) {
                if (Thread.interrupted()) {
                    process.destroyForcibly();
                }
                if ((line = line.trim()).contains("CONTAINER ID") && line.contains("NAME")) {
                    int p = line.indexOf("CONTAINER");
                    line = line.substring(p).trim();
                }
                if (line.startsWith("CONTAINER ID")) {
                    try {
                        for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
                            try {
                                if (dockerStatsDto.isOk()) continue;
                                this.dockerStats.remove(dockerStatsDto.getName());
                            }
                            catch (Exception exception) {}
                        }
                        for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
                            dockerStatsDto.setOk(false);
                        }
                        pos = new int[]{0, line.indexOf("NAME"), line.indexOf("CPU %"), line.indexOf("MEM USAGE"), line.indexOf("MEM %"), line.indexOf("NET I/O"), line.indexOf("BLOCK I/O"), line.indexOf("PIDS")};
                        this.lastStatsTimeMillis = System.currentTimeMillis();
                    }
                    catch (Exception p) {}
                    continue;
                }
                if (pos == null) continue;
                String id = line.substring((int)pos[0], (int)pos[1]).trim();
                String name = line.substring((int)pos[1], (int)pos[2]).trim();
                String cpu = line.substring(pos[2], pos[3]).trim();
                String mem = line.substring(pos[3], pos[4]).trim();
                String memP = line.substring(pos[4], pos[5]).trim();
                String net = line.substring(pos[5], pos[6]).trim();
                String block = line.substring(pos[6], pos[7]).trim();
                String pids = line.substring(pos[7]).trim();
                DockerStatsDto dockerStatsDto = null;
                if (this.dockerStats.containsKey(name)) {
                    dockerStatsDto = (DockerStatsDto)this.dockerStats.get(name);
                    dockerStatsDto.setId(id);
                } else {
                    dockerStatsDto = new DockerStatsDto(id, name);
                    this.dockerStats.put(name, dockerStatsDto);
                }
                dockerStatsDto.setOk(true);
                dockerStatsDto.setPids(pids);
                try {
                    dockerStatsDto.setCpu(Double.parseDouble(cpu.trim().substring(0, cpu.trim().length() - 1)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dockerStatsDto.setMemoryUsage(mem.split("\\s*\\/\\s*")[0].trim());
                    dockerStatsDto.setMemoryLimit(mem.split("\\s*\\/\\s*")[1].trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dockerStatsDto.setMemory(Double.parseDouble(memP.trim().substring(0, memP.trim().length() - 1)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dockerStatsDto.setNetInput(net.split("\\s*\\/\\s*")[0].trim());
                    dockerStatsDto.setNetOutput(net.split("\\s*\\/\\s*")[1].trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dockerStatsDto.setBlockInput(block.split("\\s*\\/\\s*")[0].trim());
                    dockerStatsDto.setBlockOutput(block.split("\\s*\\/\\s*")[1].trim());
                }
                catch (Exception exception) {}
            }
            int exitCode = 0;
            try {
                exitCode = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            reader.close();
            inputStreamReader.close();
            inputStream.close();
            process.destroyForcibly();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (true) {
            this.runDockerStats();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public double cpuUsage() {
        double cpu = this.analyzeService.getCpuUsage() * (double)this.analyzeService.getCPUanzahl();
        if (cpu > -1.0) {
            return cpu;
        }
        return this.cpuDockerUsage();
    }

    public double cpuUsagePercent() {
        return this.cpuUsage() / (double)this.analyzeService.getCPUanzahl();
    }

    public double cpuDockerUsage() {
        double sum = 0.0;
        boolean ct = false;
        for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
            try {
                sum += dockerStatsDto.getCpu();
            }
            catch (Exception exception) {}
        }
        return sum;
    }

    public double cpuDockerUsagePercent() {
        return this.cpuDockerUsage() / (double)this.analyzeService.getCPUanzahl();
    }

    public double cpuUsageAvg() {
        double sum = 0.0;
        boolean ct = false;
        for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
            try {
                sum += dockerStatsDto.getCpuAvg();
            }
            catch (Exception exception) {}
        }
        return sum;
    }

    public double cpuUsageAvgPercent() {
        return this.cpuUsage() / (double)this.analyzeService.getCPUanzahl();
    }

    public DockerStatsDto getContainerByName(String name) {
        if (this.dockerStats.contains(name = name.trim())) {
            return (DockerStatsDto)this.dockerStats.get(name);
        }
        return null;
    }

    public DockerStatsDto getContainerById(String id) {
        id = id.trim();
        try {
            for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
                if (!dockerStatsDto.getId().equals(id)) continue;
                return dockerStatsDto;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<DockerStatsDto> getContainers() {
        ArrayList<DockerStatsDto> ret = new ArrayList<DockerStatsDto>();
        try {
            for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
                ret.add(dockerStatsDto);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

