/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.SetupConfiguration;
import at.letto.setupservice.controller.Msg;
import at.letto.setupservice.controller.MsgType;
import at.letto.setupservice.model.RequestButtonDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.UpdateService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AnalyzeController {
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private SetupConfiguration setupConfiguration;
    @Autowired
    private DockerConfiguration dockerConfiguration;
    @Autowired
    private UpdateService updateService;
    @Autowired
    private DockerService dockerService;

    @RequestMapping(value={"/setup/session/reload"})
    public String reloadLocal(@ModelAttribute RequestButtonDto requestButtonDto, HttpServletRequest request, Model model) {
        this.analyzeService.analyzeRequestUrl(request);
        this.setupConfiguration.reload();
        this.dockerConfiguration.loadConfiguration();
        return "redirect:/setup/session/welcome";
    }

    @RequestMapping(value={"/config/session/analyze"})
    public String analyzePageDocker(@ModelAttribute RequestButtonDto requestButtonDto, Model model) {
        return this.analyzePage(requestButtonDto, model);
    }

    @RequestMapping(value={"/setup/session/analyze"})
    public String analyzePage(@ModelAttribute RequestButtonDto requestButtonDto, Model model) {
        model.addAttribute("dockerService", (Object)this.dockerService);
        String button = requestButtonDto.getUserAction();
        if (button != null) {
            if (button.equals("reload")) {
                this.analyzeService.analyze();
            }
            if (button.equals("updatedaily")) {
                String msg = this.updateService.updateSetupServiceDaily();
                if (msg.equals("ok")) {
                    return "redirect:" + this.dockerService.loginEP();
                }
                return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.analyzeEP(), (String)msg, (String)"");
            }
            if (button.equals("updatestable")) {
                String msg = this.updateService.updateSetupServiceStable();
                if (msg.equals("ok")) {
                    return "redirect:" + this.dockerService.loginEP();
                }
                return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.analyzeEP(), (String)msg, (String)"");
            }
            if (button.equals("back")) {
                return "redirect:" + this.dockerService.welcomeEP();
            }
        } else {
            this.analyzeService.analyze();
        }
        model.addAttribute("analyzeService", (Object)this.analyzeService);
        model.addAttribute("updateService", (Object)this.updateService);
        model.addAttribute("requestButtonDto", (Object)new RequestButtonDto());
        model.addAttribute("dockerService", (Object)this.dockerService);
        return "analyze";
    }

    @RequestMapping(value={"/config/session/welcomeanalyze"})
    public String welcomeanalyzeDocker(@ModelAttribute RequestButtonDto requestButtonDto, HttpServletRequest request, Model model) {
        return this.welcomeanalyze(requestButtonDto, request, model);
    }

    @RequestMapping(value={"/setup/session/welcomeanalyze"})
    public String welcomeanalyze(@ModelAttribute RequestButtonDto requestButtonDto, HttpServletRequest request, Model model) {
        this.analyzeService.analyzeRequestUrl(request);
        this.analyzeService.analyze();
        return "redirect:" + this.dockerService.welcomeEP();
    }
}

