/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.databaseclient.service.DatabaseConnectionService;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.configFiles.LettoEnvFile;
import com.mongodb.client.MongoClient;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
public class DatabaseConfiguration {
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private DatabaseConnectionService databaseConnectionService;
    private Logger logger = LoggerFactory.getLogger(DatabaseConfiguration.class);

    @PostConstruct
    public void init() {
        String mysqlPassword = "";
        String mongoPassword = "";
        String redisPassword = "";
        String lettoMysqlHost = this.isDockerRunning() ? "letto-mysql.nw-letto" : "localhost";
        String lettoRedisHost = this.isDockerRunning() ? "letto-redis.nw-letto" : "localhost";
        String lettoMongoHost = this.isDockerRunning() ? "letto-mongo.nw-letto" : "localhost";
        int mySQLPort = this.isDockerRunning() ? 3306 : 13306;
        int mongoPort = 27017;
        int redisPort = 6379;
        String mongoDefaultDatabase = "setup";
        int redisDefaultDatabase = 0;
        try {
            LettoEnvFile lettoEnvFile = new LettoEnvFile(this.microServiceConfiguration.getLettoEnvFile());
            mysqlPassword = lettoEnvFile.getMysqlRootPassword();
            String mp = lettoEnvFile.getVar("MONGO_ROOT_PASSWORD");
            String rp = lettoEnvFile.getVar("REDIS_PASSWORD");
            if (mysqlPassword != null) {
                mongoPassword = mysqlPassword;
                redisPassword = mysqlPassword;
            }
            if (mp != null && mp.length() > 0) {
                mongoPassword = mp;
            }
            if (rp != null && rp.length() > 0) {
                redisPassword = rp;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.databaseConnectionService.init(mysqlPassword, mongoPassword, redisPassword, lettoMysqlHost, lettoMongoHost, lettoRedisHost, mongoDefaultDatabase, redisDefaultDatabase, mySQLPort, mongoPort, redisPort);
    }

    @Bean
    public MongoClient mongoClient() {
        return this.databaseConnectionService.mongoClient();
    }

    @Bean(name={"mongoTemplate"})
    public MongoTemplate mongoTemplate() {
        return this.databaseConnectionService.lettoMongoTemplate();
    }

    @Bean(name={"lettoMongoTemplate"})
    public MongoTemplate lettoMongoTemplate() {
        return this.databaseConnectionService.lettoMongoTemplate();
    }

    @Bean(name={"secondaryMongoTemplate"})
    public MongoTemplate secondaryMongoTemplate() {
        return this.databaseConnectionService.secondaryMongoTemplate();
    }

    @Bean
    public LettuceConnectionFactory redisConnectionFactory() {
        LettuceConnectionFactory factory = this.databaseConnectionService.redisConnectionFactory(this.databaseConnectionService.getRedisDefaultDatabase());
        return factory;
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate() {
        return this.databaseConnectionService.redisTemplate(this.databaseConnectionService.getRedisDefaultDatabase());
    }

    public boolean isDockerRunning() {
        return this.microServiceConfiguration.isSetupDocker();
    }
}

