/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.service.BaseDownloadService;
import at.letto.setupservice.model.DownloadFile;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DownloadService
extends BaseDownloadService {
    private long ct = 0L;
    private HashMap<String, DownloadFile> downloads = new HashMap();

    public DownloadFile newDownloadGlobal(File file) {
        DownloadFile df = new DownloadFile(file, this.createNewId(), DownloadFile.RIGHT.GLOBAL);
        this.downloads.put(df.getId(), df);
        return df;
    }

    public DownloadFile newDownloadAdmin(File file) {
        DownloadFile df = new DownloadFile(file, this.createNewId(), DownloadFile.RIGHT.ADMIN);
        this.downloads.put(df.getId(), df);
        return df;
    }

    public DownloadFile newDownloadAuth(File file) {
        DownloadFile df = new DownloadFile(file, this.createNewId(), DownloadFile.RIGHT.AUTH);
        this.downloads.put(df.getId(), df);
        return df;
    }

    public DownloadFile newDownloadTeacher(File file) {
        DownloadFile df = new DownloadFile(file, this.createNewId(), DownloadFile.RIGHT.TEACHER);
        this.downloads.put(df.getId(), df);
        return df;
    }

    public DownloadFile newDownloadStudent(File file) {
        DownloadFile df = new DownloadFile(file, this.createNewId(), DownloadFile.RIGHT.STUDENT);
        this.downloads.put(df.getId(), df);
        return df;
    }

    public DownloadFile newDownloadUser(File file, String user) {
        DownloadFile df = new DownloadFile(file, this.createNewId(), user);
        this.downloads.put(df.getId(), df);
        return df;
    }

    private DownloadFile newDownload(File file, DownloadFile.RIGHT right) {
        DownloadFile df = new DownloadFile(file, this.createNewId(), right);
        this.downloads.put(df.getId(), df);
        return df;
    }

    public DownloadFile getFile(String id) {
        try {
            if (this.downloads.containsKey(id)) {
                return (DownloadFile)this.downloads.get(id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void removeFile(String id) {
        try {
            while (this.downloads.containsKey(id)) {
                this.downloads.remove(id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DownloadFile popFile(String id) {
        DownloadFile ret = this.getFile(id);
        this.removeFile(id);
        return ret;
    }

    private synchronized String createNewId() {
        ++this.ct;
        return "" + this.ct;
    }

    public void removeOldFiles(long time) {
        long ct = System.currentTimeMillis();
        Set keys = this.downloads.keySet();
        for (String key : keys) {
            try {
                if (!this.downloads.containsKey(key) || ct - ((DownloadFile)this.downloads.get(key)).getTime() < time) continue;
                this.downloads.remove(key);
            }
            catch (Exception exception) {}
        }
    }

    public void download(String id, HttpServletResponse response, DownloadFile.RIGHT right, String user) throws IOException {
        DownloadFile downloadFile = this.getFile(id);
        if (downloadFile == null) {
            throw new IOException("File not found!");
        }
        if (right != DownloadFile.RIGHT.GLOBAL && downloadFile.getRight() != right) {
            throw new RuntimeException("Permission denied!");
        }
        if (right == DownloadFile.RIGHT.USER && !downloadFile.getUser().equals(user)) {
            throw new RuntimeException("Permission denied!");
        }
        this.download(response, downloadFile.getFile(), downloadFile.getFilename());
    }

    @Generated
    public long getCt() {
        return this.ct;
    }

    @Generated
    public HashMap<String, DownloadFile> getDownloads() {
        return this.downloads;
    }
}

