/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.setupservice.config.EmailConfiguration;
import at.letto.setupservice.model.EmailConfigDto;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.EmailService;
import at.letto.setupservice.service.MessagePropertiesService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class EmailConfigController {
    @Autowired
    DockerService dockerService;
    @Autowired
    EmailConfiguration emailConfiguration;
    @Autowired
    EmailService emailService;
    @Autowired
    MessagePropertiesService messagePropertiesService;

    @RequestMapping(value={"/config/session/admin/emailconfig"})
    public String emailConfigDocker(@ModelAttribute EmailConfigDto emailConfigDto, HttpServletRequest request, Model model) {
        return this.emailConfig(emailConfigDto, request, model);
    }

    @RequestMapping(value={"/setup/session/admin/emailconfig"})
    public String emailConfigLocal(@ModelAttribute EmailConfigDto emailConfigDto, HttpServletRequest request, Model model) {
        return this.emailConfig(emailConfigDto, request, model);
    }

    public String emailConfig(EmailConfigDto emailConfigDto, HttpServletRequest request, Model model) {
        String button;
        Object msg = "";
        model.addAttribute("dockerService", (Object)this.dockerService);
        String string = button = emailConfigDto != null ? emailConfigDto.getUserAction() : null;
        if (button != null && button.trim().length() > 0) {
            switch (button = button.trim()) {
                case "save": {
                    this.emailConfiguration.setEmailConfigDto(emailConfigDto);
                    this.dockerService.saveEmailConfig(emailConfigDto);
                    msg = this.messagePropertiesService.getMessage("email.config.msg.saved");
                    break;
                }
                case "reload": {
                    emailConfigDto = this.emailConfiguration.getEmailConfigDto();
                    msg = this.messagePropertiesService.getMessage("email.config.msg.reloaded");
                    break;
                }
                case "cancel": {
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "send": {
                    emailConfigDto.setEmailTestSubject("Test-Mail from LeTTo-Server " + this.dockerService.getServerName());
                    this.emailConfiguration.sendTestEmail(emailConfigDto);
                    msg = this.messagePropertiesService.getMessage("email.config.msg.sent") + " " + emailConfigDto.getEmailTestTo();
                    break;
                }
                case "sendconfigured": {
                    this.emailService.sendSimpleMessage(emailConfigDto.getEmailTestTo(), "Test-Mail from LeTTo-Server " + this.dockerService.getServerName(), emailConfigDto.getEmailTestText());
                    msg = this.messagePropertiesService.getMessage("email.config.msg.sent") + " " + emailConfigDto.getEmailTestTo();
                    break;
                }
                case "sendconfiguredhtml": {
                    try {
                        this.emailService.sendHtmlMessage(emailConfigDto.getEmailTestTo(), "Test-Mail from LeTTo-Server " + this.dockerService.getServerName(), emailConfigDto.getEmailTestText());
                        msg = this.messagePropertiesService.getMessage("email.config.msg.sent") + " " + emailConfigDto.getEmailTestTo();
                        break;
                    }
                    catch (Exception ex) {
                        msg = this.messagePropertiesService.getMessage("email.config.msg.send.failure");
                    }
                }
            }
        } else {
            emailConfigDto = this.emailConfiguration.getEmailConfigDto();
            if (emailConfigDto.getEmailTestTo() == null || emailConfigDto.getEmailTestTo().trim().length() == 0) {
                emailConfigDto.setEmailTestTo(this.dockerService.getAdminEmail());
            }
        }
        model.addAttribute("msg", msg);
        model.addAttribute("emailConfigDto", (Object)emailConfigDto);
        return "emailconfig";
    }
}

