/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.config;

import at.letto.setup.dto.config.ConfigServiceDto;
import at.letto.setup.dto.config.ConfigServicesDto;
import at.letto.setup.dto.config.RegisterServiceResultDto;
import at.letto.setupservice.service.ImpSetupService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Config Controller", description="Verwaltung von Plugins und Services am LeTTo-Server")
public class ConfigController {
    @Autowired
    private ImpSetupService impSetupService;

    @Operation(summary="registrieren eines Plugins", description="registriert ein Plugin am Setup-Service, sollte beim Start des Services bzw. regelm\u00e4\u00dfig ausgef\u00fchrt werden<br>Body: [ConfigServiceDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/config/ConfigServiceDto.html)<br>Result: [RegisterServiceResultDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/config/RegisterServiceResultDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/config/auth/user/registerplugin"})
    public ResponseEntity<RegisterServiceResultDto> registerPlugin(@RequestBody ConfigServiceDto configPluginDto) {
        RegisterServiceResultDto result = this.impSetupService.registerPlugin(configPluginDto);
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="registrieren eines Services", description="registriert ein Service am Setup-Service, sollte beim Start des Services bzw. regelm\u00e4\u00dfig ausgef\u00fchrt werden<br>Body: [ConfigServiceDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/config/ConfigServiceDto.html)<br>Result: [RegisterServiceResultDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/config/RegisterServiceResultDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/config/auth/user/registerservice"})
    public ResponseEntity<RegisterServiceResultDto> registerService(@RequestBody ConfigServiceDto configServiceDto) {
        RegisterServiceResultDto result = this.impSetupService.registerService(configServiceDto);
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="Lister aller Plugins", description="Liefert eine Liste aller am Server registrierten Plugins<br>Result: [ConfigServicesDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/config/ConfigServicesDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/config/auth/user/getplugins"})
    public ResponseEntity<ConfigServicesDto> getPlugins() {
        ConfigServicesDto configPluginsDto = this.impSetupService.getPlugins();
        return ResponseEntity.ok((Object)configPluginsDto);
    }

    @Operation(summary="Lister aller Services", description="Liefert eine Liste aller am Server registrierten Services<br>Result: [ConfigServicesDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/config/ConfigServicesDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/config/auth/user/getservices"})
    public ResponseEntity<ConfigServicesDto> getServices() {
        ConfigServicesDto result = this.impSetupService.getServices();
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="Service Information", description="Liefert die Daten eines Services<br>Body: String - Name des Services<br>Result: [ConfigServiceDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/config/ConfigServiceDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/config/auth/user/getservice"})
    public ResponseEntity<ConfigServiceDto> getService(@RequestBody String service) {
        ConfigServiceDto result = this.impSetupService.getService(service);
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="Service Information einer Schule", description="Liefert die Daten des Services einer Schule<br>Body: String - K&uuml;rzel der Schule<br>Result: [ConfigServiceDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/config/ConfigServiceDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/config/auth/user/getschuleservice"})
    public ResponseEntity<ConfigServiceDto> getSchuleService(@RequestBody String schule) {
        ConfigServiceDto result = this.impSetupService.getSchuleService(schule);
        return ResponseEntity.ok((Object)result);
    }
}

