/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.service.rest.BaseRestClient;
import at.letto.setup.dto.SchoolLicenseDto;
import at.letto.setup.dto.ServiceSchuleDto;
import at.letto.setup.dto.ServiceSchulenListDto;
import at.letto.setup.dto.ServiceStatusDto;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.ImpSetupService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
@Tag(name="Setup Rest Controller", description="Informationen f\u00fcr andere Services")
public class SetupRestController {
    @Autowired
    DockerService dockerService;
    @Autowired
    ImpSetupService impSetupService;

    @Operation(summary="Liste der Schulen", description="Liefert eine Liste aller Schulen die auf dem Server installiert sind<br>Result: [ServiceSchulenListDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/ServiceSchulenListDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/config/auth/user/getschulen"})
    public ResponseEntity<ServiceSchulenListDto> getSchulen() {
        ServiceSchulenListDto schulenListDto = new ServiceSchulenListDto();
        schulenListDto.setSchulen(this.dockerService.getSchulen());
        return ResponseEntity.ok((Object)schulenListDto);
    }

    @Operation(summary="Information \u00fcber eine Schule", description="Liefert alle Informationen \u00fcber eine Schule die lokal am Server installiert ist<br>Body: String - K&uuml;rzel der Schule<br>Result: [ServiceSchuleDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/ServiceSchuleDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/setup/auth/user/postschule"})
    public ResponseEntity<ServiceSchuleDto> getSchuleLocal(@RequestBody String schule) {
        ServiceSchuleDto schuleDto = this.dockerService.getSchule(schule);
        return ResponseEntity.ok((Object)schuleDto);
    }

    @Operation(summary="Information \u00fcber eine Schule", description="Liefert alle Informationen \u00fcber eine Schule<br>Body: String - K&uuml;rzel der Schule<br>Result: [ServiceSchuleDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/ServiceSchuleDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/config/auth/user/postschule"})
    public ResponseEntity<ServiceSchuleDto> getSchule(@RequestBody String schule) {
        ServiceSchuleDto schuleDto = this.dockerService.getSchule(schule);
        return ResponseEntity.ok((Object)schuleDto);
    }

    @Operation(summary="Restkey", hidden=true, description="Liefert den Restkey des Servers<br>Result: String - Restkey", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/config/auth/user/getrestkey"})
    public ResponseEntity<String> getRestKey() {
        String restKey = this.dockerService.getRestKey();
        return ResponseEntity.ok((Object)restKey);
    }

    @Operation(summary="setzt die Lizenz einer Schule", hidden=true, description="setzt die Lizenz einer Schule<br>Body: [SchoolLicenseDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/SchoolLicenseDto.html)<br>Result: String - Fehlermeldung oder Leerstring", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/config/auth/user/setschoollicense"})
    public ResponseEntity<String> setSchoolLicense(@RequestBody SchoolLicenseDto dto) {
        return ResponseEntity.ok((Object)this.dockerService.setSchoolLicense(dto));
    }

    @Operation(summary="checkt den Service-Status", description="liefert den Status aller Services<br>Result: [ServiceStatusDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/ServiceStatusDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/config/auth/admin/checkservicestatus"})
    public ResponseEntity<ServiceStatusDto> checkServiceStatus() {
        return ResponseEntity.ok((Object)this.impSetupService.checkServiceStatus());
    }

    @Operation(summary="deaktiviert die Main-Funktion des Setup-Services", hidden=true, description="falls die Setup-Instanz gerade die Main-funktion hat, wird diese deaktiviert<br>Result: String - Information \u00fcber den Vorgang", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/config/auth/admin/deactivatemain"})
    public ResponseEntity<String> deactivateMain() {
        String result = this.dockerService.deactivateMain();
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="checkt den Service-Status", hidden=true, description="liefert den Status aller Services<br>Result: [ServiceStatusDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/ServiceStatusDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/setup/auth/admin/checkservicestatus"})
    public ResponseEntity<ServiceStatusDto> checkServiceStatusLocal() {
        return ResponseEntity.ok((Object)this.impSetupService.checkServiceStatusLocal());
    }

    @Operation(summary="liefert die Container-Version", description="liefert die Revision des Containers mit dem angegebenen Hostnamen<br>Body: String - Namen oder IP des Containers<br>Result: String - Revision des Services", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/config/auth/admin/getContainerVersion"})
    public ResponseEntity<String> getContainerVersion(@RequestBody String uri) {
        BaseRestClient baseRestClient = new BaseRestClient(uri);
        String version = baseRestClient.version();
        if (version == null || version.length() == 0) {
            version = "";
        }
        return ResponseEntity.ok((Object)version);
    }
}

