/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.setupservice.model.EmailConfigDto;
import at.letto.setupservice.service.DockerService;
import java.util.Properties;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
public class EmailConfiguration {
    private final DockerService dockerService;
    @Value(value="${spring.mail.host}")
    private String mailServerHost;
    @Value(value="${spring.mail.port}")
    private Integer mailServerPort;
    @Value(value="${spring.mail.username}")
    private String mailServerUsername;
    @Value(value="${spring.mail.password}")
    private String mailServerPassword;
    @Value(value="${spring.mail.properties.mail.smtp.auth}")
    private String mailServerAuth;
    @Value(value="${spring.mail.properties.mail.smtp.starttls.enable:false}")
    private String mailServerStartTls;
    @Value(value="${spring.mail.properties.mail.smtp.ssl.enable:false}")
    private String mailServerSsl;
    @Value(value="${spring.mail.properties.mail.debug:false}")
    private String mailDebug;
    @Value(value="${spring.mail.templates.path:mail-templates}")
    private String mailTemplatesPath;
    @Value(value="${spring.mail.address.noreply:noreply@myschool.at}")
    private String noReplyAddress;
    @Value(value="${spring.mail.address.reply:reply@myschool.at}")
    private String replyAddress;
    private String testEmailTo = "";
    private String testEmailSubject = "Test-Mail from LeTTo-Server";
    private String testEmailText = "This is only a Test-EMail from the LeTTo-Server!";
    private JavaMailSender javaMailSender = null;

    public EmailConfiguration(DockerService dockerService) {
        this.dockerService = dockerService;
    }

    public JavaMailSender getJavaMailSender() {
        if (this.javaMailSender == null) {
            this.javaMailSender = this.createJavaMailSender();
        }
        return this.javaMailSender;
    }

    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    private JavaMailSender createJavaMailSender() {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(this.mailServerHost);
        mailSender.setPort(this.mailServerPort != null ? this.mailServerPort : 465);
        mailSender.setUsername(this.mailServerUsername);
        mailSender.setPassword(this.mailServerPassword);
        Properties props = mailSender.getJavaMailProperties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.auth", this.mailServerAuth);
        props.put("mail.smtp.starttls.enable", this.mailServerStartTls);
        props.put("mail.smtp.ssl.enable", this.mailServerSsl);
        props.put("mail.debug", this.mailDebug);
        return mailSender;
    }

    public SpringTemplateEngine thymeleafTemplateEngine(ITemplateResolver templateResolver) {
        SpringTemplateEngine templateEngine = new SpringTemplateEngine();
        templateEngine.setTemplateResolver(templateResolver);
        templateEngine.setTemplateEngineMessageSource((MessageSource)this.emailMessageSource());
        return templateEngine;
    }

    public ResourceBundleMessageSource emailMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("mailMessages");
        return messageSource;
    }

    public EmailConfigDto getEmailConfigDto() {
        EmailConfigDto emailConfigDto = new EmailConfigDto("", this.mailServerHost, this.mailServerPort, this.mailServerUsername, this.mailServerPassword, this.mailServerAuth.equalsIgnoreCase("true"), this.mailServerStartTls.equalsIgnoreCase("true"), this.mailServerSsl.equalsIgnoreCase("true"), this.noReplyAddress, this.replyAddress, this.testEmailTo, this.testEmailSubject, this.testEmailText);
        return emailConfigDto;
    }

    public void setEmailConfigDto(EmailConfigDto emailConfigDto) {
        this.mailServerHost = emailConfigDto.getEmailHost();
        this.mailServerPort = emailConfigDto.getPort();
        this.mailServerUsername = emailConfigDto.getUsername();
        this.mailServerPassword = emailConfigDto.getPassword();
        this.mailServerAuth = "" + emailConfigDto.isAuthentication();
        this.mailServerStartTls = "" + emailConfigDto.isStartTTLsEnabled();
        this.mailServerSsl = "" + emailConfigDto.isSshEnabled();
        this.noReplyAddress = emailConfigDto.getAddressNoReply();
        this.replyAddress = emailConfigDto.getAddressReply();
        this.testEmailTo = emailConfigDto.getEmailTestTo();
        this.testEmailSubject = emailConfigDto.getEmailTestSubject();
        this.testEmailText = emailConfigDto.getEmailTestText();
        this.setJavaMailSender(this.createJavaMailSender());
    }

    public boolean sendTestEmail(EmailConfigDto emailConfigDto) {
        try {
            JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
            mailSender.setHost(emailConfigDto.getEmailHost());
            mailSender.setPort(emailConfigDto.getPort() != null ? emailConfigDto.getPort() : 465);
            mailSender.setUsername(emailConfigDto.getUsername());
            mailSender.setPassword(emailConfigDto.getPassword());
            Properties props = mailSender.getJavaMailProperties();
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.smtp.auth", (Object)emailConfigDto.isAuthentication());
            props.put("mail.smtp.starttls.enable", (Object)emailConfigDto.isStartTTLsEnabled());
            props.put("mail.smtp.ssl.enable", (Object)emailConfigDto.isSshEnabled());
            props.put("mail.debug", "true");
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(emailConfigDto.getAddressNoReply());
            message.setTo(emailConfigDto.getEmailTestTo());
            message.setSubject(emailConfigDto.getEmailTestSubject());
            message.setText(emailConfigDto.getEmailTestText());
            mailSender.send(message);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Generated
    public String getNoReplyAddress() {
        return this.noReplyAddress;
    }

    @Generated
    public String getReplyAddress() {
        return this.replyAddress;
    }
}

