/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.login.dto.servertoken.GeneratedServerToken;
import at.letto.login.dto.servertoken.GetServerTokenRequest;
import at.letto.login.dto.servertoken.ServerTokenListDto;
import at.letto.login.dto.servertoken.UserTokenRequestDto;
import at.letto.login.restclient.RestLoginService;
import at.letto.security.LettoToken;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.model.ServerTokenModel;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LettoService;
import at.letto.tools.Datum;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ServerTokenController {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private LettoService lettoService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;

    @RequestMapping(value={"/config/session/admin/servertoken"})
    public String serverTokenDocker(@ModelAttribute ServerTokenModel serverTokenModel, Model model) {
        return this.serverToken(serverTokenModel, model);
    }

    @RequestMapping(value={"/setup/session/admin/servertoken"})
    public String serverTokenLocal(@ModelAttribute ServerTokenModel serverTokenModel, Model model) {
        return this.serverToken(serverTokenModel, model);
    }

    public String serverToken(@ModelAttribute ServerTokenModel serverTokenModel, Model model) {
        ServerTokenListDto tokenListDto;
        Object msg = "";
        model.addAttribute("dockerService", (Object)this.dockerService);
        RestLoginService restLoginService = this.lettoService.getRestLoginServiceAdmin();
        String button = serverTokenModel.getUserAction();
        if (button != null) {
            switch (button) {
                case "create": {
                    GetServerTokenRequest tokenRequest = serverTokenModel.calcServerTokenRequest();
                    String token = restLoginService.getServerToken(tokenRequest);
                    serverTokenModel.setServertoken(token);
                    break;
                }
                case "cancel": {
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "check": {
                    String fingerprint = "setupfingerprintempty";
                    String ipaddress = "";
                    String token = serverTokenModel.getServertoken();
                    RestLoginService loginService = this.lettoService.getLoginService();
                    if (serverTokenModel.isNocheck()) {
                        UserTokenRequestDto request = new UserTokenRequestDto(serverTokenModel.getServertoken(), serverTokenModel.getUsername(), "", "", "", serverTokenModel.getSchool(), "de", "", true, fingerprint);
                        String usertoken = loginService.getUserTokenDirect(request);
                        if (usertoken == null || usertoken.length() == 0) {
                            msg = "failed to create Temptoken";
                            break;
                        }
                        msg = "Temptoken created: " + usertoken;
                        break;
                    }
                    ArrayList roles = new ArrayList();
                    LettoToken fremdtoken = new LettoToken(this.microServiceConfiguration.getJwtSecret(), "LeTTo-Login", "LeTTo", Long.valueOf(10000L), serverTokenModel.getUsername(), "", "", "", "", "de", Integer.valueOf(0), Integer.valueOf(0), serverTokenModel.getSchool(), "", "", "", roles);
                    String usertoken = loginService.getUserToken(serverTokenModel.getServertoken(), fremdtoken.getToken(), "de", "", true, fingerprint, ipaddress);
                    msg = usertoken == null || usertoken.length() == 0 ? "failed to create Temptoken" : "Temptoken created: " + usertoken;
                }
            }
            Matcher m = Pattern.compile("^(\\d+)([^\\d].*)$").matcher(button);
            if (m.find()) {
                try {
                    String cmd;
                    long id = Long.parseLong(m.group(1));
                    switch (cmd = m.group(2)) {
                        case "open": {
                            GeneratedServerToken token = restLoginService.loadServerToken(id);
                            serverTokenModel.setCheckEndpoint(token.getCheckEndpoint());
                            serverTokenModel.setAdmin(token.isAdmin());
                            serverTokenModel.setGlobal(token.isGlobal());
                            serverTokenModel.setStudent(token.isStudent());
                            serverTokenModel.setTeacher(token.isTeacher());
                            serverTokenModel.setCreate(token.isCreate());
                            serverTokenModel.setServerDomainName(token.getServerDomainName());
                            serverTokenModel.setNocheck(token.isNocheck());
                            serverTokenModel.setSchool(token.getSchool());
                            serverTokenModel.setServiceEndpoint(token.getServiceEndpoint());
                            serverTokenModel.setRefresh(token.isRefresh());
                            serverTokenModel.setUsername(token.getUsername());
                            serverTokenModel.setExpiration(Datum.toDauerString((long)token.getExpiration()));
                            serverTokenModel.setServertoken("");
                            break;
                        }
                        case "delete": {
                            if (restLoginService.removeServerToken(id)) {
                                msg = "Token " + id + " deleted";
                                break;
                            }
                            msg = "Token " + id + " not found";
                            break;
                        }
                        case "activate": {
                            if (restLoginService.activateServerToken(id)) {
                                msg = "Token " + id + " activated";
                                break;
                            }
                            msg = "Token " + id + " not found";
                            break;
                        }
                        case "deactivate": {
                            msg = restLoginService.deactivateServerToken(id) ? "Token " + id + " deactivated" : "Token " + id + " not found";
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((tokenListDto = restLoginService.getServerTokenList()) == null) {
            tokenListDto = new ServerTokenListDto();
        }
        if (serverTokenModel.getCheckEndpoint() == null && serverTokenModel.getServerDomainName() == null) {
            serverTokenModel.setCheckEndpoint("/login/api/tokeninfo");
        }
        model.addAttribute("msg", msg);
        model.addAttribute("model", (Object)serverTokenModel);
        model.addAttribute("tokens", (Object)tokenListDto.getTokens());
        return "servertoken";
    }
}

