/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.configFiles.SchuleEnv;
import at.letto.setupservice.model.FileInfoDto;
import at.letto.setupservice.service.BackupService;
import at.letto.setupservice.service.DatabaseService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.EmailService;
import at.letto.tools.Datum;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrontabService {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private DatabaseService databaseService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    private Logger logger = LoggerFactory.getLogger(CrontabService.class);

    public String checkHarddiskMemory() {
        Object msg = "";
        if (this.dockerService.isDockerRunning()) {
            int MEMORY_LIMIT = this.dockerService.dockerConfiguration.getSetupEnvFile().getBackupMinFreeDiskspaceMB();
            int diskFreeMB = this.dockerService.getSystemStatusDto().getUseableDiskSpaceMB();
            if (diskFreeMB < MEMORY_LIMIT) {
                this.logger.warn("Free diskspace: " + diskFreeMB + " MB - less then " + MEMORY_LIMIT + "MB!");
                msg = "<h1>" + this.dockerService.getServerName() + "</h1>";
                msg = (String)msg + "Free diskspace: " + diskFreeMB + " MB";
                msg = (String)msg + "<br/>DISK MEMORY LOW<br/>";
                try {
                    this.emailService.sendHtmlMessage(this.dockerService.getAdminEmail(), this.dockerService.getServerName() + " DISK MEMORY LOW", (String)msg);
                }
                catch (Exception e) {
                    this.logger.error("Cannot send email to admin: " + this.dockerService.getAdminEmail());
                }
            } else {
                msg = "Free diskspace: " + diskFreeMB + " MB<br/>";
                this.logger.info((String)msg);
            }
        } else {
            msg = "Not Docker setup service - no disk memory check<br/>";
        }
        return msg;
    }

    public String checkDumpFile(String filename, List<FileInfoDto> files) {
        Object msg = "";
        for (FileInfoDto info : files) {
            if (!info.getFilename().trim().equals(filename.trim())) continue;
            long ageSeconds = Datum.secondsToNow((Date)info.getDate());
            if (ageSeconds > 86400L) {
                msg = "backup " + filename + " is older then 24 hours, from " + Datum.toString((Date)info.getDate());
                this.logger.error((String)msg);
                return msg;
            }
            if (info.getSize() < 1000L) {
                msg = "backup " + filename + " filesize is less then 1kB - size: " + info.getSize();
                this.logger.error((String)msg);
                return msg;
            }
            msg = "backup " + filename + " ok, size: " + info.getSize() + " from " + Datum.toString((Date)info.getDate());
            this.logger.info((String)msg);
            return "OK!" + (String)msg;
        }
        msg = "backup " + filename + " not found ";
        this.logger.error((String)msg);
        return msg;
    }

    public String checkDatabaseDump() {
        Object msg = "";
        if (this.dockerService.isDockerRunning()) {
            List files = this.backupService.loadDatabaseDumpFiles();
            boolean ok = true;
            Vector schulelist = this.dockerService.dockerConfiguration.getLettoEnvFile().getSchulen();
            for (SchuleEnv s : schulelist) {
                String school = s.school;
                String dumpfileName = this.databaseService.schoolDatabaseDumpFile(school);
                String message = this.checkDumpFile(dumpfileName, files) + "<br/>";
                if (message.startsWith("OK!")) {
                    msg = (String)msg + message.substring(3);
                    continue;
                }
                ok = false;
                msg = (String)msg + message;
            }
            String dumpfileName = "lettolti.sql";
            String message = this.checkDumpFile(dumpfileName, files) + "<br/>";
            if (message.startsWith("OK!")) {
                msg = (String)msg + message.substring(3);
            } else {
                ok = false;
                msg = (String)msg + message;
            }
            if (!ok) {
                try {
                    this.emailService.sendHtmlMessage(this.dockerService.getAdminEmail(), this.dockerService.getServerName() + " Backup Problems!", "<h1>" + this.dockerService.getServerName() + "</h1>" + (String)msg);
                }
                catch (Exception e) {
                    this.logger.error("Cannot send email to admin: " + this.dockerService.getAdminEmail());
                }
            }
        } else {
            msg = "Not main setup service - no database-dump check<br/>";
        }
        return msg;
    }
}

