/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.basespringboot.security.MessageService;
import at.letto.databaseclient.modelMongo.login.LeTToSession;
import at.letto.databaseclient.modelMongo.login.LeTToUser;
import at.letto.databaseclient.modelMongo.login.LeTToUserWithSessions;
import at.letto.databaseclient.service.LettoUserLoginService;
import at.letto.login.restclient.RestLoginService;
import at.letto.security.LettoToken;
import at.letto.setupservice.beans.SessionBean;
import at.letto.setupservice.beans.UserBean;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.model.UsersModel;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LettoService;
import jakarta.annotation.Resource;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class UserInfoController {
    private Logger logger = LoggerFactory.getLogger(UserInfoController.class);
    @Autowired
    private DockerService dockerService;
    @Autowired
    private LettoUserLoginService lettoUserLoginService;
    @Autowired
    private LettoService lettoService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Resource(name="sessionBean")
    SessionBean sessionBean;
    @Resource(name="userBean")
    UserBean userBean;

    @RequestMapping(value={"/config/session/admin/users"})
    public String users(@ModelAttribute UsersModel usersModel, Model model) {
        Object msg = "";
        model.addAttribute("dockerService", (Object)this.dockerService);
        model.addAttribute("action", (Object)"/config/session/admin/users");
        List usersLoggedIn = this.lettoUserLoginService.getLoggedInUsers();
        usersLoggedIn.sort(Comparator.comparing(LeTToUserWithSessions::loggedInSortString));
        List usersLoggedOut = this.lettoUserLoginService.lastLoggedOutUsersSessionsLastSeconds(3600L);
        usersLoggedOut.sort(Comparator.comparing(LeTToUserWithSessions::loggedOutSort));
        String button = usersModel.getUserAction();
        if (button != null) {
            switch (button) {
                case "cancel": {
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "reload": {
                    break;
                }
                default: {
                    if (button.startsWith("Logout-")) {
                        String id = button.substring(7).trim();
                        try {
                            LettoToken loginToken;
                            int i = -1;
                            for (int j = 0; j < usersLoggedIn.size(); ++j) {
                                if (!((LeTToUserWithSessions)usersLoggedIn.get(j)).getId().equals(id)) continue;
                                i = j;
                                break;
                            }
                            if (i < 0) break;
                            LeTToUser user = ((LeTToUserWithSessions)usersLoggedIn.get(i)).getUser();
                            RestLoginService restLoginService = this.lettoService.getLoginService();
                            boolean result = restLoginService.logout((loginToken = this.sessionBean.getLettoToken()).getToken(), user.getUsername(), user.getSchool());
                            msg = !result ? "Logout from " + user.getUsername() + "@" + user.getSchool() + " failed" : "Logout from " + user.getUsername() + "@" + user.getSchool() + " successful";
                            usersLoggedIn = this.lettoUserLoginService.getLoggedInUsers();
                            usersLoggedIn.sort(Comparator.comparing(LeTToUserWithSessions::loggedInSortString));
                            usersLoggedOut = this.lettoUserLoginService.lastLoggedOutUsersSessionsLastSeconds(3600L);
                            usersLoggedOut.sort(Comparator.comparing(LeTToUserWithSessions::loggedOutSort));
                        }
                        catch (Exception i) {}
                        break;
                    }
                    if (!button.startsWith("User-")) break;
                    String id = button.substring(5).trim();
                    try {
                        LeTToUser user;
                        int i = -1;
                        for (int j = 0; j < usersLoggedIn.size(); ++j) {
                            if (!((LeTToUserWithSessions)usersLoggedIn.get(j)).getId().equals(id)) continue;
                            i = j;
                            break;
                        }
                        if (i >= 0 && (user = ((LeTToUserWithSessions)usersLoggedIn.get(i)).getUser()) != null) {
                            this.userBean.loadUser(user);
                            this.userBean.setBackEndpoint("/config/session/admin/users");
                            model.addAttribute("userBean", (Object)this.userBean);
                            model.addAttribute("usersModel", (Object)this.userBean.usersModel());
                            model.addAttribute("sessionID", (Object)this.sessionBean.getLettoToken().getServersession());
                            return "redirect:/config/session/admin/user";
                        }
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        model.addAttribute("msg", msg);
        model.addAttribute("model", (Object)usersModel);
        model.addAttribute("usersLoggedIn", (Object)usersLoggedIn);
        model.addAttribute("usersLoggedOut", (Object)usersLoggedOut);
        return "users";
    }

    @RequestMapping(value={"/config/session/admin/user"})
    public String user(@ModelAttribute UsersModel usersModel, Model model) {
        Object msg = "";
        model.addAttribute("dockerService", (Object)this.dockerService);
        model.addAttribute("action", (Object)"/config/session/admin/user");
        String button = usersModel.getUserAction();
        if (button != null) {
            switch (button) {
                case "cancel": {
                    if (this.userBean.getBackEndpoint() == null || this.userBean.getBackEndpoint().trim().length() == 0) {
                        return "redirect:" + this.dockerService.welcomeEP();
                    }
                    return "redirect:" + this.userBean.getBackEndpoint();
                }
                case "reload": {
                    this.userBean.loadUser(this.userBean.getUser());
                    break;
                }
                case "save": {
                    this.userBean.saveUsersModel(usersModel);
                    this.userBean.saveUser();
                    usersModel = this.userBean.usersModel();
                    msg = "Benutzer " + usersModel.getUsername() + " gespeichert";
                }
                default: {
                    if (button.startsWith("Logout-")) {
                        String id = button.substring(7).trim();
                        try {
                            int i = -1;
                            for (int j = 0; j < this.userBean.getSessions().size(); ++j) {
                                if (!((LeTToSession)this.userBean.getSessions().get(j)).getId().equals(id)) continue;
                                i = j;
                                break;
                            }
                            if (i < 0) break;
                            LeTToSession session = (LeTToSession)this.userBean.getSessions().get(i);
                            this.lettoUserLoginService.logout(session);
                            this.userBean.loadUser(this.userBean.getUser());
                            msg = "user " + usersModel.getUsername() + " logged out";
                        }
                        catch (Exception ex) {
                            msg = "Logout failed: " + ex.getMessage();
                        }
                        break;
                    }
                    if (!button.startsWith("Delete-")) break;
                    String id = button.substring(7).trim();
                    try {
                        int i = -1;
                        for (int j = 0; j < this.userBean.getSessions().size(); ++j) {
                            if (!((LeTToSession)this.userBean.getSessions().get(j)).getId().equals(id)) continue;
                            i = j;
                            break;
                        }
                        if (i < 0) break;
                        LeTToSession session = (LeTToSession)this.userBean.getSessions().get(i);
                        this.lettoUserLoginService.delete(session);
                        this.userBean.loadUser(this.userBean.getUser());
                        msg = "session deleted for user " + usersModel.getUsername();
                        break;
                    }
                    catch (Exception ex) {
                        msg = "Delete failed: " + ex.getMessage();
                    }
                }
            }
        }
        model.addAttribute("userBean", (Object)this.userBean);
        model.addAttribute("usersModel", (Object)this.userBean.usersModel());
        model.addAttribute("msg", msg);
        model.addAttribute("sessionID", (Object)this.sessionBean.getLettoToken().getServersession());
        return "user";
    }
}

