/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.beans;

import at.letto.data.dto.user.UserKeyDto;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.databaseclient.modelMongo.login.LeTToSession;
import at.letto.databaseclient.modelMongo.login.LeTToUser;
import at.letto.databaseclient.service.LettoUserLoginService;
import at.letto.setupservice.model.UsersModel;
import at.letto.setupservice.service.LettoService;
import at.letto.tools.Datum;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserBean {
    private Logger logger = LoggerFactory.getLogger(UserBean.class);
    @Autowired
    private LettoService lettoService;
    @Autowired
    private LettoUserLoginService lettoUserLoginService;
    private LeTToUser user = null;
    private RestLettoDataService restLettoDataService;
    private UserKeyDto userKeyDto = null;
    private String backEndpoint = "";
    private List<LeTToSession> sessions = new ArrayList();

    public void loadUser(LeTToUser user) {
        if (user == null) {
            this.user = null;
            this.restLettoDataService = null;
            this.userKeyDto = null;
            return;
        }
        this.user = user;
        try {
            this.restLettoDataService = this.lettoService.getLettoDataService(user.getSchool());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.restLettoDataService == null) {
            this.userKeyDto = null;
            this.logger.error("cannot set RestLettoDataService for user " + user.getUsername() + "@" + user.getSchool());
        } else {
            try {
                this.userKeyDto = this.restLettoDataService.getUserById(Integer.valueOf((int)user.getUserId()));
            }
            catch (Exception ex) {
                this.logger.error("cannot load user " + user.getUsername() + "@" + user.getSchool());
            }
        }
        this.sessions = this.lettoUserLoginService.getSessionsForUser(user.getId());
        this.sessions.sort(Comparator.comparing(LeTToSession::sortTime));
    }

    public void saveUser() {
        if (this.user == null) {
            this.logger.error("Cannot save user, because user is null");
            return;
        }
        if (this.restLettoDataService == null) {
            this.logger.error("Cannot save user, because restLettoDataService is null");
            return;
        }
        this.restLettoDataService.saveUser(this.userKeyDto);
    }

    public UsersModel usersModel() {
        if (this.user == null) {
            this.logger.error("Cannot get UsersModel, because user is null");
            return new UsersModel();
        }
        if (this.userKeyDto == null) {
            this.logger.error("Cannot get UsersModel, because userKeyDto is null");
            return new UsersModel(null, this.user.getUsername(), this.user.getVorname(), this.user.getNachname(), Integer.valueOf(0), "", null, Boolean.valueOf(false), Boolean.valueOf(false), this.user.getEmail(), Integer.valueOf(0), Boolean.valueOf(this.user.isAdmin()), Boolean.valueOf(false), Boolean.valueOf(this.user.isGlobal()), Boolean.valueOf(true), Boolean.valueOf(this.user.isStudent()), Boolean.valueOf(this.user.isTeacher()), "", Boolean.valueOf(false), Boolean.valueOf(false), "", Boolean.valueOf(false), "", Long.valueOf(0L), "", "", "", "", "", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        }
        return new UsersModel(null, this.user.getUsername(), this.userKeyDto.getVorname(), this.userKeyDto.getNachname(), this.userKeyDto.getIDAbteilung(), this.userKeyDto.getActiveDirectoryName(), this.userKeyDto.getBirthdate(), this.userKeyDto.getChangeAbosPossible(), this.userKeyDto.getDisabled(), this.userKeyDto.getEmail(), this.userKeyDto.getHtlID(), this.userKeyDto.getAdmin(), this.userKeyDto.getExtern(), this.userKeyDto.getGlobal(), this.userKeyDto.getMann(), this.userKeyDto.getStudent(), this.userKeyDto.getTeacher(), this.userKeyDto.getLicence(), this.userKeyDto.getUseSchoolLicence(), this.userKeyDto.getMultipleLogin(), "", this.userKeyDto.getPayingStudent(), this.userKeyDto.getPersNo(), this.userKeyDto.getSassID(), this.userKeyDto.getSokratesID(), this.userKeyDto.getSvnPasswort(), this.userKeyDto.getSVNr(), this.userKeyDto.getTel(), this.userKeyDto.getSprache(), this.userKeyDto.getUseAbosCategory(), this.userKeyDto.getUseAbosUsers(), this.userKeyDto.getUseCurrentYear());
    }

    public void saveUsersModel(UsersModel usersModel) {
        if (this.user == null) {
            this.logger.error("Cannot set UsersModel, because user is null");
            return;
        }
        this.user.setUsername(usersModel.getUsername());
        this.user.setVorname(usersModel.getVorname());
        this.user.setNachname(usersModel.getNachname());
        this.user.setEmail(usersModel.getEmail());
        this.user.setAdmin(usersModel.isAdmin());
        this.user.setGlobal(usersModel.isGlobalFlag());
        this.user.setTeacher(usersModel.isTeacher());
        this.user.setStudent(usersModel.isStudent());
        this.user.setLdapName(usersModel.getActiveDirectoryName());
        if (usersModel == null) {
            this.logger.error("Cannot set UsersModel, because usersModel is null");
            return;
        }
        this.userKeyDto.setName(usersModel.getUsername());
        this.userKeyDto.setVorname(usersModel.getVorname());
        this.userKeyDto.setNachname(usersModel.getNachname());
        this.userKeyDto.setIDAbteilung(this.userKeyDto.getIDAbteilung());
        this.userKeyDto.setActiveDirectoryName(usersModel.getActiveDirectoryName());
        try {
            this.userKeyDto.setBirthdate(Datum.parse((String)usersModel.getBirthdate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.userKeyDto.setChangeAbosPossible(Boolean.valueOf(usersModel.isChangeAbosPossible()));
        this.userKeyDto.setDisabled(Boolean.valueOf(usersModel.isDisabled()));
        this.userKeyDto.setEmail(usersModel.getEmail());
        this.userKeyDto.setHtlID(Integer.valueOf(usersModel.getHtlID()));
        this.userKeyDto.setAdmin(Boolean.valueOf(usersModel.isAdmin()));
        this.userKeyDto.setExtern(Boolean.valueOf(usersModel.isExtern()));
        this.userKeyDto.setGlobal(Boolean.valueOf(usersModel.isGlobalFlag()));
        this.userKeyDto.setMann(Boolean.valueOf(usersModel.isMann()));
        this.userKeyDto.setStudent(Boolean.valueOf(usersModel.isStudent()));
        this.userKeyDto.setTeacher(Boolean.valueOf(usersModel.isTeacher()));
        this.userKeyDto.setLicence(usersModel.getLicence());
        this.userKeyDto.setUseSchoolLicence(Boolean.valueOf(usersModel.isUseSchoolLicence()));
        this.userKeyDto.setMultipleLogin(Boolean.valueOf(usersModel.isMultipleLogin()));
        this.userKeyDto.setPayingStudent(Boolean.valueOf(usersModel.isPayingStudent()));
        this.userKeyDto.setPersNo(usersModel.getPersNo());
        this.userKeyDto.setSassID(Long.valueOf(usersModel.getSassID()));
        this.userKeyDto.setSokratesID(usersModel.getSokratesID());
        this.userKeyDto.setSvnPasswort(usersModel.getSvnPasswort());
        this.userKeyDto.setSVNr(usersModel.getSVNr());
        this.userKeyDto.setTel(usersModel.getTel());
        this.userKeyDto.setSprache(usersModel.getSprache());
        this.userKeyDto.setUseAbosCategory(Boolean.valueOf(usersModel.isUseAbosCategory()));
        this.userKeyDto.setUseAbosUsers(Boolean.valueOf(usersModel.isUseAbosUsers()));
        this.userKeyDto.setUseCurrentYear(Boolean.valueOf(usersModel.isUseCurrentYear()));
    }

    public long getIdUser() {
        return this.user.getUserId();
    }

    public long getIdSchool() {
        return this.user.getSchoolId();
    }

    public String getId() {
        return this.user.getId();
    }

    public String getSchool() {
        return this.user.getSchool();
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public LettoService getLettoService() {
        return this.lettoService;
    }

    @Generated
    public LettoUserLoginService getLettoUserLoginService() {
        return this.lettoUserLoginService;
    }

    @Generated
    public LeTToUser getUser() {
        return this.user;
    }

    @Generated
    public RestLettoDataService getRestLettoDataService() {
        return this.restLettoDataService;
    }

    @Generated
    public UserKeyDto getUserKeyDto() {
        return this.userKeyDto;
    }

    @Generated
    public String getBackEndpoint() {
        return this.backEndpoint;
    }

    @Generated
    public List<LeTToSession> getSessions() {
        return this.sessions;
    }

    @Generated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Generated
    public void setLettoService(LettoService lettoService) {
        this.lettoService = lettoService;
    }

    @Generated
    public void setLettoUserLoginService(LettoUserLoginService lettoUserLoginService) {
        this.lettoUserLoginService = lettoUserLoginService;
    }

    @Generated
    public void setUser(LeTToUser user) {
        this.user = user;
    }

    @Generated
    public void setRestLettoDataService(RestLettoDataService restLettoDataService) {
        this.restLettoDataService = restLettoDataService;
    }

    @Generated
    public void setUserKeyDto(UserKeyDto userKeyDto) {
        this.userKeyDto = userKeyDto;
    }

    @Generated
    public void setBackEndpoint(String backEndpoint) {
        this.backEndpoint = backEndpoint;
    }

    @Generated
    public void setSessions(List<LeTToSession> sessions) {
        this.sessions = sessions;
    }

    @Generated
    public UserBean() {
    }
}

