/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.configFiles.SetupEnvFile;
import at.letto.setupservice.model.docker.DockerContainerDto;
import at.letto.setupservice.model.docker.DockerStatusDto;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WatchdogService {
    static final Logger LOGGER = LoggerFactory.getLogger(WatchdogService.class);
    @Autowired
    private DockerService dockerService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private DockerConfiguration dockerConfiguration;
    private HashMap<String, Long> container_CPU_WatchdogTime = new HashMap();

    public void watchdog() {
        SetupEnvFile setupEnv = this.dockerConfiguration.getSetupEnvFile();
        int watchdogCpu = setupEnv.getWatchdogMaxCpu();
        int watchdogTime = setupEnv.getWatchdogMaxTime();
        if (this.dockerService.isMainSetupService() && setupEnv.isWatchdog()) {
            DockerStatusDto status = this.dockerService.getDockerStatus();
            for (DockerContainerDto container : status.getContainers()) {
                boolean restart = false;
                String stat = container.getStatus();
                if (container.running() && !container.healthy() && !container.starting()) {
                    restart = true;
                }
                int containerCpu = container.getCpuProzent();
                int cpuLastMinute = (int)(this.dockerService.getCpuTrendDto().getAvCpuLoadLastMinute() * 100.0 + 0.5);
                if (containerCpu > watchdogCpu && !container.starting()) {
                    long time = System.currentTimeMillis() / 1000L;
                    if (this.container_CPU_WatchdogTime.containsKey(container.getName()) && this.container_CPU_WatchdogTime.get(container.getName()) != null) {
                        long seit = (Long)this.container_CPU_WatchdogTime.get(container.getName());
                        int dauer = (int)(time - seit);
                        if (dauer > watchdogTime) {
                            restart = true;
                        }
                    } else {
                        this.container_CPU_WatchdogTime.put(container.getName(), time);
                    }
                    LOGGER.info("Container " + container.getName() + " high CPU:" + containerCpu + "% System-CPU:" + cpuLastMinute + "%");
                } else if (this.container_CPU_WatchdogTime.containsKey(container.getName())) {
                    this.container_CPU_WatchdogTime.remove(container.getName());
                }
                if (!restart) continue;
                LOGGER.warn("Container " + container.getName() + " is unhealthy -> restart in Background!");
                CmdThread t = this.cmdService.cmdScriptBackground("", "", new String[]{"docker restart " + container.getName()});
                this.container_CPU_WatchdogTime.remove(container.getName());
            }
        }
    }
}

