/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.setup.dto.CmdResultDto;
import at.letto.setup.dto.CommandDto;
import at.letto.setupservice.service.ImpLocalSetupService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
@Tag(name="Local Api Controller", description="Endpoints die auf der lokalen Instanz des Setup-Services laufen!")
public class LocalAPIController {
    @Autowired
    ImpLocalSetupService impLocalSetupService;

    @Operation(summary="Command", hidden=true, description="starten ein Kommando auf der lokalen Commandline<br>Body: [CommandDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/CommandDto.html)<br>Result: [CmdResultDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/setup/dto/CmdResultDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/setup/auth/user/cmd"})
    public ResponseEntity<CmdResultDto> callCommand(@RequestBody CommandDto dto) {
        CmdResultDto result = this.impLocalSetupService.callCommand(dto);
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="starte Letto Docker ", hidden=true, description="starte Proxy und Login im Docker Container<br>Result: String - Ergebnis Meldung", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/setup/auth/user/lettodockerstart"})
    public ResponseEntity<String> lettoDockerStart() {
        String result = this.impLocalSetupService.lettoDockerStart();
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="stoppe Letto Docker ", hidden=true, description="stoppe Proxy und Login im Docker Container<br>Result: String - Ergebnis Meldung", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/setup/auth/user/lettodockerstop"})
    public ResponseEntity<String> lettoDockerStop() {
        String result = this.impLocalSetupService.lettoDockerStop();
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="update Letto Docker ", hidden=true, description="aktualisiere Proxy und Login im Docker Container<br>Result: String - Ergebnis Meldung", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/setup/auth/user/lettodockerupdate"})
    public ResponseEntity<String> lettoDockerUpdate() {
        String result = this.impLocalSetupService.lettoDockerUpdate();
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="restarte Letto Docker ", hidden=true, description="restarte Proxy und Login im Docker Container<br>Result: String - Ergebnis Meldung", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/setup/auth/user/lettodockerrestart"})
    public ResponseEntity<String> lettoDockerRestart() {
        String result = this.impLocalSetupService.lettoDockerRestart();
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="starte Setup Docker ", hidden=true, description="starte das Setup im Docker Container<br>Result: String - Ergebnis Meldung", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/setup/auth/user/setupdockerstart"})
    public ResponseEntity<String> setupDockerStart() {
        String result = this.impLocalSetupService.setupDockerStart();
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="stoppe Setup Docker ", hidden=true, description="stoppe das Setup im Docker Container<br>Result: String - Ergebnis Meldung", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/setup/auth/user/setupdockerstop"})
    public ResponseEntity<String> setupDockerStop() {
        String result = this.impLocalSetupService.setupDockerStop();
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="restarte Setup Docker ", hidden=true, description="restarte das Setup im Docker Container<br>Result: String - Ergebnis Meldung", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/setup/auth/user/setupdockerrestart"})
    public ResponseEntity<String> setupDockerRestart() {
        String result = this.impLocalSetupService.setupDockerRestart();
        return ResponseEntity.ok((Object)result);
    }

    @Operation(summary="update Setup Docker ", hidden=true, description="update das Setup im Docker Container<br>Result: String - Ergebnis Meldung", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/setup/auth/user/setupdockerupdate"})
    public ResponseEntity<String> setupDockerUpdate() {
        String result = this.impLocalSetupService.setupDockerUpdate();
        return ResponseEntity.ok((Object)result);
    }
}

