var toggler;

function initTree() {
    toggler = document.getElementsByClassName("caret");
    var i;

    for (i = 0; i < toggler.length; i++) {
        toggler[i].addEventListener("click", function() {
            this.parentElement.querySelector(".nested").classList.toggle("active");
            this.classList.toggle("caret-down");
        });
    }
}

$(document).ready(function() {
    initTree();
    initMathJax();
});

function renderCategoryTree() {
    let maincat = post(`${serverPath()}/open/cat_loadtree`);
    // Kategoriebaum aufbauen
    let html = `<div class="tree"><ul>`;
    for (let c of maincat) html+=renderCat(c, true);
    html+="</ul></div>";
    let cat = document.getElementById("maincat");
    if (cat)
        cat.innerHTML = html;

    initTree();
    // execPostRequest(`${path}/cat_loadtree`, function (maincat) {
    // })
}

function renderCat(c, nested) {
    let html = `<li><span class="caret nolinebreak">${c.name}</span>`;
    html+=`<ul ${nested?'class="nested"':''}>`;
    for (let child of c.categories) {
        html+=renderCat(child, true);
    }
    for (let q of c.questions) {
        html+=`<div onclick="loadQuestion(${q.id});"
                 class="link nolinebreak" >${q.name} (${q.id})</div>`;
    }
    html+='</ul>';
    html+="</li>";
    return html;
}