// Step 1
const sliderDrag = interact('.slider')    // target elements with the "slider" class

$(document).ready(function(){
    $(".slider").each(function( sl ) {
        let val = this.getAttribute("val");
        if (val) {
            let min = parseFloat(this.getAttribute("min"));
            let max = parseFloat(this.getAttribute("max"));
            if (!min) min = 0;
            if (!max) max = 1;
            val = parseFloat(val);
            if (val>max) val=max;
            if (val<min) val=min;
            let proz = (val-min)/(max-min)*100;
            this.style.paddingLeft = proz+"%";
            this.classList.add("val");
        }
    });
});


sliderDrag
    // Step 2
    .draggable({                        // make the element fire drag events
        origin: 'self',                   // (0, 0) will be the element's top-left
        inertia: true,                    // start inertial movement if thrown
        modifiers: [
            interact.modifiers.restrict({
                restriction: 'self'           // keep the drag coords within the element
            })
        ],
        // Step 3
        listeners: {
            move (event) {
                // call this listener on every dragmove
                const sliderWidth = interact.getElementRect(event.target).width
                const value = event.pageX / sliderWidth
                let min = parseFloat(event.target.getAttribute("min"));
                let max = parseFloat(event.target.getAttribute("max"));
                if (!min) min = 0;
                if (!max) max = 1;
                let val = min + (max-min)*parseFloat(value);
                event.target.style.paddingLeft = (value * 100) + '%'
                event.target.setAttribute('val', val.toFixed(2));
                event.target.classList.add("val");
            }
        }
    })

