class SubQuestion {
    constructor(sqAngabe, antwort, parent, erg) {
        this.mode = sqAngabe.mode;
        this.name = sqAngabe.name;
        this.parent = parent;
        this.sqAngabe = sqAngabe;
        if (erg) {
            this.erg = erg.filter(sq=>{if (sq.name == sqAngabe.name) return sq;})[0];
        }
        this.sqOrigAngabe = JSON.parse(JSON.stringify(sqAngabe));
        // Suchen der Antworten zu der Teilfrage
        this.sqAntwort = antwort.sqAntworten.filter(a => {if (a.sq == sqAngabe.name) return a;})[0];
        this.connectHtmlWithInput();
    }

    resetSubQuestion(antwort) {
        this.sqAngabe = JSON.parse(JSON.stringify(this.sqOrigAngabe));
        this.sqAntwort = antwort.sqAntworten.filter(a => {if (a.sq == this.name) return a;})[0];
        this.connectHtmlWithInput();
    }

    /**
     * Verbindung HTML-Angabe mit Antworten zur Teilfrage
     */
    connectHtmlWithInput() {
        for (let ansHtml of this.sqAngabe.answers) {
            ansHtml.inp = this.sqAntwort.antworten[ansHtml.index];
        }
    }
    /**
     *
     * @returns {string}
     */
    renderSq() {
        return '';
    }

    /**
     * Ermittlung des Image-Strings für eine Beurteilung (FALSCh, RICHTIG,....)
     * @param score
     * @returns {string}
     */
    scoreImage(score, margin) {
        let iconClass = margin ? "scoreIcon2" : "scoreIcon";
        let space ='<span style="width: 25px; display: inline-block;">&nbsp;</span>';
        switch (score) {
            case 'FALSCH':
                return `<img src="${serverPath(relpath)}/open/img/falsch.png" class="${iconClass}">${space}`;
            case 'OK':
                return `<img src="${serverPath(relpath)}/open/img/ok.png" class="${iconClass}">${space}`;
            case 'EINHEITENFEHLER':
            case 'TEILWEISE_OK':
                return `<img src="${serverPath(relpath)}/open/img/teilrichtig.png" class="${iconClass}">${space}`;
        }
        return "";
    }

    initPlugin() {
    }
}

