class MultiChoice extends SubQuestion {
    constructor(sq, antwort, parent, erg) {
        super(sq, antwort, parent, erg);
    }
    renderSq() {
        let html =
            `<div class="ui-datatable-tablewrapper">
                <table role="grid">
                    <thead></thead>
                    <tbody class="ui-datatable-data ui-widget-content1">`;
        let i=0;
        for (let ax of this.sqAngabe.answers) {
            let inp = ax.inp;
            //let ans = a.antworten[i];
            if (this.erg)
                html += this.mc_line(inp.input=="1", ax.htmlText, i++, this.erg.antworten[ax.index]=="1");

            else html += this.mc_line(inp.input=="1", ax.htmlText, i++);
        }
        html+=`</tbody></table></div>`;
        return html;
    }


    /**
     * Vorbereitung für Zeile einer Multiple-Choice-Frage
     * @param sq    Aktuelle Subquestion die MC-Teilfrage enthält
     * @param check Angabe, ob Checkbox ausgewählt wiurde
     * @param txt   HTML-Text hinter der Checkbox
     * @param nr    Zeilennummer, bei 0 beginnend
     * @returns {string}
     */
    mc_line(check, txt, nr, erg) {
        //let a = answerDto.sqAntworten.filter(a => {if (a.sq == this.name) return a;});
        //let ans = a[0].antworten[nr];
        //let id = this.name+'_'+nr;
        //answer_map.set(id, ans ) ;

        let iconChecked = loadIcon('checkbox_full');
        let iconEmpty = loadIcon('checkbox_empty');
        let score = erg!=undefined ? ( erg==check ? "OK":"FALSCH" ) : "";
        // let mark = erg!=undefined ?  ( erg ? `<td style="width: 30px; font-size: 1.3rem"><i class="${iconChecked}"></i></td>`:`<td style="width: 30px; font-size: 1.3rem"><i class="${iconEmpty}"></i></td>` ) : "";
        let iconText = erg!=undefined ? 'checkbox_empty':'';
        if (erg) iconText = 'checkbox_full';
        let mark = iconText ? `<td style="width: 30px; font-size: 1.3rem; padding-left:6px; padding-bottom: 5px" class="${score}_frame">
                <i class="${loadIcon(iconText)}"></i>
               </td>` : '';
        let disabled = erg!=undefined ? " disabled " : "";
        let line = `
        <tr class="ui-widget-content1 ui-datatable-even " role="row">
            ${mark}
            <td style="vertical-align: top; text-align:center; width: 30px" class="${score}" role="gridcell">
                <label class="container" style="padding:10px;">
                    <input type="checkbox" ${check ? 'checked' : ''} 
                        ${disabled}
                        id="${this.name}_${nr}"
                        onclick="updateInputField(this.id, this.checked?'1':'0')">
                    <span class="checkmark"></span>
                </label>
            </td>
        
            <td class="${score}">${txt}</td>
        </tr>`;
        return line;
    }

}

