class Zuordnung extends SubQuestion {
    constructor(sq, antwort, parent, erg) {
        super(sq, antwort, parent, erg);
    }
    renderSq() {
//        const sq = JSON.parse(JSON.stringify(sq_));
//        sq.inputs = sqAnsers;
        let html = '';
        let pos=0;
        let links=[];
        links.push.apply(links, this.sqAngabe.answers);
        let rechts = this.sqAngabe.rightSides;

        if (this.erg) {
            html += `
            <div >
                <table class="border">
                <thead></thead>
                <tbody >
                <tr><td style="width: 33%">Text</td><td style="width: 33%">Antwort</td><td style="width: 33%">richtige Lösung</td></tr>`;

            for (let a of this.sqAngabe.answers) {
                let inp = this.sqAntwort.antworten[a.index].input;
                let studentInp = inp ? rechts.filter(a=>a.shortAnswer==inp)[0] : "";
                let e = this.erg.antworten[a.index];
                let korrekt = e ? rechts.filter(a=>a.shortAnswer==e)[0] : "";
                let score = e==inp ? "OK" : "FALSCH";
                html+=`<tr class="${score}">
                            <td class="">${a.htmlText}</td>
                            <td class="">${studentInp?studentInp.htmlAnswer:''}</td>
                            <td class="" >${korrekt?korrekt.htmlAnswer:''}</td>
                        </tr>`;
            }
            html+=`</tbody></table></div>`;
        }
        else {
            let anz = links.length > rechts.length ? links.length : rechts.length;

            let filled = [];
            for (let k=this.sqAngabe.answers.length-1; k>=0; k--) {
                let a = this.sqAngabe.answers[k];
                if (a.inp && a.inp.input && a.inp.input.length>0) {
                    // Dieser Antwort (links) ist eine Eingabe (rechts) zugeordnet
                    // Eintrag in rechter Spalte finden
                    const iR = rechts.indexOf(rechts.filter(r=>r.shortAnswer==a.inp.input)[0]);
                    if (iR>-1) {
                        links.splice(links.indexOf(a), 1)[0];
                        let r_ans = rechts.splice(iR, 1)[0];
                        filled.push({l:a.htmlText, pos: k, r:r_ans, obj: a});
                    }
                }
            }

            this.filled = filled;
            this.sqAngabe.answers = links;

            html += `
            <div class="ui-datatable-tablewrapper">
                <table role="grid">
                <thead></thead>
                <tbody class="ui-datatable-data ui-widget-content1">`;

            anz = links.length > rechts.length ? links.length : rechts.length;
            for (let x=0;x<anz;x++) {
                let l = '';
                try {
                    l = links[x].htmlText ? links[x].htmlText:'';
                } catch (e) {}
                let r = '';
                try {
                    r = rechts[x] ? rechts[x].htmlAnswer : ''
                } catch (e) {}
                html+=`<tr>
                            <td class="cell clickable" id="${this.name}_${x}l">${l}</td>
                            <td class="cell clickable" id="${this.name}_${x}r">${r}</td>
                        </tr>`;
            }
            html+=`</tbody></table></div>`;

            if (filled.length>0) {
                html+=`<h4>Zugeordnete Antworten</h4>`;

                html+=`<div class="ui-datatable-tablewrapper">
                            <table role="grid">
                                <thead></thead>
                                <tbody class="ui-datatable-data ui-widget-content1">`;

                let i = 0;
                for (let f of filled) {
                    let buttName = `${this.name}_${i++}_rmove`;
                    html+=`<tr>
                                <td class="cell">${f.l}</td>
                                <td class="cell">${f.r.htmlAnswer}</td>
                                <td class="cell">
                                <button
                                    onclick="q.removeZuordnung(this);" 
                                    class="butRemove btn ${button_style}" id="${buttName}"><i class="fa fa-trash"></i></button>
                                
                                </td>
                            </tr>`;
                }

                html+=`</tbody></table></div>`;
            }
        }
        return html;
    }

    click(id) {
        const m = /(Q\d+)_(\d+)(l|r)/.exec(id);
        const aNr = m[2];
        const leftRight = m[3];

        if (this.match_sel) {
            if (this.match_sel.lr == leftRight)
                this.selFirst(id, aNr, leftRight);
            else {
                // Zuordnung erfolgte
                // Aktuell geklickte Antwort ermitteln
                const a = leftRight=='l' ? this.sqAngabe.answers[aNr] : this.sqAngabe.rightSides[aNr];
                if (a) {
                    let left = undefined;
                    let right = undefined;

                    if (leftRight == 'l') {
                        left = a;
                        right = this.match_sel.a;
                    }
                    else {
                        right = a;
                        left = this.match_sel.a;
                    }
                    // Antwort eintragen
                    left.inp.input = right.shortAnswer;
                    this.reloadMatchingQuestion(this.parent.antwort);
                }
            }
        } else this.selFirst(id, aNr, leftRight);
        updateMathjax();
    }

    selFirst(id, aNr, leftRight) {
        let val = document.getElementById(id).innerText;
        if (val) {
            this.match_sel = {};
            this.match_sel.id = id;
            this.match_sel.nr = aNr;
            this.match_sel.lr = leftRight;
            this.match_sel.a = leftRight=='l' ? this.sqAngabe.answers[aNr] : this.sqAngabe.rightSides[aNr];

            $(".clickable").removeClass("selected");
            document.getElementById(id).classList.add("selected");
        }
        else this.match_sel = undefined;
    }

    removeZuordnung(filledNr) {
        const a = this.filled[filledNr].obj;
        if (a.inp) a.inp.input='';
        this.reloadMatchingQuestion(this.parent.antwort);
    }

    reloadMatchingQuestion(antwort) {
        this.resetSubQuestion(antwort);
        const html = this.renderSq();
        document.getElementById('sqInp_'+this.name).innerHTML = html;
        this.match_sel = undefined;
        $(".clickable").removeClass("selected");
        this.parent.defineEventHandlers();
        updateMathjax();
    }
}
