/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service.score;

import at.letto.globalinterfaces.CalcParamsQuestionInfo;
import at.letto.globalinterfaces.LettoDatasetDefinition;
import at.letto.math.VarHash;
import at.letto.questionservice.dto.renderedQuestion.InputQuestion;
import at.letto.questionservice.dto.score.ErgSubquestionDto;
import at.letto.questionservice.service.cache.QuestionCache;
import at.letto.tools.LettoConfigDto;
import java.util.Arrays;
import java.util.Vector;

public class CalcParamsQuestionInfoImpl
implements CalcParamsQuestionInfo {
    private InputQuestion q;
    private QuestionCache cache;
    private String school;
    private LettoConfigDto lettoConfigDto;

    public long getId() {
        return this.q.getId();
    }

    public VarHash getVars() {
        return this.cache.loadVarsFromCache(this.q.getDataset(), this.q.getId(), this.school);
    }

    public VarHash getMVars() {
        return this.cache.loadMVarsFromCache(this.q.getDataset(), this.q.getId(), this.school);
    }

    public VarHash getVarsMaxima() {
        return this.cache.loadVarsMaximaFromCache(this.q.getDataset(), this.q.getId(), this.school, this.q.getErgebnis().isPrecalc());
    }

    public String getMaxima() {
        return this.q.getErgebnis().getMaxima();
    }

    public String getMaximaDefs() {
        Object maxDefs = "";
        if (this.q.getErgebnis().isKonstanteMitProzent()) {
            return "";
        }
        Vector<String> deflist = new Vector<String>();
        deflist.addAll(Arrays.asList("i", "j", "pi", "e"));
        for (LettoDatasetDefinition d : this.q.getErgebnis().getLettoDatasetDefinitions()) {
            for (int i = 0; i < deflist.size(); ++i) {
                if (!((String)deflist.get(i)).equals(d.getName())) continue;
                deflist.remove(i--);
            }
        }
        for (String s : deflist) {
            maxDefs = s.equals("j") ? (String)maxDefs + s + ":%i" : (String)maxDefs + s + ":%" + s;
            maxDefs = (String)maxDefs + "$";
        }
        return maxDefs;
    }

    public String getMoodlemac() {
        return this.lettoConfigDto.getMoodlemac();
    }

    public double getPoints() {
        return this.q.getErgebnis().getPunkte();
    }

    public double getSubQuestionPoints(int i) {
        try {
            return ((ErgSubquestionDto)this.q.getErgebnis().getErgSubquestions().get(i)).getGrade();
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    public CalcParamsQuestionInfoImpl(InputQuestion q, QuestionCache cache, String school, LettoConfigDto lettoConfigDto) {
        this.q = q;
        this.cache = cache;
        this.school = school;
        this.lettoConfigDto = lettoConfigDto;
    }
}

