/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service.plugins;

import at.letto.globalinterfaces.ImageService;
import at.letto.globalinterfaces.LettoPlugin;
import at.letto.globalinterfaces.LettoQuestion;
import at.letto.globalinterfaces.LettoVarHash;
import at.letto.math.VarHash;
import at.letto.math.calculate.CalcErgebnis;
import at.letto.math.calculate.CalcToleranz;
import at.letto.math.calculate.ScoreInfoDto;
import at.letto.math.calculate.params.CalcParams;
import at.letto.math.dto.CalcErgebnisDto;
import at.letto.math.einheiten.Einheit;
import at.letto.math.einheiten.RechenEinheit;
import at.letto.math.einheiten.RechenEinheitNumeric;
import at.letto.math.plugins.PluginInfo;
import at.letto.plugins.dto.PluginAnswerDto;
import at.letto.plugins.dto.PluginDatasetDto;
import at.letto.plugins.dto.PluginGeneralInfo;
import at.letto.plugins.dto.PluginImageResultDto;
import at.letto.plugins.dto.PluginMaximaCalcModeDto;
import at.letto.plugins.dto.PluginScoreInfoDto;
import at.letto.plugins.enums.InputElement;
import at.letto.plugins.interfaces.PluginDto;
import at.letto.plugins.interfaces.PluginService;
import at.letto.plugins.restclient.BasePluginConnectionService;
import at.letto.plugins.restclient.PluginConnectionService;
import at.letto.plugins.restclient.PluginManagerService;
import at.letto.questionservice.config.MicroServiceConfiguration;
import at.letto.questionservice.service.plugins.PluginHandlerConfig;
import at.letto.tools.JavascriptLibrary;
import at.letto.tools.dto.FileDTO;
import at.letto.tools.dto.ImageBase64Dto;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;

public class QuestionPluginService
implements LettoPlugin {
    private String jsfRessourceConfigDialog;
    private String handlerNameConfigDialog;
    private boolean defaultPluginConfig = false;
    private String typ;
    private String name;
    private String config;
    private PluginManagerService pm;
    private String initScripts = "";
    private String tempConfig;
    private String tempTyp;

    public QuestionPluginService(MicroServiceConfiguration microServiceConfiguration, String typ, String name, String config) {
        this.typ = typ;
        this.name = name;
        this.config = config;
        this.pm = microServiceConfiguration.getPluginManagerService();
        switch (typ) {
            case "CodeCheck": 
            case "SourceCode": {
                this.jsfRessourceConfigDialog = "codecheck/confCode.xhtml";
                this.handlerNameConfigDialog = "confCode";
                break;
            }
            case "Plot": {
                this.jsfRessourceConfigDialog = "confPlugin.xhtml";
                this.handlerNameConfigDialog = "confPlugin";
                break;
            }
        }
    }

    @JsonIgnore
    public PluginGeneralInfo getPluginGeneralInfo() {
        return this.pm.getPluginGeneralInfo(this.typ);
    }

    public void setDefaultPluginConfig(boolean defConfig) {
        this.defaultPluginConfig = defConfig;
        if (defConfig) {
            this.setJsfRessourceConfigDialog();
            this.setHandlerNameConfigDialog();
        }
    }

    @JsonIgnore
    public String getWikiHelp() {
        return this.getPluginGeneralInfo().getWikiHelp();
    }

    @JsonIgnore
    public boolean isAllowJson() {
        return this.getPluginGeneralInfo().isMath();
    }

    @JsonIgnore
    public boolean isJavaScript() {
        return this.getPluginGeneralInfo().isJavaScript();
    }

    @JsonIgnore
    public String getPluginType() {
        return this.getClass().toString();
    }

    @JsonIgnore
    public String getTag() {
        return "[PI " + this.name + " " + this.typ + " \"" + this.config + "\"]";
    }

    @JsonIgnore
    public String getPluginVersion() {
        return this.pm.getPluginGeneralInfo(this.typ).getVersion();
    }

    public String getPluginImageDescription(String imageParams, LettoQuestion q) {
        return this.pm.getPluginImageDescription(this.typ, this.name, this.config, imageParams, q.toPluginQuestionDto());
    }

    public FileDTO getImage(String params, LettoQuestion q, ImageService imageService) {
        try {
            ImageBase64Dto imageBase64Dto = this.pm.getImage(imageService, this.typ, this.name, this.config, params, q.toPluginQuestionDto());
            FileDTO fileDTO = new FileDTO(imageBase64Dto);
            if (!imageService.existImage(fileDTO.getFilename())) {
                imageService.saveImage(imageBase64Dto.getBase64Image(), fileDTO.getFilename());
            }
            return fileDTO;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BufferedImage getAWTImage(String params, LettoQuestion q, PluginImageResultDto pluginImageResultDto) {
        try {
            ImageBase64Dto imageBase64Dto = this.pm.getImage(this.typ, this.name, this.config, params, q.toPluginQuestionDto());
            BufferedImage image = ImageService.base64StringToImg((String)imageBase64Dto.getBase64Image());
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @JsonIgnore
    public String getHelp() {
        try {
            return this.pm.getPluginGeneralInfo(this.typ).getHelp();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public CalcErgebnis parserPlugin(VarHash vars, CalcParams cp, CalcErgebnis ... p) {
        try {
            boolean allowJson = this.pm.getPluginGeneralInfo(this.typ).isMath();
            CalcErgebnisDto[] pArray = new CalcErgebnisDto[p.length];
            for (int i = 0; i < p.length; ++i) {
                pArray[i] = p[i].toCalcErgebnisDto(allowJson);
            }
            CalcErgebnisDto retDto = this.pm.parserPlugin(this.typ, this.name, this.config, vars.toVarHashDto(allowJson), cp.toCalcParamsDto(), pArray);
            CalcErgebnis ret = CalcErgebnis.parse((CalcErgebnisDto)retDto);
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RechenEinheit parserPluginEinheit(RechenEinheit ... p) {
        try {
            String[] pArray = new String[p.length];
            for (int i = 0; i < p.length; ++i) {
                pArray[i] = p[i].toString();
            }
            String s = this.pm.parserPluginEinheit(this.typ, this.name, this.config, pArray);
            RechenEinheitNumeric ret = new RechenEinheitNumeric(Einheit.parseEinheit((String)s));
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String modifyAngabe(String text, LettoQuestion q) {
        return this.pm.modifyAngabe(this.typ, this.name, this.config, text, q.toPluginQuestionDto());
    }

    public String modifyAngabeTextkomplett(String text, LettoQuestion q) {
        return this.pm.modifyAngabeTextkomplett(this.typ, this.name, this.config, text, q.toPluginQuestionDto());
    }

    public ScoreInfoDto score(PluginDto pluginDto, String antwort, CalcToleranz toleranz, LettoVarHash varsQuestion, PluginAnswerDto pluginAnswerDto, double grade) {
        boolean allowJson = this.pm.getPluginGeneralInfo(this.typ).isMath();
        PluginScoreInfoDto dto = this.pm.score(this.typ, this.name, this.config, pluginDto, antwort, toleranz.toDto(), varsQuestion.getVars().toVarHashDto(allowJson), pluginAnswerDto, grade);
        ScoreInfoDto ret = new ScoreInfoDto(dto);
        return ret;
    }

    public String updatePluginstringJavascript(String pluginDef, String jsResult) {
        return this.pm.updatePluginstringJavascript(this.typ, this.name, this.config, pluginDef, jsResult);
    }

    public String getAngabe(String s) {
        return this.pm.getAngabe(this.typ, this.name, this.config, s);
    }

    public String getHTML(String s, LettoQuestion lettoQuestion) {
        return this.pm.getHTML(this.typ, this.name, this.config, s, lettoQuestion.toPluginQuestionDto());
    }

    public String getMaxima(String s, LettoQuestion lettoQuestion, PluginMaximaCalcModeDto pluginMaximaCalcMode) {
        return this.pm.getMaxima(this.typ, this.name, this.config, s, lettoQuestion.toPluginQuestionDto(), pluginMaximaCalcMode);
    }

    public void generateDatasets(LettoQuestion lettoQuestion) {
        List datasetList = this.pm.generateDatasets(this.typ, this.name, this.config);
        for (PluginDatasetDto ds : datasetList) {
            lettoQuestion.addDataset(ds.getName(), ds.getBereich(), ds.getEinheit(), ds.isUseTemplate());
        }
    }

    @JsonIgnore
    public Vector<String> getVars() {
        return this.pm.getVars(this.typ, this.name, this.config);
    }

    @JsonIgnore
    public Vector<String[]> getImageTemplates() {
        return this.pm.getImageTemplates(this.typ, this.name, this.config);
    }

    public List<JavascriptLibrary> javascriptLibraries() {
        return this.pm.getPluginGeneralInfo(this.typ).getJavascriptLibraries();
    }

    public List<JavascriptLibrary> javascriptLibrariesLocal() {
        return this.pm.getPluginGeneralInfo(this.typ).getJavascriptLibrariesLocal();
    }

    public PluginDto loadPluginDto(String params, LettoQuestion lettoQuestion, ImageService imageService, int nr) {
        PluginDto pluginDto = this.pm.loadPluginDto(this.typ, this.name, this.config, params, lettoQuestion.toPluginQuestionDto(), nr);
        return pluginDto;
    }

    @JsonIgnore
    public String getInitPluginJS() {
        String t = this.pm.getPluginGeneralInfo(this.typ).getInitPluginJS();
        return t;
    }

    @JsonIgnore
    public InputElement getInputElement() {
        return this.pm.getPluginGeneralInfo(this.typ).getInputElement();
    }

    public void setJsfRessourceConfigDialog() {
        this.jsfRessourceConfigDialog = this.defaultPluginConfig ? "confPlugin.xhtml" : "";
    }

    public void setHandlerNameConfigDialog() {
        this.handlerNameConfigDialog = this.defaultPluginConfig ? "confPlugin" : "";
    }

    @JsonIgnore
    public PluginHandlerConfig getPluginHandlerConfig() {
        return null;
    }

    @JsonIgnore
    public PluginService getPluginService() {
        PluginConnectionService pc = this.pm.getPluginConnectionService(this.typ);
        if (pc instanceof BasePluginConnectionService) {
            BasePluginConnectionService bpc = (BasePluginConnectionService)pc;
            PluginService pluginService = bpc.createPluginService(this.typ, this.name, this.config);
            return pluginService;
        }
        return null;
    }

    public static LinkedHashMap<String, LettoPlugin> loadPlugins(MicroServiceConfiguration msc, String piDef) {
        LinkedHashMap<String, LettoPlugin> pluginHash = new LinkedHashMap<String, LettoPlugin>();
        if (piDef == null) {
            return pluginHash;
        }
        String[] piDefs = piDef.split("\"(?:\\]\\s*,\\s*\\[|>\\s*,\\s*<)");
        for (int i = 0; i < piDefs.length; ++i) {
            Matcher m;
            Object pd = piDefs[i];
            if (i < piDefs.length - 1) {
                pd = (String)pd + "\"]";
            }
            if (i > 0) {
                pd = "[" + (String)pd;
            }
            if (((String)pd).startsWith("<")) {
                pd = "[" + ((String)pd).substring(1);
            }
            if (((String)pd).endsWith(">")) {
                pd = ((String)pd).substring(0, ((String)pd).length() - 1) + "]";
            }
            if (!(m = PluginInfo.pluginPatternPI.matcher((CharSequence)pd)).find()) continue;
            try {
                QuestionPluginService pluginClass = new QuestionPluginService(msc, m.group("obj"), m.group("name"), m.group("par"));
                if (pluginClass.getPluginGeneralInfo() == null) continue;
                pluginHash.put(m.group("name"), (LettoPlugin)pluginClass);
                continue;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return pluginHash;
    }

    public String getJsfRessourceConfigDialog() {
        return this.jsfRessourceConfigDialog;
    }

    public String getHandlerNameConfigDialog() {
        return this.handlerNameConfigDialog;
    }

    public boolean isDefaultPluginConfig() {
        return this.defaultPluginConfig;
    }

    public String getTyp() {
        return this.typ;
    }

    public String getName() {
        return this.name;
    }

    public String getConfig() {
        return this.config;
    }

    public PluginManagerService getPm() {
        return this.pm;
    }

    public String getInitScripts() {
        return this.initScripts;
    }

    public String getTempConfig() {
        return this.tempConfig;
    }

    public String getTempTyp() {
        return this.tempTyp;
    }

    public void setJsfRessourceConfigDialog(String jsfRessourceConfigDialog) {
        this.jsfRessourceConfigDialog = jsfRessourceConfigDialog;
    }

    public void setHandlerNameConfigDialog(String handlerNameConfigDialog) {
        this.handlerNameConfigDialog = handlerNameConfigDialog;
    }

    public void setTyp(String typ) {
        this.typ = typ;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setPm(PluginManagerService pm) {
        this.pm = pm;
    }

    public void setInitScripts(String initScripts) {
        this.initScripts = initScripts;
    }

    public void setTempConfig(String tempConfig) {
        this.tempConfig = tempConfig;
    }

    public void setTempTyp(String tempTyp) {
        this.tempTyp = tempTyp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuestionPluginService)) {
            return false;
        }
        QuestionPluginService other = (QuestionPluginService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isDefaultPluginConfig() != other.isDefaultPluginConfig()) {
            return false;
        }
        String this$jsfRessourceConfigDialog = this.getJsfRessourceConfigDialog();
        String other$jsfRessourceConfigDialog = other.getJsfRessourceConfigDialog();
        if (this$jsfRessourceConfigDialog == null ? other$jsfRessourceConfigDialog != null : !this$jsfRessourceConfigDialog.equals(other$jsfRessourceConfigDialog)) {
            return false;
        }
        String this$handlerNameConfigDialog = this.getHandlerNameConfigDialog();
        String other$handlerNameConfigDialog = other.getHandlerNameConfigDialog();
        if (this$handlerNameConfigDialog == null ? other$handlerNameConfigDialog != null : !this$handlerNameConfigDialog.equals(other$handlerNameConfigDialog)) {
            return false;
        }
        String this$typ = this.getTyp();
        String other$typ = other.getTyp();
        if (this$typ == null ? other$typ != null : !this$typ.equals(other$typ)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$config = this.getConfig();
        String other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        PluginManagerService this$pm = this.getPm();
        PluginManagerService other$pm = other.getPm();
        if (this$pm == null ? other$pm != null : !this$pm.equals(other$pm)) {
            return false;
        }
        String this$initScripts = this.getInitScripts();
        String other$initScripts = other.getInitScripts();
        if (this$initScripts == null ? other$initScripts != null : !this$initScripts.equals(other$initScripts)) {
            return false;
        }
        String this$tempConfig = this.getTempConfig();
        String other$tempConfig = other.getTempConfig();
        if (this$tempConfig == null ? other$tempConfig != null : !this$tempConfig.equals(other$tempConfig)) {
            return false;
        }
        String this$tempTyp = this.getTempTyp();
        String other$tempTyp = other.getTempTyp();
        return !(this$tempTyp == null ? other$tempTyp != null : !this$tempTyp.equals(other$tempTyp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QuestionPluginService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDefaultPluginConfig() ? 79 : 97);
        String $jsfRessourceConfigDialog = this.getJsfRessourceConfigDialog();
        result = result * 59 + ($jsfRessourceConfigDialog == null ? 43 : $jsfRessourceConfigDialog.hashCode());
        String $handlerNameConfigDialog = this.getHandlerNameConfigDialog();
        result = result * 59 + ($handlerNameConfigDialog == null ? 43 : $handlerNameConfigDialog.hashCode());
        String $typ = this.getTyp();
        result = result * 59 + ($typ == null ? 43 : $typ.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        PluginManagerService $pm = this.getPm();
        result = result * 59 + ($pm == null ? 43 : $pm.hashCode());
        String $initScripts = this.getInitScripts();
        result = result * 59 + ($initScripts == null ? 43 : $initScripts.hashCode());
        String $tempConfig = this.getTempConfig();
        result = result * 59 + ($tempConfig == null ? 43 : $tempConfig.hashCode());
        String $tempTyp = this.getTempTyp();
        result = result * 59 + ($tempTyp == null ? 43 : $tempTyp.hashCode());
        return result;
    }

    public String toString() {
        return "QuestionPluginService(jsfRessourceConfigDialog=" + this.getJsfRessourceConfigDialog() + ", handlerNameConfigDialog=" + this.getHandlerNameConfigDialog() + ", defaultPluginConfig=" + this.isDefaultPluginConfig() + ", typ=" + this.getTyp() + ", name=" + this.getName() + ", config=" + this.getConfig() + ", pm=" + this.getPm() + ", initScripts=" + this.getInitScripts() + ", tempConfig=" + this.getTempConfig() + ", tempTyp=" + this.getTempTyp() + ")";
    }

    public QuestionPluginService() {
    }
}

