/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service.cache;

import at.letto.math.VarHash;
import at.letto.math.dto.VarHashDto;
import at.letto.question.dto.QuestionRenderDTO;
import at.letto.question.dto.VarhashMode;
import at.letto.questionservice.dto.renderedQuestion.QuestionInfo;
import at.letto.questionservice.service.QuestionCalc;
import at.letto.questionservice.service.cache.QuestionCache;
import at.letto.questionservice.service.cache.QuestionFileCache;
import at.letto.tools.Cmd;
import at.letto.tools.ENCRYPT;
import at.letto.tools.JSON;
import at.letto.tools.LogService;
import at.letto.tools.rest.MsgException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class QuestionFileCache
implements QuestionCache {
    private String cachePath;
    private String baseadress;

    public String getCachePath(String school) {
        if (!this.cachePath.endsWith("/")) {
            this.cachePath = this.cachePath + "/";
        }
        Object object = school = Cmd.isEmpty((String)school) ? this.baseadress : school;
        if (!((String)school).endsWith("/")) {
            school = (String)school + "/";
        }
        return this.cachePath + (String)school;
    }

    public String getQuestionFolder(String school, int id) {
        String splitId = Arrays.stream(("" + id).split("(?<=\\G.{3})")).collect(Collectors.joining("/"));
        String ret = this.getCachePath(school) + splitId;
        if (!ret.endsWith("/")) {
            ret = ret + "/";
        }
        return ret;
    }

    private String getCachePath(String dataset, int id, String school, VarhashMode mode) {
        String path = this.getQuestionFolder(school, id);
        return path + ENCRYPT.md5((String)(dataset + id)) + "_" + mode + ".var";
    }

    public void cacheQuestionRenderDto(QuestionRenderDTO questionRenderDto, String school, boolean clearCaches) {
        File mark;
        String folder = this.getQuestionFolder(school, questionRenderDto.getId());
        String file = folder + "question.json";
        File path = new File(folder);
        if (!path.exists()) {
            path.mkdir();
        }
        File f = new File(file);
        String qnew = JSON.objToJson((Object)questionRenderDto);
        if (f.exists()) {
            String json = "";
            try {
                json = new String(Files.readAllBytes(Paths.get(f.getAbsolutePath(), new String[0])));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (json.equals(qnew)) {
                return;
            }
            QuestionRenderDTO qOld = (QuestionRenderDTO)JSON.jsonToObj((String)json, QuestionRenderDTO.class);
            File qPath = new File(folder);
            if (qPath.listFiles() != null && clearCaches) {
                for (File var : qPath.listFiles()) {
                    if (!var.getName().endsWith(".var") && !var.getName().endsWith(".qi")) continue;
                    var.delete();
                }
            }
        }
        if ((mark = new File(folder + "marked.txt")).exists() && clearCaches) {
            mark.delete();
        }
        Cmd.writefile((String)qnew, (String)file);
    }

    public QuestionRenderDTO loadQuestionRenderDto(int id, String school) {
        String folder = this.getQuestionFolder(school, id);
        String file = folder + "question.json";
        File f = Paths.get(file, new String[0]).toFile();
        if (f.exists()) {
            try {
                String ret = Files.lines(Paths.get(file, new String[0]), StandardCharsets.UTF_8).collect(Collectors.joining("\n"));
                return (QuestionRenderDTO)JSON.jsonToObj((String)ret, QuestionRenderDTO.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void cacheQuestionInfo(QuestionInfo questionInfo, String school) {
        String key = ENCRYPT.md5((String)(questionInfo.getDataset() + questionInfo.getId()));
        String qi = JSON.objToJson((Object)questionInfo);
        String folder = this.getQuestionFolder(school, questionInfo.getId());
        String file = folder + key + ".qi";
        try {
            File f = new File(file);
            Files.createDirectories(Paths.get(folder, new String[0]), new FileAttribute[0]);
            if (f.exists()) {
                f.delete();
            }
            Cmd.writefile((String)qi, (String)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public QuestionInfo loadQuestionInfoFromCache(String dataset, int id, String school) {
        LogService.logToTmpFile((String)("ID-Question: " + id + " --- ds: " + dataset));
        String key = ENCRYPT.md5((String)(dataset + id));
        String file = this.getQuestionFolder(school, id) + key + ".qi";
        try {
            String ret = Files.lines(Paths.get(file, new String[0]), StandardCharsets.UTF_8).collect(Collectors.joining("\n"));
            QuestionInfo qi = (QuestionInfo)JSON.jsonToObj((String)ret, QuestionInfo.class);
            return qi;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void cacheVarHash(QuestionCalc qc, String dataset, String school) {
        this.cacheVarHash(dataset, (int)qc.getId(), school, VarhashMode.vars, qc);
        this.cacheVarHash(dataset, (int)qc.getId(), school, VarhashMode.cvars, qc);
        this.cacheVarHash(dataset, (int)qc.getId(), school, VarhashMode.mvars, qc);
        if (qc.getVarsMaxima().size() > 0) {
            this.cacheVarHash(dataset, (int)qc.getId(), school, VarhashMode.maxima, qc);
        }
    }

    public void cacheMaximaVarHash(QuestionCalc qc, String school) {
        String json = JSON.objToJson((Object)qc.getVarsMaxima().toVarHashDto(true));
        String file = this.getCachePath("", (int)qc.getId(), school, VarhashMode.maxima);
        File cacheFile = new File(file);
        try {
            Files.createDirectories(cacheFile.getParentFile().toPath(), new FileAttribute[0]);
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
            Cmd.writefile((String)json, (String)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void cacheDataset(int idQuestion, int dsNr, String dataset, String school) {
        String filename = dsNr + "_" + idQuestion + ".ds";
        String path = this.getQuestionFolder(school, idQuestion);
        String file = path + filename;
        try {
            File f = new File(file);
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
            if (f.exists()) {
                Files.delete(f.toPath());
            }
            Cmd.writefile((String)dataset, (String)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String loadDataset(int idQuestion, int dsNr, String school) {
        String filename = dsNr + "_" + idQuestion + ".ds";
        String path = this.getQuestionFolder(school, idQuestion);
        String file = path + filename;
        try {
            if (Files.lines(Paths.get(file, new String[0]), StandardCharsets.UTF_8).count() == 0L) {
                return "";
            }
            String ret = Files.lines(Paths.get(file, new String[0]), StandardCharsets.UTF_8).collect(Collectors.joining("\n"));
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void cacheVarHash(String dataset, int idQuestion, String school, VarhashMode art, QuestionCalc qc) {
        String json = "";
        switch (1.$SwitchMap$at$letto$question$dto$VarhashMode[art.ordinal()]) {
            case 1: {
                json = JSON.objToJson((Object)qc.getVars().toVarHashDto(true));
                break;
            }
            case 2: {
                json = JSON.objToJson((Object)qc.getCvars().toVarHashDto(true));
                break;
            }
            case 3: {
                json = JSON.objToJson((Object)qc.getMVars().toVarHashDto(true));
                break;
            }
            case 4: {
                json = JSON.objToJson((Object)qc.getVarsMaxima().toVarHashDto(true));
            }
        }
        String file = this.getCachePath(dataset, idQuestion, school, art);
        File cacheFile = new File(file);
        try {
            Files.createDirectories(cacheFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
        try (FileOutputStream fos = new FileOutputStream(cacheFile);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             BufferedWriter writer = new BufferedWriter(osw);){
            writer.append(json);
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VarHash loadVarsFromCache(String dataset, int id, String school) {
        return this.loadVarhashFromCache(dataset, id, school, VarhashMode.vars);
    }

    public VarHash loadCVarsFromCache(String dataset, int id, String school) {
        return this.loadVarhashFromCache(dataset, id, school, VarhashMode.cvars);
    }

    public VarHash loadMVarsFromCache(String dataset, int id, String school) {
        return this.loadVarhashFromCache(dataset, id, school, VarhashMode.mvars);
    }

    public VarHash loadVarsMaximaFromCache(String dataset, int id, String school, boolean precalc) {
        return this.loadVarhashFromCache(dataset, id, school, VarhashMode.maxima);
    }

    private VarHash loadVarhashFromCache(String dataset, int id, String school, VarhashMode mode) {
        String file = this.getCachePath(dataset, id, school, mode);
        try {
            String ret = Files.lines(Paths.get(file, new String[0]), StandardCharsets.UTF_8).collect(Collectors.joining("\n"));
            VarHashDto varsDto = (VarHashDto)JSON.jsonToObj((String)ret, VarHashDto.class);
            return new VarHash(varsDto);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public VarHashDto loadVarhashDtoFromCache(String dataset, int id, String school, VarhashMode mode) {
        String file = this.getCachePath(dataset, id, school, mode);
        try {
            String ret = Files.lines(Paths.get(file, new String[0]), StandardCharsets.UTF_8).collect(Collectors.joining("\n"));
            VarHashDto varsDto = (VarHashDto)JSON.jsonToObj((String)ret, VarHashDto.class);
            return varsDto;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clearCache(int idQuestion, String school, boolean removeQuestionDtos) {
        File qPath = new File(this.getQuestionFolder(school, idQuestion));
        if (!qPath.isDirectory()) {
            qPath.delete();
            return;
        }
        try {
            if (removeQuestionDtos) {
                FileUtils.deleteDirectory((File)qPath);
                return;
            }
            if (qPath.listFiles() != null) {
                for (File var : qPath.listFiles()) {
                    if (!var.getName().endsWith(".ds") && !var.getName().endsWith(".var") && !var.getName().endsWith(".qi")) continue;
                    var.delete();
                }
            }
        }
        catch (IOException e) {
            throw new MsgException("question.cache.err_clear_cache");
        }
    }

    private void clearCacheIterateFolders(File folder, boolean removeQuestionDtos) {
        if (folder.listFiles() == null || !folder.isDirectory()) {
            return;
        }
        File questDto = new File(folder.getAbsolutePath() + "/question.json");
        if (questDto.exists()) {
            if (removeQuestionDtos) {
                try {
                    FileUtils.deleteDirectory((File)folder);
                }
                catch (IOException e) {
                    throw new MsgException("question.cache.err_clear_cache");
                }
            } else {
                for (File var : folder.listFiles()) {
                    if (!var.getName().endsWith(".ds") && !var.getName().endsWith(".var") && !var.getName().endsWith(".qi")) continue;
                    var.delete();
                }
            }
        } else {
            for (File f : folder.listFiles()) {
                if (!f.isDirectory()) continue;
                this.clearCacheIterateFolders(f, removeQuestionDtos);
            }
        }
    }

    public void clearCache(String school, boolean removeQuestionDtos) {
        File mainFolder = new File(this.getCachePath(school));
        this.clearCacheIterateFolders(mainFolder, removeQuestionDtos);
    }

    public void markQuestionCalculated(String school, int id) {
        File f = new File(this.getQuestionFolder(school, id) + "marked.txt");
        if (!f.exists()) {
            Cmd.writefile((String)"", (String)f.getAbsolutePath());
        }
    }

    private List<Integer> loadNotCalculatedIDs(File folder) {
        Vector<Integer> ret = new Vector<Integer>();
        if (folder.listFiles() == null || !folder.isDirectory()) {
            return ret;
        }
        File questDto = new File(folder.getAbsolutePath() + "/question.json");
        if (questDto.exists()) {
            File mark = new File(folder.getAbsolutePath() + "/marked.txt");
            if (!mark.exists()) {
                try {
                    int id = Integer.parseInt(folder.getAbsolutePath().replace(new File(this.getCachePath("")).getAbsolutePath(), "").replaceAll("\\\\", ""));
                    ret.add(id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ret;
        }
        for (File f : folder.listFiles()) {
            if (!f.isDirectory()) continue;
            ret.addAll(this.loadNotCalculatedIDs(f));
        }
        return ret;
    }

    public List<Integer> loadNotMarkedQuestionIds(String school) {
        File mainFolder = new File(this.getCachePath(school));
        return this.loadNotCalculatedIDs(mainFolder);
    }

    public QuestionFileCache(String cachePath, String baseadress) {
        this.cachePath = cachePath;
        this.baseadress = baseadress;
    }
}

