/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.math.Werte;
import at.letto.math.einheiten.Einheit;
import at.letto.math.einheiten.EinheitenParser;
import at.letto.math.einheiten.ZielEinheit;
import at.letto.question.dto.DatasetrenderDTO;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZahlenBereich {
    public ZielEinheit.COMPLEXMODE cm = ZielEinheit.COMPLEXMODE.standard;
    public Einheit einheit = null;
    public String zb;
    public String zbw;
    public DatasetrenderDTO.DATASETTYPE modi;
    public int ziffern;
    public int m1;
    public int m2;
    public int ziffernGen;

    public ZahlenBereich(String zahlenbereich, String einheit) {
        try {
            String[] ex;
            String ehs = einheit;
            if (ehs.startsWith("=")) {
                ehs = ehs.substring(1);
            }
            for (String exx : ex = ehs.split(",")) {
                boolean ok = false;
                for (ZielEinheit.COMPLEXMODE cx : ZielEinheit.COMPLEXMODE.values()) {
                    if (!cx.toString().equals(exx.trim())) continue;
                    ok = true;
                    this.cm = cx;
                }
                if (ok) continue;
                this.einheit = EinheitenParser.parseSIEinheit((String)exx);
            }
            if (this.einheit == null) {
                this.einheit = Einheit.EINS;
            }
        }
        catch (Exception ehs) {
            // empty catch block
        }
        if (einheit.length() == 0) {
            this.einheit = null;
        }
        this.zb = zahlenbereich;
        this.zbw = "";
        if (!(this.zb.startsWith("sS") || this.zb.startsWith("S") || this.zb.startsWith("R"))) {
            this.zb = this.zb.replaceAll("\\s", "");
        }
        this.m1 = 0;
        this.m2 = 0;
        this.ziffern = Werte.PRINTPREC;
        this.ziffernGen = 4;
        Matcher m = Pattern.compile("^I:(.*)$").matcher(this.zb);
        if (m.find()) {
            this.modi = DatasetrenderDTO.DATASETTYPE.INT;
            this.zb = m.group(1);
        } else {
            m = Pattern.compile("^M(\\d+)x(\\d+):(.*)$").matcher(this.zb);
            if (m.find()) {
                this.modi = DatasetrenderDTO.DATASETTYPE.MATRIX;
                this.m1 = Integer.parseInt(m.group(1));
                this.m2 = Integer.parseInt(m.group(2));
                this.zb = m.group(3);
            } else {
                m = Pattern.compile("^M(\\d+):(.*)$").matcher(this.zb);
                if (m.find()) {
                    this.modi = DatasetrenderDTO.DATASETTYPE.REGULARMATRIX;
                    this.m1 = Integer.parseInt(m.group(1));
                    this.zb = m.group(2);
                } else {
                    m = Pattern.compile("^V(\\d+):(.*)$").matcher(this.zb);
                    if (m.find()) {
                        this.modi = DatasetrenderDTO.DATASETTYPE.VECTOR;
                        this.m1 = Integer.parseInt(m.group(1));
                        this.zb = m.group(2);
                    } else {
                        m = Pattern.compile("^F(\\d*):(.*)$").matcher(this.zb);
                        if (m.find()) {
                            this.modi = DatasetrenderDTO.DATASETTYPE.DOUBLE;
                            try {
                                this.ziffernGen = this.ziffern = Integer.parseInt(m.group(1));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.zb = m.group(2);
                        } else {
                            m = Pattern.compile("^[cC](\\d*):([^r]*)arg([^r].*\u00b0?)$").matcher(this.zb);
                            if (m.find()) {
                                this.modi = DatasetrenderDTO.DATASETTYPE.COMPLEXPOL;
                                try {
                                    this.ziffernGen = this.ziffern = Integer.parseInt(m.group(1));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                this.zb = m.group(2);
                                this.zbw = m.group(3);
                                if (this.cm == ZielEinheit.COMPLEXMODE.standard) {
                                    this.cm = this.zbw.contains("\u00b0") ? ZielEinheit.COMPLEXMODE.pol : ZielEinheit.COMPLEXMODE.pol;
                                }
                            } else {
                                m = Pattern.compile("^[cC](\\d*):([^ij]*)[ij]([^ij].*)$").matcher(this.zb);
                                if (m.find()) {
                                    this.modi = DatasetrenderDTO.DATASETTYPE.COMPLEXKAR;
                                    try {
                                        this.ziffernGen = this.ziffern = Integer.parseInt(m.group(1));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    this.zb = m.group(2);
                                    this.zbw = m.group(3);
                                    if (this.cm == ZielEinheit.COMPLEXMODE.standard) {
                                        this.cm = zahlenbereich.contains("j") ? ZielEinheit.COMPLEXMODE.kartj : ZielEinheit.COMPLEXMODE.karti;
                                    }
                                } else {
                                    m = Pattern.compile("^[cC](\\d*):([^ijr]*)$").matcher(this.zb);
                                    if (m.find()) {
                                        this.modi = DatasetrenderDTO.DATASETTYPE.COMPLEX;
                                        try {
                                            this.ziffernGen = this.ziffern = Integer.parseInt(m.group(1));
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        this.zb = m.group(2);
                                        if (this.cm == ZielEinheit.COMPLEXMODE.standard) {
                                            this.cm = ZielEinheit.COMPLEXMODE.pol;
                                        }
                                    } else {
                                        m = Pattern.compile("^I(.*)$").matcher(this.zb);
                                        if (m.find()) {
                                            this.modi = DatasetrenderDTO.DATASETTYPE.INT;
                                        } else {
                                            m = Pattern.compile("^S:(.*)$").matcher(this.zb);
                                            if (m.find()) {
                                                this.modi = DatasetrenderDTO.DATASETTYPE.STRING;
                                                this.zb = m.group(1);
                                            } else {
                                                m = Pattern.compile("^R:(.*)$").matcher(this.zb);
                                                if (m.find()) {
                                                    this.modi = DatasetrenderDTO.DATASETTYPE.REGEXP;
                                                    this.zb = m.group(1);
                                                    this.m1 = 1;
                                                    this.m2 = this.zb.length() + 5;
                                                } else {
                                                    m = Pattern.compile("^R(\\d+):(.*)$").matcher(this.zb);
                                                    if (m.find()) {
                                                        this.modi = DatasetrenderDTO.DATASETTYPE.REGEXP;
                                                        this.m1 = Integer.parseInt(m.group(1));
                                                        this.m2 = Integer.parseInt(m.group(1));
                                                        this.zb = m.group(2);
                                                    } else {
                                                        m = Pattern.compile("^R(\\d+)\\-(\\d+):(.*)$").matcher(this.zb);
                                                        if (m.find()) {
                                                            this.modi = DatasetrenderDTO.DATASETTYPE.REGEXP;
                                                            this.m1 = Integer.parseInt(m.group(1));
                                                            this.m2 = Integer.parseInt(m.group(2));
                                                            this.zb = m.group(3);
                                                        } else {
                                                            m = Pattern.compile("^sI:(.*)$").matcher(this.zb);
                                                            if (m.find()) {
                                                                this.modi = DatasetrenderDTO.DATASETTYPE.SORTEDINT;
                                                                this.zb = m.group(1);
                                                            } else {
                                                                m = Pattern.compile("^sF:(.*)$").matcher(this.zb);
                                                                if (m.find()) {
                                                                    this.modi = DatasetrenderDTO.DATASETTYPE.SORTEDFLOAT;
                                                                    this.zb = m.group(1);
                                                                } else {
                                                                    m = Pattern.compile("^sS:(.*)$").matcher(this.zb);
                                                                    if (m.find()) {
                                                                        this.modi = DatasetrenderDTO.DATASETTYPE.SORTEDSTRING;
                                                                        this.zb = m.group(1);
                                                                    } else {
                                                                        this.modi = DatasetrenderDTO.DATASETTYPE.DOUBLE;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

