/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.globalinterfaces.LettoPlugin;
import at.letto.math.calculate.CalcErgebnis;
import at.letto.question.dto.AnswerRenderDTO;
import at.letto.question.dto.QuestionRenderDTO;
import at.letto.question.dto.SubQuestionRenderDTO;
import at.letto.questionservice.service.QuestionCalc;
import at.letto.questionservice.service.QuestionRenderService;
import at.letto.questionservice.service.SchieberSetting;
import at.letto.questionservice.service.SubQuestionService;
import at.letto.tools.VectorTools;
import at.letto.tools.enums.AntwortenMischen;
import at.letto.tools.enums.SQMODE;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.annotation.Lazy;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class SubQuestionService {
    QuestionRenderService qService;

    public SubQuestionService(@NonNull @Lazy QuestionRenderService qService) {
        this.qService = qService;
    }

    public String getPluginName(SubQuestionRenderDTO sq) {
        try {
            String[] y;
            String[] x = sq.getPluginInfo().split(";");
            String ns = sq.getPluginInfo();
            if (x != null && x.length > 0) {
                ns = x[0];
            }
            if ((y = ns.split(":")) != null && y.length > 0) {
                return y[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getPluginButtontext(SubQuestionRenderDTO sq) {
        try {
            String[] y;
            String[] x = sq.getPluginInfo().split(";");
            String ns = sq.getPluginInfo();
            if (x != null && x.length > 0) {
                ns = x[0];
            }
            if ((y = ns.split(":")) != null && y.length > 1) {
                return y[1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getPluginParams(SubQuestionRenderDTO sq) {
        try {
            Matcher m = Pattern.compile("(^[^:]+):(.*$)").matcher(sq.getPluginInfo());
            if (m.find()) {
                String pluginname = m.group(1).trim();
                String info = m.group(2).trim();
                return info;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public LettoPlugin getPlugin(QuestionCalc qc, SubQuestionRenderDTO sq) {
        String name = this.getPluginName(sq);
        if (name == null || name.length() < 1) {
            return null;
        }
        if (!sq.getMode().equals((Object)SQMODE.PLUGIN)) {
            return null;
        }
        LettoPlugin plugin = this.qService.getPlugin(qc, this.getPluginName(sq));
        if (plugin instanceof LettoPlugin) {
            return plugin;
        }
        return null;
    }

    public AnswerRenderDTO getFirstAnswer(SubQuestionRenderDTO sq) {
        if (sq.getAnswers().size() > 0) {
            return (AnswerRenderDTO)sq.getAnswers().get(0);
        }
        AnswerRenderDTO a = new AnswerRenderDTO(sq);
        sq.getAnswers().add(a);
        return a;
    }

    public CalcErgebnis getErg(QuestionCalc qc, AnswerRenderDTO a) {
        SubQuestionRenderDTO sq = a.getParent();
        QuestionRenderDTO q = qc.getQ();
        for (int i = 0; i < q.getSubQuestions().size(); ++i) {
            if (!sq.equals(q.getSubQuestions().get(i))) continue;
            for (int j = 0; j < sq.getAnswers().size(); ++j) {
                if (!a.equals(sq.getAnswers().get(j))) continue;
                try {
                    return (CalcErgebnis)((QuestionCalc.ErgSubQuestion)qc.getErgebnisse().get(i)).getErgAntworten().get(j);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public CalcErgebnis getFirstErg(QuestionCalc qc, SubQuestionRenderDTO sq) {
        return this.getErg(qc, this.getFirstAnswer(sq));
    }

    public SchieberSetting getSchieberData(SubQuestionRenderDTO sq) {
        if (sq.getMode() != SQMODE.SCHIEBER) {
            return new SchieberSetting();
        }
        AnswerRenderDTO a = this.getFirstAnswer(sq);
        if (a == null) {
            return new SchieberSetting();
        }
        return new SchieberSetting(a.getText());
    }

    public String[] getPluginParamsArray(SubQuestionRenderDTO sq) {
        String[] ret = this.getPluginParams(sq).split(",");
        if (ret == null) {
            return new String[0];
        }
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ret[i].trim();
        }
        return ret;
    }

    public void setPluginParams(QuestionCalc qc, SubQuestionRenderDTO sq, String params) {
        this.setPluginInfo(qc, sq, this.getPluginName(sq), this.getPluginButtontext(sq), params);
    }

    public void setPluginInfo(QuestionCalc qc, SubQuestionRenderDTO sq, String pluginname, String buttoninfo, String params) {
        if (pluginname == null) {
            pluginname = "";
        }
        if (buttoninfo == null) {
            buttoninfo = "";
        }
        if (params == null) {
            params = "";
        }
        if (pluginname == "" && sq.getParent() != null && qc.getPluginList().size() == 1) {
            pluginname = (String)qc.getPluginList().keySet().iterator().next();
        }
        Object ret = pluginname;
        if (buttoninfo.length() > 0) {
            if (((String)ret).length() > 0) {
                ret = (String)ret + ":";
            }
            ret = (String)ret + buttoninfo;
        }
        ret = (String)ret + ";" + params;
        sq.setPluginInfo((String)ret);
    }

    public void setPluginParams(QuestionCalc qc, SubQuestionRenderDTO sq, String[] params) {
        Object p = "";
        String del = "";
        for (String s : params) {
            p = del + s;
            del = ",";
        }
        this.setPluginParams(qc, sq, (String)p);
    }

    public void reihenfolgeFestlegen(SubQuestionRenderDTO sq) {
        this.reihenfolgeFestlegen(sq, sq.getAnswers().size(), sq.getAnswers().size());
    }

    public void reihenfolgeFestlegen(SubQuestionRenderDTO sq, int anzLinks, int anzRechts) {
        if (sq.getMode() == SQMODE.MULTICHOICE || sq.getMode() == SQMODE.SINGLECHOICE) {
            if (sq.getShuffleAnswers() == null) {
                sq.setShuffleAnswers(sq.getParent().getShuffleAnswers());
            }
            if (sq.getShuffleAnswers() == null) {
                sq.setShuffleAnswers(AntwortenMischen.Mischen);
            }
        }
        if (sq.getMode() == SQMODE.ZUORDNUNG && sq.getShuffleAnswers() == null) {
            sq.setShuffleAnswers(sq.getParent().getShuffleAnswers());
            if (sq.getShuffleAnswers() == null) {
                sq.setShuffleAnswers(AntwortenMischen.Mischen);
            }
        }
        if (sq.getShuffleAnswers() == null) {
            return;
        }
        switch (1.$SwitchMap$at$letto$tools$enums$AntwortenMischen[sq.getShuffleAnswers().ordinal()]) {
            case 1: {
                sq.setReihenfolge(VectorTools.getSortedZahlen((int)anzLinks));
                sq.setReihenfolgeZuordnung(VectorTools.getSortedZahlen((int)anzRechts));
                break;
            }
            case 2: {
                sq.setReihenfolge(VectorTools.getZufallszahlen((int)anzLinks));
                sq.setReihenfolgeZuordnung(VectorTools.getZufallszahlen((int)anzRechts));
                break;
            }
            case 3: {
                sq.setReihenfolge(VectorTools.getZufallszahlen((int)anzLinks));
                sq.setReihenfolgeZuordnung(VectorTools.getSortedZahlen((int)anzRechts));
                break;
            }
            case 4: {
                sq.setReihenfolge(VectorTools.getSortedZahlen((int)anzLinks));
                sq.setReihenfolgeZuordnung(VectorTools.getZufallszahlen((int)anzRechts));
                break;
            }
        }
    }
}

