/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.globalinterfaces.ImageService;
import at.letto.globalinterfaces.LettoFile;
import at.letto.question.dto.QuestionFileDTO;
import at.letto.questionservice.service.BildAngaben;
import at.letto.service.base.BaseImageService;
import at.letto.tools.LogService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuestionFile
extends QuestionFileDTO
implements LettoFile {
    private ImageService imageService;

    public QuestionFile(ImageService imageService) {
        this.imageService = imageService;
    }

    public String getImgTag() {
        Object ret = " ";
        if (this.tagWidth > 0) {
            ret = (String)ret + "width=\"" + this.tagWidth + "%\" ";
        }
        if (this.tagAlt.length() > 0) {
            ret = (String)ret + "alt=\"" + this.tagAlt + "\" ";
        }
        if (this.tagTitle.length() > 0) {
            ret = (String)ret + "title=\"" + this.tagTitle + "\" ";
        }
        if (this.tagStyle.length() > 0) {
            ret = (String)ret + "style=\"" + this.tagStyle + "\" ";
        }
        return ret;
    }

    public String getImgSizeTex() {
        if (this.tagWidth == 0) {
            return "[width=100mm]";
        }
        double sz = (double)this.tagWidth / 100.0;
        Object w = sz > 0.99 ? "\\textwidth" : (sz < 0.01 ? "0.01\\textwidth" : sz + "\\textwidth");
        return "[width=" + (String)w + "]";
    }

    public String getTmpFile() {
        return "";
    }

    public String getLinkWeb(int nr, String attribs) {
        String webPath = this.imageService.getURL(this.md5 + "." + this.extension);
        if (this.getExtension().contains("mp4") && !webPath.isEmpty()) {
            return " <video width='320' height='240' controls>  <source src='" + webPath + "' type='video/mp4'></video> ";
        }
        if (this.getExtension().contains("ogg") && !webPath.isEmpty()) {
            return " <video width='320' height='240' controls>  <source src='" + webPath + "' type='video/ogg'></video> ";
        }
        if (this.getExtension().contains("mp3") && !webPath.isEmpty()) {
            return " <audio controls src='" + webPath + "' type='audio/mp3' />";
        }
        if (this.getExtension().contains("m4a") && !webPath.isEmpty()) {
            return " <audio controls src='" + webPath + "' type='audio/mp4' />";
        }
        return webPath.isEmpty() ? "<a href=\"#\" onclick=\"openDocument(" + nr + ");\">" + attribs + "</a>" : "<a href=\"" + webPath + "\" target=\"_blank\" download=\"" + attribs + "\">" + attribs + "</a>";
    }

    public String getImageWeb(boolean dblClick) {
        return this.getImageWeb(null, dblClick);
    }

    public String getWebPath() {
        return this.imageService.getURL(this.filename);
    }

    public String getInhalt() {
        return this.inhalt;
    }

    public String getFileType() {
        Matcher m = Pattern.compile(".*\\.([^\\.]+)").matcher(this.filename);
        if (m.find()) {
            return m.toMatchResult().group(1).toLowerCase();
        }
        return "";
    }

    public String getImageWeb(BildAngaben ba, boolean dblClick) {
        ImageService imgService = this.imageService;
        if (ba == null) {
            ba = new BildAngaben((double)this.tagWidth, this.breite);
        }
        BaseImageService i = (BaseImageService)imgService;
        String breite = ba.getBreitenAng();
        LogService.logToTmpFile((String)("URI: " + i.getUrlPath() + " --- Path: " + i.getLocalPath() + " --- " + imgService.existImage(this.filename)));
        this.filename = this.getMd5() + "." + this.getExtension();
        if (imgService.existImage(this.filename)) {
            String name = this.getWebPath();
            dblClick = true;
            return String.format("<img class='lettoimage' on%sclick='openImg(\"%s\")' src=\"%s\" alt=\"%s\" style=\"width:%s;\">", dblClick ? "dbl" : "", name, name, this.tagTitle, breite);
        }
        String typ = this.getFileType();
        String bild = "";
        if (!typ.equals("pdf")) {
            bild = this.getInhalt();
        }
        if (typ.equals("svgx")) {
            return this.getInhalt();
        }
        if (bild == null) {
            return "";
        }
        String b = bild.replaceAll(" ", "");
        b = b.replaceAll("\n", "");
        String funcName = "myFunction_" + System.currentTimeMillis();
        String imgStr = "<img class='lettoimage' alt='Embedded Image' width='100%' src='data:image/" + typ + "+xml;charset=utf-8;base64," + b + "'>";
        String script = "<script>function " + funcName + "() {var myWindow = window.open(\"\", \"MsgWindow" + System.currentTimeMillis() + "\", \"width=800, height=500\"); myWindow.document.documentElement.innerHTML='';myWindow.document.open();myWindow.focus(); myWindow.document.write(\"<p>" + imgStr + "</p>\");}</script>".replaceAll("\\s", "");
        String img = "<img class='lettoimage' on" + (dblClick ? "dbl" : "") + "click=\"" + funcName + "()\"  alt=\"Embedded Image\" width=\"" + breite + "\" src=\"data:image/" + typ + "+xml;charset=utf-8;base64," + bild + "\" handle.focus();><br />";
        return img + script;
    }
}

