/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.globalinterfaces.CalcParamsQuestionInfo;
import at.letto.globalinterfaces.LettoDatasetDefinition;
import at.letto.globalinterfaces.LettoPlugin;
import at.letto.globalinterfaces.LettoQuestion;
import at.letto.globalinterfaces.LettoSubQuestion;
import at.letto.math.VarHash;
import at.letto.math.calculate.CalcErgebnis;
import at.letto.math.calculate.CalcString;
import at.letto.math.calculate.params.CalcParams;
import at.letto.math.einheiten.PhysicalDimension;
import at.letto.math.einheiten.ZielEinheit;
import at.letto.plugins.dto.PluginQuestionDto;
import at.letto.plugins.dto.PluginSubQuestionDto;
import at.letto.question.dto.QuestionFileDTO;
import at.letto.question.dto.QuestionRenderDTO;
import at.letto.question.dto.QuestionTextDTO;
import at.letto.question.dto.SubQuestionRenderDTO;
import at.letto.questionservice.service.ClozePart;
import at.letto.questionservice.service.QuestionCalc;
import at.letto.questionservice.service.QuestionRenderService;
import at.letto.tools.ENCRYPT;
import at.letto.tools.LettoConfigDto;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;

public class QuestionCalc
implements CalcParamsQuestionInfo,
LettoQuestion {
    private QuestionRenderDTO q;
    private String school;
    private VarHash vars = new VarHash();
    private VarHash cvars = new VarHash();
    private VarHash mvars = new VarHash();
    private VarHash varsMaxima = new VarHash();
    private String dataset;
    private List<ClozePart> clozeQuestions = new Vector();
    private LinkedHashMap<String, LettoPlugin> pluginList;
    private int pluginNr = 0;
    private String jsPlugins = "";
    private String feedback = "";
    HashMap<String, CalcErgebnis> solveBuffer = new HashMap();
    private List<ErgSubQuestion> ergebnisse = new Vector();
    private LettoConfigDto lettoConfigDto;
    private VarHash consts = new VarHash();
    private List<PhysicalDimension> einheiten = new Vector();

    public LettoPlugin getPlugin(String name) {
        LinkedHashMap plist = this.getPluginList();
        if (plist.containsKey(name)) {
            return (LettoPlugin)((HashMap)plist).get(name);
        }
        return null;
    }

    public void addPlugin(String s) {
    }

    public CalcErgebnis getVar(String s) {
        return null;
    }

    public CalcErgebnis getVarMaxima(String s) {
        return null;
    }

    public LettoDatasetDefinition getDataset(String s) {
        return null;
    }

    public void addDataset(String s, String s1, String s2, boolean b) {
    }

    public boolean isUseSymbolicMode() {
        return false;
    }

    public void loadDataset(int i, String s) {
    }

    public List<LettoSubQuestion> getLettoSubQuestions() {
        return null;
    }

    public String getDatensatzEinheiten() {
        return null;
    }

    public int getPluginNr() {
        return 0;
    }

    public PluginSubQuestionDto toPluginSubQuestionDto(SubQuestionRenderDTO sq) {
        PluginSubQuestionDto dto = new PluginSubQuestionDto(sq.getName(), sq.getGrade());
        return dto;
    }

    public PluginQuestionDto toPluginQuestionDto() {
        ArrayList<PluginSubQuestionDto> pluginSubQuestionDtoList = new ArrayList<PluginSubQuestionDto>();
        for (Object subQuestion : this.q.getSubQuestions()) {
            pluginSubQuestionDtoList.add(this.toPluginSubQuestionDto((SubQuestionRenderDTO)subQuestion));
        }
        ArrayList<CallSite> imageList = new ArrayList<CallSite>();
        for (QuestionTextDTO t : this.q.getMoodleTexte()) {
            for (QuestionFileDTO f : t.getFiles()) {
                String filename = f.getMd5() + "." + f.getExtension();
                imageList.add((CallSite)((Object)filename));
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.q.getId());
        sb.append(this.q.getName());
        sb.append(this.getMaximaDefs());
        sb.append(this.q.getPunkte());
        sb.append(pluginSubQuestionDtoList);
        sb.append(this.q.getMaxima());
        sb.append(imageList);
        sb.append(this.q.getDatasets());
        sb.append(this.cvars != null ? this.cvars.buildString() : "");
        sb.append(this.mvars != null ? this.mvars.buildString() : "");
        String checksum = ENCRYPT.sha512((String)sb.toString());
        if (checksum.length() > 10 && this.q.getPluginChecksum() != null && this.q.getPluginQuestionDto() != null && checksum.equals(this.q.getPluginChecksum())) {
            return this.q.getPluginQuestionDto();
        }
        PluginQuestionDto dto = new PluginQuestionDto(this.getId(), this.q.getName(), this.getMaximaDefs(), this.getMoodlemac(), this.getPoints(), pluginSubQuestionDtoList, this.getMaxima(), imageList, 0, this.cvars != null ? this.cvars.toVarHashDto() : null, this.vars != null ? this.vars.toVarHashDto() : null, this.varsMaxima != null ? this.varsMaxima.toVarHashDto() : null, this.mvars != null ? this.mvars.optimize(new CalcParams(ZielEinheit.OPTMODE.NUMERIC)).toVarHashDto() : null);
        this.q.setPluginChecksum(checksum);
        this.q.setPluginQuestionDto(dto);
        return dto;
    }

    public long getId() {
        return this.q.getId();
    }

    public VarHash getMVars() {
        return this.mvars;
    }

    public String getMaxima() {
        return this.q.getMaxima();
    }

    public String getMaximaDefs() {
        return QuestionRenderService.getMaximaDefs((QuestionRenderDTO)this.q);
    }

    public String getMoodlemac() {
        return this.lettoConfigDto.getMoodlemac();
    }

    public double getPoints() {
        return this.q.getPunkte();
    }

    public double getSubQuestionPoints(int i) {
        try {
            return ((SubQuestionRenderDTO)this.q.getSubQuestions().get(i)).getGrade();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public QuestionCalc(QuestionRenderDTO q, String school) {
        this.q = q;
        this.school = school;
        for (SubQuestionRenderDTO sq : q.getSubQuestions()) {
            this.ergebnisse.add(new ErgSubQuestion(this));
        }
    }

    public void setErg(int i, CalcErgebnis erg) {
        while (this.ergebnisse.size() <= i) {
            this.ergebnisse.add(new ErgSubQuestion(this));
        }
        ((ErgSubQuestion)this.ergebnisse.get(i)).setSqErgebnis(erg);
    }

    public void setErgAntwort(int i, int a, CalcErgebnis erg) {
        while (this.ergebnisse.size() <= i) {
            this.ergebnisse.add(new ErgSubQuestion(this));
        }
        ErgSubQuestion sq = (ErgSubQuestion)this.ergebnisse.get(i);
        while (sq.getErgAntworten().size() <= a) {
            sq.getErgAntworten().add(new CalcString(""));
        }
        sq.getErgAntworten().set(a, erg);
    }

    public CalcErgebnis getErgAntwort(int i, int a) {
        try {
            return (CalcErgebnis)((ErgSubQuestion)this.ergebnisse.get(i)).getErgAntworten().get(a);
        }
        catch (Exception e) {
            return new CalcString("Antwort wurde nicht korrekt berechnet");
        }
    }

    public QuestionRenderDTO getQ() {
        return this.q;
    }

    public String getSchool() {
        return this.school;
    }

    public VarHash getVars() {
        return this.vars;
    }

    public VarHash getCvars() {
        return this.cvars;
    }

    public VarHash getVarsMaxima() {
        return this.varsMaxima;
    }

    public String getDataset() {
        return this.dataset;
    }

    public List<ClozePart> getClozeQuestions() {
        return this.clozeQuestions;
    }

    public LinkedHashMap<String, LettoPlugin> getPluginList() {
        return this.pluginList;
    }

    public String getJsPlugins() {
        return this.jsPlugins;
    }

    public String getFeedback() {
        return this.feedback;
    }

    public List<ErgSubQuestion> getErgebnisse() {
        return this.ergebnisse;
    }

    public LettoConfigDto getLettoConfigDto() {
        return this.lettoConfigDto;
    }

    public VarHash getConsts() {
        return this.consts;
    }

    public List<PhysicalDimension> getEinheiten() {
        return this.einheiten;
    }

    public void setQ(QuestionRenderDTO q) {
        this.q = q;
    }

    public void setSchool(String school) {
        this.school = school;
    }

    public void setVars(VarHash vars) {
        this.vars = vars;
    }

    public void setCvars(VarHash cvars) {
        this.cvars = cvars;
    }

    public void setMvars(VarHash mvars) {
        this.mvars = mvars;
    }

    public void setVarsMaxima(VarHash varsMaxima) {
        this.varsMaxima = varsMaxima;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public void setClozeQuestions(List<ClozePart> clozeQuestions) {
        this.clozeQuestions = clozeQuestions;
    }

    public void setPluginList(LinkedHashMap<String, LettoPlugin> pluginList) {
        this.pluginList = pluginList;
    }

    public void setPluginNr(int pluginNr) {
        this.pluginNr = pluginNr;
    }

    public void setJsPlugins(String jsPlugins) {
        this.jsPlugins = jsPlugins;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public void setSolveBuffer(HashMap<String, CalcErgebnis> solveBuffer) {
        this.solveBuffer = solveBuffer;
    }

    public void setErgebnisse(List<ErgSubQuestion> ergebnisse) {
        this.ergebnisse = ergebnisse;
    }

    public void setLettoConfigDto(LettoConfigDto lettoConfigDto) {
        this.lettoConfigDto = lettoConfigDto;
    }

    public void setConsts(VarHash consts) {
        this.consts = consts;
    }

    public void setEinheiten(List<PhysicalDimension> einheiten) {
        this.einheiten = einheiten;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuestionCalc)) {
            return false;
        }
        QuestionCalc other = (QuestionCalc)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPluginNr() != other.getPluginNr()) {
            return false;
        }
        QuestionRenderDTO this$q = this.getQ();
        QuestionRenderDTO other$q = other.getQ();
        if (this$q == null ? other$q != null : !this$q.equals(other$q)) {
            return false;
        }
        String this$school = this.getSchool();
        String other$school = other.getSchool();
        if (this$school == null ? other$school != null : !this$school.equals(other$school)) {
            return false;
        }
        VarHash this$vars = this.getVars();
        VarHash other$vars = other.getVars();
        if (this$vars == null ? other$vars != null : !this$vars.equals(other$vars)) {
            return false;
        }
        VarHash this$cvars = this.getCvars();
        VarHash other$cvars = other.getCvars();
        if (this$cvars == null ? other$cvars != null : !this$cvars.equals(other$cvars)) {
            return false;
        }
        VarHash this$mvars = this.getMVars();
        VarHash other$mvars = other.getMVars();
        if (this$mvars == null ? other$mvars != null : !this$mvars.equals(other$mvars)) {
            return false;
        }
        VarHash this$varsMaxima = this.getVarsMaxima();
        VarHash other$varsMaxima = other.getVarsMaxima();
        if (this$varsMaxima == null ? other$varsMaxima != null : !this$varsMaxima.equals(other$varsMaxima)) {
            return false;
        }
        String this$dataset = this.getDataset();
        String other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !this$dataset.equals(other$dataset)) {
            return false;
        }
        List this$clozeQuestions = this.getClozeQuestions();
        List other$clozeQuestions = other.getClozeQuestions();
        if (this$clozeQuestions == null ? other$clozeQuestions != null : !((Object)this$clozeQuestions).equals(other$clozeQuestions)) {
            return false;
        }
        LinkedHashMap this$pluginList = this.getPluginList();
        LinkedHashMap other$pluginList = other.getPluginList();
        if (this$pluginList == null ? other$pluginList != null : !((Object)this$pluginList).equals(other$pluginList)) {
            return false;
        }
        String this$jsPlugins = this.getJsPlugins();
        String other$jsPlugins = other.getJsPlugins();
        if (this$jsPlugins == null ? other$jsPlugins != null : !this$jsPlugins.equals(other$jsPlugins)) {
            return false;
        }
        String this$feedback = this.getFeedback();
        String other$feedback = other.getFeedback();
        if (this$feedback == null ? other$feedback != null : !this$feedback.equals(other$feedback)) {
            return false;
        }
        HashMap this$solveBuffer = this.getSolveBuffer();
        HashMap other$solveBuffer = other.getSolveBuffer();
        if (this$solveBuffer == null ? other$solveBuffer != null : !((Object)this$solveBuffer).equals(other$solveBuffer)) {
            return false;
        }
        List this$ergebnisse = this.getErgebnisse();
        List other$ergebnisse = other.getErgebnisse();
        if (this$ergebnisse == null ? other$ergebnisse != null : !((Object)this$ergebnisse).equals(other$ergebnisse)) {
            return false;
        }
        LettoConfigDto this$lettoConfigDto = this.getLettoConfigDto();
        LettoConfigDto other$lettoConfigDto = other.getLettoConfigDto();
        if (this$lettoConfigDto == null ? other$lettoConfigDto != null : !this$lettoConfigDto.equals(other$lettoConfigDto)) {
            return false;
        }
        VarHash this$consts = this.getConsts();
        VarHash other$consts = other.getConsts();
        if (this$consts == null ? other$consts != null : !this$consts.equals(other$consts)) {
            return false;
        }
        List this$einheiten = this.getEinheiten();
        List other$einheiten = other.getEinheiten();
        return !(this$einheiten == null ? other$einheiten != null : !((Object)this$einheiten).equals(other$einheiten));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QuestionCalc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPluginNr();
        QuestionRenderDTO $q = this.getQ();
        result = result * 59 + ($q == null ? 43 : $q.hashCode());
        String $school = this.getSchool();
        result = result * 59 + ($school == null ? 43 : $school.hashCode());
        VarHash $vars = this.getVars();
        result = result * 59 + ($vars == null ? 43 : $vars.hashCode());
        VarHash $cvars = this.getCvars();
        result = result * 59 + ($cvars == null ? 43 : $cvars.hashCode());
        VarHash $mvars = this.getMVars();
        result = result * 59 + ($mvars == null ? 43 : $mvars.hashCode());
        VarHash $varsMaxima = this.getVarsMaxima();
        result = result * 59 + ($varsMaxima == null ? 43 : $varsMaxima.hashCode());
        String $dataset = this.getDataset();
        result = result * 59 + ($dataset == null ? 43 : $dataset.hashCode());
        List $clozeQuestions = this.getClozeQuestions();
        result = result * 59 + ($clozeQuestions == null ? 43 : ((Object)$clozeQuestions).hashCode());
        LinkedHashMap $pluginList = this.getPluginList();
        result = result * 59 + ($pluginList == null ? 43 : ((Object)$pluginList).hashCode());
        String $jsPlugins = this.getJsPlugins();
        result = result * 59 + ($jsPlugins == null ? 43 : $jsPlugins.hashCode());
        String $feedback = this.getFeedback();
        result = result * 59 + ($feedback == null ? 43 : $feedback.hashCode());
        HashMap $solveBuffer = this.getSolveBuffer();
        result = result * 59 + ($solveBuffer == null ? 43 : ((Object)$solveBuffer).hashCode());
        List $ergebnisse = this.getErgebnisse();
        result = result * 59 + ($ergebnisse == null ? 43 : ((Object)$ergebnisse).hashCode());
        LettoConfigDto $lettoConfigDto = this.getLettoConfigDto();
        result = result * 59 + ($lettoConfigDto == null ? 43 : $lettoConfigDto.hashCode());
        VarHash $consts = this.getConsts();
        result = result * 59 + ($consts == null ? 43 : $consts.hashCode());
        List $einheiten = this.getEinheiten();
        result = result * 59 + ($einheiten == null ? 43 : ((Object)$einheiten).hashCode());
        return result;
    }

    public String toString() {
        return "QuestionCalc(q=" + this.getQ() + ", school=" + this.getSchool() + ", vars=" + this.getVars() + ", cvars=" + this.getCvars() + ", mvars=" + this.getMVars() + ", varsMaxima=" + this.getVarsMaxima() + ", dataset=" + this.getDataset() + ", clozeQuestions=" + this.getClozeQuestions() + ", pluginList=" + this.getPluginList() + ", pluginNr=" + this.getPluginNr() + ", jsPlugins=" + this.getJsPlugins() + ", feedback=" + this.getFeedback() + ", solveBuffer=" + this.getSolveBuffer() + ", ergebnisse=" + this.getErgebnisse() + ", lettoConfigDto=" + this.getLettoConfigDto() + ", consts=" + this.getConsts() + ", einheiten=" + this.getEinheiten() + ")";
    }

    public HashMap<String, CalcErgebnis> getSolveBuffer() {
        return this.solveBuffer;
    }
}

