/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.globalinterfaces.CalcParamsQuestionInfo;
import at.letto.globalinterfaces.LettoQuestion;
import at.letto.math.CalcMaxima;
import at.letto.math.MaximaLine;
import at.letto.math.MaximaTools;
import at.letto.math.PARSER;
import at.letto.math.UnitDefinitions;
import at.letto.math.VarHash;
import at.letto.math.calculate.CalcComplex;
import at.letto.math.calculate.CalcComplexEinheit;
import at.letto.math.calculate.CalcDouble;
import at.letto.math.calculate.CalcErgebnis;
import at.letto.math.calculate.CalcError;
import at.letto.math.calculate.CalcLong;
import at.letto.math.calculate.CalcMatrix;
import at.letto.math.calculate.CalcNumerical;
import at.letto.math.calculate.CalcPhysical;
import at.letto.math.calculate.CalcRational;
import at.letto.math.calculate.CalcString;
import at.letto.math.calculate.CalcSymbol;
import at.letto.math.calculate.CalcToleranz;
import at.letto.math.calculate.CalcVector;
import at.letto.math.calculate.Calculate;
import at.letto.math.calculate.ParserCache;
import at.letto.math.calculate.params.CalcParams;
import at.letto.math.einheiten.ZielEinheit;
import at.letto.math.enums.CALCMODE;
import at.letto.math.plugins.PluginInfo;
import at.letto.plugins.dto.PluginMaximaCalcModeDto;
import at.letto.question.dto.AnswerRenderDTO;
import at.letto.question.dto.DatasetrenderDTO;
import at.letto.question.dto.QuestionRenderDTO;
import at.letto.question.dto.SubQuestionRenderDTO;
import at.letto.questionservice.service.DatasetService;
import at.letto.questionservice.service.MaximaService;
import at.letto.questionservice.service.QuestionCalc;
import at.letto.questionservice.service.QuestionRenderService;
import at.letto.tools.enums.QuestionType;
import at.letto.tools.enums.SQMODE;
import at.letto.tools.threads.LettoTimer;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import uk.ac.ed.ph.jacomax.MaximaTimeoutException;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MaximaService {
    @Value(value="${letto.maxima.maximaPath}")
    private String maximaPath = "maxima";
    QuestionRenderService questionRenderService;
    @Autowired
    DatasetService datasetService;

    public MaximaService() {
        this.questionRenderService = new QuestionRenderService();
    }

    public MaximaService(@Lazy QuestionRenderService questionRenderService) {
        this.questionRenderService = questionRenderService;
    }

    public boolean konsistenzCheck(QuestionRenderDTO q, boolean korrigiere) {
        boolean konsistent = true;
        for (SubQuestionRenderDTO sq : q.getSubQuestions()) {
            if (q.getQuestionType() == QuestionType.MoodleMultichoice && sq.getMode() != SQMODE.MULTICHOICE && sq.getMode() != SQMODE.SINGLECHOICE) {
                if (korrigiere) {
                    sq.setMode(SQMODE.MULTICHOICE);
                }
                konsistent = false;
            }
            if (q.getQuestionType() != QuestionType.MoodleMatching || sq.getMode() == SQMODE.ZUORDNUNG) continue;
            if (korrigiere) {
                sq.setMode(SQMODE.ZUORDNUNG);
            }
            konsistent = false;
        }
        return konsistent;
    }

    public static String addDeclaration(CalcErgebnis w, String name, String maxima) {
        if (w instanceof CalcVector || w instanceof CalcMatrix) {
            maxima = "declare(" + name + ",nonscalar)\n" + (String)maxima;
        } else if (w instanceof CalcComplex || w instanceof CalcComplexEinheit) {
            maxima = "declare(" + name + ",complex)\n" + (String)maxima;
        } else if (!(w instanceof CalcString) && w instanceof CalcLong) {
            maxima = "declare(" + name + ",integer)\n" + (String)maxima;
        }
        return maxima;
    }

    public void calcMaxima(QuestionCalc qc, String configFile) {
        QuestionRenderDTO q = qc.getQ();
        VarHash vars = qc.getVars();
        VarHash cvars = qc.getCvars();
        qc.setMvars(new VarHash());
        VarHash mvars = qc.getMVars();
        qc.setVarsMaxima(new VarHash());
        VarHash varsMaxima = qc.getVarsMaxima();
        this.konsistenzCheck(q, true);
        if (q.isPreCalc()) {
            q.getSubQuestions().stream().filter(sq -> sq.getMode().equals((Object)SQMODE.CALCULATED)).forEach(sq -> sq.getAnswers().forEach(a -> a.setText("")));
        }
        Object ret = "";
        CalcMaxima m = null;
        m = q.isSendToParser() ? new CalcMaxima(PARSER.INTERN, q.isUseSymbolicMode(), (CalcParamsQuestionInfo)qc) : new CalcMaxima(this.maximaPath, PARSER.MAXIMA, q.isUseSymbolicMode(), (CalcParamsQuestionInfo)qc);
        Object MaximaFeld = q.getMaxima();
        boolean isVectorRechnung = false;
        Vector varlist = new Vector();
        for (Object def : q.getDatasetDefinitions()) {
            MaximaFeld = this.datasetService.setMaximaFeld((DatasetrenderDTO)def, (String)MaximaFeld, varlist);
            CalcErgebnis w = DatasetService.getWert((DatasetrenderDTO)def, (int)0);
            if (!(w instanceof CalcVector) && !(w instanceof CalcMatrix)) continue;
            isVectorRechnung = true;
        }
        q.setMaxima((String)MaximaFeld);
        if (!q.isSendToParser() && isVectorRechnung) {
            MaximaFeld = "load(vect)\n" + (String)MaximaFeld;
        }
        if (!q.isPreCalc()) {
            for (Object def : q.getDatasetDefinitions()) {
                MaximaFeld = MaximaService.addDeclaration((CalcErgebnis)DatasetService.getWert((DatasetrenderDTO)def, (int)0), (String)def.getName(), (String)MaximaFeld);
            }
        }
        MaximaFeld = PluginInfo.reloadMaximaFull((LettoQuestion)qc, (String)MaximaFeld, (PluginMaximaCalcModeDto)new PluginMaximaCalcModeDto(!q.isSendToParser(), q.isPreCalc()));
        VarHash maximaVarsMitEH = new VarHash();
        for (Object sq2 : q.getSubQuestions()) {
            for (Object a : sq2.getAnswers()) {
                a.setMaximaSubFeld(a.getMaxima());
                if (q.isSendToParser() || a.getMaximaSubFeld().startsWith(":")) continue;
                a.setMaximaSubFeld(MaximaTools.maximaReplaceEinheitenUndKonstante((String)a.getMaximaSubFeld(), (VarHash)maximaVarsMitEH));
            }
        }
        MaximaLine erg = null;
        try {
            if (!q.isSendToParser()) {
                MaximaFeld = MaximaTools.maximaReplaceEinheitenUndKonstante((String)MaximaFeld, (VarHash)maximaVarsMitEH);
                for (String name : maximaVarsMitEH.keySet()) {
                    MaximaFeld = MaximaService.addDeclaration((CalcErgebnis)maximaVarsMitEH.getErgebnis(name), (String)name, (String)MaximaFeld);
                }
            }
            if (q.isPreCalc()) {
                if (!q.isSendToParser()) {
                    m.defineParserFunctions();
                }
                m.setVarsMaxima(new VarHash[]{vars, maximaVarsMitEH});
                erg = m.execute((String)MaximaFeld);
            } else {
                erg = m.execute((String)MaximaFeld);
            }
            if (erg != null && q.getQuestionType() == QuestionType.MoodleCalculated) {
                String[] x = erg.getIn().split(":");
                AnswerRenderDTO a = (AnswerRenderDTO)q.getFirstAnswers().get(0);
                if (x.length == 2) {
                    a.setMaxima(x[0]);
                } else {
                    a.setMaxima(erg.getIn());
                }
            }
        }
        catch (MaximaTimeoutException e) {
            m.close();
            q.setMaximaResultErr("<h3>Maxima-Timeout</h3>Die Anfrage an Maxima hat zulange gedauert und wurde unterbrochen!");
            return;
        }
        catch (Exception e) {
            m.close();
            q.setMaximaResultErr("<h3>Berechnungsfehler im Maxima-Feld! Die Berechnung wurde abgebrochen");
            return;
        }
        VarHash maximaVars = m.getVars();
        CalcParams cp = new CalcParams(ZielEinheit.OPTMODE.NUMERIC);
        for (String varname : maximaVars.keySet()) {
            maximaVars.put(varname, maximaVars.getErgebnis(varname).insertVars(maximaVarsMitEH, cp));
        }
        cp = new CalcParams(ZielEinheit.OPTMODE.NUMERIC).setSymbolicMode(false);
        UnitDefinitions unitDefinitions = new UnitDefinitions((String)MaximaFeld);
        unitDefinitions.addUnits(vars);
        unitDefinitions.addUnits(maximaVarsMitEH);
        if (q.isPreCalc() && !q.isSendToParser()) {
            unitDefinitions.replaceUnit(maximaVars, cp);
        }
        q.setMaximaAngabe(maximaVarsMitEH.buildString() + ";::;" + maximaVars.buildString());
        vars = new VarHash();
        qc.setVars(vars);
        vars.addHashtableCalcErgebnis(cvars);
        boolean hasUntis = true;
        if (q.isPreCalc()) {
            varsMaxima = new VarHash();
            qc.setVarsMaxima(varsMaxima);
            varsMaxima.addHashtableCalcErgebnis(maximaVars);
            mvars = new VarHash();
            qc.setMvars(mvars);
            mvars.addHashtableCalcErgebnis(cvars);
            mvars.addHashtableCalcErgebnis(maximaVars);
            if (!q.isSendToParser()) {
                Object e;
                hasUntis = false;
                for (String vname : vars.keyset()) {
                    e = vars.getErgebnis(vname);
                    if (!(e instanceof CalcPhysical) || e.rechenEinheit().isEins()) continue;
                    hasUntis = true;
                }
                for (String vname : maximaVarsMitEH.keyset()) {
                    e = maximaVarsMitEH.getErgebnis(vname);
                    if (!(e instanceof CalcPhysical) || e.rechenEinheit().isEins()) continue;
                    hasUntis = true;
                }
            }
        } else {
            VarHash mc = maximaVarsMitEH;
            VarHash mv = maximaVars;
            varsMaxima.addHashtableCalcErgebnis(maximaVarsMitEH);
            cp = new CalcParams(ZielEinheit.OPTMODE.NONE, CALCMODE.MAXIMA, (CalcParamsQuestionInfo)qc);
            cp.setSymbolicMode(q.isUseSymbolicMode());
            for (String name : mv.keySet()) {
                varsMaxima.putInsertVars(name, mv.get(name), mc, cp);
            }
            mvars = new VarHash();
            qc.setMvars(mvars);
            mvars.addHashtableCalcErgebnis(cvars);
            cp.setSymbolicMode(q.isUseSymbolicMode());
            for (String name : varsMaxima.keySet()) {
                mvars.putInsertVars(name, varsMaxima.get(name), cvars, cp);
            }
        }
        for (SubQuestionRenderDTO sq3 : q.getSubQuestions()) {
            if (sq3.getAnswers().size() == 0) {
                sq3.getAnswers().add(new AnswerRenderDTO(sq3));
            }
            if (sq3.getMode() == SQMODE.CALCULATED) {
                boolean found = false;
                for (AnswerRenderDTO a : sq3.getAnswers()) {
                    if (!(a.getFraction() > 99.0)) continue;
                    found = true;
                }
                if (!found) {
                    ((AnswerRenderDTO)sq3.getAnswers().get(0)).setFraction(100.0);
                }
            }
            for (AnswerRenderDTO a : sq3.getAnswers()) {
                String Erg;
                block86: {
                    try {
                        ZielEinheit zielEinheit;
                        CalcErgebnis ex3;
                        if (a.getMaximaSubFeld().matches("^\\s*$")) {
                            Erg = "";
                            break block86;
                        }
                        if (!q.isSendToParser() && a.getMaximaSubFeld().trim().startsWith(":")) {
                            String cmd = a.getMaximaSubFeld().trim().substring(1);
                            cp = new CalcParams(ZielEinheit.OPTMODE.MAXIMA, CALCMODE.MAXIMA, new CalcToleranz(), (CalcParamsQuestionInfo)qc, true, q.isUseSymbolicMode());
                            if (cmd.startsWith(":")) {
                                cmd = cmd.substring(1);
                                cp = cp.setOptmode(ZielEinheit.OPTMODE.NONE);
                            }
                            if (cmd.length() == 0) {
                                Erg = "";
                                break block86;
                            }
                            try {
                                Vector ve = ParserCache.getCache().getCalcable(cmd);
                                CalcErgebnis e = Calculate.calcableToCalcErgebnis((Vector)ve, (VarHash)maximaVars, (CalcParams)cp);
                                Erg = e.toStringUnquoted(this.questionRenderService.getZielEinheit(a));
                                break block86;
                            }
                            catch (Exception ex2) {
                                q.setMaximaResultErr(m.getAllLinesHTML() + "<br>Fehler bei Berechnung von " + cmd + "<br>");
                                return;
                            }
                        }
                        String ms = a.getMaximaSubFeld().trim();
                        if (q.isPreCalc() && maximaVars.containsKey(ms)) {
                            Erg = maximaVars.getErgebnis(ms).toStringUnquoted(this.questionRenderService.getZielEinheit(a));
                            break block86;
                        }
                        Erg = m.execute(a.getMaximaSubFeld()).getOut();
                        if (maximaVarsMitEH.keySet().size() > 0) {
                            try {
                                ex3 = ParserCache.getCache().calculate(Erg, maximaVarsMitEH, new CalcParams(ZielEinheit.OPTMODE.NUMERIC));
                                zielEinheit = this.questionRenderService.getZielEinheit(a);
                                Erg = ex3.toStringUnquoted(zielEinheit);
                            }
                            catch (Exception ex3) {
                                // empty catch block
                            }
                        }
                        if (!q.isPreCalc()) break block86;
                        if (!q.isSendToParser()) {
                            try {
                                ZielEinheit zielEinheit2 = this.questionRenderService.getZielEinheit(a);
                                CalcErgebnis ex4 = ParserCache.getCache().calculate(a.getMaximaSubFeld(), mvars, new CalcParams(zielEinheit2.calcOptmodeLoesung()).setSymbolicMode(q.isUseSymbolicMode()));
                                Erg = ex4.toStringUnquoted(zielEinheit2);
                            }
                            catch (Exception zielEinheit2) {
                                // empty catch block
                            }
                        }
                        try {
                            ex3 = ParserCache.getCache().calculate(Erg, maximaVarsMitEH, new CalcParams(ZielEinheit.OPTMODE.NUMERIC));
                            zielEinheit = this.questionRenderService.getZielEinheit(a);
                            if (hasUntis && !q.isSendToParser() && (zielEinheit == null || zielEinheit.getEinheit() == null) && ex3.rechenEinheit().isEins()) {
                                ret = (String)ret + "<div style='color:orange;'>WARNUNG: Maxima kann die Einheit von " + sq3.getName() + " nicht ermitteln und es ist keine Zieleinheit definiert! " + Erg + "</div><br>";
                            }
                            if (zielEinheit != null) {
                                ex3 = ex3.setZielEinheit(zielEinheit);
                            }
                            if (zielEinheit.getEinheit() != null) {
                                ex3 = ex3.setEinheit(zielEinheit.getEinheit(), zielEinheit.isForcemodeForce());
                            }
                            Erg = ex3.toStringUnquoted(zielEinheit);
                        }
                        catch (Exception exe) {
                            if (!q.isSendToParser() && this.questionRenderService.getZielEinheit(a) == null) {
                                ret = (String)ret + "<div style='color:orange;'>WARNUNG: Maxima kann die Einheit von " + sq3.getName() + " nicht ermitteln und es ist keine Zieleinheit definiert! " + Erg + "</div><br>";
                            }
                        }
                    }
                    catch (MaximaTimeoutException e) {
                        m.close();
                        q.setMaximaResultErr("<h3>Maxima-Timeout</h3>Die Anfrage an Maxima hat zulange gedauert und wurde unterbrochen!");
                        return;
                    }
                }
                if (Erg.trim().length() > 0 && (q.getQuestionType() == QuestionType.MoodleClozeCalc && (sq3.getMode() == SQMODE.CALCULATED || sq3.getMode() == SQMODE.BOOLSCH || sq3.getMode() == SQMODE.PLUGIN || sq3.getMode() == SQMODE.FREITEXT || sq3.getMode() == SQMODE.REGEXP || sq3.getMode() == SQMODE.TEXT) || q.getQuestionType() == QuestionType.MoodleCalculated || q.getQuestionType() == QuestionType.MoodleCalculated_Multi || q.getQuestionType() == QuestionType.MoodleCalculated_Simple)) {
                    a.setText(Erg);
                } else {
                    Erg = a.getText();
                }
                List datasets = this.questionRenderService.getLettoDatasetDefinitions(q).stream().map(d -> d).collect(Collectors.toList());
                switch (1.$SwitchMap$at$letto$tools$enums$SQMODE[sq3.getMode().ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        ZielEinheit ze = new ZielEinheit();
                        try {
                            ze = new ZielEinheit(a.getEinheit(), datasets);
                            if (ze.getForce() == ZielEinheit.FORCEMODE.FORCE) {
                                a.setAnswer("\"" + a.getText() + "\" regular Expression casesensitive");
                                break;
                            }
                            a.setAnswer("\"" + a.getText() + "\" regular Expression");
                        }
                        catch (RuntimeException e) {
                            a.setAnswer("regular Expression mit falscher Zieleinheit");
                        }
                        break;
                    }
                    case 4: {
                        ZielEinheit ze = new ZielEinheit();
                        try {
                            ze = new ZielEinheit(a.getEinheit(), datasets);
                            if (ze.getForce() == ZielEinheit.FORCEMODE.FORCE) {
                                a.setAnswer("\"" + a.getText() + "\" casesensitive");
                                break;
                            }
                            a.setAnswer("\"" + a.getText() + "\"");
                        }
                        catch (RuntimeException e) {
                            a.setAnswer("\"" + a.getText() + "\" mit falscher Zieleinheit");
                        }
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        Object calcErg = null;
                        ZielEinheit ze = new ZielEinheit();
                        String qName = q.getSubQuestions().size() > 1 ? sq3.getName() + ": " : "";
                        try {
                            ze = this.questionRenderService.getZielEinheit(a);
                        }
                        catch (RuntimeException e) {
                            ret = (String)ret + qName + "Ziel-Einheit konnte nicht geparst werden!<br/>";
                        }
                        try {
                            calcErg = Erg.equals("") ? new CalcString("") : this.calcLoesung(qc, vars, Erg, ze, this.questionRenderService.getToleranz(a), true);
                            if (calcErg instanceof CalcError) {
                                ret = (String)ret + "<div style='color:red;'> Fehler bei " + sq3.getName() + " Error: " + Erg + "</div><br>";
                                calcErg = new CalcString(Erg);
                            } else if (!calcErg.isNumeric() && !q.isUseSymbolicMode() && sq3.getMode() != SQMODE.PLUGIN) {
                                switch (1.$SwitchMap$at$letto$math$einheiten$ZielEinheit$MODE[ze.getMode().ordinal()]) {
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: {
                                        break;
                                    }
                                    default: {
                                        ret = (String)ret + "<div style='color:orange;'>WARNUNG: Ergebnis von " + sq3.getName() + " ist symbolisch (Tippfehler?) : " + Erg + "</div><br>";
                                    }
                                }
                            }
                        }
                        catch (RuntimeException e) {
                            ret = (String)ret + qName + "L\u00f6sung konnte nicht berechnet werden :" + e.getMessage() + "<br/>";
                        }
                        if (calcErg == null || ze == null) break;
                        if (!vars.containsKey(sq3.getName())) {
                            vars.put(sq3.getName(), (CalcErgebnis)calcErg);
                        }
                        if (sq3.getMode() != SQMODE.BOOLSCH && sq3.getMode() != SQMODE.PLUGIN) {
                            cp = new CalcParams(ZielEinheit.OPTMODE.NONE, CALCMODE.MAXIMA, this.questionRenderService.getToleranz(a), (CalcParamsQuestionInfo)qc);
                            if (!q.isPreCalc() || q.isSendToParser()) {
                                CalcSymbol.EinheitsCheck echeck = ze.checkEinheit((CalcErgebnis)calcErg, cp);
                                switch (1.$SwitchMap$at$letto$math$calculate$CalcSymbol$EinheitsCheck$RESULT[echeck.getResult().ordinal()]) {
                                    case 1: {
                                        ret = (String)ret + qName + echeck.getMsg() + "<br/>";
                                        break;
                                    }
                                    case 2: {
                                        break;
                                    }
                                }
                            }
                        }
                        String se = "";
                        ze.addDatasets(datasets);
                        se = calcErg.toString(ze);
                        if (sq3.getMode() == SQMODE.BOOLSCH) break;
                        a.setAnswer(se);
                    }
                }
            }
        }
        String msgFehler = "<span style=\"color:red;\">Es traten Fehler bei der Maxima-Berechnung auf!</span><br><br>";
        q.setMaximaResult(m.hasErrors() ? (String)ret + msgFehler + m.getAllLinesHTML() : (String)ret + m.getAllLinesHTML());
        q.setMaximaResultErr((String)(m.hasErrors() ? (String)ret + msgFehler + m.getErrorsHTML() : ret));
        m.close();
    }

    public CalcErgebnis calcLoesung(QuestionCalc qc, VarHash ds, String loesung, ZielEinheit zielEinheit, CalcToleranz toleranz, boolean logError) {
        VarHash vars;
        QuestionRenderDTO q = qc.getQ();
        CalcError erg = null;
        CalcParams cp = new CalcParams(zielEinheit.calcOptmodeLoesung(), CALCMODE.LOESUNG, toleranz, (CalcParamsQuestionInfo)qc, true, q.isUseSymbolicMode());
        try {
            vars = zielEinheit.getVars(ds);
            for (String key : ds.keySet()) {
                if (!key.matches("^Q\\d+$") || vars.containsKey(key)) continue;
                vars.putGet(ds, key);
            }
            vars.addHashtableCalcErgebnis(this.questionRenderService.getMaximaConst(q));
            cp = cp.setVars(vars);
            cp = cp.setSymbolicMode(zielEinheit.isSuchMuster() || q.isUseSymbolicMode());
            erg = ParserCache.getCache().calculate(loesung, vars, cp);
        }
        catch (Exception e) {
            erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, e.getMessage());
        }
        LettoTimer.checkInterrupt();
        switch (1.$SwitchMap$at$letto$math$einheiten$ZielEinheit$MODE[zielEinheit.getMode().ordinal()]) {
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (erg != null && erg instanceof CalcLong) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Im Einheiten Mode " + zielEinheit.getMode() + " muss das Ergebnis eine Ganzzahl sein!");
                break;
            }
            case 10: {
                if (erg != null && erg instanceof CalcLong || erg instanceof CalcRational) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Im Einheiten Mode " + zielEinheit.getMode() + " muss das Ergebnis eine Ganzzahl oder ein Bruch von Ganzzahlen sein!");
                break;
            }
            case 11: {
                if (erg != null && erg instanceof CalcNumerical) {
                    if (erg instanceof CalcComplexEinheit || erg instanceof CalcComplex) {
                        erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "komplexe Zahl ist nicht als Farbcode interpretierbar!");
                    }
                    erg = new CalcDouble(erg.toDouble());
                    break;
                }
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Ergebnis ist nicht als Farbcode interpretierbar!");
                break;
            }
            case 12: {
                if (!(erg instanceof CalcNumerical)) {
                    erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert sein!");
                }
                if (!(erg instanceof CalcPhysical)) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert ohne Einheit sein!");
                break;
            }
            case 13: {
                if (erg != null) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert sein!");
                break;
            }
            case 14: {
                if (erg instanceof CalcNumerical) break;
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, "Das Ergebnis muss ein Zahlenwert sein!");
                break;
            }
        }
        if (zielEinheit.isSuchMuster() && !zielEinheit.testSchuelereingabeSuchmuster(erg.toString())) {
            try {
                vars = zielEinheit.getVars(ds);
                vars.addHashtableCalcErgebnis(this.questionRenderService.getMaximaConst(q));
                erg = ParserCache.getCache().calculate(loesung, vars, cp);
                if (!zielEinheit.testSchuelereingabeSuchmuster(erg.toString())) {
                    erg = new CalcError(CalcError.Fehler.MUSTERFEHLER, erg.toString() + "<->" + zielEinheit.calcSuchmuster());
                }
            }
            catch (Exception e) {
                erg = new CalcError(CalcError.Fehler.BERECHNUNGSFEHLER, e.getMessage());
            }
        }
        List datasets = this.questionRenderService.getLettoDatasetDefinitions(q).stream().map(d -> d).collect(Collectors.toList());
        zielEinheit.addDatasets(datasets);
        erg = erg.setZielEinheit(zielEinheit);
        return erg;
    }

    public String getMaximaPath() {
        return this.maximaPath;
    }

    public QuestionRenderService getQuestionRenderService() {
        return this.questionRenderService;
    }

    public DatasetService getDatasetService() {
        return this.datasetService;
    }

    public void setMaximaPath(String maximaPath) {
        this.maximaPath = maximaPath;
    }

    public void setQuestionRenderService(QuestionRenderService questionRenderService) {
        this.questionRenderService = questionRenderService;
    }

    public void setDatasetService(DatasetService datasetService) {
        this.datasetService = datasetService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaximaService)) {
            return false;
        }
        MaximaService other = (MaximaService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$maximaPath = this.getMaximaPath();
        String other$maximaPath = other.getMaximaPath();
        if (this$maximaPath == null ? other$maximaPath != null : !this$maximaPath.equals(other$maximaPath)) {
            return false;
        }
        QuestionRenderService this$questionRenderService = this.getQuestionRenderService();
        QuestionRenderService other$questionRenderService = other.getQuestionRenderService();
        if (this$questionRenderService == null ? other$questionRenderService != null : !this$questionRenderService.equals(other$questionRenderService)) {
            return false;
        }
        DatasetService this$datasetService = this.getDatasetService();
        DatasetService other$datasetService = other.getDatasetService();
        return !(this$datasetService == null ? other$datasetService != null : !this$datasetService.equals(other$datasetService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaximaService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $maximaPath = this.getMaximaPath();
        result = result * 59 + ($maximaPath == null ? 43 : $maximaPath.hashCode());
        QuestionRenderService $questionRenderService = this.getQuestionRenderService();
        result = result * 59 + ($questionRenderService == null ? 43 : $questionRenderService.hashCode());
        DatasetService $datasetService = this.getDatasetService();
        result = result * 59 + ($datasetService == null ? 43 : $datasetService.hashCode());
        return result;
    }

    public String toString() {
        return "MaximaService(maximaPath=" + this.getMaximaPath() + ", questionRenderService=" + this.getQuestionRenderService() + ", datasetService=" + this.getDatasetService() + ")";
    }
}

