/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.data.dto.tests.TestDetailDto;
import at.letto.data.dto.tests.testAnswer.TestAnswerDetailDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortSqDto;
import at.letto.question.dto.renderedQuestion.html.QuestionHtmlDTO;
import at.letto.question.dto.renderedQuestion.html.SubQuestionHtmlDTO;
import at.letto.questionservice.dto.renderedQuestion.InputAnswer;
import at.letto.questionservice.dto.renderedQuestion.InputQuestion;
import at.letto.questionservice.dto.renderedQuestion.InputSubQuestion;
import at.letto.questionservice.dto.renderedQuestion.QuestionInfo;
import at.letto.questionservice.dto.score.ErgAnswerDto;
import at.letto.questionservice.dto.score.ErgQuestionDto;
import at.letto.questionservice.dto.score.ErgSubquestionDto;
import at.letto.tools.enums.QuestionType;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class InputQuestionService {
    public static InputQuestion loadQuestion(int idDetail, QuestionInfo qi) {
        return InputQuestionService.loadQuestion((int)idDetail, (QuestionInfo)qi, null);
    }

    public static InputQuestion loadQuestion(int idDetail, QuestionInfo questionInfo, TestAntwortDto inp) {
        InputQuestion q = new InputQuestion();
        q.setIdTestDetail(idDetail);
        QuestionHtmlDTO angabe = questionInfo.getHtmlDto();
        q.setAngabe(angabe);
        if (inp == null) {
            inp = InputQuestionService.neueTestAntwort((QuestionHtmlDTO)angabe, (int)idDetail, (String)questionInfo.getDataset());
        }
        try {
            if (!angabe.getQuestionType().equals((Object)QuestionType.MoodleClozeCalc)) {
                ((TestAntwortSqDto)inp.getSqAntworten().get(0)).setSq("Q0");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        inp.setIdQuestion(questionInfo.getId());
        q.setInput(inp);
        q.setInputOld(inp.clone());
        q.setSubQuestions(new Vector());
        Map<String, TestAntwortSqDto> ans = inp.getSqAntworten().stream().collect(Collectors.toMap(ta -> ta.getSq(), ta -> ta, (ta1, ta2) -> ta1));
        for (SubQuestionHtmlDTO sqHtml : angabe.getSubQuestions()) {
            int answers = sqHtml.getAnswers().size();
            if (sqHtml.getName() != null && !ans.containsKey(sqHtml.getName())) {
                TestAntwortSqDto newAns = new TestAntwortSqDto(sqHtml.getName(), answers, inp);
                ans.put(sqHtml.getName(), newAns);
                inp.getSqAntworten().add(newAns);
            }
            q.getSubQuestions().add(new InputSubQuestion(sqHtml, ans.get(sqHtml.getName()), q));
        }
        return q;
    }

    public static InputQuestion loadQuestion(TestDetailDto td, QuestionInfo qi, TestAntwortDto inp) {
        InputQuestion q = InputQuestionService.loadQuestion((int)td.getId(), (QuestionInfo)qi, (TestAntwortDto)inp);
        q.setTestDetail(td);
        InputQuestionService.addErgebnis((InputQuestion)q, (ErgQuestionDto)qi.getErgDto());
        return q;
    }

    public static void addErgebnis(InputQuestion q, ErgQuestionDto erg) {
        if (erg == null) {
            return;
        }
        q.setErgebnis(erg);
        double faktor = 1.0;
        double pointsQuestion = 0.0;
        for (ErgSubquestionDto sq : erg.getErgSubquestions()) {
            if (!(sq.getGrade() > 0.0)) continue;
            pointsQuestion += sq.getGrade();
        }
        if (pointsQuestion == 0.0) {
            pointsQuestion = erg.getPunkte();
        }
        if (pointsQuestion == 0.0) {
            pointsQuestion = 1.0;
        }
        if (q.getTestDetail() != null) {
            q.getTestDetail().setPointsQuestion(pointsQuestion);
        }
        try {
            faktor = q.getTestDetail().getPoints() / pointsQuestion;
        }
        catch (Exception exception) {
            // empty catch block
        }
        double finalFaktor = faktor;
        erg.getErgSubquestions().forEach(ergSq -> {
            for (InputSubQuestion sq : q.getSubQuestions()) {
                try {
                    if (sq.getInput() == null || sq.getInput().getSq() == null || !sq.getInput().getSq().equals(ergSq.getSqName())) continue;
                    sq.setErgebnis(ergSq);
                    double points = ergSq.getGrade();
                    sq.getInput().setSoll(Double.valueOf(points * finalFaktor));
                    for (int i = 0; i < sq.getAnswers().size(); ++i) {
                        if (ergSq.getErgAnswers().size() <= i) continue;
                        ((InputAnswer)sq.getAnswers().get(i)).setErg((ErgAnswerDto)ergSq.getErgAnswers().get(i));
                    }
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (!q.getAngabe().getQuestionType().equals((Object)QuestionType.MoodleClozeCalc) && !q.getAngabe().getQuestionType().equals((Object)QuestionType.MoodleCloze)) {
                Double soll = null;
                try {
                    soll = q.getFirstSubquestion().getInput().getSoll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (soll == null || soll <= 1.0E-8) {
                    if (q.getFirstSubquestion().getInput() == null) {
                        q.getFirstSubquestion().setInput(new TestAntwortSqDto());
                    }
                    if (q.getTestDetail() != null) {
                        q.getFirstSubquestion().getInput().setSoll(Double.valueOf(q.getTestDetail().getPointsQuestion()));
                    }
                }
            }
        });
    }

    public static InputQuestion loadDecryptError() {
        InputQuestion inputQuestion = new InputQuestion();
        QuestionHtmlDTO angabe = new QuestionHtmlDTO();
        angabe.setDecryptError(true);
        inputQuestion.setAngabe(angabe);
        return inputQuestion;
    }

    public static void addAnswerToQuestion(InputQuestion q, TestAntwortDto a) {
        q.setInput(a);
        a.getSqAntworten().forEach(aSq -> {
            for (InputSubQuestion sq : q.getSubQuestions()) {
                if (sq.getAngabe().getName() == null || !sq.getAngabe().getName().equals(aSq.getSq())) continue;
                sq.setInput(aSq);
                for (int i = 0; i < sq.getAnswers().size(); ++i) {
                    if (aSq.getAntworten().size() <= i) continue;
                    ((InputAnswer)sq.getAnswers().get(i)).setInput((TestAnswerDetailDto)aSq.getAntworten().get(i));
                }
            }
        });
    }

    public static TestAntwortDto neueTestAntwort(QuestionHtmlDTO angabe, int idDetail, String dataset) {
        if (dataset == null) {
            dataset = "";
        }
        TestAntwortDto inp = new TestAntwortDto();
        inp.setTimestamp(new Date());
        inp.setSqAntworten(angabe.getSubQuestions().stream().filter(sq -> sq.getName() != null).map(sq -> new TestAntwortSqDto(sq.getName(), sq.getAnswers().size(), inp)).collect(Collectors.toList()));
        inp.setIdDetail(idDetail);
        inp.setDataset(idDetail <= 0 ? dataset : "");
        inp.setIdQuestion(angabe.getIdQuestion());
        return inp;
    }

    public static TestAntwortDto neueTestAntwort(ErgQuestionDto ergebnisse, int idDetail) {
        TestAntwortDto inp = new TestAntwortDto();
        inp.setTimestamp(new Date());
        inp.setSqAntworten(ergebnisse.getErgSubquestions().stream().map(sq -> new TestAntwortSqDto(sq.getSqName(), sq.getErgAnswers().size(), inp, sq.getGrade())).collect(Collectors.toList()));
        inp.setIdDetail(idDetail);
        return inp;
    }
}

