/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.math.VarHash;
import at.letto.math.Werte;
import at.letto.math.calculate.CalcComplex;
import at.letto.math.calculate.CalcComplexEinheit;
import at.letto.math.calculate.CalcDouble;
import at.letto.math.calculate.CalcErgebnis;
import at.letto.math.calculate.CalcLong;
import at.letto.math.calculate.CalcMatrix;
import at.letto.math.calculate.CalcNumerical;
import at.letto.math.calculate.CalcPhysical;
import at.letto.math.calculate.CalcString;
import at.letto.math.calculate.CalcVector;
import at.letto.math.calculate.params.CalcParams;
import at.letto.math.complex.Complex;
import at.letto.math.einheiten.BasisEinheit;
import at.letto.math.einheiten.Einheit;
import at.letto.math.einheiten.EinheitenParser;
import at.letto.math.einheiten.PrintPrecision;
import at.letto.math.einheiten.ZielEinheit;
import at.letto.math.enums.CALCMODE;
import at.letto.question.dto.DatasetrenderDTO;
import at.letto.questionservice.service.DatasetService;
import at.letto.questionservice.service.ZahlenBereich;
import com.mifmif.common.regex.Generex;
import java.util.Collections;
import java.util.Vector;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DatasetService {
    public static String addDatasetItem(DatasetrenderDTO ds, String data) {
        if (ds.getItems() == null) {
            ds.setItems("");
        }
        if (ds.getItems().length() > 0) {
            ds.setItems(ds.getItems() + ";" + data);
        } else {
            ds.setItems(data);
        }
        ds.setDataset_items(null);
        return data;
    }

    public static void removeDatasetItem(DatasetrenderDTO ds, int index) {
        Vector dataset_items = DatasetService.getDataset_items((DatasetrenderDTO)ds);
        if (index < dataset_items.size()) {
            dataset_items.remove(index);
            ds.setDataset_items(dataset_items);
        }
    }

    public static String getDatasetItem(DatasetrenderDTO ds, int index) {
        return (String)DatasetService.getDataset_items((DatasetrenderDTO)ds).get(index);
    }

    public static void setDatasetItem(DatasetrenderDTO ds, int index, String wert) {
        Vector dataset_items = DatasetService.getDataset_items((DatasetrenderDTO)ds);
        if (index < dataset_items.size()) {
            dataset_items.set(index, wert);
            DatasetService.setDataset_items((DatasetrenderDTO)ds, (Vector)dataset_items);
        }
    }

    public static void setDataset_items(DatasetrenderDTO ds, Vector<String> dataset_items) {
        Object newitems = "";
        for (String item : dataset_items) {
            if (((String)newitems).length() > 0) {
                newitems = (String)newitems + ";" + item;
                continue;
            }
            newitems = item;
        }
        ds.setItems((String)newitems);
    }

    private static Vector<String> getDataset_items(DatasetrenderDTO ds) {
        if (ds.getDataset_items() != null) {
            return ds.getDataset_items();
        }
        ds.setDataset_items(new Vector());
        for (String item : ds.getItems().split(";")) {
            ds.getDataset_items().add(item);
        }
        return ds.getDataset_items();
    }

    public static String generateDataset(DatasetrenderDTO ds, int anz) {
        if (anz < 1) {
            return null;
        }
        try {
            if (ds.getZahlenbereich().startsWith("import")) {
                return ds.getItems().split(";")[0];
            }
            ZahlenBereich ZBS = new ZahlenBereich(ds.getZahlenbereich(), ds.getEinheit());
            ds.setZiffern(ZBS.ziffern);
            if (anz > 1) {
                ds.setItems("");
            }
            int ziff = Werte.PRINTPREC + 1;
            Object zb = ZBS.zb;
            if (ZBS.modi == DatasetrenderDTO.DATASETTYPE.STRING || ZBS.modi == DatasetrenderDTO.DATASETTYPE.REGEXP) {
                Vector<String> werte = new Vector<String>();
                if (ZBS.modi == DatasetrenderDTO.DATASETTYPE.STRING) {
                    String zbx = ((String)zb).replaceAll("\\\\,", ";kommaseparator;");
                    for (String s : zbx.split(",")) {
                        if ((s = s.replaceAll(";kommaseparator;", ",")).trim().length() <= 0) continue;
                        werte.add(s.trim());
                    }
                    Collections.shuffle(werte);
                    for (int num = 1; num <= anz; ++num) {
                        if (anz == 1) {
                            return (String)werte.get(0);
                        }
                        DatasetService.addDatasetItem((DatasetrenderDTO)ds, (String)((String)werte.get(0)));
                        Collections.shuffle(werte);
                    }
                } else {
                    Matcher m;
                    String pkt = "[abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_\\.!:#\\+\\*\\?\\[\\]\\{\\}\\(\\)\u00a7\\$ ]";
                    String[] zbx = ((String)zb).split("\\.");
                    if (zbx.length == 0) {
                        if (((String)zb).equals(".")) {
                            zb = pkt;
                        }
                    } else {
                        zb = zbx[0];
                        for (int i = 1; i < zbx.length; ++i) {
                            zb = ((String)zb).endsWith("\\") ? (String)zb + "." + zbx[i] : (String)zb + pkt + zbx[i];
                        }
                    }
                    ((String)zb).replaceAll("\\,", "");
                    ((String)zb).replaceAll("\\;", "");
                    zb = ((String)zb).replaceAll("\\\\s", " ");
                    while ((m = Pattern.compile("^(.*)\\[\\^([^\\]]+)\\](.*)").matcher((CharSequence)zb)).find()) {
                        String bs = pkt;
                        char[] ca = m.group(2).toCharArray();
                        for (int i = 0; i < ca.length; ++i) {
                            if (ca[i] == '\\') {
                                if (i < ca.length - 1 && ca[i + 1] != '\\') {
                                    bs = ca[i + 1] == 'w' ? bs.replaceAll("a.*_", "") : (ca[i + 1] == 'd' ? bs.replaceAll("0.*9", "") : (ca[i + 1] == 's' ? bs.replaceAll(" ", "") : bs.replaceAll("\\\\" + ca[i + 1], "")));
                                }
                                ++i;
                                continue;
                            }
                            if (ca[i] == '[' || ca[i] == ']') continue;
                            bs = i < ca.length - 2 && ca[i + 1] == '-' ? bs.replaceAll(ca[i] + ".*" + ca[i + 2], "") : bs.replaceAll("" + ca[i], "");
                        }
                        zb = m.group(1) + bs + m.group(3);
                    }
                    int num = 1;
                    for (int ct = 0; num <= anz && ct < 1000; ++ct) {
                        try {
                            Generex random = new Generex((String)zb);
                            String s = random.random(ZBS.m1, ZBS.m2);
                            if ((s.length() < ZBS.m1 || s.length() > ZBS.m2) && ds.getZahlenbereich().matches(".*[\\*\\+].*")) continue;
                            if (anz == 1) {
                                return s;
                            }
                            DatasetService.addDatasetItem((DatasetrenderDTO)ds, (String)s);
                            werte.add(s);
                            ++num;
                            continue;
                        }
                        catch (Exception random) {
                            // empty catch block
                        }
                    }
                }
                if (anz == 1) {
                    return null;
                }
                Collections.sort(werte);
                ds.setMinimum((String)werte.get(0));
                ds.setMaximum((String)werte.get(werte.size() - 1));
                ds.setItemcount(anz);
                return ds.getItems();
            }
            if (ZBS.modi == DatasetrenderDTO.DATASETTYPE.SORTEDINT) {
                boolean first = true;
                long min = 0L;
                long max = 0L;
                String mins = "";
                String maxs = "";
                for (String s : ((String)zb).split(",")) {
                    if (s.trim().length() <= 0) continue;
                    try {
                        long w = Long.parseLong(s.trim());
                        CalcLong wl = new CalcLong(w);
                        CalcLong x = ZBS.einheit != null ? ZBS.einheit.wertToSIwert((CalcNumerical)wl) : wl;
                        String ws = x.toString(new PrintPrecision(ziff));
                        if (anz == 1) {
                            return ws;
                        }
                        DatasetService.addDatasetItem((DatasetrenderDTO)ds, (String)ws);
                        if (first) {
                            min = w;
                            max = w;
                            mins = ws;
                            maxs = ws;
                            first = false;
                        }
                        if (w < min) {
                            min = w;
                            mins = ws;
                        }
                        if (w <= max) continue;
                        max = w;
                        maxs = ws;
                    }
                    catch (Exception w) {
                        // empty catch block
                    }
                }
                if (anz == 1) {
                    return null;
                }
                ds.setMinimum(mins);
                ds.setMaximum(maxs);
                ds.setItemcount(anz);
                return ds.getItems();
            }
            if (ZBS.modi == DatasetrenderDTO.DATASETTYPE.SORTEDFLOAT) {
                Vector<Double> werte = new Vector<Double>();
                boolean first = true;
                double min = 0.0;
                double max = 0.0;
                String mins = "";
                String maxs = "";
                for (String s : ((String)zb).split(",")) {
                    if (s.trim().length() <= 0) continue;
                    try {
                        double w = Werte.parseWert((String)s.trim());
                        CalcDouble wl = new CalcDouble(w);
                        CalcDouble x = ZBS.einheit != null ? ZBS.einheit.wertToSIwert((CalcNumerical)wl) : wl;
                        String ws = x.toString(new PrintPrecision(ziff));
                        werte.addElement(w);
                        if (anz == 1) {
                            return ws;
                        }
                        DatasetService.addDatasetItem((DatasetrenderDTO)ds, (String)ws);
                        if (first) {
                            min = w;
                            max = w;
                            mins = ws;
                            maxs = ws;
                            first = false;
                        }
                        if (w < min) {
                            min = w;
                            mins = ws;
                        }
                        if (!(w > max)) continue;
                        max = w;
                        maxs = ws;
                    }
                    catch (Exception w) {
                        // empty catch block
                    }
                }
                if (anz == 1) {
                    return null;
                }
                ds.setMinimum(mins);
                ds.setMaximum(maxs);
                ds.setItemcount(anz);
                return ds.getItems();
            }
            if (ZBS.modi == DatasetrenderDTO.DATASETTYPE.SORTEDSTRING) {
                Vector<String> werte = new Vector<String>();
                String zbx = ((String)zb).replaceAll("\\\\,", ";kommaseparator;");
                for (String s : zbx.split(",")) {
                    if ((s = s.replaceAll(";kommaseparator;", ",")).trim().length() <= 0) continue;
                    try {
                        s = s.trim();
                        werte.add(s);
                        if (anz == 1) {
                            return s;
                        }
                        DatasetService.addDatasetItem((DatasetrenderDTO)ds, (String)s);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (anz == 1) {
                    return null;
                }
                Collections.sort(werte);
                ds.setMinimum((String)werte.get(0));
                ds.setMaximum((String)werte.get(werte.size() - 1));
                ds.setItemcount(anz);
                return ds.getItems();
            }
            Vector werte = new Vector();
            werte = DatasetService.parseDatasetWerte((DatasetrenderDTO)ds, (DatasetrenderDTO.DATASETTYPE)ZBS.modi, (String)zb, (boolean)false, (int)ZBS.ziffernGen);
            if (ZBS.modi == DatasetrenderDTO.DATASETTYPE.COMPLEX || ZBS.modi == DatasetrenderDTO.DATASETTYPE.COMPLEXKAR || ZBS.modi == DatasetrenderDTO.DATASETTYPE.COMPLEXPOL) {
                Vector werte2 = new Vector();
                if (ZBS.modi == DatasetrenderDTO.DATASETTYPE.COMPLEX) {
                    ZBS.zbw = "I0-360\u00b0";
                }
                werte2 = ZBS.modi == DatasetrenderDTO.DATASETTYPE.COMPLEXKAR ? DatasetService.parseDatasetWerte((DatasetrenderDTO)ds, (DatasetrenderDTO.DATASETTYPE)ZBS.modi, (String)ZBS.zbw, (boolean)false, (int)ZBS.ziffernGen) : DatasetService.parseDatasetWerte((DatasetrenderDTO)ds, (DatasetrenderDTO.DATASETTYPE)ZBS.modi, (String)ZBS.zbw, (boolean)true, (int)ZBS.ziffernGen);
                if (werte.size() == 1 && werte2.size() > 0) {
                    CalcNumerical w1 = (CalcNumerical)werte.get(0);
                    for (int i = 0; i < werte2.size(); ++i) {
                        CalcComplex w = ZBS.modi == DatasetrenderDTO.DATASETTYPE.COMPLEXKAR ? new CalcComplex(new Complex(w1.toDouble(), ((CalcNumerical)werte2.get(i)).toDouble())) : new CalcComplex(new Complex(w1.toDouble(), ((CalcNumerical)werte2.get(i)).toDouble(), false));
                        if (i == 0) {
                            werte.set(0, w);
                            continue;
                        }
                        werte.add(w);
                    }
                } else {
                    for (int i = 0; i < werte.size(); ++i) {
                        Collections.shuffle(werte2);
                        if (ZBS.modi == DatasetrenderDTO.DATASETTYPE.COMPLEXKAR) {
                            werte.set(i, new CalcComplex(new Complex(((CalcNumerical)werte.get(i)).toDouble(), ((CalcNumerical)werte2.get(0)).toDouble())));
                            continue;
                        }
                        werte.set(i, new CalcComplex(new Complex(((CalcNumerical)werte.get(i)).toDouble(), ((CalcNumerical)werte2.get(0)).toDouble(), false)));
                    }
                }
            }
            Vector<CalcNumerical> werteEH = new Vector<CalcNumerical>();
            for (CalcNumerical w : werte) {
                CalcNumerical x;
                CalcNumerical calcNumerical = x = ZBS.einheit != null ? ZBS.einheit.wertToSIwert(w) : w;
                if (x instanceof CalcComplex) {
                    ((CalcComplex)x).toComplex().printmode = ZBS.cm;
                }
                werteEH.add(x);
            }
            Collections.shuffle(werteEH);
            double min = ((CalcNumerical)werteEH.get(0)).doubleNorm();
            double max = ((CalcNumerical)werteEH.get(0)).doubleNorm();
            for (int num = 1; num <= anz; ++num) {
                double w = ((CalcNumerical)werteEH.get(0)).doubleNorm();
                if (w < min) {
                    min = w;
                }
                if (w > max) {
                    max = w;
                }
                try {
                    switch (1.$SwitchMap$at$letto$question$dto$DatasetrenderDTO$DATASETTYPE[ZBS.modi.ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            String s = ((CalcNumerical)werteEH.get(0)).toString(new PrintPrecision(ziff));
                            if (anz == 1) {
                                return s;
                            }
                            DatasetService.addDatasetItem((DatasetrenderDTO)ds, (String)s);
                            break;
                        }
                        case 6: {
                            CalcNumerical[][] ma = new CalcNumerical[ZBS.m1][ZBS.m2];
                            for (int i = 0; i < ZBS.m1; ++i) {
                                for (int j = 0; j < ZBS.m2; ++j) {
                                    ma[i][j] = (CalcNumerical)werteEH.get((i * ZBS.m2 + j) % werteEH.size());
                                }
                            }
                            String s = new CalcMatrix((CalcErgebnis[][])ma).toString(new PrintPrecision(ziff));
                            if (anz == 1) {
                                return s;
                            }
                            DatasetService.addDatasetItem((DatasetrenderDTO)ds, (String)s);
                            break;
                        }
                        case 7: {
                            int i;
                            int ct = 0;
                            CalcMatrix matrix = null;
                            do {
                                ++ct;
                                CalcNumerical[][] rma = new CalcNumerical[ZBS.m1][ZBS.m1];
                                for (i = 0; i < ZBS.m1; ++i) {
                                    for (int j = 0; j < ZBS.m1; ++j) {
                                        rma[i][j] = (CalcNumerical)werteEH.get((int)(Math.random() * 10.0 * (double)werteEH.size()) % werteEH.size());
                                    }
                                }
                                matrix = new CalcMatrix((CalcErgebnis[][])rma);
                            } while (ct < 10000 && matrix.determinante(new CalcParams(ZielEinheit.OPTMODE.NUMERIC)).isNull());
                            if (matrix.determinante(new CalcParams(ZielEinheit.OPTMODE.NUMERIC)).isNull()) {
                                System.out.println("Es konnte keine regul\u00e4re Matrix gebildet werden!");
                            }
                            String s = matrix.toString(new PrintPrecision(ziff));
                            if (anz == 1) {
                                return s;
                            }
                            DatasetService.addDatasetItem((DatasetrenderDTO)ds, (String)s);
                            break;
                        }
                        case 8: {
                            int i;
                            CalcNumerical[] v = new CalcNumerical[ZBS.m1];
                            for (i = 0; i < v.length; ++i) {
                                v[i] = (CalcNumerical)werteEH.get(i % werteEH.size());
                            }
                            String s = new CalcVector((CalcErgebnis[])v).toString(new PrintPrecision(ziff));
                            if (anz == 1) {
                                return s;
                            }
                            DatasetService.addDatasetItem((DatasetrenderDTO)ds, (String)s);
                            break;
                        }
                        case 9: {
                            break;
                        }
                        case 10: {
                            break;
                        }
                        case 11: {
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Collections.shuffle(werteEH);
            }
            if (anz == 1) {
                return null;
            }
            ds.setMinimum(Werte.doubleToString((double)min, (PrintPrecision)new PrintPrecision(ziff), (boolean)false));
            ds.setMaximum(Werte.doubleToString((double)max, (PrintPrecision)new PrintPrecision(ziff), (boolean)false));
            ds.setItemcount(anz);
            return ds.getItems();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getNumber_of_items(DatasetrenderDTO ds) {
        return DatasetService.getDataset_items((DatasetrenderDTO)ds).size();
    }

    public static CalcErgebnis getWert(DatasetrenderDTO ds, int nr) {
        String value = "(undef)";
        if (nr < 0) {
            value = DatasetService.generateDataset((DatasetrenderDTO)ds, (int)1);
        } else if (DatasetService.getNumber_of_items((DatasetrenderDTO)ds) > nr) {
            value = DatasetService.getDatasetItem((DatasetrenderDTO)ds, (int)nr);
        } else if (DatasetService.getNumber_of_items((DatasetrenderDTO)ds) > 0) {
            value = DatasetService.getDatasetItem((DatasetrenderDTO)ds, (int)(nr % DatasetService.getNumber_of_items((DatasetrenderDTO)ds)));
        }
        if (value != null && !value.equals("(undef)")) {
            try {
                CalcLong wert = null;
                if (ds.getZahlenbereich().matches("^:?\\s*I.*")) {
                    try {
                        wert = new CalcLong(value);
                    }
                    catch (Exception e1) {
                        wert = new CalcDouble(value);
                    }
                } else if (ds.getZahlenbereich().matches("^:?\\s*C\\d*\\:.*")) {
                    wert = new CalcComplex(value);
                } else if (ds.getZahlenbereich().matches("^:?\\s*V\\d+\\:.*")) {
                    wert = new CalcVector(value);
                } else if (ds.getZahlenbereich().matches("^:?\\s*M\\d+x\\d+\\:.*")) {
                    wert = new CalcMatrix(value);
                } else if (ds.getZahlenbereich().matches("^:?\\s*M\\d\\:.*")) {
                    wert = new CalcMatrix(value);
                } else {
                    if (ds.getZahlenbereich().matches("^:?\\s*(S|R|(R\\d+)|(R\\d+\\-\\d+)):.*")) {
                        return new CalcString(value);
                    }
                    if (ds.getZahlenbereich().matches("^:?\\s*sS\\:.*")) {
                        return new CalcString(value);
                    }
                    if (ds.getZahlenbereich().matches("^:?\\s*sI\\:.*")) {
                        try {
                            wert = new CalcLong(value);
                        }
                        catch (Exception e1) {
                            wert = new CalcDouble(value);
                        }
                    } else {
                        wert = new CalcDouble(value);
                    }
                }
                try {
                    String ehs = ds.getEinheit();
                    boolean ehforce = false;
                    if (ehs.startsWith("=")) {
                        ehs = ehs.substring(1);
                        ehforce = true;
                    }
                    String[] ex = ehs.split(",");
                    ZielEinheit.COMPLEXMODE cm = ZielEinheit.COMPLEXMODE.standard;
                    BasisEinheit e = null;
                    for (String exx : ex) {
                        boolean ok = false;
                        for (ZielEinheit.COMPLEXMODE cx : ZielEinheit.COMPLEXMODE.values()) {
                            if (!cx.toString().equals(exx.trim())) continue;
                            ok = true;
                            cm = cx;
                        }
                        if (ok) continue;
                        e = EinheitenParser.parseSIEinheit((String)exx);
                    }
                    if (e == null) {
                        e = Einheit.EINS;
                    }
                    if (wert instanceof CalcComplex) {
                        ((CalcComplex)wert).toComplex().printmode = cm;
                    }
                    if (e != Einheit.EINS) {
                        wert = wert.setEinheit((Einheit)e, ehforce);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return wert;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setDatasetWert(DatasetrenderDTO ds, String wert, VarHash vars) {
        try {
            CalcString val;
            ZielEinheit ze = null;
            String DatasetEinheit = "";
            try {
                DatasetEinheit = ds.getEinheit().trim();
                ze = new ZielEinheit(DatasetEinheit);
                ze.setPrintPrec(new PrintPrecision(new ZahlenBereich((String)ds.getZahlenbereich(), (String)ds.getEinheit()).ziffern));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String zb = ds.getZahlenbereich();
            if (zb.matches("^\\s*(sS|S|R|(R\\d+)|(R\\d+\\-\\d+)):.*")) {
                if (wert.trim().startsWith("\"") && wert.trim().endsWith("\"")) {
                    String s = wert.trim();
                    val = new CalcString(s.substring(1, s.length() - 1));
                } else {
                    val = new CalcString(wert);
                }
            } else {
                try {
                    wert = wert.trim();
                    if (wert.startsWith("\"") && wert.endsWith("\"")) {
                        wert = wert.substring(1, wert.length() - 1);
                    }
                    CalcErgebnis.ParseResult result = CalcErgebnis.parse((String)wert.trim(), (CalcErgebnis.ParseMode)CalcErgebnis.ParseMode.LOESUNG);
                    if (result.rest.trim().length() != 0) {
                        throw new RuntimeException("out");
                    }
                    val = result.ergebnis;
                }
                catch (Exception ex) {
                    val = CalcErgebnis.parse((String)wert.trim(), (CalcParams)new CalcParams(ZielEinheit.OPTMODE.NUMERIC, CALCMODE.MAXIMA));
                }
                try {
                    if (ze.getForce() == ZielEinheit.FORCEMODE.FORCE) {
                        DatasetEinheit = DatasetEinheit.substring(1);
                    }
                    Einheit e = Einheit.parseEinheit((String)DatasetEinheit);
                    boolean ehforce = false;
                    if (val instanceof CalcPhysical) {
                        ehforce = ((CalcPhysical)val).isEhForce();
                    }
                    if (!e.equals((Einheit)Einheit.EINS)) {
                        val = val.setEinheit(e, ehforce);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            val.setZielEinheit(ze);
            if (zb.matches("^\\S*F.*") && val instanceof CalcLong) {
                val = new CalcDouble(val.toDouble());
            }
            if (vars.containsKey(ds.getName())) {
                ze = vars.getZielEinheit(ds.getName());
            }
            vars.put(ds.getName().trim(), (CalcErgebnis)val, ze);
            if (val instanceof CalcVector) {
                for (int z = 0; z < ((CalcVector)val).getDimension(); ++z) {
                    vars.put(ds.getName().trim() + "_" + (z + 1), ((CalcVector)val).get(z), ze);
                }
            }
            if (val instanceof CalcMatrix) {
                for (int z = 0; z < ((CalcMatrix)val).getZeilen(); ++z) {
                    for (int s = 0; s < ((CalcMatrix)val).getSpalten(); ++s) {
                        vars.put(ds.getName().trim() + "_" + (z + 1) + "_" + (s + 1), ((CalcMatrix)val).get(z, s), ze);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getWerte(DatasetrenderDTO ds, int nr, VarHash vars) {
        block6: {
            CalcErgebnis w;
            block8: {
                block7: {
                    w = DatasetService.getWert((DatasetrenderDTO)ds, (int)nr);
                    if (w == null) break block6;
                    this.setDatasetWert(ds, w instanceof CalcString ? ((CalcString)w).toStringUnquoted() : w.toString(), vars);
                    if (nr >= 0) {
                        w = DatasetService.getWert((DatasetrenderDTO)ds, (int)nr);
                    }
                    if (!(w instanceof CalcVector)) break block7;
                    CalcVector v = (CalcVector)w;
                    for (int i = 0; i < v.getDimension(); ++i) {
                        vars.put(ds.getName().trim() + "_" + (i + 1), v.get(i));
                    }
                    break block6;
                }
                if (!(w instanceof CalcMatrix)) break block8;
                CalcMatrix m = (CalcMatrix)w;
                for (int z = 0; z < m.getZeilen(); ++z) {
                    for (int s = 0; s < m.getSpalten(); ++s) {
                        vars.put(ds.getName().trim() + "_" + (z + 1) + "_" + (s + 1), m.get(z, s));
                    }
                }
                break block6;
            }
            if (!(w instanceof CalcComplex) && !(w instanceof CalcComplexEinheit)) break block6;
            ZielEinheit ze = null;
            try {
                String DatasetEinheit = ds.getEinheit().trim();
                ze = new ZielEinheit(DatasetEinheit);
                ze.setPrintPrec(new PrintPrecision(new ZahlenBereich((String)ds.getZahlenbereich(), (String)ds.getEinheit()).ziffern));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Vector<CalcNumerical> parseDatasetWerte(DatasetrenderDTO ds, DatasetrenderDTO.DATASETTYPE modi, String werteString, boolean winkel, int printPrec) {
        Vector<CalcNumerical> werte = new Vector<CalcNumerical>();
        String[] sl = werteString.split(",");
        String REwert = "([+\\-]?\\d*\\.?\\d*[munpfakMGT]?)";
        String REber = REwert + "\\-" + REwert;
        Pattern pwert = Pattern.compile("^" + REwert + "$");
        Pattern pber = Pattern.compile("^" + REber + "$");
        Pattern pberct = Pattern.compile("^(\\d+)\\:" + REber + "$");
        Pattern pbermc = Pattern.compile("^" + REwert + "\\:" + REwert + "\\:" + REwert + "$");
        Pattern pbermcl = Pattern.compile("^" + REwert + "\\*" + REwert + "\\:" + REwert + "$");
        Pattern pnorm = Pattern.compile("^E(\\d+)\\:" + REber + "$");
        Pattern pDnorm = Pattern.compile("^D(\\d+)\\:" + REber + "$");
        Pattern pint = Pattern.compile("^I([+\\-]?\\d+?)$");
        Pattern pberint = Pattern.compile("^I([+\\-]?\\d+?)\\-([+\\-]?\\d+?)$");
        Pattern pdblwert = Pattern.compile("^\\s*(?<var>[+-]?\\d+([,.]\\d+)?((e|E)(-|\\+)?\\d+)?)\\s*$");
        Pattern pdblber = Pattern.compile("^\\s*(?<von>[+-]?\\d+([,.]\\d+)?((e|E)(-|\\+)?\\d+)?)\\s*\\-\\s*(?<bis>[+-]?\\d+([,.]\\d+)?((e|E)(-|\\+)?\\d+)?)$");
        if (sl.length < 1) {
            return null;
        }
        for (String w : sl) {
            double bis;
            double delta;
            double bis2;
            double bis3;
            MatchResult r;
            Matcher m;
            w = w.trim();
            if (winkel) {
                if (w.endsWith("\u00b0")) {
                    // empty if block
                }
                w = w.replaceAll("\u00b0", "");
            }
            if ((m = pwert.matcher(w)).find()) {
                try {
                    if (modi == DatasetrenderDTO.DATASETTYPE.INT) {
                        werte.add((CalcNumerical)new CalcLong((long)Werte.parseWert((String)w)));
                        continue;
                    }
                    werte.add((CalcNumerical)new CalcDouble(Werte.parseWert((String)w)));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            m = pber.matcher(w);
            if (m.find()) {
                r = m.toMatchResult();
                try {
                    double von = Werte.parseWert((String)r.group(1));
                    bis3 = Werte.parseWert((String)r.group(2));
                    if (von > bis3) {
                        double p = von;
                        von = bis3;
                        bis3 = p;
                    }
                    if (modi == DatasetrenderDTO.DATASETTYPE.INT) {
                        DatasetService.getBereich((int)printPrec, werte, (long)((long)von), (long)((long)bis3));
                        continue;
                    }
                    DatasetService.getBereich((int)printPrec, werte, (double)von, (double)bis3);
                }
                catch (NumberFormatException von) {}
                continue;
            }
            m = pberct.matcher(w);
            if (m.find()) {
                r = m.toMatchResult();
                try {
                    int ct = Integer.parseInt(r.group(1));
                    double von = Werte.parseWert((String)r.group(2));
                    bis2 = Werte.parseWert((String)r.group(3));
                    if (von > bis2) {
                        double p = von;
                        von = bis2;
                        bis2 = p;
                    }
                    if (modi == DatasetrenderDTO.DATASETTYPE.INT) {
                        DatasetService.getBereich((int)printPrec, werte, (long)((long)von), (long)((long)bis2));
                        continue;
                    }
                    DatasetService.getBereich((int)printPrec, werte, (double)von, (double)bis2, (int)ct);
                }
                catch (NumberFormatException ct) {}
                continue;
            }
            m = pbermc.matcher(w);
            if (m.find()) {
                r = m.toMatchResult();
                try {
                    double von = Werte.parseWert((String)r.group(1));
                    delta = Werte.parseWert((String)r.group(2));
                    bis = Werte.parseWert((String)r.group(3));
                    if (delta == 0.0) {
                        delta = 1.0;
                    }
                    double d = von;
                    for (int i = 0; (delta < 0.0 ? d >= bis : d <= bis) && i < 1000; ++i) {
                        Object c = modi == DatasetrenderDTO.DATASETTYPE.INT ? new CalcLong((long)d) : new CalcDouble(d);
                        c = c.roundRel(printPrec);
                        if (von < bis && Werte.greaterEquals((double)c.toDouble(), (double)von) && Werte.lessEquals((double)c.toDouble(), (double)bis) || von > bis && Werte.greaterEquals((double)c.toDouble(), (double)bis) && Werte.lessEquals((double)c.toDouble(), (double)von)) {
                            werte.add((CalcNumerical)c);
                        }
                        d += delta;
                    }
                    continue;
                }
                catch (NumberFormatException von) {
                    continue;
                }
            }
            m = pbermcl.matcher(w);
            if (m.find()) {
                r = m.toMatchResult();
                try {
                    double von = Werte.parseWert((String)r.group(1));
                    delta = Math.abs(Werte.parseWert((String)r.group(2)));
                    bis = Math.abs(Werte.parseWert((String)r.group(3)));
                    boolean neg = false;
                    if (von < 0.0) {
                        neg = true;
                        von = -von;
                    } else if (von == 0.0) {
                        von = 1.0E-60;
                    }
                    if (delta == 1.0) {
                        delta = 2.0;
                    }
                    double d = von;
                    for (int i = 0; (delta < 1.0 ? d >= bis : d <= bis) && i < 1000; ++i) {
                        Object c = modi == DatasetrenderDTO.DATASETTYPE.INT ? new CalcLong((long)d) : new CalcDouble(d);
                        c = c.roundRel(printPrec);
                        if (von < bis && Werte.greaterEquals((double)c.toDouble(), (double)von) && Werte.lessEquals((double)c.toDouble(), (double)bis) || von > bis && Werte.greaterEquals((double)c.toDouble(), (double)bis) && Werte.lessEquals((double)c.toDouble(), (double)von)) {
                            werte.add((CalcNumerical)(neg ? c.neg() : c));
                        }
                        d *= delta;
                    }
                    continue;
                }
                catch (NumberFormatException von) {
                    continue;
                }
            }
            m = pnorm.matcher(w);
            if (m.find()) {
                try {
                    r = m.toMatchResult();
                    int ct = Integer.parseInt(r.group(1));
                    double von = Werte.parseWert((String)r.group(2));
                    bis2 = Werte.parseWert((String)r.group(3));
                    switch (ct) {
                        case 3: {
                            DatasetService.getEBereich(werte, (double)von, (double)bis2, (modi == DatasetrenderDTO.DATASETTYPE.INT ? 1 : 0) != 0, (double[])Werte.E3);
                            break;
                        }
                        case 6: {
                            DatasetService.getEBereich(werte, (double)von, (double)bis2, (modi == DatasetrenderDTO.DATASETTYPE.INT ? 1 : 0) != 0, (double[])Werte.E6);
                            break;
                        }
                        case 12: {
                            DatasetService.getEBereich(werte, (double)von, (double)bis2, (modi == DatasetrenderDTO.DATASETTYPE.INT ? 1 : 0) != 0, (double[])Werte.E12);
                            break;
                        }
                        case 24: {
                            DatasetService.getEBereich(werte, (double)von, (double)bis2, (modi == DatasetrenderDTO.DATASETTYPE.INT ? 1 : 0) != 0, (double[])Werte.E24);
                            break;
                        }
                        case 48: {
                            DatasetService.getEBereich(werte, (double)von, (double)bis2, (modi == DatasetrenderDTO.DATASETTYPE.INT ? 1 : 0) != 0, (double[])Werte.E48);
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                catch (NumberFormatException ct) {}
                continue;
            }
            m = pDnorm.matcher(w);
            if (m.find()) {
                try {
                    r = m.toMatchResult();
                    int ct = Integer.parseInt(r.group(1));
                    double von = Werte.parseWert((String)r.group(2));
                    bis2 = Werte.parseWert((String)r.group(3));
                    switch (ct) {
                        case 2: {
                            DatasetService.getEBereich(werte, (double)von, (double)bis2, (modi == DatasetrenderDTO.DATASETTYPE.INT ? 1 : 0) != 0, (double[])Werte.D2);
                            break;
                        }
                        case 5: {
                            DatasetService.getEBereich(werte, (double)von, (double)bis2, (modi == DatasetrenderDTO.DATASETTYPE.INT ? 1 : 0) != 0, (double[])Werte.D4);
                            break;
                        }
                        case 10: {
                            DatasetService.getEBereich(werte, (double)von, (double)bis2, (modi == DatasetrenderDTO.DATASETTYPE.INT ? 1 : 0) != 0, (double[])Werte.D10);
                            break;
                        }
                        case 20: {
                            DatasetService.getEBereich(werte, (double)von, (double)bis2, (modi == DatasetrenderDTO.DATASETTYPE.INT ? 1 : 0) != 0, (double[])Werte.D20);
                            break;
                        }
                        case 40: {
                            DatasetService.getEBereich(werte, (double)von, (double)bis2, (modi == DatasetrenderDTO.DATASETTYPE.INT ? 1 : 0) != 0, (double[])Werte.D40);
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                catch (NumberFormatException ct) {}
                continue;
            }
            m = pberint.matcher(w);
            if (m.find()) {
                try {
                    r = m.toMatchResult();
                    int von = Integer.parseInt(r.group(1));
                    int bis4 = Integer.parseInt(r.group(2));
                    DatasetService.getBereich((int)printPrec, werte, (long)von, (long)bis4);
                    ds.setDecimals("0");
                }
                catch (NumberFormatException von) {}
                continue;
            }
            m = pint.matcher(w);
            if (m.find()) {
                try {
                    r = m.toMatchResult();
                    int wert = Integer.parseInt(r.group(1));
                    DatasetService.getBereich((int)printPrec, werte, (long)wert, (long)wert);
                    ds.setDecimals("0");
                }
                catch (NumberFormatException wert) {}
                continue;
            }
            m = pdblwert.matcher(w);
            if (m.find()) {
                try {
                    double wert = Double.parseDouble(m.group("var"));
                    DatasetService.getBereich((int)printPrec, werte, (double)wert, (double)wert);
                }
                catch (NumberFormatException wert) {}
                continue;
            }
            m = pdblber.matcher(w);
            if (m.find()) {
                try {
                    double von = Double.parseDouble(m.group("von"));
                    bis3 = Double.parseDouble(m.group("bis"));
                    DatasetService.getBereich((int)printPrec, werte, (double)von, (double)bis3);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            return null;
        }
        return werte;
    }

    private static void getBereich(int printPrec, Vector<CalcNumerical> werte, double von, double bis) {
        DatasetService.getBereich((int)printPrec, werte, (double)von, (double)bis, (int)0);
    }

    private static void getBereich(int printPrec, Vector<CalcNumerical> werte, double von, double bis, int anz) {
        if (bis < von) {
            double h = bis;
            bis = von;
            von = h;
        }
        if (bis / von > 100.0 && Math.abs(von) > 1.0E-20) {
            double vz = 1.0;
            if (bis < 0.0) {
                bis = -bis;
                von = -von;
                vz = -1.0;
            }
            double v = Math.log10(von);
            double b = Math.log10(bis);
            int i = 0;
            int j = 0;
            while (i < (anz < 1 ? 40 : anz)) {
                double z = Math.random();
                double w = v + (b - v) * z;
                CalcDouble c = new CalcDouble(Math.pow(10.0, w) * vz);
                if (Werte.greaterEquals((double)(c = c.roundRel(printPrec)).toDouble(), (double)von) && Werte.lessEquals((double)c.toDouble(), (double)bis)) {
                    werte.add((CalcNumerical)c);
                    ++i;
                }
                if (j > 1000) {
                    return;
                }
                ++j;
            }
        } else if (anz > 1) {
            double delta = (bis - von) / (double)(anz - 1);
            for (int i = 0; i < anz; ++i) {
                CalcDouble c = new CalcDouble(von + delta * (double)i);
                c = c.roundRel(printPrec);
                werte.add((CalcNumerical)c);
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < 40) {
                double z = Math.random();
                double w = von + (bis - von) * z;
                CalcDouble c = new CalcDouble(w);
                if (Werte.greaterEquals((double)(c = c.roundRel(printPrec)).toDouble(), (double)von) && Werte.lessEquals((double)c.toDouble(), (double)bis)) {
                    werte.add((CalcNumerical)c);
                    ++i;
                }
                if (j > 1000) {
                    return;
                }
                ++j;
            }
        }
    }

    private static void getBereich(int printPrec, Vector<CalcNumerical> werte, long von, long bis) {
        if (bis < von) {
            long h = bis;
            bis = von;
            von = h;
        }
        int i = 0;
        while (i < 100) {
            if (von == bis) {
                werte.add((CalcNumerical)new CalcLong(von));
                ++i;
                continue;
            }
            double z = Math.random();
            long w = (long)((double)(von - 1L) + (double)(bis - von + 2L) * z);
            CalcLong c = new CalcLong(w);
            if ((c = c.roundRel(printPrec)).toLong() < von || c.toLong() > bis) continue;
            werte.add((CalcNumerical)c);
            ++i;
        }
    }

    private static void getEBereich(Vector<CalcNumerical> werte, double von, double bis, boolean ganzzahl, double ... R) {
        int vz = 0;
        if (von <= 0.0 && bis <= 0.0) {
            vz = 1;
        }
        if (von <= 0.0 && bis >= 0.0) {
            vz = 2;
        }
        if (von >= 0.0 && bis <= 0.0) {
            vz = 2;
        }
        if (von == 0.0 && bis == 0.0) {
            werte.add((CalcNumerical)new CalcLong(0L));
            return;
        }
        if (von < 0.0) {
            von = -von;
        }
        if (bis < 0.0) {
            bis = -bis;
        }
        if (von > bis) {
            double h = von;
            von = bis;
            bis = h;
        }
        if (von == 0.0) {
            von = 1.0E-12;
        }
        von = Werte.getWert((double)von, (double[])R);
        do {
            if (ganzzahl) {
                if (vz != 1) {
                    werte.add((CalcNumerical)new CalcLong((long)von));
                }
                if (vz == 0) continue;
                werte.add((CalcNumerical)new CalcLong(-((long)von)));
                continue;
            }
            if (vz != 1) {
                werte.add((CalcNumerical)new CalcDouble(von));
            }
            if (vz == 0) continue;
            werte.add((CalcNumerical)new CalcDouble(-von));
        } while ((von = Werte.getAuf((double)(von * 1.01), (double[])R)) <= bis);
    }

    public String setMaximaFeld(DatasetrenderDTO ds, String maxima, Vector<String> varlist) {
        CalcErgebnis w = DatasetService.getWert((DatasetrenderDTO)ds, (int)0);
        if (w instanceof CalcVector) {
            maxima = DatasetService.removeVarDefinitionFromMaxima((String)ds.getName(), (String)maxima);
            String s = ds.getName() + ":[";
            for (int i = 0; i < ((CalcVector)w).getDimension(); ++i) {
                String n = ds.getName() + "_" + (i + 1);
                s = s + (i > 0 ? "," : "") + n;
                varlist.add(n);
            }
            s = s + "]";
            maxima = s + "\n" + (String)maxima;
        } else if (w instanceof CalcMatrix) {
            maxima = DatasetService.removeVarDefinitionFromMaxima((String)ds.getName(), (String)maxima);
            String s = ds.getName() + ":matrix(";
            for (int i = 0; i < ((CalcMatrix)w).getZeilen(); ++i) {
                s = s + (i > 0 ? "," : "");
                s = s + "[";
                for (int j = 0; j < ((CalcMatrix)w).getSpalten(); ++j) {
                    String n = ds.getName() + "_" + (i + 1) + "_" + (j + 1);
                    s = s + (j > 0 ? "," : "") + n;
                    varlist.add(n);
                }
                s = s + "]";
            }
            s = s + ")";
            maxima = s + "\n" + (String)maxima;
        } else if (w instanceof CalcComplex || w instanceof CalcComplexEinheit) {
            maxima = DatasetService.removeVarDefinitionFromMaxima((String)ds.getName(), (String)maxima);
            varlist.add(ds.getName());
        } else {
            varlist.add(ds.getName());
        }
        return maxima;
    }

    private static String removeVarDefinitionFromMaxima(String var, String maxima) {
        String[] ma = maxima.split("\n");
        if (ma.length == 0) {
            return "";
        }
        Object ret = "";
        String ps = "^\\s*((" + var + "\\s*\\:.*)|(declare\\(\\[?" + var + ".*))";
        Pattern pa = Pattern.compile(ps);
        for (String m : ma) {
            if (pa.matcher(m).find()) continue;
            ret = (String)ret + m + "\n";
        }
        return ret;
    }
}

