/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.service;

import at.letto.data.dto.question.QuestionDTO;
import at.letto.data.mapper.CycleAvoidingMappingContext;
import at.letto.data.mapper.ExportQuestionMapper_V1;
import at.letto.export.dto.category.ExportCategoryV1;
import at.letto.export.dto.questions.ExportQuestionV1;
import at.letto.question.dto.QuestionRenderDTO;
import at.letto.question.dto.transfer.CategoryTransferDto;
import at.letto.questionservice.config.MicroServiceConfiguration;
import at.letto.questionservice.service.QuestionCacheService;
import at.letto.questionservice.service.QuestionMapper;
import at.letto.questionservice.service.QuestionRenderService;
import at.letto.questionservice.service.dto.Category;
import at.letto.questionservice.service.dto.Question;
import at.letto.tools.Cmd;
import at.letto.tools.JSON;
import at.letto.tools.enums.IconType;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Service
public class CategoryService {
    private CategoryTransferDto root;
    @Autowired
    MicroServiceConfiguration mc;
    @Autowired
    QuestionCacheService questionCacheService;
    @Autowired
    QuestionRenderService questionRenderService;
    private List<Category> categories = null;
    ExportQuestionMapper_V1 qMapper_v1 = (ExportQuestionMapper_V1)Mappers.getMapper(ExportQuestionMapper_V1.class);

    @PostConstruct
    public void init() {
    }

    public List<Category> getCategories() {
        if (this.categories == null) {
            this.categories = this.loadCategories();
        }
        return this.categories;
    }

    public List<Category> loadCategories() {
        Vector<Category> main = new Vector<Category>();
        File folder = Paths.get(this.mc.getCachePath(null), new String[0]).toFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (folder.listFiles() != null) {
            Arrays.stream(folder.listFiles()).sorted(Comparator.comparing(File::getName)).forEach(file -> {
                String cat;
                Category c;
                if (file.isFile() && (c = (Category)JSON.jsonToObj((String)(cat = Cmd.readfile((File)file).stream().collect(Collectors.joining())), Category.class)) != null) {
                    main.add(c);
                }
            });
        }
        return main;
    }

    public void searchFromPath(String path, Model model) {
        List cat = this.getCategories();
        Category res = null;
        Question q = null;
        if (!Cmd.isEmpty((String)path)) {
            for (String c : path.split("/")) {
                Optional<Category> f = cat.stream().filter(categ -> categ.getName().equals(c)).findFirst();
                if (!f.isPresent() && res != null) {
                    Optional<Question> question = res.getQuestions().stream().filter(qu -> qu.getName().equals(c)).findFirst();
                    if (question.isPresent()) {
                        q = question.get();
                        break;
                    }
                    q = null;
                    res = null;
                    break;
                }
                res = f.get();
                cat = res.getCategories();
            }
            model.addAttribute("category", res);
            model.addAttribute("q", q);
        }
    }

    public String uploadFile(MultipartFile file, RedirectAttributes attributes) {
        if (file.isEmpty()) {
            attributes.addFlashAttribute("message", (Object)"Please select a file to upload.");
            return "redirect:/";
        }
        try {
            String cat = new BufferedReader(new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            Category main = null;
            try {
                ExportCategoryV1 exportCat = (ExportCategoryV1)JSON.jsonToObj((String)cat, ExportCategoryV1.class);
                main = this.map(exportCat);
            }
            catch (Exception e) {
                try {
                    CategoryTransferDto root = (CategoryTransferDto)JSON.jsonToObj((String)cat, CategoryTransferDto.class);
                    main = this.map(root);
                }
                catch (Exception root) {
                    // empty catch block
                }
            }
            String content = JSON.objToJson(main);
            String path = this.mc.getCachePath(null) + "/" + main.getName() + ".json";
            Cmd.writefile((String)content, (String)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.categories = null;
        return "";
    }

    public Category map(CategoryTransferDto c) {
        Category cat = new Category();
        cat.setName(c.getName());
        c.getJsonQuestions().forEach(json -> {
            IconType icon;
            QuestionDTO q = (QuestionDTO)JSON.jsonToObj((String)json, QuestionDTO.class);
            boolean imp = true;
            if (q.getQuestionComment() != null && q.getQuestionComment().getIcon() != null && ((icon = q.getQuestionComment().getIcon()).equals((Object)IconType.WARNING) || icon.equals((Object)IconType.BLOCKED))) {
                imp = false;
            }
            if (imp) {
                QuestionRenderDTO qrender = QuestionMapper.service.map(q, new CycleAvoidingMappingContext());
                Question qu = new Question(q.getName(), q.getId(), q.getQuestionType());
                cat.getQuestions().add(qu);
                this.questionCacheService.addQuestionToStorage(qrender, null);
            }
        });
        c.getCategories().forEach(ca -> cat.getCategories().add(this.map(ca)));
        return cat;
    }

    public Category map(ExportCategoryV1 c) {
        Category cat = new Category();
        cat.setName(c.getName());
        c.getQuestions().forEach(qExp -> {
            IconType icon;
            QuestionDTO q = this.map_to_questionDto(qExp);
            boolean imp = true;
            if (q.getQuestionComment() != null && q.getQuestionComment().getIcon() != null && ((icon = q.getQuestionComment().getIcon()).equals((Object)IconType.WARNING) || icon.equals((Object)IconType.BLOCKED))) {
                imp = false;
            }
            if (imp) {
                qExp.getLettoTexte().stream().map((? super T t) -> t.getFiles()).flatMap(Collection::stream).map((? super T f) -> f.getFile().getUrl()).forEach(url -> this.mc.getImageService().saveURLImage(url));
                QuestionRenderDTO qrender = QuestionMapper.service.map(q, new CycleAvoidingMappingContext());
                Question qu = new Question(q.getName(), q.getId(), q.getQuestionType());
                cat.getQuestions().add(qu);
                this.questionCacheService.addQuestionToStorage(qrender, null);
            }
        });
        c.getCategories().forEach(ca -> cat.getCategories().add(this.map(ca)));
        return cat;
    }

    public QuestionDTO map_to_questionDto(ExportQuestionV1 q) {
        try {
            this.qMapper_v1.mapDto(q, new CycleAvoidingMappingContext());
            return this.qMapper_v1.mapDto(q, new CycleAvoidingMappingContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void delMainCat(String name) {
        String path = this.mc.getCachePath(null) + name + ".json";
        try {
            Files.deleteIfExists(Paths.get(path, new String[0]));
            this.categories = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

