/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.dto.renderedQuestion;

import at.letto.data.dto.tests.testAnswer.TestAnswerDetailDto;
import at.letto.math.dto.CalcErgebnisDto;
import at.letto.plugins.dto.PluginAnswerDto;
import at.letto.question.dto.renderedQuestion.html.AnswerHtmlDTO;
import at.letto.questionservice.dto.renderedQuestion.InputSubQuestion;
import at.letto.questionservice.dto.score.ErgAnswerDto;
import java.io.Serializable;
import java.util.Objects;

public class InputAnswer {
    private AnswerHtmlDTO html;
    private TestAnswerDetailDto input;
    private ErgAnswerDto erg;
    private InputSubQuestion parent;

    public InputAnswer(AnswerHtmlDTO html, TestAnswerDetailDto input, InputSubQuestion parent) {
        this.html = html;
        this.input = input;
        this.parent = parent;
    }

    public PluginAnswerDto toPluginAnswerDto(boolean allowJson) {
        CalcErgebnisDto ergebnis = null;
        String answerText = "";
        String ze = "";
        try {
            ergebnis = this.getErg().getErg().toCalcErgebnisDto(allowJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            answerText = ((ErgAnswerDto)this.getParent().getErgebnis().getErgAnswers().get(0)).getText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ze = ((ErgAnswerDto)this.getParent().getErgebnis().getErgAnswers().get(0)).getZielEinheit().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PluginAnswerDto dto = new PluginAnswerDto(ergebnis, answerText, ze);
        return dto;
    }

    public boolean isAnswered() {
        if (this.input == null) {
            return false;
        }
        return this.input.getInput() != null && !this.input.getInput().trim().isEmpty();
    }

    public boolean isText() {
        if (this.html == null) {
            return false;
        }
        return this.html.getHtmlText() != null && !this.html.getHtmlText().trim().isEmpty();
    }

    public boolean isAnswer() {
        if (this.html == null) {
            return false;
        }
        return this.html.getHtmlAnswer() != null && !this.html.getHtmlAnswer().trim().isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputAnswer that = (InputAnswer)o;
        return Objects.equals(this.html, that.html) && Objects.equals(this.input, that.input);
    }

    public int hashCode() {
        return Objects.hash(this.html, this.input);
    }

    public String toString() {
        return this.html.getHtmlText() + ": " + (Serializable)(this.erg != null ? Double.valueOf(this.erg.getFraction()) : " ") + ": " + this.input.getInput();
    }

    public String getAnswer() {
        return this.html.getShortAnswer();
    }

    public String getAnswerImg() {
        return this.html.getHtmlAnswer();
    }

    public String getAnswerServer() {
        return this.input.getInput();
    }

    public String getHtmlText() {
        return this.html.getHtmlText();
    }

    public void setAnswerServer(String inputSchueler) {
        this.input.setInput(inputSchueler);
    }

    public String getColorClassMatching() {
        return this.isAnswerMatchingOK() ? "ergTrue" : "ergFalse";
    }

    public boolean isAnswerMatchingOK() {
        return this.getAnswer().equals(this.getAnswerServer()) || this.getAnswerServer().isEmpty() && this.getHtmlText().isEmpty();
    }

    public String getColorClass() {
        if (this.input.getInput().length() > 2) {
            return "";
        }
        return this.isAnswerOK() ? "ergTrue" : "ergFalse";
    }

    public boolean isAnswerOK() {
        int x = (int)this.erg.getFraction();
        if (x > 0 && this.input.isServerCB()) {
            return true;
        }
        return x <= 0 && !this.input.isServerCB();
    }

    public AnswerHtmlDTO getHtml() {
        return this.html;
    }

    public TestAnswerDetailDto getInput() {
        return this.input;
    }

    public ErgAnswerDto getErg() {
        return this.erg;
    }

    public InputSubQuestion getParent() {
        return this.parent;
    }

    public void setHtml(AnswerHtmlDTO html) {
        this.html = html;
    }

    public void setInput(TestAnswerDetailDto input) {
        this.input = input;
    }

    public void setErg(ErgAnswerDto erg) {
        this.erg = erg;
    }

    public void setParent(InputSubQuestion parent) {
        this.parent = parent;
    }

    public InputAnswer(AnswerHtmlDTO html, TestAnswerDetailDto input, ErgAnswerDto erg, InputSubQuestion parent) {
        this.html = html;
        this.input = input;
        this.erg = erg;
        this.parent = parent;
    }

    public InputAnswer() {
    }
}

