/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.controller;

import at.letto.data.dto.enums.AnswerMode;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.question.dto.QuestionWithAnswer;
import at.letto.question.dto.score.AntwortMitToken;
import at.letto.question.dto.score.CreateAnswersDto;
import at.letto.question.dto.score.ScoreMultipleQuestions;
import at.letto.questionservice.config.MicroServiceConfiguration;
import at.letto.questionservice.security.QuestionSecret;
import at.letto.questionservice.service.QuestionRenderService;
import at.letto.questionservice.service.preview.PreviewService;
import at.letto.questionservice.service.score.ScoreService;
import at.letto.security.LettoToken;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class TestQuestionController {
    @Autowired
    QuestionSecret questionSecret;
    @Autowired
    QuestionRenderService questionService;
    @Autowired
    PreviewService previewService;
    @Autowired
    ScoreService scoreService;
    @Autowired
    MicroServiceConfiguration mc;
    private ResponseToolsObject r = new ResponseToolsObject("Questionservice", "TestQuestionController");

    @PostMapping(value={"/question/open/loadQuestionByDataset"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<QuestionWithAnswer>> loadTestQuestionByDataset(@RequestBody Map<String, String> vals) {
        int idQuestion = Integer.parseInt(vals.get("idQuestion"));
        int dsNr = Integer.parseInt(vals.get("dsNr"));
        String dataset = vals.get("dataset");
        String token = vals.get("token");
        return this.r.getResponse(QuestionRenderService::loadQuestion, (Object)this.questionService, (Object)idQuestion, (Object)dsNr, (Object)dataset, (Object)this.loadToken(token));
    }

    @PostMapping(value={"/question/open/loadQuestionByDataset_res"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<QuestionWithAnswer>> loadTestQuestionByDatasetWithResult(@RequestBody Map<String, String> vals) {
        int idQuestion = Integer.parseInt(vals.get("idQuestion"));
        int dsNr = Integer.parseInt(vals.get("dsNr"));
        String dataset = vals.get("dataset");
        String token = vals.get("token");
        return this.r.getResponse(QuestionRenderService::loadQuestionWithErgebnisse, (Object)this.questionService, (Object)idQuestion, (Object)dsNr, (Object)dataset, (Object)this.loadToken(token));
    }

    @PostMapping(value={"/question/open/load_missing_answers"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<List<TestAntwortDto>>> loadQuestionAnswers(@RequestBody CreateAnswersDto ans) {
        return this.r.getResponse(QuestionRenderService::loadQuestionAnswers, (Object)this.questionService, (Object)ans.getAnswersToCreate(), (Object)this.loadToken(ans.getToken()));
    }

    @PostMapping(value={"/question/open/test_score"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<TestAntwortDto>> score(@RequestBody AntwortMitToken dto) {
        String token = dto.getToken();
        LettoToken lettoToken = this.loadToken(token);
        return this.r.getResponse(ScoreService::score, (Object)this.scoreService, (Object)AnswerMode.beurteilen, (Object)dto.getA(), (Object)false, (Object)this.loadToken());
    }

    @PostMapping(value={"/question/open/test_score_penalty"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<TestAntwortDto>> scorePenalty(@RequestBody AntwortMitToken dto) {
        String token = dto.getToken();
        LettoToken lettoToken = this.loadToken(token);
        return this.r.getResponse(ScoreService::scorePenalty, (Object)this.scoreService, (Object)AnswerMode.beurteilen, (Object)dto.getA(), (Object)false, (Object)lettoToken);
    }

    @PostMapping(value={"/question/open/test_score_all"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<List<TestAntwortDto>>> scoreAll(@RequestBody ScoreMultipleQuestions dto) {
        String token = dto.getToken();
        LettoToken lettoToken = this.loadToken(token);
        return this.r.getResponse(ScoreService::scoreAll, (Object)this.scoreService, (Object)dto, (Object)lettoToken);
    }

    private LettoToken loadToken(String token) {
        return new LettoToken(token, this.mc.getJwtSecret());
    }

    private LettoToken loadToken() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            return (LettoToken)authentication.getDetails();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String loadSchool() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            return ((LettoToken)authentication.getDetails()).getSchool();
        }
        catch (Exception e) {
            return "";
        }
    }
}

