/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.controller;

import at.letto.data.dto.enums.AnswerMode;
import at.letto.data.dto.question.QuestionDTO;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.question.dto.CalcMaximaDto;
import at.letto.question.dto.QuestionWithAnswer;
import at.letto.question.dto.VarHashes;
import at.letto.question.dto.ZwischenErgebnisDto;
import at.letto.question.dto.datasetResults.DatasetItem;
import at.letto.questionservice.config.MicroServiceConfiguration;
import at.letto.questionservice.dto.score.AntwortMitErgebnis;
import at.letto.questionservice.security.QuestionSecret;
import at.letto.questionservice.service.QuestionRenderService;
import at.letto.questionservice.service.preview.PreviewService;
import at.letto.questionservice.service.score.ScoreService;
import at.letto.security.LettoToken;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class EditQuestionController {
    @Autowired
    QuestionSecret questionSecret;
    @Autowired
    QuestionRenderService questionService;
    @Autowired
    PreviewService previewService;
    @Autowired
    ScoreService scoreService;
    @Autowired
    MicroServiceConfiguration mc;
    private ResponseToolsObject r = new ResponseToolsObject("Questionservice", "EditQuestionController");

    @GetMapping(value={"/question/api/teacher/loadQuestion"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<QuestionWithAnswer>> loadQuestionById(@RequestParam Integer idQuestion, @RequestParam Integer dsNr) {
        return this.r.getResponse(QuestionRenderService::loadQuestion, (Object)this.questionService, (Object)idQuestion, (Object)dsNr, (Object)"", (Object)this.loadToken());
    }

    @GetMapping(value={"/question/open/loadQuestionUnsecure"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<QuestionWithAnswer>> loadQuestionByIdUnsecure(@RequestParam Integer idQuestion, @RequestParam Integer dsNr, @RequestParam String token) {
        LettoToken lettoToken = new LettoToken(token, this.mc.getJwtSecret());
        return this.r.getResponse(QuestionRenderService::loadQuestion, (Object)this.questionService, (Object)idQuestion, (Object)dsNr, (Object)"", (Object)lettoToken);
    }

    @PostMapping(value={"/question/api/teacher/score"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<TestAntwortDto>> score(@RequestBody TestAntwortDto dto) {
        return this.r.getResponse(ScoreService::score, (Object)this.scoreService, (Object)AnswerMode.beurteilen, (Object)dto, (Object)false, (Object)this.loadToken());
    }

    @PostMapping(value={"/question/api/teacher/score_res"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<AntwortMitErgebnis>> scoreWithResults(@RequestBody TestAntwortDto dto) {
        return this.r.getResponse(ScoreService::scoreWithResults, (Object)this.scoreService, (Object)AnswerMode.beurteilen, (Object)dto, (Object)false, (Object)this.loadToken());
    }

    @PostMapping(value={"/question/api/teacher/question_save_dto"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<String>> saveQuestionDto(@RequestBody QuestionDTO dto) {
        return this.r.getErrResponse(QuestionRenderService::saveQuestionDto, (Object)this.questionService, (Object)dto, (Object)this.loadToken());
    }

    @PostMapping(value={"/question/api/teacher/question_calc_maxima"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<CalcMaximaDto>> calcMaxima(@RequestBody Map<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        boolean erg = Boolean.parseBoolean(vals.get("ergebnis"));
        return this.r.getResponse(QuestionRenderService::calcMaxima, (Object)this.questionService, (Object)id, (Object)erg, (Object)this.loadToken());
    }

    @PostMapping(value={"/question/api/teacher/question_load_results"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<Map<String, Map<Integer, DatasetItem>>>> loadAllResults(@RequestBody Integer dto) {
        return this.r.getResponse(QuestionRenderService::loadAllResults, (Object)this.questionService, (Object)dto, (Object)this.loadToken());
    }

    @PostMapping(value={"/question/api/teacher/question_load_result_ds"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<Map<String, DatasetItem>>> loadResult(@RequestBody Map<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        int dsNr = Integer.parseInt(vals.get("dsNr"));
        return this.r.getResponse(QuestionRenderService::loadResult, (Object)this.questionService, (Object)id, (Object)dsNr, (Object)this.loadToken());
    }

    @PostMapping(value={"/question/api/teacher/question_change_value"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<Map<String, DatasetItem>>> changeOneValue(@RequestBody Map<String, String> vals) {
        return this.r.getResponse(QuestionRenderService::changeOneValue, (Object)this.questionService, vals, (Object)this.loadToken());
    }

    @PostMapping(value={"/question/api/teacher/question_load_varhash"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<List<ZwischenErgebnisDto>>> loadVarhash(@RequestBody Map<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        int dsNr = Integer.parseInt(vals.get("dsNr"));
        return this.r.getResponse(QuestionRenderService::loadVarhash, (Object)this.questionService, (Object)id, (Object)dsNr, (Object)this.loadToken());
    }

    @PostMapping(value={"/question/api/teacher/question_load_varhashes"})
    @CrossOrigin
    public ResponseEntity<DtoAndMsg<VarHashes>> loadVarhashes(@RequestBody Map<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        int dsNr = Integer.parseInt(vals.get("dsNr"));
        return this.r.getResponse(QuestionRenderService::loadVarhashes, (Object)this.questionService, (Object)id, (Object)dsNr, (Object)this.loadToken());
    }

    private LettoToken loadToken() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            return (LettoToken)authentication.getDetails();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String loadSchool() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            return ((LettoToken)authentication.getDetails()).getSchool();
        }
        catch (Exception e) {
            return "";
        }
    }
}

