/*
 * Decompiled with CFR 0.152.
 */
package at.letto.questionservice.config;

import at.letto.basespringboot.config.BaseMicroServiceConfiguration;
import at.letto.basespringboot.security.WebSecurityConfig;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.globalinterfaces.ImageService;
import at.letto.plugins.restclient.BasePluginManagerService;
import at.letto.plugins.restclient.PluginConnectionService;
import at.letto.plugins.restclient.PluginManagerService;
import at.letto.plugins.service.PluginConnectionServiceCodecheck;
import at.letto.plugins.service.PluginConnectionServiceIntern;
import at.letto.question.endpoints.QuestionEndpoint;
import at.letto.restclient.endpoint.EndpointInterface;
import at.letto.security.LettoToken;
import at.letto.service.base.BaseImageService;
import at.letto.setup.dto.ServiceSchuleDto;
import at.letto.setup.restclient.RestSetupService;
import at.letto.setup.restclient.SetupService;
import at.letto.tools.Cmd;
import at.letto.tools.LogService;
import at.letto.tools.rest.MsgException;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MicroServiceConfiguration
extends BaseMicroServiceConfiguration {
    private PluginManagerService pluginManagerService = null;
    @Value(value="${letto_default_dataservice:}")
    private String defaultDataService = "";
    @Value(value="${letto.question.baseadress}")
    private String baseadress = "";
    @Value(value="${letto.question.copyright}")
    private String copyright = "";
    @Autowired
    private WebSecurityConfig webSecurityConfig;
    private SetupService setupService;
    private RestLettoDataService defaultDataservice = null;
    private Map<String, RestLettoDataService> dataservices = new ConcurrentHashMap();
    @Value(value="${letto.pathImages}")
    private String pathImages;
    @Value(value="${letto.pathImagesPlugins}")
    private String pathPlugins;
    @Value(value="${letto.pathQuestions}")
    private String pathQuestions;
    @Value(value="${letto.webPathImages}")
    private String webpathImages;
    @Value(value="${letto.webPathImagesPlugins}")
    private String webPathImagesPlugins;
    private Map<String, ImageService> pluginImageServices = new ConcurrentHashMap();
    ImageService imageService;
    ImageService fotoService;

    @PostConstruct
    public void init() {
        this.webSecurityConfig.init((BaseMicroServiceConfiguration)this, (EndpointInterface)new QuestionEndpoint());
    }

    public String getCachePath(LettoToken token) {
        if (token != null) {
            return this.pathQuestions + "/" + token.getSchool() + "/";
        }
        return this.pathQuestions + "/" + this.baseadress + "/";
    }

    public PluginManagerService getPluginManagerService() {
        if (this.pluginManagerService == null) {
            this.pluginManagerService = new BasePluginManagerService();
            PluginConnectionServiceIntern pIntern = null;
            if (this.getPluginServiceUri() == null || this.getPluginServiceUri().trim().length() < 1) {
                pIntern = new PluginConnectionServiceIntern();
            } else if (pIntern == null) {
                pIntern = new PluginConnectionServiceIntern();
            }
            PluginConnectionServiceCodecheck pCodecheck = null;
            if (this.getPluginServiceUri() == null || this.getPluginServiceUri().trim().length() < 1) {
                pCodecheck = new PluginConnectionServiceCodecheck();
            } else if (pCodecheck == null) {
                pCodecheck = new PluginConnectionServiceCodecheck();
            }
            if (pIntern != null) {
                this.pluginManagerService.registerPluginConnectionService((PluginConnectionService)pIntern);
            }
            if (pCodecheck != null) {
                this.pluginManagerService.registerPluginConnectionService((PluginConnectionService)pCodecheck);
            }
        }
        return this.pluginManagerService;
    }

    public SetupService getSetupService() {
        if (this.setupService == null) {
            try {
                this.setupService = new RestSetupService(this.getSetupServiceUri(), "user", this.getUserUserPassword());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.setupService;
    }

    public RestLettoDataService getDefaultDataservice(String school) {
        if (this.defaultDataservice == null) {
            try {
                this.defaultDataservice = new RestLettoDataService(this.defaultDataService, "user", this.getUserUserPassword(), 0, school);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultDataservice;
    }

    public RestLettoDataService getDataService(LettoToken token) {
        return this.getDataService(token.getSchool());
    }

    public RestLettoDataService getDataService(String school) {
        if (!Cmd.isEmpty((String)this.defaultDataService)) {
            return this.getDefaultDataservice(school);
        }
        if (this.dataservices.containsKey(school)) {
            return (RestLettoDataService)this.dataservices.get(school);
        }
        Optional<ServiceSchuleDto> schule = this.getSetupService().getSchulen().stream().filter(s -> s.getShortname().equals(school)).findFirst();
        if (schule.isPresent()) {
            String uri = schule.get().getDataUri();
            RestLettoDataService dataService = new RestLettoDataService(uri, "user", this.getUserUserPassword(), schule.get().getIdSchuleData(), school);
            this.dataservices.put(school, dataService);
            return dataService;
        }
        throw new MsgException("dataserviceNotFound");
    }

    public ImageService getPluginImageService(String school) {
        if (Cmd.isEmpty((String)school)) {
            school = "question";
        }
        if (!this.pluginImageServices.containsKey(school)) {
            try {
                BaseImageService pluginImageService = new BaseImageService(this.pathPlugins + "/" + school, this.webPathImagesPlugins + "/" + school, true);
                LogService.logToTmpFile((String)("URL-Plugin: " + pluginImageService.getUrlPath()));
                this.pluginImageServices.put(school, pluginImageService);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (ImageService)this.pluginImageServices.get(school);
    }

    public ImageService getImageService() {
        if (this.imageService == null) {
            try {
                this.imageService = new BaseImageService(this.pathImages, this.webpathImages, true);
                LogService.logToTmpFile((String)("URL-Image: " + ((BaseImageService)this.imageService).getUrlPath()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.imageService;
    }

    public String getBaseadress() {
        return this.baseadress;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getPathQuestions() {
        return this.pathQuestions;
    }
}

