/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.service;

import at.letto.loginservice.config.MicroServiceConfiguration;
import at.letto.setup.dto.ServiceSchuleDto;
import at.letto.setup.dto.ServiceSchulenListDto;
import at.letto.tools.JSON;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class RestClientSetup {
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;

    public List<ServiceSchuleDto> getSchools() {
        try {
            String uri = this.microServiceConfiguration.getSetupServiceUri() + "//config/auth/user/getschulen";
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.getForEntity(uri, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                ServiceSchulenListDto serviceSchulenListDto = (ServiceSchulenListDto)JSON.jsonToObj((String)((String)response.getBody()), ServiceSchulenListDto.class);
                return serviceSchulenListDto.getSchulen();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

