/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.service;

import at.letto.data.restclient.RestLettoDataService;
import at.letto.loginservice.config.LoggingConfiguration;
import at.letto.loginservice.config.MicroServiceConfiguration;
import at.letto.loginservice.config.TomcatConfiguration;
import at.letto.setup.dto.ServiceSchuleDto;
import at.letto.setup.restclient.RestSetupService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LettoService {
    private Logger logger = LoggerFactory.getLogger(LettoService.class);
    private TomcatConfiguration tomcatConfiguration;
    private MicroServiceConfiguration microServiceConfiguration;
    private LoggingConfiguration loggingConfiguration;
    private RestSetupService setupService = null;
    private String restKey = "";
    private HashMap<String, RestLettoDataService> dataServiceHashtable = new HashMap();

    public LettoService(TomcatConfiguration tomcatConfiguration, MicroServiceConfiguration microServiceConfiguration, LoggingConfiguration loggingConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.tomcatConfiguration = tomcatConfiguration;
        this.loggingConfiguration = loggingConfiguration;
    }

    private void loadLettoDataService(String school, int idSchule, String schulname, String username, String password, String uri) {
        try {
            RestLettoDataService dataService = new RestLettoDataService(uri, username, password, idSchule, schulname);
            this.dataServiceHashtable.put(school, dataService);
        }
        catch (Exception ex) {
            this.logger.error("LettoData Service f\u00fcr die Schule " + schulname + " kann nicht geladen werden von " + uri);
        }
    }

    public HashMap<String, RestLettoDataService> getDataServiceHashtable() {
        try {
            List schulen = this.getSetupService().getSchulen();
            this.dataServiceHashtable = new HashMap();
            for (ServiceSchuleDto schule : schulen) {
                try {
                    RestLettoDataService dataService = new RestLettoDataService(schule.getDataUri(), schule.getDataUser(), schule.getDataPassword(), schule.getIdSchuleData(), schule.getShortname());
                    this.dataServiceHashtable.put(schule.getShortname(), dataService);
                }
                catch (Exception ex) {
                    this.logger.error("LettoData Service f\u00fcr die Schule " + schule.getShortname() + " kann nicht geladen werden von " + schule.getDataUri());
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Keine Verbindung zum Setup-Service m\u00f6glich!");
        }
        return this.dataServiceHashtable;
    }

    public List<RestLettoDataService> getLettoDataServices() {
        ArrayList<RestLettoDataService> ret = new ArrayList<RestLettoDataService>();
        for (RestLettoDataService s : this.getDataServiceHashtable().values()) {
            ret.add(s);
        }
        return ret;
    }

    public RestSetupService getSetupService() {
        if (this.setupService == null) {
            this.setupService = new RestSetupService(this.microServiceConfiguration.getSetupServiceUri(), "user", this.microServiceConfiguration.getUserUserPassword());
        }
        return this.setupService;
    }

    public RestLettoDataService getLettoDataService(String school) {
        if (school != null && this.getDataServiceHashtable().containsKey(school)) {
            return (RestLettoDataService)this.getDataServiceHashtable().get(school);
        }
        return null;
    }

    public String getRestKey() {
        if (this.restKey == null || this.restKey.length() == 0) {
            this.restKey = this.getSetupService().getRestKey();
        }
        return this.restKey;
    }
}

