/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.service;

import at.letto.basespringboot.exceptions.UserNotFoundException;
import at.letto.basespringboot.security.JwtTokenService;
import at.letto.data.dto.user.UserKeyDto;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.login.dto.JWTTokenResponse;
import at.letto.loginservice.config.MicroServiceConfiguration;
import at.letto.loginservice.security.TempTokenService;
import at.letto.loginservice.service.AuthenticationService;
import at.letto.loginservice.service.LettoService;
import at.letto.security.LettoToken;
import at.letto.service.interfaces.CheckPasswortResponseDto;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationService {
    private JwtTokenService jwtTokenService;
    private LettoService lettoService;
    private TempTokenService tempTokenService;
    private MicroServiceConfiguration microServiceConfiguration;

    public AuthenticationService(JwtTokenService jwtTokenService, LettoService lettoService, TempTokenService tempTokenService, MicroServiceConfiguration microServiceConfiguration) {
        this.jwtTokenService = jwtTokenService;
        this.lettoService = lettoService;
        this.tempTokenService = tempTokenService;
        this.microServiceConfiguration = microServiceConfiguration;
    }

    private LettoToken authenticateUser(RestLettoDataService dataService, String username, String password) {
        CheckPasswortResponseDto checkPasswortResponseDto = dataService.checkCredentials(username, password);
        if (checkPasswortResponseDto != null) {
            switch (1.$SwitchMap$at$letto$service$interfaces$RequestResult[checkPasswortResponseDto.getRequestResult().ordinal()]) {
                case 1: {
                    UserKeyDto user = checkPasswortResponseDto.getUserKeyDto();
                    ArrayList<String> roles = new ArrayList<String>();
                    if (user.getGlobal().booleanValue()) {
                        roles.add("global");
                    }
                    if (user.getExtern().booleanValue()) {
                        roles.add("extern");
                    }
                    if (user.getChangeAbosPossible().booleanValue()) {
                        roles.add("changeabos");
                    }
                    if (user.getMultipleLogin().booleanValue()) {
                        roles.add("multiplelogin");
                    }
                    if (user.getPayingStudent().booleanValue()) {
                        roles.add("payingstudent");
                    }
                    if (user.getStudent().booleanValue()) {
                        roles.add("student");
                    }
                    if (user.getTeacher().booleanValue()) {
                        roles.add("teacher");
                    }
                    if (user.getAdmin().booleanValue()) {
                        roles.add("admin");
                    }
                    if (user.getDisabled().booleanValue()) {
                        roles.add("disabled");
                    }
                    if (user.getUseAbosCategory().booleanValue()) {
                        roles.add("useraboscategory");
                    }
                    if (user.getUseAbosUsers().booleanValue()) {
                        roles.add("userabosusers");
                    }
                    if (user.getUseCurrentYear().booleanValue()) {
                        roles.add("usecurrentyear");
                    }
                    LettoToken lettoToken = this.jwtTokenService.generateLettoToken(username, user.getVorname(), user.getNachname(), user.getActiveDirectoryName(), user.getEmail(), user.getSprache(), user.getId(), Integer.valueOf(dataService.getIdSchule()), dataService.getSchulename(), this.lettoService.getSetupService().getBaseURI(), this.lettoService.getRestKey(), roles);
                    return lettoToken;
                }
                case 2: {
                    break;
                }
            }
        }
        return null;
    }

    public LettoToken generateLettoToken(String username, String password, String school) {
        RestLettoDataService dataService = this.lettoService.getLettoDataService(school);
        LettoToken lettoToken = null;
        if (dataService != null) {
            lettoToken = this.authenticateUser(dataService, username, password);
            if (lettoToken == null) {
                throw new UserNotFoundException(username, "Passwort falsch!");
            }
        } else if (school == null || school.trim().length() == 0) {
            RestLettoDataService ds;
            Iterator iterator = this.lettoService.getLettoDataServices().iterator();
            while (iterator.hasNext() && (lettoToken = this.authenticateUser(ds = (RestLettoDataService)iterator.next(), username, password)) == null) {
            }
        }
        if (lettoToken != null) {
            return lettoToken;
        }
        throw new UserNotFoundException(username, "Account not found");
    }

    public JWTTokenResponse generateJWTToken(String username, String password, String school) {
        LettoToken lettoToken = this.generateLettoToken(username, password, school);
        if (lettoToken != null) {
            return new JWTTokenResponse(lettoToken.getToken());
        }
        throw new UserNotFoundException(username, "Account not found");
    }

    public JWTTokenResponse refreshJWTToken(String token) {
        LettoToken lettoToken = this.jwtTokenService.refreshToken(token);
        if (lettoToken != null) {
            return new JWTTokenResponse(lettoToken.getToken());
        }
        throw new RuntimeException("cannot refresh token");
    }

    public JWTTokenResponse generateJWTTokenFromTempToken(String tempToken, String secret) {
        try {
            LettoToken lettoToken;
            if (secret != null && secret.equals(this.microServiceConfiguration.getServerSecret()) && (lettoToken = this.tempTokenService.getLettoTokenFromTempToken(tempToken)) != null) {
                return new JWTTokenResponse(lettoToken.getToken());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String generateTempTokenUriShort(LettoToken lettoToken) {
        RestLettoDataService dataService = this.lettoService.getLettoDataService(lettoToken.getSchool());
        Object redirectUri = dataService.getTempTokenRedirectUri();
        String tempToken = this.tempTokenService.getTempToken(lettoToken, this.microServiceConfiguration.getShortTempTokenAge());
        redirectUri = (String)redirectUri + "?token=" + tempToken.replaceAll("\\+", "\\%2b");
        return redirectUri;
    }

    public String generateTempTokenUriShort(String token) {
        LettoToken lettoToken = this.jwtTokenService.refreshToken(token);
        RestLettoDataService dataService = this.lettoService.getLettoDataService(lettoToken.getSchool());
        Object redirectUri = dataService.getTempTokenRedirectUri();
        String tempToken = this.tempTokenService.getTempToken(lettoToken, this.microServiceConfiguration.getShortTempTokenAge());
        redirectUri = (String)redirectUri + "?token=" + tempToken.replaceAll("\\+", "\\%2b");
        return redirectUri;
    }

    public String generateTempTokenUriMedium(LettoToken lettoToken) {
        return this.tempTokenService.getTempToken(lettoToken, this.microServiceConfiguration.getMediumTempTokenAge());
    }

    public String generateTempTokenUriLong(LettoToken lettoToken) {
        return this.tempTokenService.getTempToken(lettoToken, this.microServiceConfiguration.getLongTempTokenAge());
    }
}

