/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.security;

import at.letto.loginservice.config.MicroServiceConfiguration;
import at.letto.loginservice.security.TempTokenService;
import at.letto.security.LettoToken;
import at.letto.tools.ENCRYPT;
import java.util.HashMap;
import org.springframework.stereotype.Component;

@Component
public class TempTokenService {
    private static long MAX_TOKENS = 10000L;
    private String tempSecret;
    private HashMap<String, LettoTokenStore> tempTokens;
    private MicroServiceConfiguration microServiceConfiguration;

    public TempTokenService(MicroServiceConfiguration microServiceConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.tempSecret = ENCRYPT.generateKey((int)40);
        this.tempTokens = new HashMap();
    }

    public String getTempToken(LettoToken lettoToken, long lifeTimeSeconds) {
        if (lettoToken == null) {
            return null;
        }
        try {
            String key = ENCRYPT.generateKey((int)20);
            String tempToken = ENCRYPT.encrypt((String)key, (String)this.tempSecret);
            this.tempTokens.put(key, new LettoTokenStore(lettoToken, lifeTimeSeconds));
            return tempToken;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public LettoToken getLettoTokenFromTempToken(String tempToken) {
        try {
            String key = ENCRYPT.decrypt((String)tempToken, (String)this.tempSecret);
            this.cleanLettoTokenStore();
            if (this.tempTokens.containsKey(key)) {
                LettoTokenStore storedLettoToken = (LettoTokenStore)this.tempTokens.get(key);
                this.tempTokens.remove(key);
                if (System.currentTimeMillis() <= storedLettoToken.expirationTime) {
                    return storedLettoToken.lettoToken;
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Decrypt-Fehler im Temp-Token!" + tempToken);
        }
        return null;
    }

    private synchronized void cleanLettoTokenStore() {
        if ((long)this.tempTokens.keySet().size() < MAX_TOKENS) {
            return;
        }
        long time = System.currentTimeMillis();
        try {
            Object[] keys;
            for (Object keyObject : keys = this.tempTokens.keySet().toArray()) {
                String key = (String)keyObject;
                if (!this.tempTokens.containsKey(key) || ((LettoTokenStore)this.tempTokens.get((Object)key)).expirationTime >= time) continue;
                this.tempTokens.remove(key);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

