/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.controller;

import at.letto.basespringboot.exceptions.UserNotFoundException;
import at.letto.loginservice.config.MicroServiceConfiguration;
import at.letto.loginservice.config.TomcatConfiguration;
import at.letto.loginservice.model.LoginModel;
import at.letto.loginservice.service.AuthenticationService;
import at.letto.loginservice.service.LettoService;
import at.letto.loginservice.service.RestClientSetup;
import at.letto.security.LettoToken;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class MainHttpController {
    @Autowired
    TomcatConfiguration tomcatConfiguration;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    private RestClientSetup restClientSetup;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private LettoService lettoService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;

    private String getusername() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        try {
            return ((User)auth.getPrincipal()).getUsername();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean hasRole(String role) {
        try {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            for (GrantedAuthority a : auth.getAuthorities()) {
                if (!a.toString().equals("ROLE_" + role.toUpperCase())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isUser() {
        return this.hasRole("user");
    }

    public boolean isGast() {
        return this.hasRole("gast");
    }

    public boolean isAdmin() {
        return this.hasRole("admin");
    }

    public boolean isLetto() {
        return this.hasRole("letto");
    }

    @RequestMapping(value={""})
    public String indexForm(HttpServletRequest request, Model model) {
        return this.microServiceConfiguration.redirect(request, "/login/open/login");
    }

    @RequestMapping(value={"/login"})
    public String servicePath(HttpServletRequest request, Model model) {
        return this.microServiceConfiguration.redirect(request, "/login/open/login");
    }

    @RequestMapping(value={"/login/"})
    public String servicePathSlash(HttpServletRequest request, Model model) {
        return this.microServiceConfiguration.redirect(request, "/login/open/login");
    }

    @RequestMapping(value={"/login/open/home"})
    public String home(Model model) {
        model.addAttribute("username", (Object)this.getusername());
        model.addAttribute("style", (Object)"/login/open/css/style.css");
        model.addAttribute("login", (Object)"/login/open/login");
        model.addAttribute("logout", (Object)"/login/auth/logout");
        return "home";
    }

    @RequestMapping(value={"/login/open/login"})
    public String login(@ModelAttribute LoginModel loginModel, Model model) {
        List schulen = new ArrayList();
        try {
            schulen = this.lettoService.getSetupService().getSchulen();
        }
        catch (Exception exception) {
            // empty catch block
        }
        List schulenlist = this.microServiceConfiguration.getSchulen();
        model.addAttribute("loginModel", (Object)loginModel);
        model.addAttribute("username", (Object)(loginModel != null ? loginModel.getName() : ""));
        model.addAttribute("schulenlist", (Object)schulenlist);
        model.addAttribute("schulen", schulen);
        model.addAttribute("action", (Object)"/login/open/loginletto");
        model.addAttribute("style", (Object)"/login/open/css/style.css");
        return "loginletto";
    }

    @RequestMapping(value={"/login/open/loginletto"})
    public Object loginletto(@ModelAttribute LoginModel loginModel, Model model) {
        Object msg;
        block6: {
            HttpHeaders httpHeaders = new HttpHeaders();
            msg = "";
            try {
                URI uri = new URI("/login/open/login");
                httpHeaders.setLocation(uri);
                if (loginModel == null || loginModel.getName().length() <= 0 || loginModel.getPasswort().length() <= 0) break block6;
                try {
                    LettoToken lettoToken = this.authenticationService.generateLettoToken(loginModel.getName(), loginModel.getPasswort(), null);
                    if (lettoToken != null) {
                        String redirectUri = this.authenticationService.generateTempTokenUriShort(lettoToken);
                        uri = new URI(redirectUri);
                        httpHeaders.setLocation(uri);
                        ResponseEntity response = new ResponseEntity((MultiValueMap)httpHeaders, (HttpStatusCode)HttpStatus.SEE_OTHER);
                        return response;
                    }
                    msg = "bad user or password!";
                }
                catch (Exception ex) {
                    if (ex instanceof UserNotFoundException) {
                        msg = "User " + loginModel.getName() + " not found.";
                        msg = "bad user or password!";
                        break block6;
                    }
                    msg = "undefined login-error with user " + loginModel.getName();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                msg = "Undefinierter Fehler bei Login!";
            }
        }
        model.addAttribute("msg", msg);
        return this.login(loginModel, model);
    }

    @RequestMapping(value={"/login/open/logincheck"})
    public String logincheckForm(@ModelAttribute LoginModel loginModel, Model model) {
        model.addAttribute("action", (Object)"/login/open/login");
        model.addAttribute("style", (Object)"/login/open/css/style.css");
        return "login";
    }

    @RequestMapping(value={"/login/open/logoutletto"})
    public String logout(Model model) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String username = "World";
        try {
            username = ((User)auth.getPrincipal()).getUsername();
        }
        catch (Exception exception) {
            // empty catch block
        }
        model.addAttribute("message", (Object)"Hallo Welt!");
        model.addAttribute("user", (Object)username);
        model.addAttribute("tasks", (Object)this);
        model.addAttribute("loginModel", (Object)new LoginModel());
        model.addAttribute("action", (Object)"/login/open/loginletto");
        model.addAttribute("style", (Object)"/login/open/css/style.css");
        return "loginletto";
    }

    @RequestMapping(value={"/login/open/dashboard"})
    public String dashboard(Model model) {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            LettoToken lettoToken = (LettoToken)authentication.getDetails();
            model.addAttribute("username", (Object)lettoToken.getUsername());
            model.addAttribute("email", (Object)lettoToken.getEmail());
            model.addAttribute("style", (Object)"/login/open/css/style.css");
            model.addAttribute("login", (Object)"/login/open/login");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "dashboard";
    }
}

