/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.controller;

import at.letto.basespringboot.exceptions.UserNotFoundException;
import at.letto.basespringboot.security.JwtTokenService;
import at.letto.login.dto.AuthenticationRequest;
import at.letto.login.dto.JWTTokenResponse;
import at.letto.login.dto.TempTokenRequest;
import at.letto.loginservice.config.MicroServiceConfiguration;
import at.letto.loginservice.security.TempTokenService;
import at.letto.loginservice.service.AuthenticationService;
import at.letto.security.LettoToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JWTLoginController {
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private TempTokenService tempTokenService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private JwtTokenService jwtTokenService;

    @PostMapping(value={"/login/api/open/jwtlogin"})
    public ResponseEntity<JWTTokenResponse> jwtLogin(@RequestBody AuthenticationRequest request) {
        return new ResponseEntity((Object)this.authenticationService.generateJWTToken(request.getUsername(), request.getPassword(), request.getSchool()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/login/api/jwtrefresh"})
    public ResponseEntity<JWTTokenResponse> jwtLogin(@RequestBody String token) {
        return new ResponseEntity((Object)this.authenticationService.refreshJWTToken(token), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/login/api/open/jwttemptoken"})
    public ResponseEntity<JWTTokenResponse> jwtTempToken(@RequestBody TempTokenRequest request) {
        return new ResponseEntity((Object)this.authenticationService.generateJWTTokenFromTempToken(request.getTempToken(), request.getSecret()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/login/api/open/jwtgettemptokenuri"})
    public ResponseEntity<String> jwtGetTempTokenUri(@RequestBody String token) {
        return new ResponseEntity((Object)this.authenticationService.generateTempTokenUriShort(token), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/login/api/jwtgettemptoken"})
    public ResponseEntity<String> jwtGetTempToken(@RequestBody String token) {
        LettoToken lettoToken = this.jwtTokenService.refreshToken(token);
        if (lettoToken != null) {
            String tempToken = this.tempTokenService.getTempToken(lettoToken, this.microServiceConfiguration.getShortTempTokenAge());
            tempToken = tempToken.replaceAll("\\+", "\\%2b");
            return new ResponseEntity((Object)tempToken, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)"Cannot Refresh Token!", (HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={UserNotFoundException.class})
    public ResponseEntity<String> handleEntityNotFoundException(UserNotFoundException ex) {
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

