/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.controller;

import at.letto.loginservice.config.TomcatConfiguration;
import at.letto.security.LettoToken;
import at.letto.service.microservice.AdminInfoDto;
import at.letto.tools.ServerStatus;
import java.util.Date;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class InfoController {
    private final ApplicationContext applicationContext;
    private final TomcatConfiguration tomcatConfiguration;

    public InfoController(ApplicationContext applicationContext, TomcatConfiguration tomcatConfiguration) {
        this.applicationContext = applicationContext;
        this.tomcatConfiguration = tomcatConfiguration;
    }

    @PostMapping(value={"/login/ping"})
    public ResponseEntity<String> pingPost() {
        return ResponseEntity.ok((Object)"pong");
    }

    @GetMapping(value={"/login/ping"})
    public ResponseEntity<String> pingGet() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/login/pingp"})
    public ResponseEntity<String> pingP(@RequestBody String dto) {
        if (dto.equals("ping")) {
            return ResponseEntity.ok((Object)"pong");
        }
        return ResponseEntity.ok((Object)"fail");
    }

    @GetMapping(value={"/login/pingg"})
    public ResponseEntity<String> pingG(@RequestParam String dto) {
        if (dto.equals("ping")) {
            return ResponseEntity.ok((Object)"pong");
        }
        return ResponseEntity.ok((Object)"fail");
    }

    @PostMapping(value={"/login/api/student/ping"})
    public ResponseEntity<String> pingStudent() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/login/api/teacher/ping"})
    public ResponseEntity<String> pingTeacher() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        LettoToken lettoToken = (LettoToken)authentication.getDetails();
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/login/api/admin/ping"})
    public ResponseEntity<String> pingAdmin() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/login/api/global/ping"})
    public ResponseEntity<String> pingGlobal() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/login/auth/gast/ping"})
    public ResponseEntity<String> pingAuthGast() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/login/auth/user/ping"})
    public ResponseEntity<String> pingAuthUser() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/login/auth/admin/ping"})
    public ResponseEntity<String> pingAuthAdmin() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/login/auth/letto/ping"})
    public ResponseEntity<String> pingAuthLetto() {
        return ResponseEntity.ok((Object)"pong");
    }

    @GetMapping(value={"/login/open/version"})
    public ResponseEntity<String> version() {
        return ResponseEntity.ok((Object)ServerStatus.getRevision());
    }

    @GetMapping(value={"/login/open/info"})
    public ResponseEntity<String> info() {
        String applicationname = this.applicationContext.getId();
        String msg = "Application: " + applicationname;
        return ResponseEntity.ok((Object)msg);
    }

    @GetMapping(value={"/login/auth/letto/info"})
    public ResponseEntity<AdminInfoDto> lettoinfo() {
        return this.admininfo();
    }

    @GetMapping(value={"/login/auth/admin/info"})
    public ResponseEntity<AdminInfoDto> admininfo() {
        String pid = new ApplicationPid().toString();
        String applicationname = this.applicationContext.getId();
        String applicationhome = new ApplicationHome().toString();
        long uptime = System.currentTimeMillis() - this.applicationContext.getStartupDate();
        Object serverversion = ServerStatus.getServerVersion();
        serverversion = "Spring Boot " + SpringVersion.getVersion() + (String)(serverversion != null && ((String)serverversion).length() > 0 ? " , " + (String)serverversion : "");
        AdminInfoDto ret = new AdminInfoDto(applicationname, pid, applicationhome, this.applicationContext.getStartupDate(), uptime, ServerStatus.getRevision(), new Date().toString(), ServerStatus.getBetriebssystem(), ServerStatus.getIP(), ServerStatus.getEncoding(), ServerStatus.getFileEncoding(), ServerStatus.getFileSeparator(), ServerStatus.getJavaSpecificationVersion(), ServerStatus.getJavaVendor(), ServerStatus.getJavaVersion(), ServerStatus.getJavaVersionNumber(), ServerStatus.getHostname(), ServerStatus.getLanguage(), ServerStatus.getLinuxDescription(), ServerStatus.getLinuxDistribution(), ServerStatus.getLinuxRelease(), ServerStatus.getServerUsername(), (String)serverversion, ServerStatus.getSystemHome(), ServerStatus.isLinux(), ServerStatus.isUbuntu(), ServerStatus.isWindows(), this.tomcatConfiguration.getHttpPort(), this.tomcatConfiguration.getAjpPort(), this.tomcatConfiguration.getHttpsPort());
        return ResponseEntity.ok((Object)ret);
    }
}

